/*
 * Decompiled with CFR 0.152.
 */
package y.view.hierarchy;

import java.util.HashMap;
import y.base.DataProvider;
import y.base.Node;
import y.base.NodeCursor;
import y.base.NodeMap;
import y.geom.YDimension;
import y.geom.YInsets;
import y.layout.grouping.GroupingKeys;
import y.util.DataProviderAdapter;
import y.util.Maps;
import y.view.Graph2D;
import y.view.NodeRealizer;
import y.view.SizeConstraintProvider;
import y.view.hierarchy.AutoBoundsFeature;
import y.view.hierarchy.HierarchyManager;

public class GroupLayoutConfigurator {
    private Graph2D i;
    private HierarchyManager f;
    private DataProvider c;
    private DataProvider d;
    private DataProvider h;
    private DataProvider b;
    private DataProvider j;
    private HashMap g;
    private boolean e;

    public GroupLayoutConfigurator(Graph2D graph2D) {
        this.i = graph2D;
        this.f = HierarchyManager.getInstance(graph2D);
    }

    public boolean isTreatEmptyGroupNodesAsNormalNodesEnabled() {
        return this.e;
    }

    public void setTreatEmptyGroupNodesAsNormalNodesEnabled(boolean bl) {
        this.e = bl;
    }

    public void prepareGroupDataProviders() {
        if (this.f != null) {
            this.c = this.i.getDataProvider(GroupingKeys.GROUP_DPKEY);
            this.d = this.i.getDataProvider(GroupingKeys.NODE_ID_DPKEY);
            this.h = this.i.getDataProvider(GroupingKeys.PARENT_NODE_ID_DPKEY);
            if (this.c != null) {
                this.i.removeDataProvider(GroupingKeys.GROUP_DPKEY);
            }
            if (this.d != null) {
                this.i.removeDataProvider(GroupingKeys.NODE_ID_DPKEY);
            }
            if (this.h != null) {
                this.i.removeDataProvider(GroupingKeys.PARENT_NODE_ID_DPKEY);
            }
            this.i.addDataProvider(GroupingKeys.GROUP_DPKEY, this.createGroupDP(this.i));
            this.i.addDataProvider(GroupingKeys.PARENT_NODE_ID_DPKEY, this.f.getParentNodeIdDataProvider());
            this.i.addDataProvider(GroupingKeys.NODE_ID_DPKEY, this.f.getNodeIdDataProvider());
        }
    }

    protected DataProvider createGroupDP(Graph2D graph2D) {
        int n2 = HierarchyManager.z;
        DataProvider dataProvider = this.f.getGroupNodeDataProvider();
        if (!this.isTreatEmptyGroupNodesAsNormalNodesEnabled() || dataProvider == null) {
            return dataProvider;
        }
        NodeMap nodeMap = Maps.createHashedNodeMap();
        NodeCursor nodeCursor = graph2D.nodes();
        while (nodeCursor.ok()) {
            Node node = nodeCursor.node();
            boolean bl = dataProvider.getBool(node) && this.f.getChildren(node).size() > 0;
            nodeMap.setBool(node, bl);
            nodeCursor.next();
            if (n2 == 0) continue;
        }
        return nodeMap;
    }

    public void prepareGroupNodeInsets() {
        if (this.f != null) {
            this.b = this.i.getDataProvider(GroupingKeys.GROUP_NODE_INSETS_DPKEY);
            this.i.addDataProvider(GroupingKeys.GROUP_NODE_INSETS_DPKEY, new DataProviderAdapter(){
                private final YInsets jd = new YInsets(15.0, 15.0, 15.0, 15.0);

                public Object get(Object object) {
                    YInsets yInsets = GroupLayoutConfigurator.this.getGroupNodeInsets(GroupLayoutConfigurator.this.i, (Node)object);
                    if (yInsets == null) {
                        return this.jd;
                    }
                    return yInsets;
                }
            });
        }
    }

    protected YInsets getGroupNodeInsets(Graph2D graph2D, Node node) {
        NodeRealizer nodeRealizer = graph2D.getRealizer(node);
        AutoBoundsFeature autoBoundsFeature = nodeRealizer.getAutoBoundsFeature();
        if (autoBoundsFeature == null) {
            return null;
        }
        return autoBoundsFeature.getAutoBoundsInsets();
    }

    public void prepareMinGroupNodeSizes() {
        if (this.f != null) {
            this.j = this.i.getDataProvider(GroupingKeys.MINIMUM_NODE_SIZE_DPKEY);
            this.i.addDataProvider(GroupingKeys.MINIMUM_NODE_SIZE_DPKEY, new MinNodeSizeDataProvider(this.i));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    public void prepareGroupNodeBounds() {
        boolean bl;
        NodeRealizer nodeRealizer;
        AutoBoundsFeature autoBoundsFeature;
        Node node;
        Object object;
        int n2;
        block5: {
            n2 = HierarchyManager.z;
            if (this.f != null) {
                object = this.f.postTraversal();
                while (object.hasNext()) {
                    node = (Node)object.next();
                    if (!this.i.contains(node) || (autoBoundsFeature = (nodeRealizer = this.i.getRealizer(node)).getAutoBoundsFeature()) == null || !(bl = autoBoundsFeature.isAutoBoundsEnabled())) continue;
                    autoBoundsFeature.setAutoBoundsEnabled(false);
                    autoBoundsFeature.setAutoBoundsEnabled(true);
                    if (n2 == 0) {
                        continue;
                    }
                    break block5;
                }
                return;
            }
        }
        object = this.i.nodes();
        do {
            if (!object.ok()) return;
            node = object.node();
            nodeRealizer = this.i.getRealizer(node);
            autoBoundsFeature = nodeRealizer.getAutoBoundsFeature();
            if (autoBoundsFeature != null && (bl = autoBoundsFeature.isAutoBoundsEnabled())) {
                autoBoundsFeature.setAutoBoundsEnabled(false);
                autoBoundsFeature.setAutoBoundsEnabled(true);
            }
            object.next();
        } while (n2 == 0);
    }

    public void restoreGroupDataProviders() {
        block6: {
            block12: {
                block11: {
                    int n2;
                    block10: {
                        block9: {
                            block8: {
                                block7: {
                                    n2 = HierarchyManager.z;
                                    if (this.f == null) break block6;
                                    if (this.c != null) break block7;
                                    this.i.removeDataProvider(GroupingKeys.GROUP_DPKEY);
                                    if (n2 == 0) break block8;
                                }
                                this.i.addDataProvider(GroupingKeys.GROUP_DPKEY, this.c);
                            }
                            if (this.h != null) break block9;
                            this.i.removeDataProvider(GroupingKeys.PARENT_NODE_ID_DPKEY);
                            if (n2 == 0) break block10;
                        }
                        this.i.addDataProvider(GroupingKeys.PARENT_NODE_ID_DPKEY, this.h);
                    }
                    if (this.d != null) break block11;
                    this.i.removeDataProvider(GroupingKeys.NODE_ID_DPKEY);
                    if (n2 == 0) break block12;
                }
                this.i.addDataProvider(GroupingKeys.NODE_ID_DPKEY, this.d);
            }
            this.c = null;
            this.d = null;
            this.h = null;
        }
    }

    public void prepareAutoBoundsFeatures() {
        if (this.f != null) {
            this.b(true);
        }
    }

    public void restoreGroupNodeInsets() {
        block2: {
            block3: {
                if (this.f == null) break block2;
                if (this.b == null) break block3;
                this.i.addDataProvider(GroupingKeys.GROUP_NODE_INSETS_DPKEY, this.b);
                if (HierarchyManager.z == 0) break block2;
            }
            this.i.removeDataProvider(GroupingKeys.GROUP_NODE_INSETS_DPKEY);
        }
    }

    public void restoreMinGroupNodeSizes() {
        block2: {
            block3: {
                if (this.f == null) break block2;
                if (this.j == null) break block3;
                this.i.addDataProvider(GroupingKeys.MINIMUM_NODE_SIZE_DPKEY, this.j);
                if (HierarchyManager.z == 0) break block2;
            }
            this.i.removeDataProvider(GroupingKeys.MINIMUM_NODE_SIZE_DPKEY);
        }
    }

    public void restoreAutoBoundsFeatures() {
        if (this.f != null) {
            this.b(false);
        }
    }

    private void b(boolean bl) {
        block10: {
            int n2;
            block12: {
                block11: {
                    n2 = HierarchyManager.z;
                    if (!bl) break block11;
                    this.g = new HashMap();
                    if (n2 == 0) break block12;
                }
                if (this.g == null) {
                    return;
                }
            }
            NodeCursor nodeCursor = this.i.nodes();
            while (nodeCursor.ok()) {
                block13: {
                    AutoBoundsFeature autoBoundsFeature;
                    Node node;
                    block14: {
                        block15: {
                            node = nodeCursor.node();
                            NodeRealizer nodeRealizer = this.i.getRealizer(node);
                            autoBoundsFeature = nodeRealizer.getAutoBoundsFeature();
                            if (n2 != 0) break block10;
                            if (autoBoundsFeature == null) break block13;
                            if (!bl) break block14;
                            if (!autoBoundsFeature.isAutoBoundsEnabled()) break block15;
                            autoBoundsFeature.setAutoBoundsEnabled(false);
                            if (n2 == 0) break block13;
                        }
                        this.g.put(node, Boolean.TRUE);
                        if (n2 == 0) break block13;
                    }
                    if (this.g.get(node) != Boolean.TRUE) {
                        autoBoundsFeature.setAutoBoundsEnabled(true);
                    }
                }
                nodeCursor.next();
                if (n2 == 0) continue;
            }
            if (!bl) {
                this.g = null;
            }
        }
    }

    public void prepareAll() {
        if (this.f != null) {
            this.prepareGroupNodeBounds();
            this.prepareGroupDataProviders();
            this.prepareGroupNodeInsets();
            this.prepareAutoBoundsFeatures();
            this.prepareMinGroupNodeSizes();
        }
    }

    public void restoreAll() {
        if (this.f != null) {
            this.restoreAutoBoundsFeatures();
            this.restoreGroupNodeInsets();
            this.restoreGroupDataProviders();
            this.restoreMinGroupNodeSizes();
        }
    }

    public static class MinNodeSizeDataProvider
    extends DataProviderAdapter {
        private final Graph2D hd;
        private YDimension id = new YDimension(0.0, 0.0);

        public MinNodeSizeDataProvider(Graph2D graph2D) {
            this.hd = graph2D;
        }

        public Object get(Object object) {
            NodeRealizer nodeRealizer = this.hd.getRealizer((Node)object);
            SizeConstraintProvider sizeConstraintProvider = nodeRealizer.getSizeConstraintProvider();
            if (sizeConstraintProvider != null) {
                return sizeConstraintProvider.getMinimumSize();
            }
            return this.id;
        }
    }
}

