/*
 * Decompiled with CFR 0.152.
 */
package y.view;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import y.view.Drawable;
import y.view.Graph2DView;
import y.view.GraphicsContext;
import y.view.NodeRealizer;
import y.view.YRenderingHints;

public class ViewCoordDrawableAdapter
implements Drawable {
    protected Graph2DView view;
    protected Drawable viewCoordDrawable;

    public ViewCoordDrawableAdapter(Graph2DView graph2DView, Drawable drawable) {
        this.view = graph2DView;
        this.viewCoordDrawable = drawable;
    }

    public Rectangle getBounds() {
        Rectangle rectangle = this.getViewCoordinateDrawableBounds();
        Point2D point2D = this.view.getViewPoint2D();
        double d2 = 1.0 / this.view.getZoom();
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(point2D.getX(), point2D.getY());
        affineTransform.scale(d2, d2);
        return affineTransform.createTransformedShape(rectangle).getBounds();
    }

    public void paint(Graphics2D graphics2D) {
        AffineTransform affineTransform;
        block3: {
            block2: {
                affineTransform = graphics2D.getTransform();
                GraphicsContext graphicsContext = YRenderingHints.getGraphicsContext(graphics2D);
                if (graphicsContext == null || graphicsContext.getViewTransform() == null) break block2;
                graphics2D.setTransform(graphicsContext.getViewTransform());
                if (NodeRealizer.z == 0) break block3;
            }
            Point2D point2D = this.view.getViewPoint2D();
            double d2 = 1.0 / this.view.getZoom();
            graphics2D.translate(point2D.getX(), point2D.getY());
            graphics2D.scale(d2, d2);
        }
        this.paintViewCoordinateDrawable(graphics2D);
        graphics2D.setTransform(affineTransform);
    }

    protected void paintViewCoordinateDrawable(Graphics2D graphics2D) {
        this.viewCoordDrawable.paint(graphics2D);
    }

    protected Rectangle getViewCoordinateDrawableBounds() {
        return this.viewCoordDrawable.getBounds();
    }
}

