/*
 * Decompiled with CFR 0.152.
 */
package y.view;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import y.base.Node;
import y.view.AbstractCustomNodePainter;
import y.view.GenericNodeRealizer;
import y.view.GraphicsContext;
import y.view.NodeRealizer;
import y.view.YRenderingHints;
import y.view.c;
import y.view.hierarchy.HierarchyManager;

public class ShapeNodePainter
extends AbstractCustomNodePainter
implements GenericNodeRealizer.ContainsTest {
    public static final byte RECT = 0;
    public static final byte ROUND_RECT = 1;
    public static final byte ELLIPSE = 2;
    public static final byte PARALLELOGRAM = 3;
    public static final byte HEXAGON = 4;
    public static final byte TRIANGLE = 5;
    public static final byte RECT_3D = 6;
    public static final byte OCTAGON = 7;
    public static final byte DIAMOND = 8;
    public static final byte TRAPEZOID = 9;
    public static final byte TRAPEZOID_2 = 10;
    private byte mb;
    private boolean nb = true;

    public ShapeNodePainter() {
        this(0);
    }

    public ShapeNodePainter(byte by) {
        this.mb = by;
    }

    protected void paintNode(NodeRealizer nodeRealizer, Graphics2D graphics2D, boolean bl) {
        Shape shape = this.m(nodeRealizer);
        this.paintFilledShape(nodeRealizer, graphics2D, shape);
        this.paintShapeBorder(nodeRealizer, graphics2D, shape);
    }

    private Shape m(NodeRealizer nodeRealizer) {
        double d2;
        double d3;
        double d4;
        double d5;
        block15: {
            block14: {
                if (nodeRealizer == null) break block14;
                d5 = nodeRealizer.getX();
                d4 = nodeRealizer.getY();
                d3 = nodeRealizer.getWidth();
                d2 = nodeRealizer.getHeight();
                if (NodeRealizer.z == 0) break block15;
            }
            d5 = 0.0;
            d4 = 0.0;
            d3 = 1.0;
            d2 = 1.0;
        }
        switch (this.mb) {
            case 2: {
                return new Ellipse2D.Double(d5, d4, d3, d2);
            }
            case 0: 
            case 6: {
                return new Rectangle2D.Double(d5, d4, d3, d2);
            }
            case 1: {
                return new RoundRectangle2D.Double(d5, d4, d3, d2, 8.0, 8.0);
            }
            case 3: {
                GeneralPath generalPath = new GeneralPath(0, 9);
                generalPath.moveTo((float)(d5 + d3 * 0.1), (float)d4);
                generalPath.lineTo((float)(d5 + d3), (float)d4);
                generalPath.lineTo((float)(d5 + d3 * 0.9), (float)(d4 + d2));
                generalPath.lineTo((float)d5, (float)(d4 + d2));
                generalPath.closePath();
                return generalPath;
            }
            case 4: {
                GeneralPath generalPath = new GeneralPath(0, 9);
                generalPath.moveTo((float)d5, (float)(d4 + d2 / 2.0));
                generalPath.lineTo((float)(d5 + d3 * 0.1), (float)d4);
                generalPath.lineTo((float)(d5 + d3 * 0.9), (float)d4);
                generalPath.lineTo((float)(d5 + d3), (float)(d4 + d2 / 2.0));
                generalPath.lineTo((float)(d5 + d3 * 0.9), (float)(d4 + d2));
                generalPath.lineTo((float)(d5 + d3 * 0.1), (float)(d4 + d2));
                generalPath.closePath();
                return generalPath;
            }
            case 5: {
                GeneralPath generalPath = new GeneralPath(0, 9);
                generalPath.moveTo((float)(d5 + d3 / 2.0), (float)d4);
                generalPath.lineTo((float)(d5 + d3), (float)(d4 + d2));
                generalPath.lineTo((float)d5, (float)(d4 + d2));
                generalPath.closePath();
                return generalPath;
            }
            case 7: {
                double d6 = Math.sqrt(2.0);
                double d7 = d3 / (2.0 + d6);
                double d8 = d2 / (2.0 + d6);
                GeneralPath generalPath = new GeneralPath(0, 9);
                generalPath.moveTo((float)d5, (float)(d4 + d8));
                generalPath.lineTo((float)(d5 + d7), (float)d4);
                generalPath.lineTo((float)(d5 + d3 - d7), (float)d4);
                generalPath.lineTo((float)(d5 + d3), (float)(d4 + d8));
                generalPath.lineTo((float)(d5 + d3), (float)(d4 + d2 - d8));
                generalPath.lineTo((float)(d5 + d3 - d7), (float)(d4 + d2));
                generalPath.lineTo((float)(d5 + d7), (float)(d4 + d2));
                generalPath.lineTo((float)d5, (float)(d4 + d2 - d8));
                generalPath.closePath();
                return generalPath;
            }
            case 8: {
                GeneralPath generalPath = new GeneralPath(0, 9);
                generalPath.moveTo((float)d5, (float)(d4 + d2 * 0.5));
                generalPath.lineTo((float)(d5 + d3 * 0.5), (float)d4);
                generalPath.lineTo((float)(d5 + d3), (float)(d4 + d2 * 0.5));
                generalPath.lineTo((float)(d5 + d3 * 0.5), (float)(d4 + d2));
                generalPath.closePath();
                return generalPath;
            }
            case 9: {
                GeneralPath generalPath = new GeneralPath(0, 9);
                generalPath.moveTo((float)d5, (float)(d4 + d2));
                generalPath.lineTo((float)(d5 + d3 * 0.25), (float)d4);
                generalPath.lineTo((float)(d5 + d3 * 0.75), (float)d4);
                generalPath.lineTo((float)(d5 + d3), (float)(d4 + d2));
                generalPath.closePath();
                return generalPath;
            }
            case 10: {
                GeneralPath generalPath = new GeneralPath(0, 9);
                generalPath.moveTo((float)d5, (float)d4);
                generalPath.lineTo((float)(d5 + d3), (float)d4);
                generalPath.lineTo((float)(d5 + d3 * 0.75), (float)(d4 + d2));
                generalPath.lineTo((float)(d5 + d3 * 0.25), (float)(d4 + d2));
                generalPath.closePath();
                return generalPath;
            }
        }
        return new Rectangle2D.Double(d5, d4, d3, d2);
    }

    protected void paintFilledShape(NodeRealizer nodeRealizer, Graphics2D graphics2D, Shape shape) {
        Paint paint;
        if (!nodeRealizer.isTransparent() && (paint = this.c(nodeRealizer, graphics2D)) != null) {
            graphics2D.setPaint(paint);
            graphics2D.fill(shape);
        }
    }

    protected Color getFillColor(NodeRealizer nodeRealizer, boolean bl) {
        HierarchyManager hierarchyManager;
        Node node;
        Color color = super.getFillColor(nodeRealizer, bl);
        if (this.isGroupDepthFillColorEnabled() && color != null && (node = nodeRealizer.getNode()) != null && (hierarchyManager = HierarchyManager.getInstance(node.getGraph())) != null && hierarchyManager.isGroupNode(node)) {
            Color color2 = color;
            int n2 = hierarchyManager.getLocalGroupDepth(node);
            if (n2 > 0) {
                color2 = new Color(Math.max(color.getRed() - 20 * n2, 0), Math.max(color.getGreen() - 20 * n2, 0), Math.max(color.getBlue() - 20 * n2, 0), color.getAlpha());
            }
            color = color2;
        }
        return color;
    }

    protected void paintShapeBorder(NodeRealizer nodeRealizer, Graphics2D graphics2D, Shape shape) {
        block3: {
            Stroke stroke;
            block6: {
                block4: {
                    int n2;
                    block5: {
                        Color color;
                        block2: {
                            n2 = NodeRealizer.z;
                            if (this.mb != 6) break block2;
                            color = this.getFillColor(nodeRealizer, ShapeNodePainter.d(nodeRealizer, graphics2D));
                            if (color == null) break block3;
                            graphics2D.setColor(color);
                            this.f(nodeRealizer, graphics2D, true);
                            if (n2 == 0) break block3;
                        }
                        if ((color = this.getLineColor(nodeRealizer, ShapeNodePainter.d(nodeRealizer, graphics2D))) == null) break block3;
                        stroke = graphics2D.getStroke();
                        graphics2D.setStroke(nodeRealizer.getLineType());
                        graphics2D.setColor(color);
                        if (this.mb != 2) break block4;
                        GraphicsContext graphicsContext = (GraphicsContext)graphics2D.getRenderingHint(YRenderingHints.GRAPHICS_CONTEXT_KEY);
                        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
                        if (RenderingHints.VALUE_ANTIALIAS_ON.equals(object) || graphicsContext != null && graphicsContext.isPrinting()) break block5;
                        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        graphics2D.draw(shape);
                        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
                        if (n2 == 0) break block6;
                    }
                    graphics2D.draw(shape);
                    if (n2 == 0) break block6;
                }
                graphics2D.draw(shape);
            }
            graphics2D.setStroke(stroke);
        }
    }

    private void f(NodeRealizer nodeRealizer, Graphics2D graphics2D, boolean bl) {
        Color color;
        Color color2;
        Paint paint;
        double d2;
        double d3;
        double d4;
        double d5;
        block5: {
            Color color3;
            block4: {
                d5 = nodeRealizer.getX();
                d4 = nodeRealizer.getY();
                d3 = nodeRealizer.getWidth();
                d2 = nodeRealizer.getHeight();
                paint = graphics2D.getPaint();
                color3 = graphics2D.getColor();
                color2 = color3.brighter();
                color = color3.darker();
                if (bl) break block4;
                graphics2D.setColor(color);
                if (NodeRealizer.z == 0) break block5;
            }
            if (paint != color3) {
                graphics2D.setColor(color3);
            }
        }
        graphics2D.setColor(bl ? color2 : color);
        Rectangle2D.Double double_ = c.b().m;
        double_.setFrame(d5, d4, 1.0, d2);
        graphics2D.fill(double_);
        double_.setFrame(d5 + 1.0, d4, d3 - 2.0, 1.0);
        graphics2D.fill(double_);
        graphics2D.setColor(bl ? color : color2);
        double_.setFrame(d5 + 1.0, d4 + d2 - 1.0, d3 - 1.0, 1.0);
        graphics2D.fill(double_);
        double_.setFrame(d5 + d3 - 1.0, d4, 1.0, d2 - 1.0);
        graphics2D.fill(double_);
        graphics2D.setPaint(paint);
    }

    public void setShapeType(byte by) {
        this.mb = by;
    }

    public byte getShapeType() {
        return this.mb;
    }

    public void setGroupDepthFillColorEnabled(boolean bl) {
        this.nb = bl;
    }

    public boolean isGroupDepthFillColorEnabled() {
        return this.nb;
    }

    protected Shape getShape(NodeRealizer nodeRealizer) {
        return this.m(nodeRealizer);
    }

    public boolean contains(NodeRealizer nodeRealizer, double d2, double d3) {
        return this.m(nodeRealizer).contains(d2, d3);
    }
}

