/*
 * Decompiled with CFR 0.152.
 */
package y.view;

import y.base.DataProvider;
import y.base.Edge;
import y.base.EdgeCursor;
import y.base.EdgeMap;
import y.base.GraphEvent;
import y.base.GraphListener;
import y.base.Node;
import y.base.NodeCursor;
import y.base.NodeList;
import y.base.NodeMap;
import y.util.EdgeMapAdapter;
import y.util.Filter;
import y.util.NodeMapAdapter;
import y.view.Bend;
import y.view.BendCursor;
import y.view.BendList;
import y.view.EdgeRealizer;
import y.view.Graph2D;
import y.view.Graph2DSelectionEvent;
import y.view.Graph2DSelectionListener;
import y.view.NodePort;
import y.view.NodeRealizer;
import y.view.YLabel;
import y.view.hierarchy.HierarchyManager;

public abstract class Selections {
    private Selections() {
    }

    public static boolean isSelected(Graph2D graph2D, Object object) {
        return object instanceof Node && graph2D.isSelected((Node)object) || object instanceof Edge && graph2D.isSelected((Edge)object) || object instanceof Bend && graph2D.isSelected((Bend)object) || object instanceof YLabel && graph2D.isSelected((YLabel)object) || object instanceof NodePort && graph2D.isSelected((NodePort)object);
    }

    public static void setSelected(Graph2D graph2D, Object object, boolean bl) {
        block5: {
            block8: {
                int n2;
                block7: {
                    block6: {
                        block4: {
                            n2 = NodeRealizer.z;
                            if (!(object instanceof Node)) break block4;
                            graph2D.setSelected((Node)object, bl);
                            if (n2 == 0) break block5;
                        }
                        if (!(object instanceof Edge)) break block6;
                        graph2D.setSelected((Edge)object, bl);
                        if (n2 == 0) break block5;
                    }
                    if (!(object instanceof Bend)) break block7;
                    graph2D.setSelected((Bend)object, bl);
                    if (n2 == 0) break block5;
                }
                if (!(object instanceof YLabel)) break block8;
                graph2D.setSelected((YLabel)object, bl);
                if (n2 == 0) break block5;
            }
            if (object instanceof NodePort) {
                graph2D.setSelected((NodePort)object, bl);
            }
        }
    }

    public static void selectNodesAndSelfLoopBends(Graph2D graph2D) {
        int n2 = NodeRealizer.z;
        NodeCursor nodeCursor = graph2D.nodes();
        while (nodeCursor.ok()) {
            Selections.selectNodeAndSelfLoopBends(graph2D, nodeCursor.node());
            nodeCursor.next();
            if (n2 == 0) continue;
        }
    }

    public static void selectNodeAndSelfLoopBends(Graph2D graph2D, Node node) {
        int n2 = NodeRealizer.z;
        graph2D.setSelected(node, true);
        EdgeCursor edgeCursor = node.outEdges();
        while (edgeCursor.ok()) {
            Edge edge = edgeCursor.edge();
            if (edge.isSelfLoop()) {
                BendCursor bendCursor = graph2D.getRealizer(edge).bends();
                while (bendCursor.ok()) {
                    graph2D.setSelected(bendCursor.bend(), true);
                    bendCursor.next();
                    if (n2 == 0) {
                        if (n2 == 0) continue;
                    }
                    break;
                }
            } else {
                edgeCursor.next();
            }
            if (n2 == 0) continue;
        }
    }

    public static void deselectNodeAndSelfLoopBends(Graph2D graph2D, Node node) {
        int n2 = NodeRealizer.z;
        graph2D.setSelected(node, false);
        EdgeCursor edgeCursor = node.outEdges();
        while (edgeCursor.ok()) {
            Edge edge = edgeCursor.edge();
            if (edge.isSelfLoop()) {
                BendCursor bendCursor = graph2D.getRealizer(edge).bends();
                while (bendCursor.ok()) {
                    graph2D.setSelected(bendCursor.bend(), false);
                    bendCursor.next();
                    if (n2 == 0) {
                        if (n2 == 0) continue;
                    }
                    break;
                }
            } else {
                edgeCursor.next();
            }
            if (n2 == 0) continue;
        }
    }

    public static DataProvider createSelectionDataProvider(Graph2D graph2D) {
        return new _c(Selections.createSelectionNodeMap(graph2D), Selections.createSelectionEdgeMap(graph2D));
    }

    public static NodeMap createSelectionNodeMap(Graph2D graph2D) {
        return new _d(graph2D);
    }

    public static EdgeMap createSelectionEdgeMap(Graph2D graph2D) {
        return new _b(graph2D);
    }

    public static void findExtendedGroupingSelection(final Graph2D graph2D, NodeList nodeList, NodeList nodeList2, BendList bendList) {
        Selections.b(graph2D, new Filter(){

            public boolean accept(Object object) {
                return graph2D.isSelected((Node)object);
            }
        }, new Filter(){

            public boolean accept(Object object) {
                return graph2D.isSelected((Bend)object);
            }
        }, nodeList, nodeList2, bendList);
    }

    static void b(Graph2D graph2D, Filter filter, Filter filter2, NodeList nodeList, NodeList nodeList2, BendList bendList) {
        int n2 = NodeRealizer.z;
        HierarchyManager hierarchyManager = HierarchyManager.getInstance(graph2D);
        if (hierarchyManager == null) {
            return;
        }
        boolean[] blArray = new boolean[graph2D.N()];
        NodeCursor nodeCursor = graph2D.nodes();
        while (nodeCursor.ok()) {
            Node node;
            Node node2 = nodeCursor.node();
            block1: while (filter.accept(node = node2)) {
                if (hierarchyManager.isGroupNode(node) && !blArray[node.index()]) {
                    Selections.b(hierarchyManager, graph2D, filter, filter2, node, node, nodeList, bendList, blArray);
                }
                Node node3 = hierarchyManager.getParentNode(node);
                while (hierarchyManager.isGroupNode(node3)) {
                    block9: {
                        block8: {
                            node2 = node3;
                            if (n2 != 0) continue block1;
                            if (node2.getGraph() != graph2D || blArray[node3.index()]) break block1;
                            if (!filter.accept(node3)) break block8;
                            Selections.b(hierarchyManager, graph2D, filter, filter2, node3, node3, nodeList, bendList, blArray);
                            if (n2 == 0) break block9;
                        }
                        nodeList2.add(node3);
                    }
                    blArray[node3.index()] = true;
                    node3 = hierarchyManager.getParentNode(node3);
                    if (n2 == 0) continue;
                }
                break block1;
            }
            nodeCursor.next();
            if (n2 == 0) continue;
        }
    }

    private static void b(HierarchyManager hierarchyManager, Graph2D graph2D, Filter filter, Filter filter2, Node node, Node node2, NodeList nodeList, BendList bendList, boolean[] blArray) {
        int n2 = NodeRealizer.z;
        NodeCursor nodeCursor = hierarchyManager.getChildren(node2);
        block0: while (true) {
            int n3 = nodeCursor.ok();
            block1: while (n3 != 0) {
                Node node3 = nodeCursor.node();
                if (nodeList != null && !blArray[node3.index()] && !filter.accept(node3)) {
                    nodeList.add(node3);
                    blArray[node3.index()] = true;
                }
                if (hierarchyManager.isGroupNode(node3)) {
                    Selections.b(hierarchyManager, graph2D, filter, filter2, node, node3, nodeList, bendList, blArray);
                }
                if (bendList != null) {
                    for (Edge edge = node3.firstOutEdge(); edge != null; edge = edge.nextOutEdge()) {
                        EdgeRealizer edgeRealizer = graph2D.getRealizer(edge);
                        n3 = edgeRealizer.bendCount();
                        if (n2 != 0) continue block1;
                        if (n3 <= 0 || !hierarchyManager.isAncestor(node, edge.target())) continue;
                        BendCursor bendCursor = edgeRealizer.bends();
                        while (bendCursor.ok()) {
                            n3 = filter2.accept(bendCursor.bend()) ? 1 : 0;
                            if (n2 != 0) continue block1;
                            if (n3 == 0) {
                                bendList.add(bendCursor.bend());
                            }
                            bendCursor.next();
                            if (n2 == 0) continue;
                        }
                        if (n2 == 0) continue;
                    }
                }
                nodeCursor.next();
                if (n2 == 0) continue block0;
            }
            break;
        }
    }

    public static boolean isNodeSelectionEmpty(Graph2D graph2D) {
        boolean bl;
        block3: {
            int n2 = NodeRealizer.z;
            NodeCursor nodeCursor = graph2D.nodes();
            while (nodeCursor.ok()) {
                bl = graph2D.isSelected(nodeCursor.node());
                if (n2 == 0) {
                    if (bl) {
                        return false;
                    }
                    nodeCursor.next();
                    if (n2 == 0) continue;
                }
                break block3;
            }
            bl = true;
        }
        return bl;
    }

    public static boolean isEdgeSelectionEmpty(Graph2D graph2D) {
        boolean bl;
        block3: {
            int n2 = NodeRealizer.z;
            EdgeCursor edgeCursor = graph2D.edges();
            while (edgeCursor.ok()) {
                bl = graph2D.isSelected(edgeCursor.edge());
                if (n2 == 0) {
                    if (bl) {
                        return false;
                    }
                    edgeCursor.next();
                    if (n2 == 0) continue;
                }
                break block3;
            }
            bl = true;
        }
        return bl;
    }

    public static class SelectionStateObserver
    implements Graph2DSelectionListener,
    GraphListener {
        int af = 0;
        boolean ze = false;

        public void onGraph2DSelectionEvent(Graph2DSelectionEvent graph2DSelectionEvent) {
            this.ze = true;
            if (this.af == 0) {
                this.updateSelectionState(graph2DSelectionEvent.getGraph2D());
                this.ze = false;
            }
        }

        public void onGraphEvent(GraphEvent graphEvent) {
            int n2 = NodeRealizer.z;
            switch (graphEvent.getType()) {
                case 12: {
                    ++this.af;
                    if (n2 == 0) break;
                }
                case 13: {
                    --this.af;
                    if (!this.ze || this.af != 0) break;
                    this.updateSelectionState((Graph2D)graphEvent.getGraph());
                    this.ze = false;
                    if (n2 == 0) break;
                }
                case 0: 
                case 1: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 10: 
                case 11: {
                    this.ze = true;
                    if (this.af != 0) break;
                    this.updateSelectionState((Graph2D)graphEvent.getGraph());
                    this.ze = false;
                }
            }
        }

        protected void updateSelectionState(Graph2D graph2D) {
        }
    }

    private static final class _c
    implements DataProvider {
        private NodeMap me;
        private EdgeMap le;

        _c(NodeMap nodeMap, EdgeMap edgeMap) {
            this.me = nodeMap;
            this.le = edgeMap;
        }

        public Object get(Object object) {
            if (object instanceof Node) {
                return this.me.get(object);
            }
            if (object instanceof Edge) {
                return this.le.get(object);
            }
            return null;
        }

        public boolean getBool(Object object) {
            if (object instanceof Node) {
                return this.me.getBool(object);
            }
            if (object instanceof Edge) {
                return this.le.getBool(object);
            }
            return false;
        }

        public double getDouble(Object object) {
            if (object instanceof Node) {
                return this.me.getDouble(object);
            }
            if (object instanceof Edge) {
                return this.le.getDouble(object);
            }
            return 0.0;
        }

        public int getInt(Object object) {
            if (object instanceof Node) {
                return this.me.getInt(object);
            }
            if (object instanceof Edge) {
                return this.le.getInt(object);
            }
            return 0;
        }
    }

    private static final class _b
    extends EdgeMapAdapter {
        private Graph2D sb;

        _b(Graph2D graph2D) {
            this.sb = graph2D;
        }

        public void setBool(Object object, boolean bl) {
            this.sb.setSelected((Edge)object, bl);
        }

        public boolean getBool(Object object) {
            return this.sb.isSelected((Edge)object);
        }
    }

    private static final class _d
    extends NodeMapAdapter {
        private Graph2D h;

        _d(Graph2D graph2D) {
            this.h = graph2D;
        }

        public void setBool(Object object, boolean bl) {
            this.h.setSelected((Node)object, bl);
        }

        public boolean getBool(Object object) {
            return this.h.isSelected((Node)object);
        }
    }
}

