/*
 * Decompiled with CFR 0.152.
 */
package y.view;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import y.geom.YPoint;
import y.io.BadVersionException;
import y.view.EdgeRealizer;
import y.view.NodeRealizer;
import y.view.c;

public class Port {
    protected double xoff;
    protected double yoff;
    protected EdgeRealizer realizer;

    public Port() {
        this(0.0, 0.0);
    }

    public Port(double d2, double d3) {
        this.xoff = d2;
        this.yoff = d3;
    }

    public Port(Port port) {
        this(port.xoff, port.yoff);
    }

    public Port createCopy() {
        return new Port(this.xoff, this.yoff);
    }

    public Port createRotatedPort() {
        return new Port(this.getOffsetY(), -this.getOffsetX());
    }

    void b(EdgeRealizer edgeRealizer) {
        this.realizer = edgeRealizer;
    }

    public EdgeRealizer getOwner() {
        return this.realizer;
    }

    public boolean findIntersection(NodeRealizer nodeRealizer, double d2, double d3, double d4, double d5, Point2D point2D) {
        return nodeRealizer.findIntersection(d2, d3, d4, d5, point2D);
    }

    public void paint(Graphics2D graphics2D, NodeRealizer nodeRealizer) {
        if (EdgeRealizer.b(this.realizer, graphics2D)) {
            Rectangle2D.Double double_ = c.b().m;
            double_.height = 6.0;
            double_.width = 6.0;
            double_.x = this.getX(nodeRealizer) - 3.0;
            double_.y = this.getY(nodeRealizer) - 3.0;
            graphics2D.setColor(Color.black);
            graphics2D.fill(double_);
        }
    }

    protected void setDirty() {
        if (this.realizer != null) {
            this.realizer.setDirty();
        }
    }

    public boolean contains(double d2, double d3) {
        block2: {
            NodeRealizer nodeRealizer;
            block4: {
                block3: {
                    if (!this.realizer.isSelected()) break block2;
                    if (this.realizer.getSourcePort() != this) break block3;
                    nodeRealizer = this.realizer.getSourceRealizer();
                    if (NodeRealizer.z == 0) break block4;
                }
                nodeRealizer = this.realizer.getTargetRealizer();
            }
            double d4 = this.getX(nodeRealizer);
            double d5 = this.getY(nodeRealizer);
            return d4 - 3.0 <= d2 && d4 + 3.0 >= d2 && d5 - 3.0 <= d3 && d5 + 3.0 >= d3;
        }
        return false;
    }

    YPoint b() {
        NodeRealizer nodeRealizer;
        block3: {
            block2: {
                if (this.realizer.getSourcePort() != this) break block2;
                nodeRealizer = this.realizer.getSourceRealizer();
                if (NodeRealizer.z == 0) break block3;
            }
            nodeRealizer = this.realizer.getTargetRealizer();
        }
        return new YPoint(this.getX(nodeRealizer), this.getY(nodeRealizer));
    }

    public void calcUnionRect(Rectangle2D rectangle2D, NodeRealizer nodeRealizer) {
        rectangle2D.add(this.getX(nodeRealizer), this.getY(nodeRealizer));
    }

    public double getOffsetX() {
        return this.xoff;
    }

    public double getOffsetY() {
        return this.yoff;
    }

    public double getX(NodeRealizer nodeRealizer) {
        return nodeRealizer.getCenterX() + this.xoff;
    }

    public double getY(NodeRealizer nodeRealizer) {
        return nodeRealizer.getCenterY() + this.yoff;
    }

    public void setOffsetX(double d2) {
        this.setDirty();
        this.xoff = d2;
    }

    public void setOffsetY(double d2) {
        this.setDirty();
        this.yoff = d2;
    }

    public void setOffsets(double d2, double d3) {
        this.setDirty();
        this.xoff = d2;
        this.yoff = d3;
    }

    public void write(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeByte(1);
        objectOutputStream.writeFloat((float)this.xoff);
        objectOutputStream.writeFloat((float)this.yoff);
    }

    public void read(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n2 = NodeRealizer.z;
        switch (objectInputStream.readByte()) {
            case 0: {
                objectInputStream.readByte();
                this.xoff = objectInputStream.readFloat();
                this.yoff = objectInputStream.readFloat();
                if (n2 == 0) break;
            }
            case 1: {
                this.xoff = objectInputStream.readFloat();
                this.yoff = objectInputStream.readFloat();
                if (n2 == 0) break;
            }
            default: {
                throw new BadVersionException();
            }
        }
    }

    public String toString() {
        return "Port: (" + this.getOffsetX() + ',' + this.getOffsetY() + ')';
    }
}

