/*
 * Decompiled with CFR 0.152.
 */
package y.view;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.HashMap;
import y.view.Drawable;
import y.view.Graph2DView;
import y.view.GraphicsContext;
import y.view.NodeRealizer;
import y.view.YRenderingHints;

public class Graph2DPrinter
implements Printable {
    public static final byte TITLE_AND_FOOTER_FOR_ENTIRE_POSTER = 0;
    public static final byte TITLE_AND_FOOTER_FOR_EVERY_PAGE = 1;
    private Graph2DView h;
    private int f = 1;
    private int b = 1;
    private byte m = 1;
    private boolean d = false;
    private double c = 1.0;
    private byte k = 0;
    private RenderingHints e;
    private boolean l = true;
    TitleDrawable n;
    FooterDrawable i;
    byte g;
    Rectangle2D j;
    public static final byte SCALING_AUTO = 0;
    public static final byte SCALING_FIX = 1;
    public static final byte CLIP_VIEW = 0;
    public static final byte CLIP_GRAPH = 1;
    public static final byte CLIP_CUSTOM = 2;

    public Graph2DPrinter(Graph2DView graph2DView) {
        this.h = graph2DView;
        this.n = new DefaultTitleDrawable();
        this.e = new RenderingHints(new HashMap());
        this.e.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        this.g = 0;
    }

    public void setPrintPosterCoords(boolean bl) {
        this.d = bl;
    }

    public boolean getPrintPosterCoords() {
        return this.d;
    }

    public void setCenterContentsOnPageEnabled(boolean bl) {
        this.l = bl;
    }

    public boolean isCenterContentsOnPageEnabled() {
        return this.l;
    }

    public void setPosterRows(int n2) {
        this.f = n2;
    }

    public void setPosterColumns(int n2) {
        this.b = n2;
    }

    public int getPosterRows() {
        return this.f;
    }

    public int getPosterColumns() {
        return this.b;
    }

    public void setClipType(byte by) {
        this.m = by;
    }

    public byte getClipType() {
        return this.m;
    }

    public void setScalingFactor(double d2) {
        this.c = d2;
    }

    public double getScalingFactor() {
        return this.c;
    }

    public void setScalingType(byte by) {
        this.k = by;
    }

    public byte getScalingType() {
        return this.k;
    }

    public void setCustomClip(Rectangle2D rectangle2D) {
        this.j = rectangle2D;
    }

    public Rectangle2D getCustomClip() {
        return this.j;
    }

    public byte getTextBarType() {
        return this.g;
    }

    public void setTextBarType(byte by) {
        switch (by) {
            case 0: 
            case 1: {
                this.g = by;
                if (NodeRealizer.z == 0) break;
            }
            default: {
                throw new IllegalArgumentException("Not a valid type for title and footer.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public int print(Graphics var1_1, PageFormat var2_2, int var3_3) throws PrinterException {
        var54_4 = NodeRealizer.z;
        var4_5 = (Graphics2D)var1_1.create();
        var4_5.addRenderingHints(this.e);
        try {
            block27: {
                block26: {
                    var5_6 = var4_5.getTransform();
                    var6_7 = var4_5.getClip();
                    if (var6_7 == null) {
                        throw new IllegalArgumentException("Graphics.getClip() must be non-null!");
                    }
                    var7_8 = var2_2.getImageableX();
                    var9_9 = var2_2.getImageableY();
                    var11_10 = var2_2.getImageableWidth();
                    var13_11 = var2_2.getImageableHeight();
                    var15_12 = this.b();
                    var16_13 = var15_12.getWidth();
                    var18_14 = var15_12.getHeight();
                    var20_15 = var15_12.getX();
                    var22_16 = var15_12.getY();
                    var24_17 = 0.0;
                    var26_18 = 0.0;
                    if (this.n != null) {
                        var28_19 = new PrintContext();
                        var28_19.b = var4_5;
                        var28_19.c = var3_3;
                        var28_19.f = var2_2;
                        var28_19.g = this.b;
                        var28_19.h = this.f;
                        var28_19.e = var3_3 % this.b;
                        var28_19.d = var3_3 / this.b;
                        this.n.setContext(var28_19);
                        var24_17 = this.n.getBounds().getHeight();
                    }
                    if (this.i != null) {
                        var28_19 = new PrintContext();
                        var28_19.b = var4_5;
                        var28_19.c = var3_3;
                        var28_19.f = var2_2;
                        var28_19.g = this.b;
                        var28_19.h = this.f;
                        var28_19.e = var3_3 % this.b;
                        var28_19.d = var3_3 / this.b;
                        this.i.setContext(var28_19);
                        var26_18 = this.i.getBounds().getHeight();
                    }
                    switch (this.k) {
                        case 1: {
                            var32_21 = var16_13 * this.c;
                            var34_22 = var18_14 * this.c;
                            var31_23 = (int)Math.ceil(var32_21 / var11_10 - 0.01);
                            var30_24 = (int)Math.ceil(var34_22 / var13_11 - 0.01);
                            var28_20 = this.c;
                            var32_21 = var11_10 * (double)var31_23;
                            if (this.getTextBarType() == 1) {
                                var34_22 = var13_11 * (double)var30_24 - var24_17 * (double)var30_24 - var26_18 * (double)var30_24;
                                if (var54_4 == 0) break;
                            }
                            var34_22 = var13_11 * (double)var30_24 - var24_17 - var26_18;
                            if (var54_4 == 0) break;
                        }
                        case 0: {
                            var31_23 = this.b;
                            var30_24 = this.f;
                            var32_21 = var11_10 * (double)var31_23;
                            if (this.getTextBarType() != 1) ** GOTO lbl62
                            var34_22 = var13_11 * (double)var30_24 - var24_17 * (double)var30_24 - var26_18 * (double)var30_24;
                            if (var54_4 == 0) ** GOTO lbl63
lbl62:
                            // 2 sources

                            var34_22 = var13_11 * (double)var30_24 - var24_17 - var26_18;
lbl63:
                            // 2 sources

                            if (var32_21 / var34_22 > var16_13 / var18_14) {
                                var28_20 = var34_22 / var18_14;
                                if (var54_4 == 0) break;
                            }
                            var28_20 = var32_21 / var16_13;
                            if (var54_4 == 0) break;
                        }
                        default: {
                            throw new RuntimeException("Undefined ScalingType: " + this.k);
                        }
                    }
                    if (var3_3 >= var30_24 * var31_23) {
                        var36_25 = 1;
                        return var36_25;
                    }
                    var36_26 = var3_3 % var31_23;
                    var37_27 = var3_3 / var31_23;
                    var38_28 = 0.0;
                    var40_29 = 0.0;
                    if (this.l) {
                        var38_28 = Math.max(0.0, (var32_21 - var16_13 * var28_20) / 2.0);
                        var40_29 = Math.max(0.0, (var34_22 - var18_14 * var28_20) / 2.0);
                    }
                    if (this.getTextBarType() != 1) break block26;
                    var42_30 = (int)Math.ceil(var7_8);
                    var43_32 = (int)Math.ceil(var9_9 + var24_17);
                    var44_34 = (int)Math.floor(var7_8 + var11_10);
                    var45_36 = (int)Math.floor(var9_9 + var13_11 - var26_18);
                    var4_5.clipRect(var42_30, var43_32, var44_34 - var42_30, var45_36 - var43_32);
                    var4_5.translate(var7_8 + var38_28 - var20_15 * var28_20 - var11_10 * (double)var36_26, var9_9 + var40_29 - var22_16 * var28_20 - var13_11 * (double)var37_27 + var24_17 * (double)(var37_27 + 1) + var26_18 * (double)var37_27);
                    if (var54_4 == 0) break block27;
                }
                var4_5.translate(var7_8 + var38_28 - var20_15 * var28_20 - var11_10 * (double)var36_26, var9_9 + var40_29 - var22_16 * var28_20 - var13_11 * (double)var37_27 + var24_17);
            }
            var4_5.scale(var28_20, var28_20);
            var42_31 = new Rectangle(var15_12);
            var43_33 = var4_5.getClipBounds();
            var44_35 = var43_33.intersection(var42_31);
            var4_5.clip(var44_35);
            var45_37 = this.createGraphicsContext(this.h, var4_5);
            if (var45_37 != null) {
                var4_5.setRenderingHint(YRenderingHints.GRAPHICS_CONTEXT_KEY, var45_37);
            }
            if (this.h.getClientProperty("Graph2DPrinter.fixJdk8068168") != null) {
                var46_38 = var4_5.getPaint();
                var47_39 = var44_35.getX();
                var49_42 = var44_35.getY();
                var51_43 = new Point2D.Double(var47_39, var49_42);
                var52_44 = new Color(255, 255, 255, 0);
                var4_5.setPaint(new GradientPaint(var51_43, var52_44, var51_43, var52_44));
                var4_5.fill(new Rectangle2D.Double(var47_39, var49_42, 0.0, 0.0));
                var4_5.setPaint((Paint)var46_38);
            }
            this.h.getBackgroundRenderer().paint(var4_5, var44_35.x, var44_35.y, var44_35.width, var44_35.height);
            this.h.k(var4_5);
            var46_38 = this.h.getGraph2DRenderer();
            var46_38.paint(var4_5, this.h.getGraph2D());
            this.h.j(var4_5);
            var4_5.setTransform(var5_6);
            var4_5.setClip(var6_7);
            var4_5.setColor(Color.black);
            if (this.getPrintPosterCoords()) {
                var47_40 = new PrintContext();
                var47_40.b = var4_5;
                var47_40.c = var3_3;
                var47_40.f = var2_2;
                var47_40.g = var31_23;
                var47_40.h = var30_24;
                var47_40.e = var3_3 % var31_23;
                var47_40.d = var3_3 / var31_23;
                this.printPosterCoords(var4_5, var47_40);
            }
            if (this.n != null) {
                this.n.paint(var4_5);
            }
            if (this.i != null) {
                this.i.paint(var4_5);
            }
            var47_41 = 0;
            return var47_41;
        }
        finally {
            var4_5.dispose();
        }
    }

    protected void printPosterCoords(Graphics2D graphics2D, PrintContext printContext) {
        Color color = graphics2D.getColor();
        Font font = graphics2D.getFont();
        this.initializePosterCoordsFont(graphics2D, printContext);
        PageFormat pageFormat = printContext.getPageFormat();
        int n2 = (int)pageFormat.getImageableX() + 15;
        int n3 = (int)pageFormat.getImageableY() + 15;
        int n4 = printContext.getCurrentColumn() + 1;
        int n5 = printContext.getCurrentRow() + 1;
        TextLayout textLayout = new TextLayout("[" + n4 + ',' + n5 + "]", graphics2D.getFont(), graphics2D.getFontRenderContext());
        graphics2D.setColor(Color.white);
        Rectangle2D rectangle2D = textLayout.getBounds();
        rectangle2D.setRect(rectangle2D.getX() + (double)n2 - 2.0, rectangle2D.getY() + (double)n3 - 2.0, rectangle2D.getWidth() + 4.0, rectangle2D.getHeight() + 4.0);
        graphics2D.fill(rectangle2D);
        graphics2D.setColor(Color.black);
        textLayout.draw(graphics2D, n2, n3);
        graphics2D.setFont(font);
        graphics2D.setColor(color);
    }

    protected void initializePosterCoordsFont(Graphics2D graphics2D, PrintContext printContext) {
        Font font = graphics2D.getFont();
        if (font.getSize() != 11) {
            graphics2D.setFont(font.deriveFont(11.0f));
        }
    }

    public Dimension getFixedScalingPosterDimension(PageFormat pageFormat) {
        Rectangle rectangle = this.b();
        double d2 = rectangle.getWidth() * this.c;
        double d3 = rectangle.getHeight() * this.c;
        this.b = (int)Math.ceil(d2 / pageFormat.getImageableWidth());
        this.f = (int)Math.ceil(d3 / pageFormat.getImageableHeight());
        return new Dimension(this.b, this.f);
    }

    Rectangle b() {
        Rectangle rectangle = null;
        switch (this.getClipType()) {
            case 0: {
                rectangle = this.h.getVisibleRect();
                break;
            }
            case 2: {
                if (this.j == null) {
                    throw new IllegalArgumentException("custom clip not set");
                }
                rectangle = this.j.getBounds();
                break;
            }
            default: {
                rectangle = this.h.getGraph2D().getBoundingBox();
                rectangle.setFrame(rectangle.x - 2, rectangle.y - 2, rectangle.width + 4, rectangle.height + 4);
            }
        }
        return rectangle;
    }

    protected GraphicsContext createGraphicsContext(Graph2DView graph2DView, Graphics2D graphics2D) {
        if (graphics2D.getRenderingHint(YRenderingHints.GRAPHICS_CONTEXT_KEY) == null) {
            GraphicsContext graphicsContext = new GraphicsContext();
            graphicsContext.setPrinting(true);
            graphicsContext.setGraph2DView(graph2DView);
            Point2D point2D = graph2DView.getViewPoint2D();
            AffineTransform affineTransform = graphics2D.getTransform();
            affineTransform.translate(point2D.getX(), point2D.getY());
            double d2 = 1.0 / graph2DView.getZoom();
            affineTransform.scale(d2, d2);
            graphicsContext.setViewTransform(affineTransform);
            return graphicsContext;
        }
        return null;
    }

    public void setTitleDrawable(TitleDrawable titleDrawable) {
        this.n = titleDrawable;
    }

    public TitleDrawable getTitleDrawable() {
        return this.n;
    }

    public void setFooterDrawable(FooterDrawable footerDrawable) {
        this.i = footerDrawable;
    }

    public FooterDrawable getFooterDrawable() {
        return this.i;
    }

    public void setRenderingHints(RenderingHints renderingHints) {
        if (renderingHints == null) {
            throw new IllegalArgumentException("RenderingHints cannot be null");
        }
        this.e = renderingHints;
    }

    public RenderingHints getRenderingHints() {
        return this.e;
    }

    public static class RepeatingTitleDrawable
    extends AbstractTitleDrawable {
        void tb() {
            block4: {
                double d2;
                double d3;
                Paper paper;
                double d4;
                block6: {
                    int n2;
                    block5: {
                        n2 = NodeRealizer.z;
                        this.jg.setFrame(0.0, 0.0, 0.0, 0.0);
                        if (this.mg == null || "".equals(this.mg)) break block4;
                        this.ig = new TextLayout(this.mg, this.hg, this.kg.b.getFontRenderContext());
                        d4 = this.ig.getBounds().getHeight() + 20.0;
                        paper = this.kg.f.getPaper();
                        if (this.kg.f.getOrientation() != 1) break block5;
                        this.jg = new Rectangle2D.Double(paper.getImageableX(), paper.getImageableY(), paper.getImageableWidth(), d4);
                        if (n2 == 0) break block4;
                    }
                    if (this.kg.f.getOrientation() != 0) break block6;
                    d3 = paper.getHeight() - paper.getImageableY() - paper.getImageableHeight();
                    d2 = paper.getImageableX();
                    this.jg = new Rectangle2D.Double(d3, d2, paper.getImageableHeight(), d4);
                    if (n2 == 0) break block4;
                }
                if (this.kg.f.getOrientation() == 2) {
                    d3 = paper.getImageableY();
                    d2 = paper.getWidth() - paper.getImageableX() - paper.getImageableWidth();
                    this.jg = new Rectangle2D.Double(d3, d2, paper.getImageableHeight(), d4);
                }
            }
        }
    }

    public static class DefaultTitleDrawable
    extends AbstractTitleDrawable {
        void tb() {
            block4: {
                Paper paper;
                block6: {
                    double d2;
                    double d3;
                    double d4;
                    block7: {
                        int n2;
                        block5: {
                            n2 = NodeRealizer.z;
                            this.jg.setFrame(0.0, 0.0, 0.0, 0.0);
                            if (this.mg == null || "".equals(this.mg)) break block4;
                            this.ig = new TextLayout(this.mg, this.hg, this.kg.b.getFontRenderContext());
                            d4 = this.ig.getBounds().getHeight() + 20.0;
                            paper = this.kg.f.getPaper();
                            if (this.kg.f.getOrientation() != 1) break block5;
                            this.jg = new Rectangle2D.Double(paper.getImageableX(), paper.getImageableY(), paper.getImageableWidth(), d4);
                            if (n2 == 0) break block6;
                        }
                        if (this.kg.f.getOrientation() != 0) break block7;
                        d3 = paper.getHeight() - paper.getImageableY() - paper.getImageableHeight();
                        d2 = paper.getImageableX();
                        this.jg = new Rectangle2D.Double(d3, d2, paper.getImageableHeight(), d4);
                        if (n2 == 0) break block6;
                    }
                    if (this.kg.f.getOrientation() == 2) {
                        d3 = paper.getImageableY();
                        d2 = paper.getWidth() - paper.getImageableX() - paper.getImageableWidth();
                        this.jg = new Rectangle2D.Double(d3, d2, paper.getImageableHeight(), d4);
                    }
                }
                this.jg.x -= (double)this.kg.e * this.jg.width;
                this.jg.y -= (double)this.kg.d * paper.getImageableHeight();
                this.jg.width *= (double)this.kg.g;
            }
        }
    }

    public static abstract class AbstractTitleDrawable
    extends AbstractTextBarDrawable {
        Color ng = Color.lightGray;

        public void paint(Graphics2D graphics2D) {
            this.tb();
            if (this.ng != null) {
                graphics2D.setColor(this.ng);
                graphics2D.fill(this.jg);
            }
            if (this.lg != null && this.ig != null) {
                graphics2D.setColor(this.lg);
                Rectangle2D rectangle2D = this.ig.getBounds();
                this.ig.draw(graphics2D, (float)(this.jg.x + (this.jg.width - rectangle2D.getWidth()) / 2.0), (float)(this.jg.y - rectangle2D.getY() + (this.jg.height - rectangle2D.getHeight()) / 2.0));
            }
        }

        public Color getTitleBarColor() {
            return this.ng;
        }

        public void setTitleBarColor(Color color) {
            this.ng = color;
        }
    }

    public static class RepeatingFooterDrawable
    extends AbstractFooterDrawable {
        void tb() {
            block4: {
                double d2;
                double d3;
                Paper paper;
                double d4;
                block6: {
                    int n2;
                    block5: {
                        n2 = NodeRealizer.z;
                        this.jg.setFrame(0.0, 0.0, 0.0, 0.0);
                        if (this.mg == null || "".equals(this.mg)) break block4;
                        this.ig = new TextLayout(this.mg, this.hg, this.kg.b.getFontRenderContext());
                        d4 = this.ig.getBounds().getHeight() + 20.0;
                        paper = this.kg.f.getPaper();
                        if (this.kg.f.getOrientation() != 1) break block5;
                        this.jg = new Rectangle2D.Double(paper.getImageableX(), paper.getImageableY() + paper.getImageableHeight() - d4, paper.getImageableWidth(), d4);
                        if (n2 == 0) break block4;
                    }
                    if (this.kg.f.getOrientation() != 0) break block6;
                    d3 = paper.getHeight() - paper.getImageableY() - paper.getImageableHeight();
                    d2 = paper.getImageableX() + paper.getImageableWidth() - d4;
                    this.jg = new Rectangle2D.Double(d3, d2, paper.getImageableHeight(), d4);
                    if (n2 == 0) break block4;
                }
                if (this.kg.f.getOrientation() == 2) {
                    d3 = paper.getImageableY();
                    d2 = paper.getWidth() - paper.getImageableX() - d4;
                    this.jg = new Rectangle2D.Double(d3, d2, paper.getImageableHeight(), d4);
                }
            }
        }
    }

    public static class DefaultFooterDrawable
    extends AbstractFooterDrawable {
        void tb() {
            block4: {
                block6: {
                    double d2;
                    double d3;
                    Paper paper;
                    double d4;
                    block7: {
                        int n2;
                        block5: {
                            n2 = NodeRealizer.z;
                            this.jg.setFrame(0.0, 0.0, 0.0, 0.0);
                            if (this.mg == null || "".equals(this.mg)) break block4;
                            this.ig = new TextLayout(this.mg, this.hg, this.kg.b.getFontRenderContext());
                            d4 = this.ig.getBounds().getHeight() + 20.0;
                            paper = this.kg.f.getPaper();
                            if (this.kg.f.getOrientation() != 1) break block5;
                            this.jg = new Rectangle2D.Double(paper.getImageableX(), paper.getImageableY() + paper.getImageableHeight() - d4, paper.getImageableWidth(), d4);
                            this.jg.y += (double)(this.kg.h - this.kg.d - 1) * paper.getImageableHeight();
                            if (n2 == 0) break block6;
                        }
                        if (this.kg.f.getOrientation() != 0) break block7;
                        d3 = paper.getHeight() - paper.getImageableY() - paper.getImageableHeight();
                        d2 = paper.getImageableX() + paper.getImageableWidth() - d4;
                        this.jg = new Rectangle2D.Double(d3, d2, paper.getImageableHeight(), d4);
                        this.jg.y += (double)(this.kg.h - this.kg.d - 1) * paper.getImageableWidth();
                        if (n2 == 0) break block6;
                    }
                    if (this.kg.f.getOrientation() == 2) {
                        d3 = paper.getImageableY();
                        d2 = paper.getWidth() - paper.getImageableX() - d4;
                        this.jg = new Rectangle2D.Double(d3, d2, paper.getImageableHeight(), d4);
                        this.jg.y += (double)(this.kg.h - this.kg.d - 1) * paper.getImageableWidth();
                    }
                }
                this.jg.x -= (double)this.kg.e * this.jg.width;
                this.jg.width *= (double)this.kg.g;
            }
        }
    }

    public static abstract class AbstractFooterDrawable
    extends AbstractTextBarDrawable {
        Color og = Color.lightGray;

        public void paint(Graphics2D graphics2D) {
            this.tb();
            if (this.og != null) {
                graphics2D.setColor(this.og);
                graphics2D.fill(this.jg);
            }
            if (this.lg != null && this.ig != null) {
                graphics2D.setColor(this.lg);
                Rectangle2D rectangle2D = this.ig.getBounds();
                this.ig.draw(graphics2D, (float)(this.jg.x + (this.jg.width - rectangle2D.getWidth()) / 2.0), (float)(this.jg.y - rectangle2D.getY() + (this.jg.height - rectangle2D.getHeight()) / 2.0));
            }
        }

        public Color getFooterColor() {
            return this.og;
        }

        public void setFooterColor(Color color) {
            this.og = color;
        }
    }

    public static abstract class AbstractTextBarDrawable
    implements FooterDrawable,
    TitleDrawable {
        String mg = "";
        Font hg;
        Color lg;
        PrintContext kg;
        TextLayout ig;
        Rectangle2D.Double jg = new Rectangle2D.Double();

        public AbstractTextBarDrawable() {
            this.hg = new Font("Dialog", 0, 24);
            this.lg = Color.black;
        }

        public void setContext(PrintContext printContext) {
            this.kg = printContext;
        }

        public abstract void paint(Graphics2D var1);

        public Rectangle getBounds() {
            this.tb();
            return this.jg.getBounds();
        }

        abstract void tb();

        public Font getFont() {
            return this.hg;
        }

        public void setFont(Font font) {
            this.hg = font;
        }

        public PrintContext getPrintContext() {
            return this.kg;
        }

        public void setPrintContext(PrintContext printContext) {
            this.kg = printContext;
        }

        public String getText() {
            return this.mg;
        }

        public void setText(String string) {
            this.mg = string;
        }

        public Color getTextColor() {
            return this.lg;
        }

        public void setTextColor(Color color) {
            this.lg = color;
        }
    }

    public static interface FooterDrawable
    extends Drawable {
        public void setContext(PrintContext var1);
    }

    public static interface TitleDrawable
    extends Drawable {
        public void setContext(PrintContext var1);
    }

    public static class PrintContext {
        PageFormat f;
        Graphics2D b;
        int c;
        int e;
        int d;
        int h;
        int g;

        public int getCurrentColumn() {
            return this.e;
        }

        public int getCurrentPageNumber() {
            return this.c;
        }

        public int getCurrentRow() {
            return this.d;
        }

        public Graphics2D getGraphics2D() {
            return this.b;
        }

        public PageFormat getPageFormat() {
            return this.f;
        }

        public int getPosterColumns() {
            return this.g;
        }

        public int getPosterRows() {
            return this.h;
        }
    }
}

