/*
 * Decompiled with CFR 0.152.
 */
package y.view;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import y.view.Arrow;
import y.view.BendList;
import y.view.EdgeRealizer;
import y.view.GenericEdgePainter;
import y.view.GenericEdgeRealizer;
import y.view.LineType;
import y.view.NodeRealizer;

public class FramedEdgePainter
extends GenericEdgePainter {
    public static final String PROPERTY_FILL_COLOR = "FramedEdgePainter.fillColor";

    protected void paintPath(EdgeRealizer edgeRealizer, BendList bendList, GeneralPath generalPath, Graphics2D graphics2D, boolean bl) {
        if (this.initializeSelectionLine(edgeRealizer, graphics2D, bl)) {
            this.renderPath(edgeRealizer, graphics2D, generalPath, true);
        }
        if (this.initializeLine(edgeRealizer, graphics2D, bl)) {
            this.renderPath(edgeRealizer, graphics2D, generalPath, false);
        }
    }

    protected void renderPath(EdgeRealizer edgeRealizer, Graphics2D graphics2D, GeneralPath generalPath, boolean bl) {
        AffineTransform affineTransform;
        Object object;
        Object object2;
        Arrow arrow;
        Area area;
        boolean bl2;
        boolean bl3;
        Stroke stroke;
        Paint paint;
        block10: {
            block11: {
                int n2;
                block8: {
                    block9: {
                        n2 = NodeRealizer.z;
                        paint = graphics2D.getPaint();
                        stroke = graphics2D.getStroke();
                        bl3 = false;
                        bl2 = false;
                        area = new Area(stroke.createStrokedShape(generalPath));
                        arrow = edgeRealizer.getSourceArrow();
                        if (arrow == Arrow.NONE) break block8;
                        object2 = arrow.getShape();
                        if (object2 != null && this.b(arrow)) break block9;
                        bl3 = true;
                        if (n2 == 0) break block8;
                    }
                    object = this.getSourceArrowTransform(edgeRealizer, generalPath, arrow, bl);
                    area.add(new Area(((AffineTransform)object).createTransformedShape((Shape)object2)));
                }
                if ((object2 = edgeRealizer.getTargetArrow()) == Arrow.NONE) break block10;
                object = ((Arrow)object2).getShape();
                if (object != null && this.b((Arrow)object2)) break block11;
                bl2 = true;
                if (n2 == 0) break block10;
            }
            affineTransform = this.getTargetArrowTransform(edgeRealizer, generalPath, (Arrow)object2, bl);
            area.add(new Area(affineTransform.createTransformedShape((Shape)object)));
        }
        object = new GeneralPath();
        ((Path2D.Float)object).append(area.getPathIterator(null), false);
        this.paintBackground(edgeRealizer, graphics2D, generalPath, (GeneralPath)object, bl);
        graphics2D.setPaint(paint);
        this.paintForeground(edgeRealizer, graphics2D, generalPath, (GeneralPath)object, bl);
        graphics2D.setStroke(stroke);
        graphics2D.setPaint(paint);
        if (bl3) {
            affineTransform = this.getSourceArrowTransform(edgeRealizer, generalPath, arrow, bl);
            this.paintSourceArrow(edgeRealizer, graphics2D, generalPath, arrow, affineTransform);
        }
        if (bl2) {
            affineTransform = this.getTargetArrowTransform(edgeRealizer, generalPath, (Arrow)object2, bl);
            this.paintTargetArrow(edgeRealizer, graphics2D, generalPath, (Arrow)object2, affineTransform);
        }
    }

    protected void paintForeground(EdgeRealizer edgeRealizer, Graphics2D graphics2D, GeneralPath generalPath, GeneralPath generalPath2, boolean bl) {
        graphics2D.setStroke(this.getOutlineStroke(edgeRealizer, bl));
        graphics2D.draw(generalPath2);
    }

    protected void paintBackground(EdgeRealizer edgeRealizer, Graphics2D graphics2D, GeneralPath generalPath, GeneralPath generalPath2, boolean bl) {
        Paint paint = this.getFillPaint(edgeRealizer, bl);
        if (paint != null) {
            graphics2D.setPaint(paint);
            graphics2D.fill(generalPath2);
        }
    }

    protected AffineTransform getSourceArrowTransform(EdgeRealizer edgeRealizer, GeneralPath generalPath, Arrow arrow, boolean bl) {
        return edgeRealizer.b(generalPath, arrow, this.getSourceArrowScaleFactor(edgeRealizer, arrow, bl), true);
    }

    protected double getSourceArrowScaleFactor(EdgeRealizer edgeRealizer, Arrow arrow, boolean bl) {
        double d2 = bl ? 0.5 : 0.0;
        return edgeRealizer.getArrowScaleFactor() + d2;
    }

    protected AffineTransform getTargetArrowTransform(EdgeRealizer edgeRealizer, GeneralPath generalPath, Arrow arrow, boolean bl) {
        return edgeRealizer.b(generalPath, arrow, this.getTargetArrowScaleFactor(edgeRealizer, arrow, bl), false);
    }

    protected double getTargetArrowScaleFactor(EdgeRealizer edgeRealizer, Arrow arrow, boolean bl) {
        double d2 = bl ? 0.5 : 0.0;
        return edgeRealizer.getArrowScaleFactor() + d2;
    }

    private boolean b(Arrow arrow) {
        return Arrow.PLAIN != arrow && Arrow.DASH != arrow && Arrow.SKEWED_DASH != arrow && Arrow.T_SHAPE != arrow;
    }

    protected void paintSourceArrow(EdgeRealizer edgeRealizer, Graphics2D graphics2D, GeneralPath generalPath, Arrow arrow, AffineTransform affineTransform) {
        arrow.paint(graphics2D, affineTransform);
    }

    protected void paintTargetArrow(EdgeRealizer edgeRealizer, Graphics2D graphics2D, GeneralPath generalPath, Arrow arrow, AffineTransform affineTransform) {
        arrow.paint(graphics2D, affineTransform);
    }

    protected Paint getFillPaint(EdgeRealizer edgeRealizer, boolean bl) {
        Object object;
        if (edgeRealizer instanceof GenericEdgeRealizer && (object = ((GenericEdgeRealizer)edgeRealizer).getStyleProperty(PROPERTY_FILL_COLOR)) instanceof Color) {
            return (Color)object;
        }
        return null;
    }

    protected Stroke getOutlineStroke(EdgeRealizer edgeRealizer, boolean bl) {
        LineType lineType = edgeRealizer.getLineType();
        if (lineType.getLineStyle() == 127) {
            return new BasicStroke(1.0f, lineType.getEndCap(), lineType.getLineJoin(), lineType.getMiterLimit(), lineType.getDashArray(), lineType.getDashPhase());
        }
        return LineType.getLineType(1, lineType.getLineStyle());
    }

    protected Stroke getLineStroke(EdgeRealizer edgeRealizer, boolean bl) {
        LineType lineType = edgeRealizer.getLineType();
        if (lineType.getLineStyle() == 0) {
            return lineType;
        }
        return LineType.getLineType(Math.round(lineType.getLineWidth()), (byte)0);
    }
}

