/*
 * Decompiled with CFR 0.152.
 */
package y.view;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import y.base.Edge;
import y.base.Graph;
import y.base.ListCell;
import y.geom.Geom;
import y.geom.YPoint;
import y.geom.YRectangle;
import y.io.BadVersionException;
import y.io.YGFIOHandler;
import y.layout.EdgeLayout;
import y.view.Arrow;
import y.view.Bend;
import y.view.BendCursor;
import y.view.BendList;
import y.view.BridgeCalculator;
import y.view.DefaultGraph2DRenderer;
import y.view.EdgeLabel;
import y.view.Graph2D;
import y.view.LineType;
import y.view.MouseInputEditorProvider;
import y.view.NodeRealizer;
import y.view.PolyLineEdgeRealizer;
import y.view.Port;
import y.view.YRenderingHints;
import y.view.c;
import y.view.x;

public abstract class EdgeRealizer
implements EdgeLayout {
    static final int xb = 1;
    static final int ob = 2;
    public static final byte PATH_UNCLIPPED = 0;
    public static final byte PATH_CLIPPED_AT_SOURCE = 4;
    public static final byte PATH_CLIPPED_AT_TARGET = 8;
    public static final byte PATH_CLIPPED_AT_SOURCE_AND_TARGET = 12;
    public static final byte PATH_INVISBLE = 28;
    Object vb;
    Object zb;
    private boolean rb;
    int pb;
    private Edge qb;
    private Color kb;
    private LineType dc;
    private Arrow ib;
    private Arrow yb;
    private ArrayList cc;
    private byte hc;
    private boolean tb;
    private Port sb;
    private Port fc;
    private float mb;
    private float jb;
    private float bc;
    private float ac;
    private boolean gc;
    private static Color wb = Color.orange;
    private static LineType lb = LineType.LINE_5;
    private static Color ub = Color.green;
    private static boolean ec = true;
    protected BendList bends;
    protected GeneralPath path;
    Rectangle2D.Float nb;

    protected EdgeRealizer() {
        this.g();
        this.kb = Color.black;
        this.dc = LineType.LINE_1;
        this.yb = this.ib = Arrow.NONE;
        this.setSourcePort(new Port());
        this.setTargetPort(new Port());
    }

    protected EdgeRealizer(EdgeRealizer edgeRealizer) {
        this.g();
        this.b(edgeRealizer);
    }

    void b(EdgeRealizer edgeRealizer) {
        block7: {
            EdgeRealizer edgeRealizer2;
            int n2 = NodeRealizer.z;
            this.kb = edgeRealizer.getLineColor();
            this.dc = edgeRealizer.getLineType();
            this.yb = edgeRealizer.getArrow();
            this.ib = edgeRealizer.getSourceArrow();
            this.vb = edgeRealizer.vb;
            this.zb = edgeRealizer.zb;
            int n3 = edgeRealizer.labelCount();
            if (n3 > 0) {
                this.cc = new ArrayList(n3);
                for (int i2 = 0; i2 < n3; ++i2) {
                    edgeRealizer2 = this;
                    if (n2 == 0) {
                        edgeRealizer2.addLabel((EdgeLabel)edgeRealizer.getLabel(i2).clone());
                        if (n2 == 0) continue;
                    }
                    break;
                }
            } else {
                edgeRealizer2 = edgeRealizer;
            }
            BendCursor bendCursor = edgeRealizer2.bends();
            while (bendCursor.ok()) {
                Bend bend = this.appendBend(bendCursor.bend().getX(), bendCursor.bend().getY());
                if (n2 == 0) {
                    if (bend != null) {
                        bend.setSelected(bendCursor.bend().isSelected());
                    }
                    bendCursor.next();
                    if (n2 == 0) continue;
                }
                break block7;
            }
            this.setSourcePort(edgeRealizer.getSourcePort().createCopy());
            this.setTargetPort(edgeRealizer.getTargetPort().createCopy());
            this.tb = edgeRealizer.isSelected();
            this.setVisible(edgeRealizer.isVisible());
            this.gc = edgeRealizer.gc;
            this.rb = true;
        }
    }

    public EdgeRealizer createCopy() {
        return this.createCopy(this);
    }

    public abstract EdgeRealizer createCopy(EdgeRealizer var1);

    private void g() {
        this.pb = 1;
        this.path = new GeneralPath(1, 2);
        this.bends = new BendList();
        this.rb = true;
    }

    protected void bindEdge(Edge edge) {
        this.qb = edge;
        this.setDirty();
    }

    public NodeRealizer getTargetRealizer() {
        return ((Graph2D)this.qb.getGraph()).getRealizer(this.qb.target());
    }

    public NodeRealizer getSourceRealizer() {
        return ((Graph2D)this.qb.getGraph()).getRealizer(this.qb.source());
    }

    public Edge getEdge() {
        return this.qb;
    }

    Graph2D i() {
        if (this.qb != null) {
            return (Graph2D)this.qb.getGraph();
        }
        return null;
    }

    public void setPorts(Port port, Port port2) {
        this.setSourcePort(port);
        this.setTargetPort(port2);
    }

    public void setSourcePort(Port port) {
        port.b(this);
        this.sb = port;
        this.setDirty();
    }

    public void setTargetPort(Port port) {
        port.b(this);
        this.fc = port;
        this.setDirty();
    }

    public Port getSourcePort() {
        return this.sb;
    }

    public Port getTargetPort() {
        return this.fc;
    }

    public abstract Bend createBend(double var1, double var3, Bend var5, int var6);

    public abstract void reInsertBend(Bend var1, Bend var2, int var3);

    public abstract Bend insertBend(double var1, double var3);

    public abstract Bend removeBend(Bend var1);

    public void bendChanged(Bend bend, double d2, double d3) {
    }

    protected void labelBoundsChanged() {
    }

    public Bend appendBend(double d2, double d3) {
        return this.createBend(d2, d3, this.lastBend(), 0);
    }

    public int bendPos(Bend bend) {
        return this.bends.indexOf(bend);
    }

    public int bendCount() {
        return this.bends.size();
    }

    public Bend getBend(int n2) {
        return (Bend)this.bends.elementAt(n2);
    }

    public BendCursor bends() {
        return this.bends.bends();
    }

    public Bend firstBend() {
        if (this.bends.size() == 0) {
            return null;
        }
        return (Bend)this.bends.first();
    }

    public Bend lastBend() {
        if (this.bends.size() == 0) {
            return null;
        }
        return (Bend)this.bends.last();
    }

    public int getMinBendCount() {
        return 0;
    }

    public void clearBends() {
        this.bends.clear();
        this.setDirty();
    }

    public YPoint getPoint(int n2) {
        Bend bend = this.getBend(n2);
        if (bend != null) {
            return new YPoint(bend.getX(), bend.getY());
        }
        return null;
    }

    public int pointCount() {
        return this.bendCount();
    }

    public YPoint getSourcePoint() {
        Port port = this.getSourcePort();
        return new YPoint(port.getOffsetX(), port.getOffsetY());
    }

    public YPoint getTargetPoint() {
        Port port = this.getTargetPort();
        return new YPoint(port.getOffsetX(), port.getOffsetY());
    }

    public void setSourcePoint(YPoint yPoint) {
        this.getSourcePort().setOffsets(yPoint.getX(), yPoint.getY());
    }

    public void setTargetPoint(YPoint yPoint) {
        this.getTargetPort().setOffsets(yPoint.getX(), yPoint.getY());
    }

    public void setPoint(int n2, double d2, double d3) {
        Bend bend = this.getBend(n2);
        if (bend != null) {
            bend.setLocation(d2, d3);
        }
    }

    public void addPoint(double d2, double d3) {
        this.appendBend(d2, d3);
    }

    public void clearPoints() {
        this.clearBends();
    }

    public void registerObstacles(BridgeCalculator bridgeCalculator) {
    }

    public void paintSloppy(Graphics2D graphics2D) {
        if (!this.isVisible()) {
            return;
        }
        this.d(graphics2D, YRenderingHints.isSloppyPolylinePaintingEnabled(graphics2D));
        if (EdgeRealizer.e(graphics2D, true)) {
            this.paintLabels(graphics2D);
        }
    }

    void c(Graphics2D graphics2D) {
        this.d(graphics2D, true);
    }

    private void d(Graphics2D graphics2D, boolean bl) {
        Color color;
        Stroke stroke;
        block18: {
            GeneralPath generalPath;
            block19: {
                boolean bl2;
                int n2;
                block17: {
                    block13: {
                        double d2;
                        double d3;
                        Object object;
                        block15: {
                            block16: {
                                block14: {
                                    n2 = NodeRealizer.z;
                                    generalPath = this.path;
                                    if (!bl && generalPath.getPathIterator(null).isDone()) {
                                        return;
                                    }
                                    stroke = graphics2D.getStroke();
                                    color = graphics2D.getColor();
                                    boolean bl3 = EdgeRealizer.b(this, graphics2D);
                                    if (!bl3 || wb == null) break block14;
                                    graphics2D.setColor(wb);
                                    if (n2 == 0) break block15;
                                }
                                if ((object = this.getLineColor()) == null) break block16;
                                graphics2D.setColor((Color)object);
                                if (n2 == 0) break block15;
                            }
                            return;
                        }
                        graphics2D.setStroke(LineType.LINE_1);
                        if (!bl) break block17;
                        object = this.getSourceRealizer();
                        double d4 = this.sb.getX((NodeRealizer)object);
                        double d5 = this.sb.getY((NodeRealizer)object);
                        for (ListCell listCell = this.bends.firstCell(); listCell != null; listCell = listCell.succ()) {
                            Bend bend = (Bend)listCell.getInfo();
                            d3 = bend.getX();
                            d2 = bend.getY();
                            graphics2D.drawLine((int)d4, (int)d5, (int)d3, (int)d2);
                            d4 = d3;
                            d5 = d2;
                            if (n2 == 0) {
                                if (n2 == 0) continue;
                            }
                            break block13;
                        }
                        object = this.getTargetRealizer();
                        d3 = this.fc.getX((NodeRealizer)object);
                        d2 = this.fc.getY((NodeRealizer)object);
                        graphics2D.drawLine((int)d4, (int)d5, (int)d3, (int)d2);
                    }
                    if (n2 == 0) break block18;
                }
                boolean bl4 = this.getSourceArrow() != Arrow.NONE;
                boolean bl5 = bl2 = this.getTargetArrow() != Arrow.NONE;
                if (!bl4 && !bl2) break block19;
                GeneralPath generalPath2 = new GeneralPath(generalPath.getWindingRule());
                if (bl4) {
                    Point2D point2D = this.getSourceIntersection();
                    generalPath2.moveTo((float)point2D.getX(), (float)point2D.getY());
                }
                generalPath2.append(generalPath, bl4);
                if (bl2) {
                    Point2D point2D = this.getTargetIntersection();
                    generalPath2.lineTo((float)point2D.getX(), (float)point2D.getY());
                }
                graphics2D.draw(generalPath2);
                if (n2 == 0) break block18;
            }
            graphics2D.draw(generalPath);
        }
        graphics2D.setStroke(stroke);
        graphics2D.setColor(color);
    }

    public void repaint() {
        Graph graph;
        Edge edge = this.getEdge();
        if (edge != null && (graph = edge.getGraph()) instanceof Graph2D) {
            Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, -1.0, -1.0);
            this.calcUnionRect(double_);
            ((Graph2D)graph).updateViews(double_.x, double_.y, double_.width, double_.height);
        }
    }

    public void paint(Graphics2D graphics2D) {
        boolean bl;
        GeneralPath generalPath;
        Stroke stroke;
        Color color;
        block11: {
            block12: {
                block13: {
                    BridgeCalculator bridgeCalculator;
                    if ((this.pb & 1) == 0) {
                        return;
                    }
                    if (this.isDirty()) {
                        this.recalculateFeatures();
                    }
                    if ((this.pb & 2) == 0) {
                        return;
                    }
                    color = graphics2D.getColor();
                    stroke = graphics2D.getStroke();
                    generalPath = this.path;
                    if (this instanceof PolyLineEdgeRealizer && (!this.qb.isSelfLoop() || this.bendCount() >= 2) && (bridgeCalculator = DefaultGraph2DRenderer.getBridgeCalculator(this, graphics2D)) != null) {
                        GeneralPath generalPath2 = new GeneralPath();
                        PathIterator pathIterator = bridgeCalculator.insertBridges(generalPath.getPathIterator(null, 1.0));
                        generalPath2.append(pathIterator, true);
                        generalPath = generalPath2;
                    }
                    if (this.gc) {
                        generalPath = x.b(generalPath);
                    }
                    if (!(bl = EdgeRealizer.b(this, graphics2D)) || wb == null) break block11;
                    graphics2D.setColor(wb);
                    if (lb == null) break block12;
                    int n2 = (int)(this.dc.getLineWidth() - lb.getLineWidth());
                    if (n2 < 0) break block13;
                    graphics2D.setStroke(new BasicStroke(this.dc.getLineWidth() + 4.0f, 2, 2));
                    if (NodeRealizer.z == 0) break block12;
                }
                graphics2D.setStroke(lb);
            }
            graphics2D.draw(generalPath);
        }
        if (this.kb != null) {
            graphics2D.setColor(this.kb);
            graphics2D.setStroke(this.dc);
            graphics2D.draw(generalPath);
            this.paintArrows(graphics2D);
        }
        if (EdgeRealizer.e(graphics2D, false)) {
            this.paintLabels(graphics2D);
        }
        this.paintPorts(graphics2D);
        if (bl) {
            this.paintHighlightedBends(graphics2D);
        }
        this.paintBends(graphics2D);
        graphics2D.setStroke(stroke);
        graphics2D.setColor(color);
    }

    protected void paintHighlightedBends(Graphics2D graphics2D) {
        int n2 = NodeRealizer.z;
        graphics2D.setStroke(LineType.LINE_1);
        if (this.bendCount() > 0) {
            Ellipse2D.Double double_ = c.b().k;
            double_.height = 6.0;
            double_.width = 6.0;
            BendCursor bendCursor = this.bends.bends();
            while (bendCursor.ok()) {
                Bend bend = bendCursor.bend();
                graphics2D.setColor(ub);
                double_.x = bend.getX() - 3.0;
                double_.y = bend.getY() - 3.0;
                graphics2D.fill(double_);
                graphics2D.setColor(Color.darkGray);
                graphics2D.draw(double_);
                bendCursor.next();
                if (n2 == 0) continue;
            }
        }
    }

    protected void paintBends(Graphics2D graphics2D) {
        int n2 = NodeRealizer.z;
        if (!this.bends.isEmpty()) {
            boolean bl = YRenderingHints.isSelectionPaintingEnabled(graphics2D);
            for (ListCell listCell = this.bends.firstCell(); listCell != null; listCell = listCell.succ()) {
                Bend bend = (Bend)listCell.getInfo();
                if (!bend.isSelected() || !bl) continue;
                bend.paint(graphics2D);
                if (n2 == 0) continue;
            }
        }
    }

    protected void paintPorts(Graphics2D graphics2D) {
        this.sb.paint(graphics2D, this.getSourceRealizer());
        this.fc.paint(graphics2D, this.getTargetRealizer());
    }

    protected void paintArrows(Graphics2D graphics2D) {
        Arrow arrow = this.ib;
        Arrow arrow2 = this.yb;
        if (arrow != Arrow.NONE) {
            arrow.paint(graphics2D, this.b(this.path, arrow, this.getArrowScaleFactor(), true));
        }
        if (arrow2 != Arrow.NONE) {
            arrow2.paint(graphics2D, this.b(this.path, arrow2, this.getArrowScaleFactor(), false));
        }
    }

    AffineTransform b(GeneralPath generalPath, Arrow arrow, double d2, boolean bl) {
        AffineTransform affineTransform;
        block19: {
            double d3;
            double d4;
            double d5;
            int n2;
            float[] fArray;
            block21: {
                float f2;
                float f3;
                block20: {
                    int n3;
                    int n4;
                    block15: {
                        PathIterator pathIterator;
                        block16: {
                            block18: {
                                block17: {
                                    n4 = NodeRealizer.z;
                                    if (Arrow.NONE == arrow) {
                                        return null;
                                    }
                                    pathIterator = generalPath.getPathIterator(null);
                                    c c2 = c.b();
                                    affineTransform = c2.n;
                                    fArray = c2.g;
                                    pathIterator.currentSegment(fArray);
                                    pathIterator.next();
                                    f3 = fArray[0];
                                    f2 = fArray[1];
                                    pathIterator.currentSegment(fArray);
                                    pathIterator.next();
                                    if (!bl) break block16;
                                    n2 = this.isPathClippedAtSource();
                                    if (n2 == 0) break block17;
                                    d5 = this.mb - f3;
                                    d4 = this.jb - f2;
                                    if (n4 == 0) break block18;
                                }
                                d5 = f3 - fArray[0];
                                d4 = f2 - fArray[1];
                            }
                            if (!((d3 = Math.sqrt(d5 * d5 + d4 * d4)) > 0.0)) break block19;
                            d5 /= d3;
                            d4 /= d3;
                            if (n2 != 0) {
                                f3 = (float)((double)f3 + arrow.getArrowLength() * d5 * d2);
                                f2 = (float)((double)f2 + arrow.getArrowLength() * d4 * d2);
                            }
                            affineTransform.setTransform(d5, d4, -d4, d5, f3, f2);
                            if (d2 == 1.0) break block19;
                            affineTransform.scale(d2, d2);
                            if (n4 == 0) break block19;
                        }
                        while (!pathIterator.isDone()) {
                            f3 = fArray[0];
                            f2 = fArray[1];
                            n3 = pathIterator.currentSegment(fArray);
                            if (n4 == 0) {
                                pathIterator.next();
                                if (n4 == 0) continue;
                            }
                            break block15;
                        }
                        n3 = this.isPathClippedAtTarget();
                    }
                    if ((n2 = n3) == 0) break block20;
                    d5 = this.bc - fArray[0];
                    d4 = this.ac - fArray[1];
                    if (n4 == 0) break block21;
                }
                d5 = fArray[0] - f3;
                d4 = fArray[1] - f2;
            }
            if ((d3 = Math.sqrt(d5 * d5 + d4 * d4)) > 0.0) {
                d5 /= d3;
                d4 /= d3;
                if (n2 != 0) {
                    fArray[0] = (float)((double)fArray[0] + arrow.getArrowLength() * d5 * d2);
                    fArray[1] = (float)((double)fArray[1] + arrow.getArrowLength() * d4 * d2);
                }
                affineTransform.setTransform(d5, d4, -d4, d5, fArray[0], fArray[1]);
                if (d2 != 1.0) {
                    affineTransform.scale(d2, d2);
                }
            }
        }
        return affineTransform;
    }

    public double getArrowScaleFactor() {
        double d2 = this.getLineType().getLineWidth();
        if (d2 != 1.0) {
            d2 = 1.0 + (d2 - 1.0) / 8.0;
        }
        return d2;
    }

    protected void paintLabels(Graphics2D graphics2D) {
        int n2 = NodeRealizer.z;
        if (this.cc != null) {
            int n3 = this.cc.size();
            for (int i2 = 0; i2 < n3; ++i2) {
                this.getLabel(ec ? n3 - 1 - i2 : i2).paint(graphics2D);
                if (n2 == 0) continue;
            }
        }
    }

    static boolean b(EdgeRealizer edgeRealizer, Graphics2D graphics2D) {
        return edgeRealizer.isSelected() && YRenderingHints.isSelectionPaintingEnabled(graphics2D);
    }

    static boolean e(Graphics2D graphics2D, boolean bl) {
        Object object = graphics2D.getRenderingHint(YRenderingHints.KEY_EDGE_LABEL_PAINTING);
        if (bl) {
            return YRenderingHints.VALUE_EDGE_LABEL_PAINTING_ON.equals(object);
        }
        return !YRenderingHints.VALUE_EDGE_LABEL_PAINTING_OFF.equals(object);
    }

    protected abstract byte calculatePath(Point2D var1, Point2D var2);

    public static final byte calculateClippingAndIntersection(EdgeRealizer edgeRealizer, GeneralPath generalPath, GeneralPath generalPath2, Point2D point2D, Point2D point2D2) {
        return x.b(edgeRealizer, generalPath, generalPath2, point2D, point2D2);
    }

    protected final void recalculateFeatures() {
        block7: {
            block6: {
                boolean bl;
                int n2;
                block5: {
                    Point2D.Double double_;
                    Point2D.Double double_2;
                    block4: {
                        n2 = NodeRealizer.z;
                        c c2 = c.b();
                        double_2 = c2.i;
                        double_ = c2.f;
                        this.h();
                        this.pb &= 0xFFFFFFF3;
                        byte by = this.calculatePath(double_2, double_);
                        this.pb |= 0xC & by;
                        PathIterator pathIterator = this.path.getPathIterator(null);
                        bl = true;
                        if (!pathIterator.isDone()) break block4;
                        bl = false;
                        if (n2 == 0) break block5;
                    }
                    this.mb = (float)double_2.x;
                    this.jb = (float)double_2.y;
                    this.bc = (float)double_.x;
                    this.ac = (float)double_.y;
                }
                if (!bl) break block6;
                this.pb |= 2;
                if (n2 == 0) break block7;
            }
            this.pb &= 0xFFFFFFFD;
            Port port = this.getTargetPort();
            this.bc = (float)port.getX(this.getTargetRealizer());
            this.ac = (float)port.getY(this.getTargetRealizer());
            Port port2 = this.getSourcePort();
            this.mb = (float)port2.getX(this.getSourceRealizer());
            this.jb = (float)port2.getY(this.getSourceRealizer());
        }
        this.rb = false;
    }

    public boolean hasVisiblePath() {
        return (this.pb & 3) == 3;
    }

    public Point2D getSourceIntersection() {
        if (this.isDirty()) {
            this.recalculateFeatures();
        }
        return new Point2D.Float(this.mb, this.jb);
    }

    public Point2D getTargetIntersection() {
        if (this.isDirty()) {
            this.recalculateFeatures();
        }
        return new Point2D.Float(this.bc, this.ac);
    }

    public boolean isReversedPathRenderingEnabled() {
        return this.gc;
    }

    public void setReversedPathRenderingEnabled(boolean bl) {
        if (bl != this.gc) {
            this.gc = bl;
        }
    }

    public Color getLineColor() {
        return this.kb;
    }

    public void setLineColor(Color color) {
        this.kb = color;
    }

    public static Color getSelectionColor() {
        return wb;
    }

    public static void setSelectionColor(Color color) {
        wb = color;
    }

    public static void setHighlightedBendColor(Color color) {
        ub = color;
    }

    public static Color getHighlightedBendColor() {
        return ub;
    }

    public static void setLabelRenderingOrderInverted(boolean bl) {
        ec = bl;
    }

    public static boolean isLabelRenderingOrderInverted() {
        return ec;
    }

    public LineType getLineType() {
        return this.dc;
    }

    public void setLineType(LineType lineType) {
        if (this.dc != lineType) {
            if (this.dc.getLineWidth() != lineType.getLineWidth() && (this.ib.getArrowLength() != 0.0 || this.yb.getArrowLength() != 0.0)) {
                this.setDirty();
            }
            this.dc = lineType;
        }
    }

    public static void setSelectionStroke(LineType lineType) {
        lb = lineType;
    }

    public static Stroke getSelectionStroke() {
        return lb;
    }

    public Arrow getArrow() {
        return this.yb;
    }

    public void setArrow(Arrow arrow) {
        this.setTargetArrow(arrow);
    }

    public Arrow getTargetArrow() {
        return this.yb;
    }

    public void setTargetArrow(Arrow arrow) {
        if (arrow != this.yb) {
            if (this.yb.getClipLength() != arrow.getClipLength() || this.yb.getArrowLength() != arrow.getArrowLength()) {
                this.setDirty();
            }
            this.yb = arrow;
        }
    }

    public Arrow getSourceArrow() {
        return this.ib;
    }

    public void setSourceArrow(Arrow arrow) {
        if (arrow != this.ib) {
            if (this.ib.getClipLength() != arrow.getClipLength() || this.ib.getArrowLength() != arrow.getArrowLength()) {
                this.setDirty();
            }
            this.ib = arrow;
        }
    }

    public void setLayer(byte by) {
        this.hc = by;
    }

    public byte getLayer() {
        return this.hc;
    }

    public void setVisible(boolean bl) {
        block3: {
            block2: {
                if (!bl) break block2;
                this.pb |= 1;
                if (NodeRealizer.z == 0) break block3;
            }
            this.pb &= 0xFFFFFFFE;
        }
    }

    public boolean isVisible() {
        return (this.pb & 1) == 1;
    }

    public boolean isPathClippedAtSource() {
        return (this.pb & 4) == 4;
    }

    public boolean isPathClippedAtTarget() {
        return (this.pb & 8) == 8;
    }

    public void setSelected(boolean bl) {
        if (bl != this.tb) {
            this.tb = bl;
            Graph2D graph2D = this.i();
            if (graph2D != null) {
                graph2D.fireGraph2DSelectionEvent(this.getEdge());
            }
            this.f();
        }
    }

    void f() {
    }

    public boolean isSelected() {
        return this.tb;
    }

    public void setDirty() {
        if (this.cc != null) {
            for (int i2 = this.cc.size() - 1; i2 >= 0; --i2) {
                EdgeLabel edgeLabel = this.getLabel(i2);
                edgeLabel.setOffsetDirty();
            }
        }
        this.rb = true;
        this.h();
    }

    protected boolean isDirty() {
        return this.rb;
    }

    public GeneralPath getPath() {
        if (this.isDirty()) {
            this.recalculateFeatures();
        }
        return this.path;
    }

    public MouseInputEditorProvider getMouseInputEditorProvider() {
        if (this instanceof MouseInputEditorProvider) {
            return (MouseInputEditorProvider)((Object)this);
        }
        return null;
    }

    public void addLabel(EdgeLabel edgeLabel) {
        edgeLabel.bindRealizer(this);
        if (this.cc == null) {
            this.cc = new ArrayList(1);
        }
        this.cc.add(edgeLabel);
    }

    public void removeLabel(EdgeLabel edgeLabel) {
        if (this.cc != null) {
            this.cc.remove(edgeLabel);
            this.rb = true;
        }
    }

    public void removeLabel(int n2) {
        if (this.cc == null) {
            throw new IndexOutOfBoundsException("Index: " + n2 + ", Size: 0");
        }
        try {
            this.cc.remove(n2);
            this.rb = true;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IndexOutOfBoundsException("Index: " + n2 + ", Size: " + this.cc.size());
        }
    }

    public EdgeLabel getLabel() {
        if (this.labelCount() == 0) {
            this.addLabel(this.createEdgeLabel());
        }
        return this.getLabel(0);
    }

    public int labelCount() {
        return this.cc != null ? this.cc.size() : 0;
    }

    public EdgeLabel getLabel(int n2) {
        if (this.cc == null) {
            throw new ArrayIndexOutOfBoundsException(0);
        }
        return (EdgeLabel)this.cc.get(n2);
    }

    public void setLabelText(String string) {
        this.getLabel().setText(string);
    }

    public String getLabelText() {
        return this.getLabel().getText();
    }

    public EdgeLabel createEdgeLabel() {
        return new EdgeLabel();
    }

    public boolean contains(double d2, double d3) {
        if ((this.pb & 2) == 0) {
            return false;
        }
        if (this.isDirty() || this.nb == null) {
            this.nb = this.b(this.nb);
        }
        double d4 = this.nb.x - 5.0f;
        double d5 = this.nb.y - 5.0f;
        double d6 = d4 + (double)this.nb.width + 10.0;
        double d7 = d5 + (double)this.nb.height + 10.0;
        if (d2 > d4 && d2 < d6 && d3 > d5 && d3 < d7) {
            boolean bl;
            boolean bl2 = bl = this.containsSeg(d2, d3) > 0;
            if (bl) {
                Point2D point2D = this.getSourceIntersection();
                if (point2D.distanceSq(d2, d3) < 25.0) {
                    return false;
                }
                Point2D point2D2 = this.getTargetIntersection();
                if (point2D2.distanceSq(d2, d3) < 25.0) {
                    return false;
                }
            }
            return bl;
        }
        return false;
    }

    public int containsSeg(double d2, double d3) {
        int n2;
        block5: {
            PathIterator pathIterator;
            int n3 = NodeRealizer.z;
            int n4 = 1;
            if (this.isDirty()) {
                this.recalculateFeatures();
            }
            if ((pathIterator = this.path.getPathIterator(null)).isDone()) {
                return 0;
            }
            float[] fArray = c.b().g;
            pathIterator.currentSegment(fArray);
            pathIterator.next();
            float f2 = fArray[0];
            float f3 = fArray[1];
            while (!pathIterator.isDone()) {
                pathIterator.currentSegment(fArray);
                double d4 = Line2D.ptSegDistSq(f2, f3, fArray[0], fArray[1], d2, d3) - 25.0;
                n2 = d4 == 0.0 ? 0 : (d4 < 0.0 ? -1 : 1);
                if (n3 == 0) {
                    if (n2 < 0) {
                        return n4;
                    }
                    ++n4;
                    pathIterator.next();
                    f2 = fArray[0];
                    f3 = fArray[1];
                    if (n3 == 0) continue;
                }
                break block5;
            }
            n2 = 0;
        }
        return n2;
    }

    public void calcUnionRect(Rectangle2D rectangle2D) {
        if (this.isDirty() || this.nb == null) {
            this.nb = this.b(this.nb);
        }
        Geom.calcUnion(rectangle2D, this.nb, rectangle2D);
    }

    public boolean pathIntersects(Rectangle2D rectangle2D, boolean bl) {
        boolean bl2;
        boolean bl3;
        int n2;
        block10: {
            n2 = NodeRealizer.z;
            if (this.isDirty()) {
                this.recalculateFeatures();
            }
            if (this.nb != null && !this.nb.intersects(rectangle2D)) {
                return false;
            }
            PathIterator pathIterator = this.path.getPathIterator(null);
            if (pathIterator.isDone()) {
                return false;
            }
            float[] fArray = c.b().g;
            pathIterator.currentSegment(fArray);
            pathIterator.next();
            float f2 = fArray[0];
            float f3 = fArray[1];
            while (!pathIterator.isDone()) {
                pathIterator.currentSegment(fArray);
                bl3 = rectangle2D.intersectsLine(f2, f3, fArray[0], fArray[1]);
                if (n2 == 0) {
                    if (bl3) {
                        return true;
                    }
                    pathIterator.next();
                    f2 = fArray[0];
                    f3 = fArray[1];
                    if (n2 == 0) continue;
                }
                break block10;
            }
            bl3 = bl;
        }
        if (bl3) {
            for (int i2 = this.labelCount() - 1; i2 >= 0; --i2) {
                EdgeLabel edgeLabel = this.getLabel(i2);
                bl2 = edgeLabel.isVisible();
                if (n2 == 0) {
                    if (!bl2 || edgeLabel.getText().length() == 0 && edgeLabel.getIcon() == null) continue;
                    YRectangle yRectangle = edgeLabel.getBox();
                    if (!rectangle2D.intersects(yRectangle.x, yRectangle.y, yRectangle.width, yRectangle.height)) continue;
                    return true;
                }
                break;
            }
        } else {
            bl2 = false;
        }
        return bl2;
    }

    void h() {
        this.nb = null;
    }

    public boolean intersects(Rectangle2D rectangle2D) {
        Object object;
        int n2 = NodeRealizer.z;
        if (!this.isDirty() && this.nb != null) {
            return this.nb.intersects(rectangle2D);
        }
        if (this.bends.size() > 0) {
            for (object = this.bends.firstCell(); object != null; object = ((ListCell)object).succ()) {
                Bend bend = (Bend)((ListCell)object).getInfo();
                if (!rectangle2D.contains(bend.getX(), bend.getY())) continue;
                return true;
            }
        }
        if (rectangle2D.contains((Point2D)(object = this.getTargetIntersection()))) {
            return true;
        }
        object = this.getSourceIntersection();
        if (rectangle2D.contains((Point2D)object)) {
            return true;
        }
        this.nb = this.b(this.nb);
        return this.nb.intersects(rectangle2D);
    }

    Rectangle2D.Float b(Rectangle2D.Float float_) {
        block4: {
            Rectangle2D rectangle2D;
            int n2 = NodeRealizer.z;
            Point2D point2D = this.getTargetIntersection();
            float_ = new Rectangle2D.Float((float)point2D.getX(), (float)point2D.getY(), 1.0f, 1.0f);
            if (this.isDirty()) {
                this.recalculateFeatures();
            }
            if ((rectangle2D = this.path.getBounds2D()).getWidth() > 0.0 || rectangle2D.getHeight() > 0.0) {
                float_.add(rectangle2D);
            }
            double d2 = float_.getX();
            double d3 = d2 + float_.getWidth();
            double d4 = float_.getY();
            double d5 = d4 + float_.getHeight();
            for (int i2 = this.labelCount() - 1; i2 >= 0; --i2) {
                EdgeLabel edgeLabel = this.getLabel(i2);
                if (n2 == 0) {
                    if (!edgeLabel.isVisible() || edgeLabel.getText().length() == 0 && edgeLabel.getIcon() == null) continue;
                    YRectangle yRectangle = edgeLabel.getBox();
                    d3 = Math.max(yRectangle.x + yRectangle.width, d3);
                    d2 = Math.min(yRectangle.x, d2);
                    d5 = Math.max(yRectangle.y + yRectangle.height, d5);
                    d4 = Math.min(yRectangle.y, d4);
                    if (n2 == 0) continue;
                }
                break block4;
            }
            float_.setFrame(d2, d4, d3 - d2, d5 - d4);
        }
        return float_;
    }

    public void write(ObjectOutputStream objectOutputStream) throws IOException {
        block7: {
            int n2;
            block6: {
                n2 = NodeRealizer.z;
                objectOutputStream.writeByte(6);
                objectOutputStream.writeInt(this.bends.size());
                BendCursor bendCursor = this.bends();
                while (bendCursor.ok()) {
                    objectOutputStream.writeFloat((float)bendCursor.bend().getX());
                    objectOutputStream.writeFloat((float)bendCursor.bend().getY());
                    bendCursor.next();
                    if (n2 == 0) {
                        if (n2 == 0) continue;
                    }
                    break block6;
                }
                objectOutputStream.writeObject(this.getLineColor());
                objectOutputStream.writeByte(this.getArrow().getType());
            }
            if (this.getArrow().getType() == 0) {
                objectOutputStream.writeObject(this.getArrow().getCustomName());
            }
            objectOutputStream.writeByte(this.getSourceArrow().getType());
            if (this.getSourceArrow().getType() == 0) {
                objectOutputStream.writeObject(this.getSourceArrow().getCustomName());
            }
            LineType.serializeLineType(objectOutputStream, this.dc);
            objectOutputStream.writeObject(YGFIOHandler.encode(this.sb.getClass().getName()));
            this.sb.write(objectOutputStream);
            objectOutputStream.writeObject(YGFIOHandler.encode(this.fc.getClass().getName()));
            this.fc.write(objectOutputStream);
            objectOutputStream.writeInt(this.labelCount());
            for (int i2 = 0; i2 < this.labelCount(); ++i2) {
                this.getLabel(i2).write(objectOutputStream);
                if (n2 == 0) {
                    if (n2 == 0) continue;
                }
                break block7;
            }
            objectOutputStream.writeBoolean(this.isVisible());
            objectOutputStream.writeBoolean(this.gc);
        }
    }

    public void read(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n2 = NodeRealizer.z;
        byte by = objectInputStream.readByte();
        switch (by) {
            case 0: {
                this.b(objectInputStream);
                if (n2 == 0) break;
            }
            case 1: {
                this.c(objectInputStream);
                if (n2 == 0) break;
            }
            case 2: {
                this.d(objectInputStream);
                if (n2 == 0) break;
            }
            case 3: {
                this.e(objectInputStream);
                if (n2 == 0) break;
            }
            case 4: {
                this.f(objectInputStream);
                if (n2 == 0) break;
            }
            case 5: {
                this.f(objectInputStream);
                this.setVisible(objectInputStream.readBoolean());
                if (n2 == 0) break;
            }
            case 6: {
                this.f(objectInputStream);
                this.setVisible(objectInputStream.readBoolean());
                this.gc = objectInputStream.readBoolean();
                if (n2 == 0) break;
            }
            default: {
                throw new BadVersionException(by);
            }
        }
    }

    void f(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Object object;
        int n2;
        block20: {
            block19: {
                byte by;
                block18: {
                    block17: {
                        block16: {
                            n2 = NodeRealizer.z;
                            byte by2 = objectInputStream.readInt();
                            for (by = 0; by < by2; ++by) {
                                this.appendBend(objectInputStream.readFloat(), objectInputStream.readFloat());
                                if (n2 == 0) {
                                    if (n2 == 0) continue;
                                }
                                break block16;
                            }
                            this.setLineColor((Color)objectInputStream.readObject());
                            by = objectInputStream.readByte();
                        }
                        if (by == 0) break block17;
                        this.setArrow(Arrow.getArrow(by));
                        if (n2 == 0) break block18;
                    }
                    if ((object = Arrow.getCustomArrow((String)objectInputStream.readObject())) != null) {
                        this.setArrow((Arrow)object);
                    }
                }
                if ((by = objectInputStream.readByte()) == 0) break block19;
                this.setSourceArrow(Arrow.getArrow(by));
                if (n2 == 0) break block20;
            }
            if ((object = Arrow.getCustomArrow((String)objectInputStream.readObject())) != null) {
                this.setSourceArrow((Arrow)object);
            }
        }
        this.dc = LineType.createLineType(objectInputStream);
        try {
            object = YGFIOHandler.decode((String)objectInputStream.readObject());
            this.sb = (Port)Class.forName((String)object).newInstance();
            this.sb.read(objectInputStream);
            this.setSourcePort(this.sb);
            object = YGFIOHandler.decode((String)objectInputStream.readObject());
            this.fc = (Port)Class.forName((String)object).newInstance();
            this.fc.read(objectInputStream);
            this.setTargetPort(this.fc);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new BadVersionException("Could not construct Port!");
        }
        catch (InstantiationException instantiationException) {
            throw new BadVersionException("Could not instantiate Port!");
        }
        int n3 = objectInputStream.readInt();
        for (int i2 = 0; i2 < n3; ++i2) {
            EdgeLabel edgeLabel = this.createEdgeLabel();
            this.addLabel(edgeLabel);
            edgeLabel.read(objectInputStream);
            if (n2 == 0) continue;
        }
    }

    void e(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Object object;
        int n2;
        block20: {
            block19: {
                byte by;
                block18: {
                    block17: {
                        block16: {
                            n2 = NodeRealizer.z;
                            byte by2 = objectInputStream.readInt();
                            for (by = 0; by < by2; ++by) {
                                this.appendBend(objectInputStream.readFloat(), objectInputStream.readFloat());
                                if (n2 == 0) {
                                    if (n2 == 0) continue;
                                }
                                break block16;
                            }
                            this.setLineColor((Color)objectInputStream.readObject());
                            by = objectInputStream.readByte();
                        }
                        if (by == 0) break block17;
                        this.setArrow(Arrow.getArrow(by));
                        if (n2 == 0) break block18;
                    }
                    if ((object = Arrow.getCustomArrow((String)objectInputStream.readObject())) != null) {
                        this.setArrow((Arrow)object);
                    }
                }
                if ((by = objectInputStream.readByte()) == 0) break block19;
                this.setSourceArrow(Arrow.getArrow(by));
                if (n2 == 0) break block20;
            }
            if ((object = Arrow.getCustomArrow((String)objectInputStream.readObject())) != null) {
                this.setSourceArrow((Arrow)object);
            }
        }
        this.dc = LineType.createLineType(objectInputStream.readByte(), objectInputStream.readByte());
        try {
            object = YGFIOHandler.decode((String)objectInputStream.readObject());
            this.sb = (Port)Class.forName((String)object).newInstance();
            this.sb.read(objectInputStream);
            this.setSourcePort(this.sb);
            object = YGFIOHandler.decode((String)objectInputStream.readObject());
            this.fc = (Port)Class.forName((String)object).newInstance();
            this.fc.read(objectInputStream);
            this.setTargetPort(this.fc);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new BadVersionException("Could not construct Port!");
        }
        catch (InstantiationException instantiationException) {
            throw new BadVersionException("Could not instantiate Port!");
        }
        int n3 = objectInputStream.readInt();
        for (int i2 = 0; i2 < n3; ++i2) {
            EdgeLabel edgeLabel = this.createEdgeLabel();
            this.addLabel(edgeLabel);
            edgeLabel.read(objectInputStream);
            if (n2 == 0) continue;
        }
    }

    void d(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Object object;
        block22: {
            block21: {
                byte by;
                int n2;
                block20: {
                    block19: {
                        block18: {
                            byte by2;
                            block17: {
                                n2 = NodeRealizer.z;
                                byte by3 = objectInputStream.readInt();
                                for (by2 = 0; by2 < by3; ++by2) {
                                    this.appendBend(objectInputStream.readFloat(), objectInputStream.readFloat());
                                    if (n2 == 0) {
                                        if (n2 == 0) continue;
                                    }
                                    break block17;
                                }
                                by2 = objectInputStream.readInt();
                            }
                            for (by = 0; by < by2; ++by) {
                                object = this.createEdgeLabel();
                                this.addLabel((EdgeLabel)object);
                                ((EdgeLabel)object).read(objectInputStream);
                                if (n2 == 0) {
                                    if (n2 == 0) continue;
                                }
                                break block18;
                            }
                            this.setLineColor((Color)objectInputStream.readObject());
                            by = objectInputStream.readByte();
                        }
                        if (by == 0) break block19;
                        this.setArrow(Arrow.getArrow(by));
                        if (n2 == 0) break block20;
                    }
                    if ((object = Arrow.getCustomArrow((String)objectInputStream.readObject())) != null) {
                        this.setArrow((Arrow)object);
                    }
                }
                if ((by = objectInputStream.readByte()) == 0) break block21;
                this.setSourceArrow(Arrow.getArrow(by));
                if (n2 == 0) break block22;
            }
            if ((object = Arrow.getCustomArrow((String)objectInputStream.readObject())) != null) {
                this.setSourceArrow((Arrow)object);
            }
        }
        this.dc = LineType.createLineType(objectInputStream.readByte(), objectInputStream.readByte());
        try {
            object = YGFIOHandler.decode((String)objectInputStream.readObject());
            this.sb = (Port)Class.forName((String)object).newInstance();
            this.sb.read(objectInputStream);
            this.setSourcePort(this.sb);
            object = YGFIOHandler.decode((String)objectInputStream.readObject());
            this.fc = (Port)Class.forName((String)object).newInstance();
            this.fc.read(objectInputStream);
            this.setTargetPort(this.fc);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new BadVersionException("Could not construct Port!");
        }
        catch (InstantiationException instantiationException) {
            throw new BadVersionException("Could not instantiate Port!");
        }
    }

    void c(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Object object;
        int n2;
        block32: {
            block31: {
                byte by;
                block30: {
                    block29: {
                        block28: {
                            byte by2;
                            block27: {
                                n2 = NodeRealizer.z;
                                byte by3 = objectInputStream.readInt();
                                for (by2 = 0; by2 < by3; ++by2) {
                                    this.appendBend(objectInputStream.readFloat(), objectInputStream.readFloat());
                                    if (n2 == 0) {
                                        if (n2 == 0) continue;
                                    }
                                    break block27;
                                }
                                by2 = objectInputStream.readInt();
                            }
                            for (by = 0; by < by2; ++by) {
                                object = this.createEdgeLabel();
                                ((EdgeLabel)object).read(objectInputStream);
                                this.addLabel((EdgeLabel)object);
                                if (n2 == 0) {
                                    if (n2 == 0) continue;
                                }
                                break block28;
                            }
                            this.setLineColor((Color)objectInputStream.readObject());
                            by = objectInputStream.readByte();
                        }
                        if (by == 0) break block29;
                        this.setArrow(Arrow.getArrow(by));
                        if (n2 == 0) break block30;
                    }
                    if ((object = Arrow.getCustomArrow((String)objectInputStream.readObject())) != null) {
                        this.setArrow((Arrow)object);
                    }
                }
                if ((by = objectInputStream.readByte()) == 0) break block31;
                this.setSourceArrow(Arrow.getArrow(by));
                if (n2 == 0) break block32;
            }
            if ((object = Arrow.getCustomArrow((String)objectInputStream.readObject())) != null) {
                this.setSourceArrow((Arrow)object);
            }
        }
        this.dc = LineType.createLineType(objectInputStream.readByte(), objectInputStream.readByte());
        try {
            block36: {
                block35: {
                    block34: {
                        block33: {
                            if (!objectInputStream.readBoolean()) break block33;
                            this.sb = new Port();
                            if (n2 == 0) break block34;
                        }
                        if (((String)(object = (String)objectInputStream.readObject())).startsWith("y.graph")) {
                            object = "y.view.Port";
                        }
                        this.sb = (Port)Class.forName((String)object).newInstance();
                        this.sb.read(objectInputStream);
                    }
                    if (!objectInputStream.readBoolean()) break block35;
                    this.fc = new Port();
                    if (n2 == 0) break block36;
                }
                if (((String)(object = (String)objectInputStream.readObject())).startsWith("y.graph")) {
                    object = "y.view.Port";
                }
                this.fc = (Port)Class.forName((String)object).newInstance();
                this.fc.read(objectInputStream);
            }
            this.setPorts(this.sb, this.fc);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new BadVersionException("Could not construct Port!");
        }
        catch (InstantiationException instantiationException) {
            throw new BadVersionException("Could not instantiate Port!");
        }
    }

    void b(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Object object;
        int n2;
        block22: {
            block21: {
                EdgeRealizer edgeRealizer;
                block20: {
                    n2 = NodeRealizer.z;
                    int n3 = objectInputStream.readInt();
                    for (int i2 = 0; i2 < n3; ++i2) {
                        edgeRealizer = this;
                        if (n2 == 0) {
                            edgeRealizer.appendBend(objectInputStream.readFloat(), objectInputStream.readFloat());
                            if (n2 == 0) continue;
                        }
                        break block20;
                    }
                    edgeRealizer = this;
                }
                EdgeLabel edgeLabel = edgeRealizer.createEdgeLabel();
                edgeLabel.read(objectInputStream);
                this.addLabel(edgeLabel);
                this.setLineColor((Color)objectInputStream.readObject());
                byte by = objectInputStream.readByte();
                if (by == 0) break block21;
                this.setArrow(Arrow.getArrow(by));
                if (n2 == 0) break block22;
            }
            if ((object = Arrow.getCustomArrow((String)objectInputStream.readObject())) != null) {
                this.setArrow((Arrow)object);
            }
        }
        this.dc = LineType.createLineType(objectInputStream.readByte(), objectInputStream.readByte());
        try {
            block26: {
                block25: {
                    block24: {
                        block23: {
                            if (!objectInputStream.readBoolean()) break block23;
                            this.sb = new Port();
                            if (n2 == 0) break block24;
                        }
                        if (((String)(object = (String)objectInputStream.readObject())).startsWith("y.graph")) {
                            object = "y.view.Port";
                        }
                        this.sb = (Port)Class.forName((String)object).newInstance();
                        this.sb.read(objectInputStream);
                    }
                    if (!objectInputStream.readBoolean()) break block25;
                    this.fc = new Port();
                    if (n2 == 0) break block26;
                }
                if (((String)(object = (String)objectInputStream.readObject())).startsWith("y.graph")) {
                    object = "y.view.Port";
                }
                this.fc = (Port)Class.forName((String)object).newInstance();
                this.fc.read(objectInputStream);
            }
            this.setPorts(this.sb, this.fc);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new BadVersionException("Could not construct Port!");
        }
        catch (InstantiationException instantiationException) {
            throw new BadVersionException("Could not instantiate Port!");
        }
    }
}

