/*
 * Decompiled with CFR 0.152.
 */
package y.view;

import java.applet.Applet;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventObject;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import y.base.DataMap;
import y.base.DataProvider;
import y.base.Node;
import y.util.DataProviders;
import y.view.HitInfo;
import y.view.NodeCellEditor;
import y.view.NodeRealizer;
import y.view.ViewMode;
import y.view.cb;
import y.view.l;

public class CellEditorMode
extends ViewMode {
    private final DataProvider y;
    private final DataMap x;
    private NodeCellEditor db;
    private NodeRealizer cb;
    private JComponent bb;
    private final CellEditorListener ab = new _b();
    private cb v;
    private l w;
    private PropertyChangeListener z;

    public CellEditorMode(NodeCellEditor nodeCellEditor, DataMap dataMap) {
        this(DataProviders.createConstantDataProvider(nodeCellEditor), dataMap);
    }

    public CellEditorMode(DataProvider dataProvider, DataMap dataMap) {
        this.y = dataProvider;
        this.x = dataMap;
    }

    public boolean editNode(Node node, EventObject eventObject) {
        if (!this.isNodeEditable(node) || this.isCellEditing() && !this.stopCellEditing()) {
            return false;
        }
        NodeRealizer nodeRealizer = this.getGraph2D().getRealizer(node);
        NodeCellEditor nodeCellEditor = this.getNodeCellEditor(node);
        if (nodeCellEditor != null && (eventObject == null || nodeCellEditor.isCellEditable(eventObject))) {
            this.startCellEditing(nodeRealizer, nodeCellEditor);
            if (eventObject instanceof MouseEvent && ((MouseEvent)eventObject).getID() == 500 && this.v != null && this.isCellEditing()) {
                this.v.mouseClicked((MouseEvent)eventObject);
            }
            return true;
        }
        return false;
    }

    public boolean isNodeEditable(Node node) {
        return this.getNodeCellEditor(node) != null;
    }

    private void b(MouseEvent mouseEvent) {
        block5: {
            Node node;
            HitInfo hitInfo;
            block4: {
                if (this.isCellEditing()) break block4;
                if (!this.shouldStartCellEditing(mouseEvent) || (hitInfo = this.getHitInfo(mouseEvent)).getHitNode() == null) break block5;
                this.editNode(hitInfo.getHitNode(), mouseEvent);
                if (NodeRealizer.z == 0) break block5;
            }
            this.b(KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner());
            if (this.isCellEditing() && mouseEvent.getID() == 501 && ((node = (hitInfo = this.getHitInfo(mouseEvent)).getHitNode()) == null || node != this.cb.getNode()) && !this.stopCellEditing()) {
                this.cancelCellEditing();
            }
        }
    }

    public Object getUserObject(Node node) {
        return this.x.get(this.cb.getNode());
    }

    public void setUserObject(Node node, Object object) {
        this.x.set(node, object);
    }

    protected boolean shouldStartCellEditing(MouseEvent mouseEvent) {
        return mouseEvent.getID() == 500 && mouseEvent.getClickCount() == 2;
    }

    public NodeCellEditor getNodeCellEditor(Node node) {
        Object object = this.y != null ? this.y.get(node) : null;
        return object instanceof NodeCellEditor ? (NodeCellEditor)object : null;
    }

    public boolean isCellEditing() {
        return this.db != null;
    }

    public void startCellEditing(NodeRealizer nodeRealizer, NodeCellEditor nodeCellEditor) {
        if (this.isCellEditing() && !this.stopCellEditing()) {
            this.cancelCellEditing();
        }
        if (!this.isCellEditing()) {
            this.db = nodeCellEditor;
            this.cb = nodeRealizer;
            nodeCellEditor.addCellEditorListener(this.ab);
            this.installEditor(nodeCellEditor.getNodeCellEditorComponent(this.view, nodeRealizer, this.getUserObject(nodeRealizer.getNode()), nodeRealizer.isSelected()), nodeRealizer);
        }
    }

    public NodeCellEditor getEditor() {
        return this.db;
    }

    public Node getEditingNode() {
        return this.cb != null ? this.cb.getNode() : null;
    }

    public void cancelCellEditing() {
        if (this.db != null) {
            this.db.cancelCellEditing();
        }
    }

    public boolean stopCellEditing() {
        if (this.db != null) {
            return this.db.stopCellEditing();
        }
        return true;
    }

    protected void cellEditingCanceled() {
        if (this.db != null) {
            this.db.removeCellEditorListener(this.ab);
            this.removeEditor();
            this.db = null;
            this.reactivateParent();
        }
    }

    protected void cellEditingStopped() {
        if (this.db != null) {
            this.setUserObject(this.cb.getNode(), this.db.getCellEditorValue());
            this.db.removeCellEditorListener(this.ab);
            this.removeEditor();
            this.db = null;
            this.reactivateParent();
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.v != null) {
            this.v.mouseMoved(mouseEvent);
        }
    }

    private void c(MouseEvent mouseEvent) {
        Node node;
        if (!(mouseEvent.getID() != 501 || (node = this.getHitInfo(mouseEvent).getHitNode()) != null && node == this.cb.getNode() || this.stopCellEditing())) {
            this.cancelCellEditing();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        block3: {
            block2: {
                if (this.v == null) break block2;
                this.v.mouseReleased(mouseEvent);
                this.c(mouseEvent);
                if (NodeRealizer.z == 0) break block3;
            }
            this.b(mouseEvent);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        block3: {
            block2: {
                if (this.v == null) break block2;
                this.v.mouseDragged(mouseEvent);
                this.c(mouseEvent);
                if (NodeRealizer.z == 0) break block3;
            }
            this.b(mouseEvent);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        block3: {
            block2: {
                if (this.v == null) break block2;
                this.v.mousePressed(mouseEvent);
                this.c(mouseEvent);
                if (NodeRealizer.z == 0) break block3;
            }
            this.b(mouseEvent);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        block3: {
            block2: {
                if (this.v == null) break block2;
                this.v.mouseClicked(mouseEvent);
                this.c(mouseEvent);
                if (NodeRealizer.z == 0) break block3;
            }
            this.b(mouseEvent);
        }
    }

    protected void installEditor(JComponent jComponent, NodeRealizer nodeRealizer) {
        if (jComponent.getNextFocusableComponent() == null) {
            jComponent.setNextFocusableComponent(this.view.getCanvasComponent());
        }
        this.view.s().add(jComponent);
        this.bb = jComponent;
        cb cb2 = new cb();
        this.setChild(cb2, null, null, null);
        this.v = cb2;
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(nodeRealizer.getX(), nodeRealizer.getY());
        cb2.b(jComponent, affineTransform);
        this.w = new l(this.view, jComponent, affineTransform);
        this.view.addDrawable(this.w);
        jComponent.setBounds(0, 0, (int)nodeRealizer.getWidth(), (int)nodeRealizer.getHeight());
        jComponent.validate();
        jComponent.requestFocusInWindow();
        jComponent.repaint();
        if (this.z == null) {
            KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            this.z = new _c(keyboardFocusManager);
            keyboardFocusManager.addPropertyChangeListener("permanentFocusOwner", this.z);
        }
    }

    protected void removeEditor() {
        if (this.z != null) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("permanentFocusOwner", this.z);
            this.z = null;
        }
        if (this.bb != null) {
            this.v.reactivateParent();
            this.view.s().remove(this.bb);
            this.view.removeDrawable(this.w);
            this.view.getCanvasComponent().repaint();
            this.v = null;
        }
        this.bb = null;
    }

    private void b(Component component) {
        int n2 = NodeRealizer.z;
        if (!this.isCellEditing()) {
            return;
        }
        for (Component component2 = component; component2 != null; component2 = component2.getParent()) {
            if (component2 == this.view.s()) {
                return;
            }
            if (!(component2 instanceof Window) && (!(component2 instanceof Applet) || component2.getParent() != null)) continue;
            if (component2 != SwingUtilities.getRoot(this.view) || this.stopCellEditing()) break;
            this.cancelCellEditing();
            if (n2 == 0) break;
            if (n2 == 0) continue;
        }
    }

    class _c
    implements PropertyChangeListener {
        private final KeyboardFocusManager b;

        public _c(KeyboardFocusManager keyboardFocusManager) {
            this.b = keyboardFocusManager;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            CellEditorMode.this.b(this.b.getPermanentFocusOwner());
        }
    }

    final class _b
    implements CellEditorListener {
        _b() {
        }

        public void editingStopped(ChangeEvent changeEvent) {
            CellEditorMode.this.cellEditingStopped();
        }

        public void editingCanceled(ChangeEvent changeEvent) {
            CellEditorMode.this.cellEditingCanceled();
        }
    }
}

