/*
 * Decompiled with CFR 0.152.
 */
package y.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

public class ResourceResolver {
    private ResourceResolver() {
    }

    public static URL getResource(String string, String string2, String string3) {
        URL uRL = null;
        if (string != null) {
            uRL = ResourceResolver.getSystemResource(string);
        }
        if (uRL == null && string2 != null) {
            uRL = ResourceResolver.getUserHomeResource(string2);
        }
        if (uRL == null && string3 != null) {
            uRL = ResourceResolver.getClassPathResource(string3);
        }
        return uRL;
    }

    public static URL getUserHomeResource(String string) {
        try {
            String string2 = System.getProperty("user.home");
            return ResourceResolver.getFileResource(string2 + File.separatorChar + string);
        }
        catch (SecurityException securityException) {
            return null;
        }
    }

    public static URL getClassPathResource(String string) {
        return new ResourceResolver().getClass().getClassLoader().getResource(string);
    }

    public static URL getURLResource(String string) {
        try {
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static URL getFileResource(String string) {
        try {
            File file = new File(string);
            if (file.canRead()) {
                return file.toURL();
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return null;
    }

    public static URL getSystemResource(String string) {
        try {
            String string2 = System.getProperty(string);
            if (string2 != null) {
                return ResourceResolver.b(string2, false);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return null;
    }

    public static URL getResource(String string) {
        return ResourceResolver.b(string, true);
    }

    private static URL b(String string, boolean bl) {
        URL uRL = null;
        if (bl) {
            uRL = ResourceResolver.getSystemResource(string);
        }
        if (uRL == null) {
            uRL = ResourceResolver.getUserHomeResource(string);
        }
        if (uRL == null) {
            uRL = ResourceResolver.getClassPathResource(string);
        }
        if (uRL == null) {
            uRL = ResourceResolver.getFileResource(string);
        }
        if (uRL == null) {
            uRL = ResourceResolver.getURLResource(string);
        }
        return uRL;
    }
}

