/*
 * Decompiled with CFR 0.152.
 */
package y.util;

import y.base.Edge;
import y.base.EdgeCursor;
import y.base.EdgeList;
import y.base.Graph;
import y.base.ListCell;
import y.base.Node;
import y.base.NodeCursor;
import y.base.NodeList;
import y.base.YCursor;
import y.util.DataProviderAdapter;
import y.util.Maps;

public class GraphHider {
    private Graph c;
    protected EdgeList hiddenEdges;
    protected NodeList hiddenNodes;
    private boolean b = true;

    public GraphHider(Graph graph) {
        this.c = graph;
        this.hiddenEdges = new EdgeList();
        this.hiddenNodes = new NodeList();
    }

    public void setFireGraphEventsEnabled(boolean bl) {
        this.b = !bl;
    }

    public boolean isFireGraphEventsEnabled() {
        return !this.b;
    }

    public void hideAll() {
        int n2 = DataProviderAdapter.z;
        NodeCursor nodeCursor = this.c.nodes();
        while (nodeCursor.ok()) {
            this.hide(nodeCursor.node());
            nodeCursor.next();
            if (n2 == 0) continue;
        }
    }

    public void hideEdges() {
        int n2 = DataProviderAdapter.z;
        EdgeCursor edgeCursor = this.c.edges();
        while (edgeCursor.ok()) {
            this.hide(edgeCursor.edge());
            edgeCursor.next();
            if (n2 == 0) continue;
        }
    }

    public void hideSelfLoops() {
        int n2 = DataProviderAdapter.z;
        EdgeCursor edgeCursor = this.c.edges();
        while (edgeCursor.ok()) {
            if (edgeCursor.edge().isSelfLoop()) {
                this.hide(edgeCursor.edge());
            }
            edgeCursor.next();
            if (n2 == 0) continue;
        }
    }

    public void simplifyGraph() {
        this.hideSelfLoops();
        this.hideMultipleEdges();
    }

    /*
     * Unable to fully structure code
     */
    public void hideMultipleEdges() {
        block8: {
            var8_1 = DataProviderAdapter.z;
            var1_2 = this.c.createNodeMap();
            var2_3 = this.c.nodes();
            while (var2_3.ok()) {
                block9: {
                    var3_4 = var2_3.node();
                    if (var8_1 != 0) break block8;
                    var4_5 = var3_4.edges();
                    while (var4_5.ok()) {
                        block10: {
                            block11: {
                                var5_6 = var4_5.edge();
                                var6_7 = var5_6.opposite(var3_4);
                                v0 = var7_8 = (Edge)var1_2.get(var6_7);
                                if (var8_1 != 0) ** GOTO lbl25
                                if (v0 == var5_6) break block10;
                                if (var7_8 != null) break block11;
                                var1_2.set(var6_7, var5_6);
                                if (var8_1 == 0) break block10;
                            }
                            this.hide(var5_6);
                        }
                        var4_5.next();
                        if (var8_1 == 0) continue;
                    }
                    var4_5 = var3_4.edges();
                    while (var4_5.ok()) {
                        v0 = var5_6 = var4_5.edge();
lbl25:
                        // 2 sources

                        var6_7 = v0.opposite(var3_4);
                        var1_2.set(var6_7, null);
                        var4_5.next();
                        if (var8_1 == 0) {
                            if (var8_1 == 0) continue;
                        }
                        break block9;
                    }
                    var2_3.next();
                }
                if (var8_1 == 0) continue;
            }
            this.c.disposeNodeMap(var1_2);
        }
    }

    public void unhideAll() {
        this.unhideNodes();
        this.unhideEdges();
    }

    public void unhideNodes() {
        int n2 = DataProviderAdapter.z;
        while (!this.hiddenNodes.isEmpty()) {
            Node node = this.hiddenNodes.popNode();
            if (this.c.contains(node)) continue;
            this.unhide(node);
            if (n2 == 0) continue;
        }
    }

    public void unhideEdges() {
        int n2 = DataProviderAdapter.z;
        while (!this.hiddenEdges.isEmpty()) {
            Edge edge = this.hiddenEdges.popEdge();
            if (this.c.contains(edge)) continue;
            this.unhide(edge);
            if (n2 == 0) continue;
        }
    }

    public void hide(Node node) {
        block12: {
            block11: {
                boolean bl;
                int n2;
                block10: {
                    Edge edge;
                    n2 = DataProviderAdapter.z;
                    Edge edge2 = node.firstInEdge();
                    while (edge2 != null) {
                        edge = edge2;
                        edge2 = edge2.nextInEdge();
                        this.hiddenEdges.push(edge);
                        bl = this.b;
                        if (n2 == 0) {
                            if (bl) {
                                this.c.hide(edge);
                                if (n2 == 0) continue;
                            }
                            this.c.removeEdge(edge);
                            if (n2 == 0) continue;
                        }
                        break block10;
                    }
                    edge2 = node.firstOutEdge();
                    while (edge2 != null) {
                        edge = edge2;
                        edge2 = edge2.nextOutEdge();
                        this.hiddenEdges.push(edge);
                        bl = this.b;
                        if (n2 == 0) {
                            if (bl) {
                                this.c.hide(edge);
                                if (n2 == 0) continue;
                            }
                            this.c.removeEdge(edge);
                            if (n2 == 0) continue;
                        }
                        break block10;
                    }
                    this.hiddenNodes.push(node);
                    bl = this.b;
                }
                if (!bl) break block11;
                this.c.hide(node);
                if (n2 == 0) break block12;
            }
            this.c.removeNode(node);
        }
    }

    public void hide(Edge edge) {
        block3: {
            block2: {
                this.hiddenEdges.push(edge);
                if (!this.b) break block2;
                this.c.hide(edge);
                if (DataProviderAdapter.z == 0) break block3;
            }
            this.c.removeEdge(edge);
        }
    }

    public void hide(EdgeList edgeList) {
        int n2 = DataProviderAdapter.z;
        for (ListCell listCell = edgeList.firstCell(); listCell != null; listCell = listCell.succ()) {
            this.hide((Edge)listCell.getInfo());
            if (n2 == 0) continue;
        }
    }

    public void hide(NodeList nodeList) {
        int n2 = DataProviderAdapter.z;
        for (ListCell listCell = nodeList.firstCell(); listCell != null; listCell = listCell.succ()) {
            this.hide((Node)listCell.getInfo());
            if (n2 == 0) continue;
        }
    }

    public void hide(EdgeCursor edgeCursor) {
        int n2 = DataProviderAdapter.z;
        while (edgeCursor.ok()) {
            this.hide(edgeCursor.edge());
            edgeCursor.next();
            if (n2 == 0) continue;
        }
    }

    public void hide(NodeCursor nodeCursor) {
        int n2 = DataProviderAdapter.z;
        while (nodeCursor.ok()) {
            this.hide(nodeCursor.node());
            nodeCursor.next();
            if (n2 == 0) continue;
        }
    }

    public void hide(YCursor yCursor) {
        int n2 = DataProviderAdapter.z;
        while (yCursor.ok()) {
            block4: {
                block5: {
                    Object object;
                    block3: {
                        object = yCursor.current();
                        if (!(object instanceof Node)) break block3;
                        this.hide((Node)object);
                        if (n2 == 0) break block4;
                    }
                    if (!(object instanceof Edge)) break block5;
                    this.hide((Edge)object);
                    if (n2 == 0) break block4;
                }
                throw new ClassCastException("Node or Edge expected");
            }
            yCursor.next();
            if (n2 == 0) continue;
        }
    }

    public static void unhideSubgraph(Graph graph, EdgeCursor edgeCursor) {
        int n2 = DataProviderAdapter.z;
        edgeCursor.toFirst();
        while (edgeCursor.ok()) {
            Edge edge = edgeCursor.edge();
            if (!graph.contains(edge.source())) {
                graph.unhide(edge.source());
            }
            if (!graph.contains(edge.target())) {
                graph.unhide(edge.target());
            }
            if (!graph.contains(edge)) {
                graph.unhide(edge);
            }
            edgeCursor.next();
            if (n2 == 0) continue;
        }
    }

    public static void hideSubgraph(Graph graph, EdgeCursor edgeCursor) {
        int n2 = DataProviderAdapter.z;
        edgeCursor.toFirst();
        while (edgeCursor.ok()) {
            Edge edge = edgeCursor.edge();
            if (graph.contains(edge)) {
                graph.hide(edge);
            }
            if (edge.source().degree() == 0) {
                graph.hide(edge.source());
            }
            if (edge.target().degree() == 0) {
                graph.hide(edge.target());
            }
            edgeCursor.next();
            if (n2 == 0) continue;
        }
    }

    public Graph getGraph() {
        return this.c;
    }

    protected void unhide(Edge edge) {
        block3: {
            block2: {
                if (!this.b) break block2;
                this.c.unhide(edge);
                if (DataProviderAdapter.z == 0) break block3;
            }
            this.c.reInsertEdge(edge);
        }
    }

    public void unhideEdge(Edge edge) {
        if (edge.getGraph() == null) {
            this.unhide(edge);
        }
        this.hiddenEdges.remove(edge);
    }

    public void unhideEdges(EdgeList edgeList) {
        Object object;
        Object object2;
        int n2;
        block7: {
            Graph graph;
            block6: {
                n2 = DataProviderAdapter.z;
                EdgeList edgeList2 = new EdgeList();
                for (object2 = edgeList.firstCell(); object2 != null; object2 = ((ListCell)object2).succ()) {
                    object = (Edge)((ListCell)object2).getInfo();
                    graph = ((Edge)object).getGraph();
                    if (n2 == 0) {
                        if (graph != null) continue;
                        this.unhide((Edge)object);
                        edgeList2.add(object);
                        if (n2 == 0) continue;
                    }
                    break block6;
                }
                graph = this.c;
            }
            object2 = Maps.createIndexEdgeMap(new boolean[graph.E()]);
            for (object = edgeList2.firstCell(); object != null; object = ((ListCell)object).succ()) {
                object2.setBool(((ListCell)object).getInfo(), true);
                if (n2 == 0) {
                    if (n2 == 0) continue;
                }
                break block7;
            }
            object = this.hiddenEdges.firstCell();
        }
        while (object != null) {
            Edge edge = (Edge)((ListCell)object).getInfo();
            if (edge.getGraph() == this.c && object2.getBool(edge)) {
                this.hiddenEdges.removeCell((ListCell)object);
            }
            object = ((ListCell)object).succ();
            if (n2 == 0) continue;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void unhideNodes(NodeList var1_1, boolean var2_2) {
        block14: {
            block13: {
                block12: {
                    var7_3 = DataProviderAdapter.z;
                    var3_4 = new NodeList();
                    for (var4_5 = var1_1.firstCell(); var4_5 != null; var4_5 = var4_5.succ()) {
                        var5_6 = (Node)var4_5.getInfo();
                        v0 = var5_6.getGraph();
                        if (var7_3 == 0) {
                            if (v0 != null) continue;
                            this.unhide((Node)var5_6);
                            var3_4.add(var5_6);
                            if (var7_3 == 0) continue;
                        }
                        break block12;
                    }
                    v0 = this.c;
                }
                var4_5 = Maps.createIndexNodeMap(new boolean[v0.N()]);
                for (var5_6 = var3_4.firstCell(); var5_6 != null; var5_6 = var5_6.succ()) {
                    var4_5.setBool(var5_6.getInfo(), true);
                    if (var7_3 == 0) {
                        if (var7_3 == 0) continue;
                    }
                    break block13;
                }
                var5_6 = this.hiddenNodes.firstCell();
            }
            while (var5_6 != null) {
                v1 = ((Node)var5_6.getInfo()).getGraph();
                if (var7_3 == 0) {
                    if (v1 == this.c) {
                        this.hiddenNodes.removeCell((ListCell)var5_6);
                    }
                    var5_6 = var5_6.succ();
                    if (var7_3 == 0) continue;
                }
                ** GOTO lbl35
            }
            if (!var2_2) break block14;
            for (var5_6 = this.hiddenEdges.firstCell(); var5_6 != null; var5_6 = var5_6.succ()) {
                v1 = var5_6.getInfo();
lbl35:
                // 2 sources

                if ((var6_7 = (Edge)v1).source().getGraph() != this.c || var6_7.target().getGraph() != this.c || !var4_5.getBool(var6_7.target()) && !var4_5.getBool(var6_7.source())) continue;
                this.hiddenEdges.removeCell((ListCell)var5_6);
                this.unhide(var6_7);
                if (var7_3 == 0) continue;
            }
        }
    }

    public void unhideNode(Node node, boolean bl) {
        int n2 = DataProviderAdapter.z;
        if (node.getGraph() == null) {
            this.unhide(node);
        }
        this.hiddenNodes.remove(node);
        if (bl) {
            for (ListCell listCell = this.hiddenEdges.firstCell(); listCell != null; listCell = listCell.succ()) {
                Edge edge = (Edge)listCell.getInfo();
                if ((edge.source() != node || edge.target().getGraph() != this.c) && (edge.target() != node || edge.source().getGraph() != this.c)) continue;
                this.hiddenEdges.removeCell(listCell);
                this.unhide(edge);
                if (n2 == 0) continue;
            }
        }
    }

    protected void unhide(Node node) {
        block3: {
            block2: {
                if (!this.b) break block2;
                this.c.unhide(node);
                if (DataProviderAdapter.z == 0) break block3;
            }
            this.c.reInsertNode(node);
        }
    }

    public NodeCursor hiddenNodes() {
        return this.hiddenNodes.nodes();
    }

    public EdgeCursor hiddenEdges() {
        return this.hiddenEdges.edges();
    }
}

