/*
 * Decompiled with CFR 0.152.
 */
package y.util;

import java.util.Iterator;
import y.base.Edge;
import y.base.Graph;
import y.base.Node;
import y.util.Cursors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Generics {
    private Generics() {
    }

    public static Iterable<Node> nodes(final Graph graph) {
        return new Iterable<Node>(){

            @Override
            public Iterator<Node> iterator() {
                return graph.nodeObjects();
            }
        };
    }

    public static Iterable<Edge> edges(final Graph graph) {
        return new Iterable<Edge>(){

            @Override
            public Iterator<Edge> iterator() {
                return graph.edgeObjects();
            }
        };
    }

    public static Iterable<Edge> inEdges(final Node node) {
        return new Iterable<Edge>(){

            @Override
            public Iterator<Edge> iterator() {
                return Cursors.createIterator(node.inEdges());
            }
        };
    }

    public static Iterable<Edge> outEdges(final Node node) {
        return new Iterable<Edge>(){

            @Override
            public Iterator<Edge> iterator() {
                return Cursors.createIterator(node.outEdges());
            }
        };
    }

    public static Iterable<Edge> edges(final Node node) {
        return new Iterable<Edge>(){

            @Override
            public Iterator<Edge> iterator() {
                return Cursors.createIterator(node.edges());
            }
        };
    }

    public static Iterable<Node> successors(final Node node) {
        return new Iterable<Node>(){

            @Override
            public Iterator<Node> iterator() {
                return Cursors.createIterator(node.successors());
            }
        };
    }

    public static Iterable<Node> predecessors(final Node node) {
        return new Iterable<Node>(){

            @Override
            public Iterator<Node> iterator() {
                return Cursors.createIterator(node.predecessors());
            }
        };
    }
}

