/*
 * Decompiled with CFR 0.152.
 */
package y.module.io;

import y.io.ImageOutputHandler;
import y.io.JPGIOHandler;
import y.io.ViewPortConfigurator;
import y.module.io.IOHandlerModule;
import y.module.io.ImageOutputModule;
import y.option.OptionHandler;
import y.view.BackgroundRenderer;
import y.view.DefaultBackgroundRenderer;
import y.view.Graph2D;
import y.view.Graph2DView;

public class JPGOutput
extends ImageOutputModule {
    private static final String pe = "JPG_OUTPUT";
    private static final String re = "JPG";
    private static final String oe = "QUALITY";
    private static final String qe = "ANTIALIASING";
    private ViewPortConfigurator ne = new ViewPortConfigurator();

    public JPGOutput() {
        super(pe);
    }

    protected OptionHandler createOptionHandler() {
        OptionHandler optionHandler = new OptionHandler(pe);
        optionHandler.useSection("VIEWPORT");
        this.addViewPortOptions(optionHandler);
        optionHandler.useSection(re);
        optionHandler.addInt(oe, 75, 1, 100);
        optionHandler.addBool(qe, true);
        this.addRenderingOptions(optionHandler);
        optionHandler.useSection("TILING");
        this.addTilingOptions(optionHandler);
        return optionHandler;
    }

    protected ImageOutputHandler createImageOutputHandler() {
        return new JPGIOHandler();
    }

    protected void mainrun() {
        Graph2DView graph2DView;
        Graph2D graph2D;
        JPGIOHandler jPGIOHandler;
        block3: {
            block2: {
                jPGIOHandler = (JPGIOHandler)this.getIOHandler();
                graph2D = this.getGraph2D();
                Graph2DView graph2DView2 = jPGIOHandler.createDefaultGraph2DView(graph2D);
                graph2DView = this.getGraph2DView();
                graph2D.setCurrentView(graph2DView2);
                this.configureViewPort(graph2DView2, graph2DView);
                graph2DView2.setGraph2DRenderer(graph2DView.getGraph2DRenderer());
                OptionHandler optionHandler = this.getOptionHandler();
                jPGIOHandler.setQuality(0.01f * (float)optionHandler.getInt(oe));
                jPGIOHandler.setAntialiasingEnabled(optionHandler.getBool(qe));
                this.configureRendering();
                this.configureTiling();
                BackgroundRenderer backgroundRenderer = graph2DView.getBackgroundRenderer();
                if (!(backgroundRenderer instanceof DefaultBackgroundRenderer)) break block2;
                DefaultBackgroundRenderer defaultBackgroundRenderer = (DefaultBackgroundRenderer)backgroundRenderer;
                defaultBackgroundRenderer.setGraph2DView(graph2DView2);
                graph2DView2.setBackgroundRenderer(defaultBackgroundRenderer);
                super.mainrun();
                defaultBackgroundRenderer.setGraph2DView(graph2DView);
                if (IOHandlerModule.z == 0) break block3;
            }
            super.mainrun();
        }
        this.setIOHandler(jPGIOHandler);
        graph2D.removeView(graph2D.getCurrentView());
        graph2D.setCurrentView(graph2DView);
    }
}

