/*
 * Decompiled with CFR 0.152.
 */
package y.module.io;

import y.io.IOHandler;
import y.io.ImageOutputHandler;
import y.io.TiledImageOutputHandler;
import y.module.io.IOHandlerModule;
import y.option.OptionHandler;
import y.view.Graph2DView;

public abstract class ImageOutputModule
extends IOHandlerModule {
    protected static final String OPTION_SELECTION_PAINTING = "SELECTION_PAINTING";

    protected ImageOutputModule(String string, String string2, String string3) {
        super(string, string2, string3);
        this.setIOMode((byte)0);
        this.setBackupRealizersEnabled(false);
    }

    protected ImageOutputModule(String string) {
        super(string);
        this.setIOMode((byte)0);
        this.setBackupRealizersEnabled(false);
    }

    protected void addRenderingOptions(OptionHandler optionHandler) {
        optionHandler.addBool(OPTION_SELECTION_PAINTING, false);
    }

    protected void configureViewPort(Graph2DView graph2DView, Graph2DView graph2DView2) {
        graph2DView.setAntialiasedPainting(false);
        super.configureViewPort(graph2DView, graph2DView2);
    }

    protected void configureRendering() {
        OptionHandler optionHandler = this.getOptionHandler();
        ((ImageOutputHandler)this.getIOHandler()).setSelectionPaintingEnabled(optionHandler.getBool(OPTION_SELECTION_PAINTING));
    }

    protected void configureTiling() {
        OptionHandler optionHandler = this.getOptionHandler();
        if (optionHandler.getBool("TILING_ACTIVE")) {
            TiledImageOutputHandler tiledImageOutputHandler = new TiledImageOutputHandler(this.getIOHandler());
            tiledImageOutputHandler.setColumnCount(optionHandler.getInt("TILE_COLUMN_COUNT"));
            tiledImageOutputHandler.setRowCount(optionHandler.getInt("TILE_ROW_COUNT"));
            tiledImageOutputHandler.setHTMLTableGenerationActive(optionHandler.getBool("GENERATE_HTML_TABLE"));
            this.setIOHandler(tiledImageOutputHandler);
        }
    }

    protected IOHandler createIOHandler() {
        return this.createImageOutputHandler();
    }

    protected abstract ImageOutputHandler createImageOutputHandler();
}

