/*
 * Decompiled with CFR 0.152.
 */
package y.module.io;

import java.awt.RenderingHints;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import y.base.Graph;
import y.io.IOHandler;
import y.io.ViewPortConfigurator;
import y.module.YModule;
import y.option.ConstraintManager;
import y.option.DoubleOptionItem;
import y.option.IntOptionItem;
import y.option.OptionHandler;
import y.util.D;
import y.view.Graph2D;
import y.view.Graph2DView;

public abstract class IOHandlerModule
extends YModule {
    private IOHandler je;
    protected ViewPortConfigurator vpc = new ViewPortConfigurator();
    public static final byte OUTPUT_MODE = 0;
    public static final byte INPUT_MODE = 1;
    private byte he = 0;
    private URL ie;
    protected static final String TAB_VIEWPORT = "VIEWPORT";
    protected static final String OPTION_SIZE_TYPE = "SIZE";
    protected static final String OPTION_SIZE_USE_ORIGINAL = "USE_ORIGINAL_SIZE";
    protected static final String OPTION_SIZE_USE_CUSTOM_WIDTH = "USE_CUSTOM_WIDTH";
    protected static final String OPTION_SIZE_USE_CUSTOM_HEIGHT = "USE_CUSTOM_HEIGHT";
    protected static final String OPTION_CUSTOM_WIDTH = "CUSTOM_WIDTH";
    protected static final String OPTION_CUSTOM_HEIGHT = "CUSTOM_HEIGHT";
    protected static final String OPTION_MARGIN = "MARGIN";
    protected static final String OPTION_SCALING_FACTOR = "SCALING_FACTOR";
    protected static final String OPTION_CLIP_TYPE = "CLIP_REGION";
    protected static final String OPTION_CLIP_VIEW = "CLIP_VIEW";
    protected static final String OPTION_CLIP_GRAPH = "CLIP_GRAPH";
    protected static final String TAB_TILING = "TILING";
    protected static final String OPTION_TILING_ACTIVE = "TILING_ACTIVE";
    protected static final String OPTION_TILE_COLUMN_COUNT = "TILE_COLUMN_COUNT";
    protected static final String OPTION_TILE_ROW_COUNT = "TILE_ROW_COUNT";
    protected static final String OPTION_GENERATE_HTML_TABLE = "GENERATE_HTML_TABLE";
    public static int z;

    protected IOHandlerModule(String string, String string2, String string3) {
        super(string, string2, string3);
    }

    protected IOHandlerModule(String string) {
        super(string);
    }

    protected void setIOMode(byte by) {
        this.he = by;
    }

    protected void configureViewPort(Graph2DView graph2DView, Graph2DView graph2DView2) {
        this.adoptViewPortOptions();
        this.vpc.setGraph2D(graph2DView.getGraph2D());
        this.vpc.setGraph2DView(graph2DView2);
        this.vpc.configure(graph2DView);
        this.adoptRenderingHints(graph2DView, graph2DView2);
    }

    protected void addViewPortOptions(OptionHandler optionHandler) {
        int n2 = z;
        ConstraintManager constraintManager = new ConstraintManager(optionHandler);
        optionHandler.addEnum(OPTION_SIZE_TYPE, new String[]{OPTION_SIZE_USE_ORIGINAL, OPTION_SIZE_USE_CUSTOM_WIDTH, OPTION_SIZE_USE_CUSTOM_HEIGHT}, this.vpc.getSizeType());
        optionHandler.addInt(OPTION_CUSTOM_WIDTH, this.vpc.getCustomWidth()).setAttribute(IntOptionItem.ATTRIBUTE_MIN_VALUE, new Integer(1));
        constraintManager.setEnabledOnValueEquals(OPTION_SIZE_TYPE, (Object)OPTION_SIZE_USE_CUSTOM_WIDTH, OPTION_CUSTOM_WIDTH);
        optionHandler.addInt(OPTION_CUSTOM_HEIGHT, this.vpc.getCustomHeight()).setAttribute(IntOptionItem.ATTRIBUTE_MIN_VALUE, new Integer(1));
        constraintManager.setEnabledOnValueEquals(OPTION_SIZE_TYPE, (Object)OPTION_SIZE_USE_CUSTOM_HEIGHT, OPTION_CUSTOM_HEIGHT);
        optionHandler.addInt(OPTION_MARGIN, this.vpc.getMargin());
        optionHandler.addEnum(OPTION_CLIP_TYPE, new String[]{OPTION_CLIP_GRAPH, OPTION_CLIP_VIEW}, this.vpc.getClipType());
        optionHandler.addDouble(OPTION_SCALING_FACTOR, this.vpc.getScalingFactor()).setAttribute(DoubleOptionItem.ATTRIBUTE_MIN_VALUE, new Double(1.0E-7));
        if (n2 != 0) {
            int n3 = Graph.z;
            Graph.z = ++n3;
        }
    }

    protected void addTilingOptions(OptionHandler optionHandler) {
        ConstraintManager constraintManager = new ConstraintManager(optionHandler);
        optionHandler.addBool(OPTION_TILING_ACTIVE, false);
        optionHandler.addInt(OPTION_TILE_COLUMN_COUNT, 2).setAttribute(IntOptionItem.ATTRIBUTE_MIN_VALUE, new Integer(0));
        optionHandler.addInt(OPTION_TILE_ROW_COUNT, 2).setAttribute(IntOptionItem.ATTRIBUTE_MIN_VALUE, new Integer(0));
        optionHandler.addBool(OPTION_GENERATE_HTML_TABLE, false);
        constraintManager.setEnabledOnValueEquals(OPTION_TILING_ACTIVE, (Object)Boolean.TRUE, OPTION_TILE_COLUMN_COUNT);
        constraintManager.setEnabledOnValueEquals(OPTION_TILING_ACTIVE, (Object)Boolean.TRUE, OPTION_TILE_ROW_COUNT);
        constraintManager.setEnabledOnValueEquals(OPTION_TILING_ACTIVE, (Object)Boolean.TRUE, OPTION_GENERATE_HTML_TABLE);
    }

    protected void adoptViewPortOptions() {
        block12: {
            OptionHandler optionHandler;
            block11: {
                int n2;
                block9: {
                    block10: {
                        block8: {
                            n2 = z;
                            optionHandler = this.getOptionHandler();
                            if (!optionHandler.get(OPTION_SIZE_TYPE).equals(OPTION_SIZE_USE_ORIGINAL)) break block8;
                            this.vpc.setSizeType(ViewPortConfigurator.SIZE_USE_ORIGINAL);
                            if (n2 == 0) break block9;
                        }
                        if (!optionHandler.get(OPTION_SIZE_TYPE).equals(OPTION_SIZE_USE_CUSTOM_WIDTH)) break block10;
                        this.vpc.setSizeType(ViewPortConfigurator.SIZE_USE_CUSTOM_WIDTH);
                        if (n2 == 0) break block9;
                    }
                    if (optionHandler.get(OPTION_SIZE_TYPE).equals(OPTION_SIZE_USE_CUSTOM_HEIGHT)) {
                        this.vpc.setSizeType(ViewPortConfigurator.SIZE_USE_CUSTOM_HEIGHT);
                    }
                }
                this.vpc.setCustomWidth(Math.max(optionHandler.getInt(OPTION_CUSTOM_WIDTH), 1));
                this.vpc.setCustomHeight(Math.max(optionHandler.getInt(OPTION_CUSTOM_HEIGHT), 1));
                this.vpc.setMargin(optionHandler.getInt(OPTION_MARGIN));
                this.vpc.setScalingFactor(Math.max(optionHandler.getDouble(OPTION_SCALING_FACTOR), 1.0E-7));
                if (!optionHandler.get(OPTION_CLIP_TYPE).equals(OPTION_CLIP_GRAPH)) break block11;
                this.vpc.setClipType(ViewPortConfigurator.CLIP_GRAPH);
                if (n2 == 0) break block12;
            }
            if (optionHandler.get(OPTION_CLIP_TYPE).equals(OPTION_CLIP_VIEW)) {
                this.vpc.setClipType(ViewPortConfigurator.CLIP_VIEW);
            }
        }
    }

    protected void adoptRenderingHints(Graph2DView graph2DView, Graph2DView graph2DView2) {
        if (graph2DView2 != null) {
            RenderingHints renderingHints;
            RenderingHints.Key key = RenderingHints.KEY_FRACTIONALMETRICS;
            Object object = graph2DView2.getRenderingHints().get(key);
            if (object != null && (renderingHints = graph2DView.getRenderingHints()).get(key) == null) {
                renderingHints.put(key, object);
            }
        }
    }

    public byte getIOMode() {
        return this.he;
    }

    public void setURL(URL uRL) {
        this.ie = uRL;
    }

    public URL getURL() {
        return this.ie;
    }

    protected abstract IOHandler createIOHandler();

    public IOHandler getIOHandler() {
        if (this.je == null) {
            this.je = this.createIOHandler();
        }
        return this.je;
    }

    protected void setIOHandler(IOHandler iOHandler) {
        this.je = iOHandler;
    }

    protected void mainrun() {
        block14: {
            try {
                Graph2D graph2D = this.getGraph2D();
                URL uRL = this.getURL();
                if (uRL == null) {
                    uRL = graph2D.getURL();
                }
                if (uRL == null) {
                    throw new IllegalStateException("No URL given");
                }
                switch (this.getIOMode()) {
                    case 1: {
                        this.getIOHandler().read(this.getGraph2D(), uRL);
                        if (z == 0) break;
                    }
                    case 0: {
                        try {
                            File file = new File(new URI(uRL.toString()));
                            String string = file.getCanonicalPath();
                            this.getIOHandler().write(this.getGraph2D(), string);
                            this.getGraph2D().updateViews();
                            break;
                        }
                        catch (URISyntaxException uRISyntaxException) {
                            String string = uRL.getFile();
                            this.getIOHandler().write(this.getGraph2D(), string);
                            this.getGraph2D().updateViews();
                        }
                    }
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (this.exceptionHappened(illegalArgumentException)) {
                    D.show(illegalArgumentException);
                }
            }
            catch (IOException iOException) {
                if (this.exceptionHappened(iOException)) {
                    D.show(iOException);
                }
            }
            catch (OutOfMemoryError outOfMemoryError) {
                if (!this.exceptionHappened(outOfMemoryError)) break block14;
                D.show(outOfMemoryError);
            }
        }
    }
}

