/*
 * Decompiled with CFR 0.152.
 */
package y.module;

import java.awt.Dimension;
import y.base.DataMap;
import y.base.DataProvider;
import y.base.Edge;
import y.base.EdgeCursor;
import y.base.EdgeMap;
import y.base.Node;
import y.layout.AbstractLayoutStage;
import y.layout.CanonicMultiStageLayouter;
import y.layout.ComponentLayouter;
import y.layout.EdgeLabelLayout;
import y.layout.LayoutGraph;
import y.layout.LayoutStage;
import y.layout.Layouter;
import y.layout.grouping.Grouping;
import y.layout.labeling.AbstractLabelingAlgorithm;
import y.layout.labeling.GreedyMISLabeling;
import y.layout.labeling.MISLabelingAlgorithm;
import y.layout.router.OrganicEdgeRouter;
import y.layout.router.StraightLineEdgeRouter;
import y.layout.router.polyline.EdgeRouter;
import y.layout.tree.ARTreeLayouter;
import y.layout.tree.HVTreeLayouter;
import y.layout.tree.TreeLayouter;
import y.layout.tree.TreeReductionStage;
import y.module.LayoutModule;
import y.module.YModule;
import y.option.ConstraintManager;
import y.option.EnumOptionItem;
import y.option.OptionHandler;
import y.option.OptionItem;
import y.util.DataProviderAdapter;
import y.util.GraphHider;
import y.util.Maps;
import y.view.Graph2D;
import y.view.Graph2DView;

public class TreeLayoutModule
extends LayoutModule {
    protected static final String MODULE_TREE = "TREE";
    protected static final String SECTION_GENERAL = "GENERAL";
    protected static final String ITEM_LAYOUT_STYLE = "LAYOUT_STYLE";
    protected static final String VALUE_DIRECTED = "DIRECTED";
    protected static final String VALUE_HV = "HV";
    protected static final String VALUE_AR = "AR";
    protected static final String ITEM_ROUTING_STYLE_FOR_NON_TREE_EDGES = "ROUTING_STYLE_FOR_NON_TREE_EDGES";
    protected static final String VALUE_ROUTE_ORGANIC = "ROUTE_ORGANIC";
    protected static final String VALUE_ROUTE_ORTHOGONAL = "ROUTE_ORTHOGONAL";
    protected static final String VALUE_ROUTE_STRAIGHTLINE = "ROUTE_STRAIGHTLINE";
    protected static final String ITEM_ACT_ON_SELECTION_ONLY = "ACT_ON_SELECTION_ONLY";
    protected static final String SECTION_DIRECTED = "DIRECTED";
    protected static final String ITEM_MINIMAL_NODE_DISTANCE = "MINIMAL_NODE_DISTANCE";
    protected static final String ITEM_MINIMAL_LAYER_DISTANCE = "MINIMAL_LAYER_DISTANCE";
    protected static final String ITEM_ORIENTATION = "ORIENTATION";
    protected static final String VALUE_TOP_TO_BOTTOM = "TOP_TO_BOTTOM";
    protected static final String VALUE_LEFT_TO_RIGHT = "LEFT_TO_RIGHT";
    protected static final String VALUE_BOTTOM_TO_TOP = "BOTTOM_TO_TOP";
    protected static final String VALUE_RIGHT_TO_LEFT = "RIGHT_TO_LEFT";
    protected static final String ITEM_PORT_STYLE = "PORT_STYLE";
    protected static final String VALUE_NODE_CENTER_PORTS = "NODE_CENTER";
    protected static final String VALUE_BORDER_CENTER_PORTS = "BORDER_CENTER";
    protected static final String VALUE_BORDER_DISTRIBUTED_PORTS = "BORDER_DISTRIBUTED";
    protected static final String VALUE_PORT_CONSTRAINTS_AWARE = "PORT_CONSTRAINTS_AWARE";
    protected static final String ITEM_INTEGRATED_NODE_LABELING = "INTEGRATED_NODE_LABELING";
    protected static final String ITEM_INTEGRATED_EDGE_LABELING = "INTEGRATED_EDGE_LABELING";
    protected static final String ITEM_ORTHOGONAL_EDGE_ROUTING = "ORTHOGONAL_EDGE_ROUTING";
    protected static final String ITEM_BUS_ALIGNMENT = "BUS_ALIGNMENT";
    protected static final String ITEM_VERTICAL_ALIGNMENT = "VERTICAL_ALIGNMENT";
    protected static final String VALUE_ALIGNMENT_TOP = "ALIGNMENT_TOP";
    protected static final String VALUE_ALIGNMENT_CENTER = "ALIGNMENT_CENTER";
    protected static final String VALUE_ALIGNMENT_BOTTOM = "ALIGNMENT_BOTTOM";
    protected static final String ITEM_CHILD_PLACEMENT_POLICY = "CHILD_PLACEMENT_POLICY";
    protected static final String VALUE_SIBLINGS_ON_SAME_LAYER = "SIBLINGS_ON_SAME_LAYER";
    protected static final String VALUE_ALL_LEAVES_ON_SAME_LAYER = "ALL_LEAVES_ON_SAME_LAYER";
    protected static final String VALUE_LEAVES_STACKED = "LEAVES_STACKED";
    protected static final String VALUE_LEAVES_STACKED_LEFT = "LEAVES_STACKED_LEFT";
    protected static final String VALUE_LEAVES_STACKED_RIGHT = "LEAVES_STACKED_RIGHT";
    protected static final String ITEM_ENFORCE_GLOBAL_LAYERING = "ENFORCE_GLOBAL_LAYERING";
    protected static final String SECTION_HV = "HV";
    protected static final String ITEM_HORIZONTAL_SPACE_HV = "HORIZONTAL_SPACE";
    protected static final String ITEM_VERTICAL_SPACE_HV = "VERTICAL_SPACE";
    protected static final String SECTION_AR = "AR";
    protected static final String ITEM_HORIZONTAL_SPACE_AR = "HORIZONTAL_SPACE";
    protected static final String ITEM_VERTICAL_SPACE_AR = "VERTICAL_SPACE";
    protected static final String ITEM_BEND_DISTANCE = "BEND_DISTANCE";
    protected static final String ITEM_USE_VIEW_ASPECT_RATIO = "USE_VIEW_ASPECT_RATIO";
    protected static final String ITEM_ASPECT_RATIO = "ASPECT_RATIO";

    public TreeLayoutModule() {
        super(MODULE_TREE);
        this.setPortIntersectionCalculatorEnabled(true);
    }

    protected OptionHandler createOptionHandler() {
        OptionHandler optionHandler = new OptionHandler(this.getModuleName());
        ConstraintManager constraintManager = new ConstraintManager(optionHandler);
        TreeLayouter treeLayouter = new TreeLayouter();
        HVTreeLayouter hVTreeLayouter = new HVTreeLayouter();
        ARTreeLayouter aRTreeLayouter = new ARTreeLayouter();
        ((ComponentLayouter)hVTreeLayouter.getComponentLayouter()).setStyle((byte)8);
        ((ComponentLayouter)aRTreeLayouter.getComponentLayouter()).setStyle((byte)8);
        optionHandler.useSection(SECTION_GENERAL);
        optionHandler.addEnum(ITEM_LAYOUT_STYLE, new String[]{"DIRECTED", "HV", "AR"}, 0);
        optionHandler.addEnum(ITEM_ROUTING_STYLE_FOR_NON_TREE_EDGES, new String[]{VALUE_ROUTE_ORGANIC, VALUE_ROUTE_ORTHOGONAL, VALUE_ROUTE_STRAIGHTLINE}, 0);
        optionHandler.addBool(ITEM_ACT_ON_SELECTION_ONLY, false);
        optionHandler.useSection("DIRECTED");
        optionHandler.addInt(ITEM_MINIMAL_NODE_DISTANCE, (int)treeLayouter.getMinimalNodeDistance(), 1, 100);
        optionHandler.addInt(ITEM_MINIMAL_LAYER_DISTANCE, (int)treeLayouter.getMinimalLayerDistance(), 10, 300);
        optionHandler.addEnum(ITEM_ORIENTATION, new String[]{VALUE_TOP_TO_BOTTOM, VALUE_LEFT_TO_RIGHT, VALUE_BOTTOM_TO_TOP, VALUE_RIGHT_TO_LEFT}, 0);
        optionHandler.addEnum(ITEM_PORT_STYLE, new String[]{VALUE_NODE_CENTER_PORTS, VALUE_BORDER_CENTER_PORTS, VALUE_BORDER_DISTRIBUTED_PORTS, VALUE_PORT_CONSTRAINTS_AWARE}, 0);
        optionHandler.addBool(ITEM_INTEGRATED_NODE_LABELING, false);
        optionHandler.addBool(ITEM_INTEGRATED_EDGE_LABELING, false);
        OptionItem optionItem = optionHandler.addBool(ITEM_ORTHOGONAL_EDGE_ROUTING, false);
        EnumOptionItem enumOptionItem = optionHandler.addEnum(ITEM_BUS_ALIGNMENT, new String[]{VALUE_ALIGNMENT_TOP, VALUE_ALIGNMENT_CENTER, VALUE_ALIGNMENT_BOTTOM}, 1);
        optionHandler.addEnum(ITEM_VERTICAL_ALIGNMENT, new String[]{VALUE_ALIGNMENT_TOP, VALUE_ALIGNMENT_CENTER, VALUE_ALIGNMENT_BOTTOM}, 1);
        EnumOptionItem enumOptionItem2 = optionHandler.addEnum(ITEM_CHILD_PLACEMENT_POLICY, new String[]{VALUE_SIBLINGS_ON_SAME_LAYER, VALUE_ALL_LEAVES_ON_SAME_LAYER, VALUE_LEAVES_STACKED, VALUE_LEAVES_STACKED_LEFT, VALUE_LEAVES_STACKED_RIGHT}, 0);
        OptionItem optionItem2 = optionHandler.addBool(ITEM_ENFORCE_GLOBAL_LAYERING, false);
        ConstraintManager.Condition condition = constraintManager.createConditionValueEquals(optionItem, (Object)Boolean.TRUE).and(constraintManager.createConditionValueEquals(optionItem2, (Object)Boolean.TRUE).or(constraintManager.createConditionValueEquals(enumOptionItem2, (Object)VALUE_ALL_LEAVES_ON_SAME_LAYER)));
        constraintManager.setEnabledOnCondition(condition, enumOptionItem);
        optionHandler.useSection("HV");
        optionHandler.addInt("HORIZONTAL_SPACE", (int)hVTreeLayouter.getHorizontalSpace());
        optionHandler.addInt("VERTICAL_SPACE", (int)hVTreeLayouter.getVerticalSpace());
        optionHandler.useSection("AR");
        optionHandler.addInt("HORIZONTAL_SPACE", (int)aRTreeLayouter.getHorizontalSpace());
        optionHandler.addInt("VERTICAL_SPACE", (int)aRTreeLayouter.getVerticalSpace());
        optionHandler.addInt(ITEM_BEND_DISTANCE, (int)aRTreeLayouter.getBendDistance());
        OptionItem optionItem3 = optionHandler.addBool(ITEM_USE_VIEW_ASPECT_RATIO, true);
        OptionItem optionItem4 = optionHandler.addDouble(ITEM_ASPECT_RATIO, aRTreeLayouter.getAspectRatio());
        constraintManager.setEnabledOnValueEquals(optionItem3, (Object)Boolean.FALSE, optionItem4);
        return optionHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void mainrun() {
        CanonicMultiStageLayouter canonicMultiStageLayouter;
        Graph2D graph2D;
        OptionHandler optionHandler;
        block7: {
            CanonicMultiStageLayouter canonicMultiStageLayouter2;
            block8: {
                String string;
                boolean bl;
                block6: {
                    bl = YModule.z;
                    optionHandler = this.getOptionHandler();
                    graph2D = this.getGraph2D();
                    string = optionHandler.getString(ITEM_LAYOUT_STYLE);
                    if (!"HV".equals(string)) break block6;
                    canonicMultiStageLayouter2 = new HVTreeLayouter();
                    this.configure((HVTreeLayouter)canonicMultiStageLayouter2, optionHandler);
                    canonicMultiStageLayouter = canonicMultiStageLayouter2;
                    if (!bl) break block7;
                }
                if (!"AR".equals(string)) break block8;
                canonicMultiStageLayouter2 = new ARTreeLayouter();
                this.configure((ARTreeLayouter)canonicMultiStageLayouter2, optionHandler);
                canonicMultiStageLayouter = canonicMultiStageLayouter2;
                if (!bl) break block7;
            }
            canonicMultiStageLayouter2 = new TreeLayouter();
            this.configure((TreeLayouter)canonicMultiStageLayouter2, optionHandler);
            canonicMultiStageLayouter = canonicMultiStageLayouter2;
        }
        boolean bl = optionHandler.getBool(ITEM_INTEGRATED_EDGE_LABELING);
        _b _b2 = new _b(bl);
        this.configure(_b2, optionHandler);
        canonicMultiStageLayouter.appendStage(_b2);
        canonicMultiStageLayouter.prependStage(new _d());
        canonicMultiStageLayouter.prependStage(new _c(bl));
        this.prepareGraph(graph2D, optionHandler);
        try {
            this.launchLayouter(canonicMultiStageLayouter);
        }
        finally {
            this.restoreGraph(graph2D, optionHandler);
        }
    }

    protected void prepareGraph(final Graph2D graph2D, OptionHandler optionHandler) {
        block5: {
            String string;
            block4: {
                string = optionHandler.getString(ITEM_LAYOUT_STYLE);
                if (!"HV".equals(string)) break block4;
                this.backupDataProvider(graph2D, HVTreeLayouter.SUBTREE_ORIENTATION);
                graph2D.addDataProvider(HVTreeLayouter.SUBTREE_ORIENTATION, new DataProviderAdapter(){

                    public Object get(Object object) {
                        if (graph2D.isSelected((Node)object)) {
                            return HVTreeLayouter.VERTICAL_SUBTREE;
                        }
                        return HVTreeLayouter.HORIZONTAL_SUBTREE;
                    }
                });
                if (!YModule.z) break block5;
            }
            if ("AR".equals(string)) {
                this.backupDataProvider(graph2D, ARTreeLayouter.ROUTING_POLICY);
                graph2D.addDataProvider(ARTreeLayouter.ROUTING_POLICY, new DataProviderAdapter(){

                    public Object get(Object object) {
                        if (graph2D.isSelected((Node)object)) {
                            return ARTreeLayouter.ROUTING_HORIZONTAL;
                        }
                        return ARTreeLayouter.ROUTING_VERTICAL;
                    }
                });
            }
        }
    }

    protected void restoreGraph(Graph2D graph2D, OptionHandler optionHandler) {
        block5: {
            String string;
            block4: {
                string = optionHandler.getString(ITEM_LAYOUT_STYLE);
                if (!"HV".equals(string)) break block4;
                this.restoreDataProvider(graph2D, HVTreeLayouter.SUBTREE_ORIENTATION);
                if (!YModule.z) break block5;
            }
            if ("AR".equals(string)) {
                this.restoreDataProvider(graph2D, ARTreeLayouter.ROUTING_POLICY);
            }
        }
    }

    protected void configure(TreeLayouter treeLayouter, OptionHandler optionHandler) {
        block43: {
            block44: {
                String string;
                boolean bl;
                block42: {
                    block40: {
                        block41: {
                            String string2;
                            block39: {
                                block36: {
                                    block38: {
                                        String string3;
                                        block37: {
                                            block35: {
                                                block34: {
                                                    block33: {
                                                        block29: {
                                                            String string4;
                                                            block32: {
                                                                block31: {
                                                                    block30: {
                                                                        block28: {
                                                                            block27: {
                                                                                block26: {
                                                                                    block23: {
                                                                                        block25: {
                                                                                            String string5;
                                                                                            block24: {
                                                                                                block22: {
                                                                                                    bl = YModule.z;
                                                                                                    ((ComponentLayouter)treeLayouter.getComponentLayouter()).setStyle((byte)8);
                                                                                                    treeLayouter.setMinimalNodeDistance(optionHandler.getInt("DIRECTED", ITEM_MINIMAL_NODE_DISTANCE));
                                                                                                    treeLayouter.setMinimalLayerDistance(optionHandler.getInt("DIRECTED", ITEM_MINIMAL_LAYER_DISTANCE));
                                                                                                    string5 = optionHandler.getString(ITEM_ORIENTATION);
                                                                                                    if (!VALUE_TOP_TO_BOTTOM.equals(string5)) break block22;
                                                                                                    treeLayouter.setLayoutOrientation((byte)0);
                                                                                                    if (!bl) break block23;
                                                                                                }
                                                                                                if (!VALUE_BOTTOM_TO_TOP.equals(string5)) break block24;
                                                                                                treeLayouter.setLayoutOrientation((byte)2);
                                                                                                if (!bl) break block23;
                                                                                            }
                                                                                            if (!VALUE_RIGHT_TO_LEFT.equals(string5)) break block25;
                                                                                            treeLayouter.setLayoutOrientation((byte)3);
                                                                                            if (!bl) break block23;
                                                                                        }
                                                                                        treeLayouter.setLayoutOrientation((byte)1);
                                                                                    }
                                                                                    if (!optionHandler.getBool(ITEM_ORTHOGONAL_EDGE_ROUTING)) break block26;
                                                                                    treeLayouter.setLayoutStyle(1);
                                                                                    if (!bl) break block27;
                                                                                }
                                                                                treeLayouter.setLayoutStyle(0);
                                                                            }
                                                                            if (!VALUE_SIBLINGS_ON_SAME_LAYER.equals(string4 = optionHandler.getString(ITEM_CHILD_PLACEMENT_POLICY))) break block28;
                                                                            treeLayouter.setChildPlacementPolicy((byte)5);
                                                                            if (!bl) break block29;
                                                                        }
                                                                        if (!VALUE_LEAVES_STACKED_LEFT.equals(string4)) break block30;
                                                                        treeLayouter.setChildPlacementPolicy((byte)1);
                                                                        if (!bl) break block29;
                                                                    }
                                                                    if (!VALUE_LEAVES_STACKED_RIGHT.equals(string4)) break block31;
                                                                    treeLayouter.setChildPlacementPolicy((byte)2);
                                                                    if (!bl) break block29;
                                                                }
                                                                if (!VALUE_LEAVES_STACKED.equals(string4)) break block32;
                                                                treeLayouter.setChildPlacementPolicy((byte)0);
                                                                if (!bl) break block29;
                                                            }
                                                            if (VALUE_ALL_LEAVES_ON_SAME_LAYER.equals(string4)) {
                                                                treeLayouter.setChildPlacementPolicy((byte)4);
                                                            }
                                                        }
                                                        if (!optionHandler.getBool(ITEM_ENFORCE_GLOBAL_LAYERING)) break block33;
                                                        treeLayouter.setEnforceGlobalLayering(true);
                                                        if (!bl) break block34;
                                                    }
                                                    treeLayouter.setEnforceGlobalLayering(false);
                                                }
                                                if (!VALUE_NODE_CENTER_PORTS.equals(string3 = optionHandler.getString(ITEM_PORT_STYLE))) break block35;
                                                treeLayouter.setPortStyle(0);
                                                if (!bl) break block36;
                                            }
                                            if (!VALUE_BORDER_CENTER_PORTS.equals(string3)) break block37;
                                            treeLayouter.setPortStyle(1);
                                            if (!bl) break block36;
                                        }
                                        if (!VALUE_BORDER_DISTRIBUTED_PORTS.equals(string3)) break block38;
                                        treeLayouter.setPortStyle(2);
                                        if (!bl) break block36;
                                    }
                                    treeLayouter.setPortStyle(3);
                                }
                                treeLayouter.setIntegratedNodeLabelingEnabled(optionHandler.getBool("DIRECTED", ITEM_INTEGRATED_NODE_LABELING));
                                treeLayouter.setIntegratedEdgeLabelingEnabled(optionHandler.getBool("DIRECTED", ITEM_INTEGRATED_EDGE_LABELING));
                                string2 = optionHandler.getString(ITEM_VERTICAL_ALIGNMENT);
                                if (!VALUE_ALIGNMENT_TOP.equals(string2)) break block39;
                                treeLayouter.setVerticalAlignment(0.0);
                                if (!bl) break block40;
                            }
                            if (!VALUE_ALIGNMENT_BOTTOM.equals(string2)) break block41;
                            treeLayouter.setVerticalAlignment(1.0);
                            if (!bl) break block40;
                        }
                        treeLayouter.setVerticalAlignment(0.5);
                    }
                    if (!VALUE_ALIGNMENT_TOP.equals(string = optionHandler.getString(ITEM_BUS_ALIGNMENT))) break block42;
                    treeLayouter.setBusAlignment(0.1);
                    if (!bl) break block43;
                }
                if (!VALUE_ALIGNMENT_BOTTOM.equals(string)) break block44;
                treeLayouter.setBusAlignment(0.9);
                if (!bl) break block43;
            }
            treeLayouter.setBusAlignment(0.5);
        }
        treeLayouter.setSubgraphLayouterEnabled(optionHandler.getBool(ITEM_ACT_ON_SELECTION_ONLY));
    }

    protected void configure(ARTreeLayouter aRTreeLayouter, OptionHandler optionHandler) {
        block4: {
            block2: {
                boolean bl;
                block3: {
                    bl = YModule.z;
                    if (!optionHandler.getBool(ITEM_USE_VIEW_ASPECT_RATIO)) break block2;
                    Graph2DView graph2DView = this.getGraph2DView();
                    if (graph2DView == null) break block3;
                    Dimension dimension = graph2DView.getSize();
                    aRTreeLayouter.setAspectRatio(dimension.getWidth() / dimension.getHeight());
                    if (!bl) break block4;
                }
                aRTreeLayouter.setAspectRatio(1.0);
                if (!bl) break block4;
            }
            aRTreeLayouter.setAspectRatio(optionHandler.getDouble(ITEM_ASPECT_RATIO));
        }
        aRTreeLayouter.setHorizontalSpace(optionHandler.getInt("AR", "HORIZONTAL_SPACE"));
        aRTreeLayouter.setVerticalSpace(optionHandler.getInt("AR", "VERTICAL_SPACE"));
        aRTreeLayouter.setBendDistance(optionHandler.getInt("AR", ITEM_BEND_DISTANCE));
        aRTreeLayouter.setSubgraphLayouterEnabled(optionHandler.getBool(ITEM_ACT_ON_SELECTION_ONLY));
    }

    protected void configure(HVTreeLayouter hVTreeLayouter, OptionHandler optionHandler) {
        hVTreeLayouter.setHorizontalSpace(optionHandler.getInt("HV", "HORIZONTAL_SPACE"));
        hVTreeLayouter.setVerticalSpace(optionHandler.getInt("HV", "VERTICAL_SPACE"));
        hVTreeLayouter.setSubgraphLayouterEnabled(optionHandler.getBool(ITEM_ACT_ON_SELECTION_ONLY));
    }

    protected void configure(TreeReductionStage treeReductionStage, OptionHandler optionHandler) {
        block5: {
            Object object;
            block6: {
                LayoutStage layoutStage;
                boolean bl;
                block4: {
                    bl = YModule.z;
                    treeReductionStage.setMultiParentAllowed("DIRECTED".equals(optionHandler.getString(ITEM_LAYOUT_STYLE)) && !optionHandler.getBool(ITEM_ENFORCE_GLOBAL_LAYERING) && !VALUE_ALL_LEAVES_ON_SAME_LAYER.equals(optionHandler.getString(ITEM_CHILD_PLACEMENT_POLICY)));
                    object = optionHandler.get(ITEM_ROUTING_STYLE_FOR_NON_TREE_EDGES);
                    if (!VALUE_ROUTE_ORGANIC.equals(object)) break block4;
                    layoutStage = new OrganicEdgeRouter();
                    treeReductionStage.setNonTreeEdgeRouter(layoutStage);
                    treeReductionStage.setNonTreeEdgeSelectionKey(OrganicEdgeRouter.ROUTE_EDGE_DPKEY);
                    if (!bl) break block5;
                }
                if (!VALUE_ROUTE_ORTHOGONAL.equals(object)) break block6;
                layoutStage = new EdgeRouter();
                ((EdgeRouter)layoutStage).setReroutingEnabled(true);
                ((EdgeRouter)layoutStage).setSphereOfAction((byte)2);
                treeReductionStage.setNonTreeEdgeSelectionKey(((EdgeRouter)layoutStage).getSelectedEdgesDpKey());
                treeReductionStage.setNonTreeEdgeRouter(layoutStage);
                if (!bl) break block5;
            }
            if (VALUE_ROUTE_STRAIGHTLINE.equals(object)) {
                treeReductionStage.setNonTreeEdgeRouter(treeReductionStage.createStraightlineRouter());
            }
        }
    }

    private static class _d
    extends AbstractLayoutStage {
        private boolean rpb = true;
        private Layouter qpb = new StraightLineEdgeRouter();
        private Object ppb = Layouter.SELECTED_EDGES;

        public boolean dj() {
            return this.rpb;
        }

        public void rb(boolean bl) {
            this.rpb = bl;
        }

        public Object ej() {
            return this.ppb;
        }

        public void l(Object object) {
            this.ppb = object;
        }

        public Layouter cj() {
            return this.qpb;
        }

        public void b(Layouter layouter) {
            this.qpb = layouter;
        }

        public boolean canLayout(LayoutGraph layoutGraph) {
            return true;
        }

        public void doLayout(LayoutGraph layoutGraph) {
            block9: {
                boolean bl;
                Object object;
                Object object2;
                EdgeMap edgeMap;
                GraphHider graphHider;
                Grouping grouping;
                block7: {
                    boolean bl2;
                    block8: {
                        boolean bl3;
                        bl2 = YModule.z;
                        boolean bl4 = bl3 = !Grouping.isFlat(layoutGraph);
                        if (bl3) break block8;
                        this.doLayoutCore(layoutGraph);
                        if (!bl2) break block9;
                    }
                    grouping = new Grouping(layoutGraph);
                    graphHider = new GraphHider(layoutGraph);
                    edgeMap = layoutGraph.createEdgeMap();
                    boolean bl5 = false;
                    object2 = layoutGraph.edges();
                    while (object2.ok()) {
                        object = object2.edge();
                        bl = grouping.isGroupNode(((Edge)object).source());
                        if (!bl2) {
                            if (bl || grouping.isGroupNode(((Edge)object).target())) {
                                edgeMap.setBool(object, true);
                                graphHider.hide((Edge)object);
                                if (!bl5) {
                                    bl5 = true;
                                }
                            }
                            object2.next();
                            if (!bl2) continue;
                        }
                        break block7;
                    }
                    this.doLayoutCore(layoutGraph);
                    bl = bl5;
                }
                if (bl) {
                    graphHider.unhideAll();
                    this.b(layoutGraph, edgeMap);
                    if (this.rpb) {
                        object2 = "SELECTED_LABELS";
                        layoutGraph.addDataProvider(object2, new DataProviderAdapter(this, layoutGraph, edgeMap){
                            private final /* synthetic */ LayoutGraph val$graph;
                            private final /* synthetic */ EdgeMap val$hiddenEdgesMap;
                            private final /* synthetic */ _d this$0;
                            {
                                this.this$0 = _d2;
                                this.val$graph = layoutGraph;
                                this.val$hiddenEdgesMap = edgeMap;
                            }

                            public boolean getBool(Object object) {
                                if (object instanceof EdgeLabelLayout) {
                                    EdgeLabelLayout edgeLabelLayout = (EdgeLabelLayout)object;
                                    Edge edge = this.val$graph.getFeature(edgeLabelLayout);
                                    return this.val$hiddenEdgesMap.getBool(edge);
                                }
                                return false;
                            }
                        });
                        object = new GreedyMISLabeling();
                        ((MISLabelingAlgorithm)object).setOptimizationStrategy((byte)0);
                        ((AbstractLabelingAlgorithm)object).setPlaceNodeLabels(false);
                        ((AbstractLabelingAlgorithm)object).setPlaceEdgeLabels(true);
                        ((AbstractLabelingAlgorithm)object).setSelection(object2);
                        ((AbstractLabelingAlgorithm)object).doLayout(layoutGraph);
                        layoutGraph.removeDataProvider(object2);
                    }
                }
                layoutGraph.disposeEdgeMap(edgeMap);
                grouping.dispose();
            }
        }

        protected void b(LayoutGraph layoutGraph, EdgeMap edgeMap) {
            if (this.qpb == null) {
                return;
            }
            DataProvider dataProvider = null;
            if (this.ppb != null) {
                dataProvider = layoutGraph.getDataProvider(this.ppb);
                layoutGraph.addDataProvider(this.ppb, edgeMap);
            }
            if (this.qpb instanceof StraightLineEdgeRouter) {
                StraightLineEdgeRouter straightLineEdgeRouter = (StraightLineEdgeRouter)this.qpb;
                straightLineEdgeRouter.setSphereOfAction((byte)2);
                straightLineEdgeRouter.setSelectedEdgesDpKey(this.ppb);
            }
            this.qpb.doLayout(layoutGraph);
            layoutGraph.removeDataProvider(this.ppb);
            if (dataProvider != null) {
                layoutGraph.addDataProvider(this.ppb, dataProvider);
            }
        }
    }

    private static class _b
    extends TreeReductionStage {
        private boolean bkc;

        _b(boolean bl) {
            this.bkc = bl;
        }

        protected void routeNonTreeEdges(LayoutGraph layoutGraph, EdgeMap edgeMap) {
            block4: {
                boolean bl = YModule.z;
                super.routeNonTreeEdges(layoutGraph, edgeMap);
                if (this.bkc) {
                    String string = "selectionDPKey";
                    DataMap dataMap = Maps.createHashedDataMap();
                    EdgeCursor edgeCursor = layoutGraph.edges();
                    while (edgeCursor.ok()) {
                        block5: {
                            Edge edge = edgeCursor.edge();
                            EdgeLabelLayout[] edgeLabelLayoutArray = layoutGraph.getEdgeLabelLayout(edge);
                            boolean bl2 = edgeMap.getBool(edge);
                            if (bl) break block4;
                            for (int i2 = 0; i2 < edgeLabelLayoutArray.length; ++i2) {
                                dataMap.setBool(edgeLabelLayoutArray[i2], bl2);
                                if (!bl) {
                                    if (!bl) continue;
                                }
                                break block5;
                            }
                            edgeCursor.next();
                        }
                        if (!bl) continue;
                    }
                    layoutGraph.addDataProvider(string, dataMap);
                }
            }
        }
    }

    private static class _c
    extends AbstractLayoutStage {
        private boolean opb;

        _c(boolean bl) {
            this.opb = bl;
        }

        public boolean canLayout(LayoutGraph layoutGraph) {
            return this.canLayoutCore(layoutGraph);
        }

        public void doLayout(LayoutGraph layoutGraph) {
            this.doLayoutCore(layoutGraph);
            if (this.opb) {
                String string = "selectionDPKey";
                GreedyMISLabeling greedyMISLabeling = new GreedyMISLabeling();
                greedyMISLabeling.setOptimizationStrategy((byte)0);
                greedyMISLabeling.setPlaceNodeLabels(false);
                greedyMISLabeling.setPlaceEdgeLabels(true);
                greedyMISLabeling.setSelection(string);
                greedyMISLabeling.doLayout(layoutGraph);
                layoutGraph.removeDataProvider(string);
            }
        }
    }
}

