/*
 * Decompiled with CFR 0.152.
 */
package y.module;

import java.awt.Rectangle;
import y.base.Graph;
import y.base.Node;
import y.base.NodeCursor;
import y.base.NodeMap;
import y.layout.ComponentLayouter;
import y.layout.organic.OutputRestriction;
import y.layout.organic.SmartOrganicLayouter;
import y.module.LayoutModule;
import y.module.YModule;
import y.option.ConstraintManager;
import y.option.DefaultEditorFactory;
import y.option.DoubleOptionItem;
import y.option.EnumOptionItem;
import y.option.IntOptionItem;
import y.option.OptionGroup;
import y.option.OptionHandler;
import y.option.OptionItem;
import y.util.Maps;
import y.view.Graph2D;
import y.view.Graph2DLayoutExecutor;
import y.view.Selections;
import y.view.hierarchy.HierarchyManager;

public class SmartOrganicLayoutModule
extends LayoutModule {
    protected static final String MODULE_SMARTORGANIC = "SMARTORGANIC";
    protected static final String SECTION_VISUAL = "VISUAL";
    protected static final String ITEM_SCOPE = "SCOPE";
    protected static final String VALUE_SCOPE_ALL = "ALL";
    protected static final String VALUE_SCOPE_MAINLY_SUBSET = "MAINLY_SUBSET";
    protected static final String VALUE_SCOPE_SUBSET = "SUBSET";
    protected static final String ITEM_PREFERRED_EDGE_LENGTH = "PREFERRED_EDGE_LENGTH";
    protected static final String ITEM_CONSIDER_NODE_LABELS = "CONSIDER_NODE_LABELS";
    protected static final String ITEM_ALLOW_NODE_OVERLAPS = "ALLOW_NODE_OVERLAPS";
    protected static final String ITEM_MINIMAL_NODE_DISTANCE = "MINIMAL_NODE_DISTANCE";
    protected static final String ITEM_AVOID_NODE_EDGE_OVERLAPS = "AVOID_NODE_EDGE_OVERLAPS";
    protected static final String ITEM_COMPACTNESS = "COMPACTNESS";
    protected static final String ITEM_USE_AUTO_CLUSTERING = "USE_AUTO_CLUSTERING";
    protected static final String ITEM_AUTO_CLUSTERING_QUALITY = "AUTO_CLUSTERING_QUALITY";
    protected static final String SECTION_RESTRICTIONS = "RESTRICTIONS";
    protected static final String ITEM_RESTRICT_OUTPUT = "RESTRICT_OUTPUT";
    protected static final String VALUE_NONE = "NONE";
    protected static final String VALUE_OUTPUT_CAGE = "OUTPUT_CAGE";
    protected static final String VALUE_OUTPUT_CIRCULAR_CAGE = "OUTPUT_CIRCULAR_CAGE";
    protected static final String VALUE_OUTPUT_AR = "OUTPUT_AR";
    protected static final String VALUE_OUTPUT_ELLIPTICAL_CAGE = "OUTPUT_ELLIPTICAL_CAGE";
    protected static final String TITLE_OUTPUT_CAGE = "OUTPUT_CAGE";
    protected static final String ITEM_RECT_CAGE_USE_VIEW = "RECT_CAGE_USE_VIEW";
    protected static final String ITEM_CAGE_X = "CAGE_X";
    protected static final String ITEM_CAGE_Y = "CAGE_Y";
    protected static final String ITEM_CAGE_WIDTH = "CAGE_WIDTH";
    protected static final String ITEM_CAGE_HEIGHT = "CAGE_HEIGHT";
    protected static final String TITLE_OUTPUT_CIRCULAR_CAGE = "OUTPUT_CIRCULAR_CAGE";
    protected static final String ITEM_CIRC_CAGE_USE_VIEW = "CIRC_CAGE_USE_VIEW";
    protected static final String ITEM_CAGE_CENTER_X = "CAGE_CENTER_X";
    protected static final String ITEM_CAGE_CENTER_Y = "CAGE_CENTER_Y";
    protected static final String ITEM_CAGE_RADIUS = "CAGE_RADIUS";
    protected static final String TITLE_OUTPUT_AR = "OUTPUT_AR";
    protected static final String ITEM_AR_CAGE_USE_VIEW = "AR_CAGE_USE_VIEW";
    protected static final String ITEM_CAGE_RATIO = "CAGE_RATIO";
    protected static final String TITLE_OUTPUT_ELLIPTICAL_CAGE = "OUTPUT_ELLIPTICAL_CAGE";
    protected static final String ITEM_ELL_CAGE_USE_VIEW = "ELL_CAGE_USE_VIEW";
    protected static final String ITEM_ELLIPTICAL_CAGE_X = "ELLIPTICAL_CAGE_X";
    protected static final String ITEM_ELLIPTICAL_CAGE_Y = "ELLIPTICAL_CAGE_Y";
    protected static final String ITEM_ELLIPTICAL_CAGE_WIDTH = "ELLIPTICAL_CAGE_WIDTH";
    protected static final String ITEM_ELLIPTICAL_CAGE_HEIGHT = "ELLIPTICAL_CAGE_HEIGHT";
    protected static final String SECTION_GROUPING = "GROUPING";
    protected static final String ITEM_GROUP_LAYOUT_POLICY = "GROUP_LAYOUT_POLICY";
    protected static final String VALUE_LAYOUT_GROUPS = "LAYOUT_GROUPS";
    protected static final String VALUE_FIX_GROUP_CONTENTS = "FIX_GROUP_CONTENTS";
    protected static final String VALUE_FIX_GROUP_BOUNDS = "FIX_GROUP_BOUNDS";
    protected static final String VALUE_IGNORE_GROUPS = "IGNORE_GROUPS";
    protected static final String ITEM_USE_AUTOMATIC_GROUP_NODE_COMPACTION = "USE_AUTOMATIC_GROUP_NODE_COMPACTION";
    protected static final String ITEM_GROUP_COMPACTNESS = "GROUP_COMPACTNESS";
    protected static final String SECTION_ALGORITHM = "ALGORITHM";
    protected static final String ITEM_QUALITY_TIME_RATIO = "QUALITY_TIME_RATIO";
    protected static final String ITEM_MAXIMAL_DURATION = "MAXIMAL_DURATION";
    protected static final String ITEM_ACTIVATE_DETERMINISTIC_MODE = "ACTIVATE_DETERMINISTIC_MODE";
    protected static final String ITEM_ALLOW_MULTI_THREADING = "ALLOW_MULTI_THREADING";
    private boolean uc;

    public SmartOrganicLayoutModule() {
        super(MODULE_SMARTORGANIC);
        this.setPortIntersectionCalculatorEnabled(true);
    }

    protected OptionHandler createOptionHandler() {
        boolean bl = YModule.z;
        OptionHandler optionHandler = new OptionHandler(this.getModuleName());
        ConstraintManager constraintManager = new ConstraintManager(optionHandler);
        SmartOrganicLayouter smartOrganicLayouter = new SmartOrganicLayouter();
        optionHandler.useSection(SECTION_VISUAL);
        optionHandler.addEnum(ITEM_SCOPE, new String[]{VALUE_SCOPE_ALL, VALUE_SCOPE_MAINLY_SUBSET, VALUE_SCOPE_SUBSET}, smartOrganicLayouter.getScope());
        optionHandler.addInt(ITEM_PREFERRED_EDGE_LENGTH, (int)smartOrganicLayouter.getPreferredEdgeLength(), 5, 500);
        OptionItem optionItem = optionHandler.addBool(ITEM_CONSIDER_NODE_LABELS, smartOrganicLayouter.isConsiderNodeLabelsEnabled());
        OptionItem optionItem2 = optionHandler.addBool(ITEM_ALLOW_NODE_OVERLAPS, smartOrganicLayouter.isNodeOverlapsAllowed());
        OptionItem optionItem3 = optionHandler.addDouble(ITEM_MINIMAL_NODE_DISTANCE, smartOrganicLayouter.getMinimalNodeDistance(), 0.0, 100.0, 0);
        optionHandler.addBool(ITEM_AVOID_NODE_EDGE_OVERLAPS, false);
        optionHandler.addDouble(ITEM_COMPACTNESS, smartOrganicLayouter.getCompactness(), 0.0, 1.0);
        OptionItem optionItem4 = optionHandler.addBool(ITEM_USE_AUTO_CLUSTERING, smartOrganicLayouter.isAutoClusteringEnabled());
        OptionItem optionItem5 = optionHandler.addDouble(ITEM_AUTO_CLUSTERING_QUALITY, smartOrganicLayouter.getAutoClusteringQuality(), 0.0, 1.0);
        ConstraintManager.Condition condition = constraintManager.createConditionValueEquals(optionItem2, (Object)Boolean.FALSE).or(constraintManager.createConditionValueEquals(optionItem, (Object)Boolean.TRUE));
        constraintManager.setEnabledOnCondition(condition, optionItem3);
        constraintManager.setEnabledOnValueEquals(optionItem, (Object)Boolean.FALSE, optionItem2);
        constraintManager.setEnabledOnValueEquals(optionItem4, (Object)Boolean.TRUE, optionItem5);
        optionHandler.useSection(SECTION_RESTRICTIONS);
        Object object = new Object();
        EnumOptionItem enumOptionItem = optionHandler.addEnum(ITEM_RESTRICT_OUTPUT, new String[]{VALUE_NONE, "OUTPUT_CAGE", "OUTPUT_CIRCULAR_CAGE", "OUTPUT_AR", "OUTPUT_ELLIPTICAL_CAGE"}, 0);
        enumOptionItem.setAttribute(DefaultEditorFactory.ATTRIBUTE_CONTROLLER_ID, object);
        OptionGroup optionGroup = new OptionGroup();
        optionGroup.setAttribute("OptionGroup.title", "OUTPUT_CAGE");
        optionGroup.setAttribute(DefaultEditorFactory.ATTRIBUTE_CONTROLLER_ID, object);
        optionGroup.setAttribute(DefaultEditorFactory.ATTRIBUTE_CARD_ID, "OUTPUT_CAGE");
        OptionItem optionItem6 = optionGroup.addItem(optionHandler.addBool(ITEM_RECT_CAGE_USE_VIEW, true));
        OptionItem optionItem7 = optionGroup.addItem(optionHandler.addDouble(ITEM_CAGE_X, 0.0));
        OptionItem optionItem8 = optionGroup.addItem(optionHandler.addDouble(ITEM_CAGE_Y, 0.0));
        OptionItem optionItem9 = optionGroup.addItem(optionHandler.addDouble(ITEM_CAGE_WIDTH, 1000.0));
        optionItem9.setAttribute(DoubleOptionItem.ATTRIBUTE_MIN_VALUE, new Double(Double.MIN_VALUE));
        OptionItem optionItem10 = optionGroup.addItem(optionHandler.addDouble(ITEM_CAGE_HEIGHT, 1000.0));
        optionItem10.setAttribute(DoubleOptionItem.ATTRIBUTE_MIN_VALUE, new Double(Double.MIN_VALUE));
        constraintManager.setEnabledOnValueEquals((OptionItem)enumOptionItem, (Object)"OUTPUT_CAGE", optionGroup);
        condition = constraintManager.createConditionValueEquals(enumOptionItem, (Object)"OUTPUT_CAGE").and(constraintManager.createConditionValueEquals(optionItem6, (Object)Boolean.FALSE));
        constraintManager.setEnabledOnCondition(condition, optionItem7);
        constraintManager.setEnabledOnCondition(condition, optionItem8);
        constraintManager.setEnabledOnCondition(condition, optionItem9);
        constraintManager.setEnabledOnCondition(condition, optionItem10);
        OptionGroup optionGroup2 = new OptionGroup();
        optionGroup2.setAttribute("OptionGroup.title", "OUTPUT_CIRCULAR_CAGE");
        optionGroup2.setAttribute(DefaultEditorFactory.ATTRIBUTE_CONTROLLER_ID, object);
        optionGroup2.setAttribute(DefaultEditorFactory.ATTRIBUTE_CARD_ID, "OUTPUT_CIRCULAR_CAGE");
        OptionItem optionItem11 = optionGroup2.addItem(optionHandler.addBool(ITEM_CIRC_CAGE_USE_VIEW, true));
        OptionItem optionItem12 = optionGroup2.addItem(optionHandler.addDouble(ITEM_CAGE_CENTER_X, 0.0));
        OptionItem optionItem13 = optionGroup2.addItem(optionHandler.addDouble(ITEM_CAGE_CENTER_Y, 0.0));
        OptionItem optionItem14 = optionGroup2.addItem(optionHandler.addDouble(ITEM_CAGE_RADIUS, 1000.0));
        optionItem14.setAttribute(DoubleOptionItem.ATTRIBUTE_MIN_VALUE, new Double(Double.MIN_VALUE));
        constraintManager.setEnabledOnValueEquals((OptionItem)enumOptionItem, (Object)"OUTPUT_CIRCULAR_CAGE", optionGroup2);
        condition = constraintManager.createConditionValueEquals(enumOptionItem, (Object)"OUTPUT_CIRCULAR_CAGE").and(constraintManager.createConditionValueEquals(optionItem11, (Object)Boolean.FALSE));
        constraintManager.setEnabledOnCondition(condition, optionItem12);
        constraintManager.setEnabledOnCondition(condition, optionItem13);
        constraintManager.setEnabledOnCondition(condition, optionItem14);
        OptionGroup optionGroup3 = new OptionGroup();
        optionGroup3.setAttribute("OptionGroup.title", "OUTPUT_AR");
        optionGroup3.setAttribute(DefaultEditorFactory.ATTRIBUTE_CONTROLLER_ID, object);
        optionGroup3.setAttribute(DefaultEditorFactory.ATTRIBUTE_CARD_ID, "OUTPUT_AR");
        OptionItem optionItem15 = optionGroup3.addItem(optionHandler.addBool(ITEM_AR_CAGE_USE_VIEW, true));
        constraintManager.setEnabledOnValueEquals((OptionItem)enumOptionItem, (Object)"OUTPUT_AR", optionGroup3);
        condition = constraintManager.createConditionValueEquals(enumOptionItem, (Object)"OUTPUT_AR").and(constraintManager.createConditionValueEquals(optionItem15, (Object)Boolean.FALSE));
        constraintManager.setEnabledOnCondition(condition, optionGroup3.addItem(optionHandler.addDouble(ITEM_CAGE_RATIO, 1.0)));
        OptionGroup optionGroup4 = new OptionGroup();
        optionGroup4.setAttribute("OptionGroup.title", "OUTPUT_ELLIPTICAL_CAGE");
        optionGroup4.setAttribute(DefaultEditorFactory.ATTRIBUTE_CONTROLLER_ID, object);
        optionGroup4.setAttribute(DefaultEditorFactory.ATTRIBUTE_CARD_ID, "OUTPUT_ELLIPTICAL_CAGE");
        OptionItem optionItem16 = optionGroup4.addItem(optionHandler.addBool(ITEM_ELL_CAGE_USE_VIEW, true));
        OptionItem optionItem17 = optionGroup4.addItem(optionHandler.addDouble(ITEM_ELLIPTICAL_CAGE_X, 0.0));
        OptionItem optionItem18 = optionGroup4.addItem(optionHandler.addDouble(ITEM_ELLIPTICAL_CAGE_Y, 0.0));
        OptionItem optionItem19 = optionGroup4.addItem(optionHandler.addDouble(ITEM_ELLIPTICAL_CAGE_WIDTH, 1000.0));
        optionItem19.setAttribute(DoubleOptionItem.ATTRIBUTE_MIN_VALUE, new Double(Double.MIN_VALUE));
        OptionItem optionItem20 = optionGroup4.addItem(optionHandler.addDouble(ITEM_ELLIPTICAL_CAGE_HEIGHT, 1000.0));
        optionItem20.setAttribute(DoubleOptionItem.ATTRIBUTE_MIN_VALUE, new Double(Double.MIN_VALUE));
        constraintManager.setEnabledOnValueEquals((OptionItem)enumOptionItem, (Object)"OUTPUT_ELLIPTICAL_CAGE", optionGroup4);
        condition = constraintManager.createConditionValueEquals(enumOptionItem, (Object)"OUTPUT_ELLIPTICAL_CAGE").and(constraintManager.createConditionValueEquals(optionItem16, (Object)Boolean.FALSE));
        constraintManager.setEnabledOnCondition(condition, optionItem17);
        constraintManager.setEnabledOnCondition(condition, optionItem18);
        constraintManager.setEnabledOnCondition(condition, optionItem19);
        constraintManager.setEnabledOnCondition(condition, optionItem20);
        optionHandler.useSection(SECTION_GROUPING);
        optionHandler.addEnum(ITEM_GROUP_LAYOUT_POLICY, new String[]{VALUE_LAYOUT_GROUPS, VALUE_FIX_GROUP_CONTENTS, VALUE_FIX_GROUP_BOUNDS, VALUE_IGNORE_GROUPS}, 0);
        OptionItem optionItem21 = optionHandler.addBool(ITEM_USE_AUTOMATIC_GROUP_NODE_COMPACTION, smartOrganicLayouter.isAutomaticGroupNodeCompactionEnabled());
        OptionItem optionItem22 = optionHandler.addDouble(ITEM_GROUP_COMPACTNESS, smartOrganicLayouter.getGroupNodeCompactness(), 0.0, 1.0);
        constraintManager.setEnabledOnValueEquals(optionItem21, (Object)Boolean.FALSE, optionItem22);
        optionHandler.useSection(SECTION_ALGORITHM);
        OptionItem optionItem23 = optionHandler.addDouble(ITEM_QUALITY_TIME_RATIO, smartOrganicLayouter.getQualityTimeRatio(), 0.0, 1.0);
        optionItem23.setAttribute(DefaultEditorFactory.ATTRIBUTE_MIN_VALUE_LABEL_TEXT, "SPEED");
        optionItem23.setAttribute(DefaultEditorFactory.ATTRIBUTE_MAX_VALUE_LABEL_TEXT, "QUALITY");
        optionHandler.addInt(ITEM_MAXIMAL_DURATION, (int)(smartOrganicLayouter.getMaximumDuration() / 1000L)).setAttribute(IntOptionItem.ATTRIBUTE_MIN_VALUE, new Integer(0));
        optionHandler.addBool(ITEM_ACTIVATE_DETERMINISTIC_MODE, smartOrganicLayouter.isDeterministic());
        optionHandler.addBool(ITEM_ALLOW_MULTI_THREADING, true);
        if (Graph.z != 0) {
            YModule.z = !bl;
        }
        return optionHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void mainrun() {
        SmartOrganicLayouter smartOrganicLayouter = new SmartOrganicLayouter();
        OptionHandler optionHandler = this.getOptionHandler();
        this.configure(smartOrganicLayouter, optionHandler);
        Graph2D graph2D = this.getGraph2D();
        Graph2DLayoutExecutor graph2DLayoutExecutor = this.getLayoutExecutor();
        boolean bl = graph2DLayoutExecutor.isConfiguringGrouping();
        graph2DLayoutExecutor.setConfiguringGrouping(this.b(graph2D, optionHandler.getString(ITEM_GROUP_LAYOUT_POLICY)));
        this.prepareGraph(graph2D, optionHandler);
        try {
            this.launchLayouter(smartOrganicLayouter);
        }
        finally {
            this.restoreGraph(graph2D, optionHandler);
            graph2DLayoutExecutor.setConfiguringGrouping(bl);
        }
    }

    protected void prepareGraph(Graph2D graph2D, OptionHandler optionHandler) {
        block12: {
            Node node;
            NodeCursor nodeCursor;
            NodeMap nodeMap;
            boolean bl;
            String string;
            boolean bl2;
            block11: {
                Graph2D graph2D2;
                block9: {
                    bl2 = YModule.z;
                    this.uc = false;
                    string = optionHandler.getString(ITEM_GROUP_LAYOUT_POLICY);
                    bl = this.b(graph2D, string);
                    if (!VALUE_FIX_GROUP_BOUNDS.equals(string) || !bl) break block11;
                    nodeMap = Maps.createHashedNodeMap();
                    nodeCursor = graph2D.nodes();
                    while (nodeCursor.ok()) {
                        node = nodeCursor.node();
                        graph2D2 = graph2D;
                        if (!bl2) {
                            if (HierarchyManager.getInstance(graph2D2).isGroupNode(node)) {
                                nodeMap.set(node, SmartOrganicLayouter.GROUP_NODE_MODE_FIX_BOUNDS);
                            }
                            nodeCursor.next();
                            if (!bl2) continue;
                        }
                        break block9;
                    }
                    this.backupDataProvider(graph2D, SmartOrganicLayouter.GROUP_NODE_MODE_DATA);
                    graph2D2 = graph2D;
                }
                graph2D2.addDataProvider(SmartOrganicLayouter.GROUP_NODE_MODE_DATA, nodeMap);
                this.uc = true;
                if (!bl2) break block12;
            }
            if (VALUE_FIX_GROUP_CONTENTS.equals(string) && bl) {
                Graph2D graph2D3;
                block10: {
                    nodeMap = Maps.createHashedNodeMap();
                    nodeCursor = graph2D.nodes();
                    while (nodeCursor.ok()) {
                        node = nodeCursor.node();
                        graph2D3 = graph2D;
                        if (!bl2) {
                            if (HierarchyManager.getInstance(graph2D3).isGroupNode(node)) {
                                nodeMap.set(node, SmartOrganicLayouter.GROUP_NODE_MODE_FIX_CONTENTS);
                            }
                            nodeCursor.next();
                            if (!bl2) continue;
                        }
                        break block10;
                    }
                    this.backupDataProvider(graph2D, SmartOrganicLayouter.GROUP_NODE_MODE_DATA);
                    graph2D3 = graph2D;
                }
                graph2D3.addDataProvider(SmartOrganicLayouter.GROUP_NODE_MODE_DATA, nodeMap);
                this.uc = true;
            }
        }
        this.backupDataProvider(graph2D, SmartOrganicLayouter.NODE_SUBSET_DATA);
        graph2D.addDataProvider(SmartOrganicLayouter.NODE_SUBSET_DATA, Selections.createSelectionNodeMap(graph2D));
    }

    protected void restoreGraph(Graph2D graph2D, OptionHandler optionHandler) {
        this.restoreDataProvider(graph2D, SmartOrganicLayouter.NODE_SUBSET_DATA);
        if (this.uc) {
            this.uc = false;
            this.restoreDataProvider(graph2D, SmartOrganicLayouter.GROUP_NODE_MODE_DATA);
        }
    }

    protected void configure(SmartOrganicLayouter smartOrganicLayouter, OptionHandler optionHandler) {
        block14: {
            double d2;
            double d3;
            double d4;
            double d5;
            block25: {
                block24: {
                    Rectangle rectangle;
                    String string;
                    boolean bl;
                    block21: {
                        block23: {
                            block22: {
                                block18: {
                                    double d6;
                                    block20: {
                                        block19: {
                                            block15: {
                                                double d7;
                                                block17: {
                                                    block16: {
                                                        block13: {
                                                            block11: {
                                                                block12: {
                                                                    String string2;
                                                                    block10: {
                                                                        bl = YModule.z;
                                                                        smartOrganicLayouter.setPreferredEdgeLength(optionHandler.getInt(SECTION_VISUAL, ITEM_PREFERRED_EDGE_LENGTH));
                                                                        boolean bl2 = optionHandler.getBool(SECTION_VISUAL, ITEM_CONSIDER_NODE_LABELS);
                                                                        smartOrganicLayouter.setConsiderNodeLabelsEnabled(bl2);
                                                                        smartOrganicLayouter.setNodeOverlapsAllowed(optionHandler.getBool(SECTION_VISUAL, ITEM_ALLOW_NODE_OVERLAPS) && !bl2);
                                                                        smartOrganicLayouter.setMinimalNodeDistance(optionHandler.getDouble(SECTION_VISUAL, ITEM_MINIMAL_NODE_DISTANCE));
                                                                        string2 = optionHandler.getString(SECTION_VISUAL, ITEM_SCOPE);
                                                                        if (!VALUE_SCOPE_SUBSET.equals(string2)) break block10;
                                                                        smartOrganicLayouter.setScope((byte)2);
                                                                        if (!bl) break block11;
                                                                    }
                                                                    if (!VALUE_SCOPE_MAINLY_SUBSET.equals(string2)) break block12;
                                                                    smartOrganicLayouter.setScope((byte)1);
                                                                    if (!bl) break block11;
                                                                }
                                                                smartOrganicLayouter.setScope((byte)0);
                                                            }
                                                            smartOrganicLayouter.setCompactness(optionHandler.getDouble(SECTION_VISUAL, ITEM_COMPACTNESS));
                                                            smartOrganicLayouter.setAutomaticGroupNodeCompactionEnabled(optionHandler.getBool(ITEM_USE_AUTOMATIC_GROUP_NODE_COMPACTION));
                                                            smartOrganicLayouter.setGroupNodeCompactness(optionHandler.getDouble(ITEM_GROUP_COMPACTNESS));
                                                            smartOrganicLayouter.setNodeSizeAware(true);
                                                            smartOrganicLayouter.setAutoClusteringEnabled(optionHandler.getBool(ITEM_USE_AUTO_CLUSTERING));
                                                            smartOrganicLayouter.setAutoClusteringQuality(optionHandler.getDouble(ITEM_AUTO_CLUSTERING_QUALITY));
                                                            smartOrganicLayouter.setNodeEdgeOverlapAvoided(optionHandler.getBool(ITEM_AVOID_NODE_EDGE_OVERLAPS));
                                                            smartOrganicLayouter.setDeterministic(optionHandler.getBool(SECTION_ALGORITHM, ITEM_ACTIVATE_DETERMINISTIC_MODE));
                                                            smartOrganicLayouter.setMultiThreadingAllowed(optionHandler.getBool(SECTION_ALGORITHM, ITEM_ALLOW_MULTI_THREADING));
                                                            smartOrganicLayouter.setMaximumDuration(1000L * (long)optionHandler.getInt(SECTION_ALGORITHM, ITEM_MAXIMAL_DURATION));
                                                            smartOrganicLayouter.setQualityTimeRatio(optionHandler.getDouble(SECTION_ALGORITHM, ITEM_QUALITY_TIME_RATIO));
                                                            ((ComponentLayouter)smartOrganicLayouter.getComponentLayouter()).setStyle((byte)8);
                                                            string = optionHandler.getString(ITEM_RESTRICT_OUTPUT);
                                                            if (!VALUE_NONE.equals(string)) break block13;
                                                            smartOrganicLayouter.setComponentLayouterEnabled(true);
                                                            smartOrganicLayouter.setOutputRestriction(OutputRestriction.NONE);
                                                            if (!bl) break block14;
                                                        }
                                                        if (!"OUTPUT_CAGE".equals(string)) break block15;
                                                        if (!optionHandler.getBool(ITEM_RECT_CAGE_USE_VIEW) || this.getGraph2DView() == null) break block16;
                                                        rectangle = this.getGraph2DView().getVisibleRect();
                                                        d5 = rectangle.x;
                                                        d6 = rectangle.y;
                                                        d4 = rectangle.width;
                                                        d7 = rectangle.height;
                                                        if (!bl) break block17;
                                                    }
                                                    d5 = optionHandler.getDouble(ITEM_CAGE_X);
                                                    d6 = optionHandler.getDouble(ITEM_CAGE_Y);
                                                    d4 = optionHandler.getDouble(ITEM_CAGE_WIDTH);
                                                    d7 = optionHandler.getDouble(ITEM_CAGE_HEIGHT);
                                                }
                                                smartOrganicLayouter.setOutputRestriction(OutputRestriction.createRectangularCageRestriction(d5, d6, d4, d7));
                                                smartOrganicLayouter.setComponentLayouterEnabled(false);
                                                if (!bl) break block14;
                                            }
                                            if (!"OUTPUT_CIRCULAR_CAGE".equals(string)) break block18;
                                            if (!optionHandler.getBool(ITEM_CIRC_CAGE_USE_VIEW) || this.getGraph2DView() == null) break block19;
                                            Rectangle rectangle2 = this.getGraph2DView().getVisibleRect();
                                            d5 = rectangle2.getCenterX();
                                            d6 = rectangle2.getCenterY();
                                            d4 = (double)Math.min(rectangle2.width, rectangle2.height) * 0.5;
                                            if (!bl) break block20;
                                        }
                                        d5 = optionHandler.getDouble(ITEM_CAGE_CENTER_X);
                                        d6 = optionHandler.getDouble(ITEM_CAGE_CENTER_Y);
                                        d4 = optionHandler.getDouble(ITEM_CAGE_RADIUS);
                                    }
                                    smartOrganicLayouter.setOutputRestriction(OutputRestriction.createCircularCageRestriction(d5, d6, d4));
                                    smartOrganicLayouter.setComponentLayouterEnabled(false);
                                    if (!bl) break block14;
                                }
                                if (!"OUTPUT_AR".equals(string)) break block21;
                                if (!optionHandler.getBool(ITEM_AR_CAGE_USE_VIEW) || this.getGraph2DView() == null) break block22;
                                Rectangle rectangle3 = this.getGraph2DView().getVisibleRect();
                                d5 = rectangle3.getWidth() / rectangle3.getHeight();
                                if (!bl) break block23;
                            }
                            d5 = optionHandler.getDouble(ITEM_CAGE_RATIO);
                        }
                        smartOrganicLayouter.setOutputRestriction(OutputRestriction.createAspectRatioRestriction(d5));
                        smartOrganicLayouter.setComponentLayouterEnabled(true);
                        ((ComponentLayouter)smartOrganicLayouter.getComponentLayouter()).setPreferredLayoutSize(d5 * 100.0, 100.0);
                        if (!bl) break block14;
                    }
                    if (!"OUTPUT_ELLIPTICAL_CAGE".equals(string)) break block14;
                    if (!optionHandler.getBool(ITEM_ELL_CAGE_USE_VIEW) || this.getGraph2DView() == null) break block24;
                    rectangle = this.getGraph2DView().getVisibleRect();
                    d5 = rectangle.x;
                    d3 = rectangle.y;
                    d4 = rectangle.width;
                    d2 = rectangle.height;
                    if (!bl) break block25;
                }
                d5 = optionHandler.getDouble(ITEM_ELLIPTICAL_CAGE_X);
                d3 = optionHandler.getDouble(ITEM_ELLIPTICAL_CAGE_Y);
                d4 = optionHandler.getDouble(ITEM_ELLIPTICAL_CAGE_WIDTH);
                d2 = optionHandler.getDouble(ITEM_ELLIPTICAL_CAGE_HEIGHT);
            }
            smartOrganicLayouter.setOutputRestriction(OutputRestriction.createEllipticalCageRestriction(d5, d3, d4, d2));
            smartOrganicLayouter.setComponentLayouterEnabled(false);
        }
    }

    private boolean b(Graph2D graph2D, String string) {
        return !VALUE_IGNORE_GROUPS.equals(string) && HierarchyManager.containsGroupNodes(graph2D);
    }
}

