/*
 * Decompiled with CFR 0.152.
 */
package y.module;

import y.layout.radial.RadialLayouter;
import y.module.LayoutModule;
import y.module.YModule;
import y.option.ConstraintManager;
import y.option.EnumOptionItem;
import y.option.OptionHandler;
import y.option.OptionItem;

public class RadialLayoutModule
extends LayoutModule {
    private static final int rc = 10;
    private static final int tc = 1;
    private static final int sc = 4;
    protected static final String MODULE_RADIAL = "RADIAL";
    protected static final String SECTION_GENERAL = "GENERAL";
    protected static final String ITEM_CENTER_STRATEGY = "CENTER_STRATEGY";
    protected static final String VALUE_CENTER_DIRECTED = "CENTER_DIRECTED";
    protected static final String VALUE_CENTER_CENTRAL = "CENTER_CENTRAL";
    protected static final String VALUE_CENTER_WEIGHTED_CENTRAL = "CENTER_WEIGHTED_CENTRAL";
    protected static final String VALUE_CENTER_SELECTED = "CENTER_SELECTED";
    protected static final String ITEM_LAYERING_STRATEGY = "LAYERING_STRATEGY";
    protected static final String VALUE_LAYERING_BFS = "LAYERING_BFS";
    protected static final String VALUE_LAYERING_HIERARCHICAL = "LAYERING_HIERARCHICAL";
    protected static final String ITEM_MINIMAL_LAYER_DISTANCE = "MINIMAL_LAYER_DISTANCE";
    protected static final String ITEM_MINIMAL_NODE_DISTANCE = "MINIMAL_NODE_DISTANCE";
    protected static final String ITEM_MAXIMAL_CHILD_SECTOR_SIZE = "MAXIMAL_CHILD_SECTOR_SIZE";
    protected static final String ITEM_EDGE_ROUTING_STRATEGY = "EDGE_ROUTING_STRATEGY";
    protected static final String VALUE_EDGE_POLYLINE = "EDGE_POLYLINE";
    protected static final String VALUE_EDGE_ARC = "EDGE_ARC";
    protected static final String ITEM_EDGE_SMOOTHNESS = "EDGE_SMOOTHNESS";
    protected static final String ITEM_CONSIDER_NODE_LABELS = "CONSIDER_NODE_LABELS";

    public RadialLayoutModule() {
        super(MODULE_RADIAL);
    }

    protected OptionHandler createOptionHandler() {
        OptionHandler optionHandler = new OptionHandler(this.getModuleName());
        ConstraintManager constraintManager = new ConstraintManager(optionHandler);
        RadialLayouter radialLayouter = new RadialLayouter();
        optionHandler.useSection(SECTION_GENERAL);
        optionHandler.addEnum(ITEM_CENTER_STRATEGY, new String[]{VALUE_CENTER_DIRECTED, VALUE_CENTER_CENTRAL, VALUE_CENTER_WEIGHTED_CENTRAL, VALUE_CENTER_SELECTED}, radialLayouter.getCenterNodesPolicy());
        optionHandler.addEnum(ITEM_LAYERING_STRATEGY, new String[]{VALUE_LAYERING_BFS, VALUE_LAYERING_HIERARCHICAL}, radialLayouter.getLayeringStrategy() == 4 ? 0 : 1);
        optionHandler.addInt(ITEM_MINIMAL_LAYER_DISTANCE, (int)radialLayouter.getMinimalLayerDistance(), 1, 1000);
        optionHandler.addInt(ITEM_MINIMAL_NODE_DISTANCE, (int)radialLayouter.getMinimalNodeToNodeDistance(), 0, 300);
        optionHandler.addInt(ITEM_MAXIMAL_CHILD_SECTOR_SIZE, (int)radialLayouter.getMaximalChildSectorAngle(), 15, 360);
        EnumOptionItem enumOptionItem = optionHandler.addEnum(ITEM_EDGE_ROUTING_STRATEGY, new String[]{VALUE_EDGE_POLYLINE, VALUE_EDGE_ARC}, radialLayouter.getEdgeRoutingStrategy() == 1 ? 0 : 1);
        int n2 = (int)Math.min(10.0, (41.0 - radialLayouter.getMinimalBendAngle()) / 4.0);
        OptionItem optionItem = optionHandler.addInt(ITEM_EDGE_SMOOTHNESS, n2, 1, 10);
        optionHandler.addBool(ITEM_CONSIDER_NODE_LABELS, radialLayouter.isConsiderNodeLabelsEnabled());
        constraintManager.setEnabledOnCondition(constraintManager.createConditionValueEquals(enumOptionItem, (Object)VALUE_EDGE_ARC), optionItem);
        return optionHandler;
    }

    protected void mainrun() {
        RadialLayouter radialLayouter = new RadialLayouter();
        OptionHandler optionHandler = this.getOptionHandler();
        this.configure(radialLayouter, optionHandler);
        this.launchLayouter(radialLayouter);
    }

    protected void configure(RadialLayouter radialLayouter, OptionHandler optionHandler) {
        block17: {
            block16: {
                boolean bl;
                block13: {
                    block15: {
                        block14: {
                            block12: {
                                block11: {
                                    block10: {
                                        bl = YModule.z;
                                        radialLayouter.setMinimalNodeToNodeDistance(optionHandler.getInt(ITEM_MINIMAL_NODE_DISTANCE));
                                        if (!optionHandler.getString(ITEM_EDGE_ROUTING_STRATEGY).equals(VALUE_EDGE_POLYLINE)) break block10;
                                        radialLayouter.setEdgeRoutingStrategy((byte)1);
                                        if (!bl) break block11;
                                    }
                                    if (optionHandler.getString(ITEM_EDGE_ROUTING_STRATEGY).equals(VALUE_EDGE_ARC)) {
                                        radialLayouter.setEdgeRoutingStrategy((byte)5);
                                    }
                                }
                                double d2 = 1 + (10 - optionHandler.getInt(ITEM_EDGE_SMOOTHNESS)) * 4;
                                radialLayouter.setMinimalBendAngle(d2);
                                radialLayouter.setMinimalLayerDistance(optionHandler.getInt(ITEM_MINIMAL_LAYER_DISTANCE));
                                radialLayouter.setMaximalChildSectorAngle(optionHandler.getInt(ITEM_MAXIMAL_CHILD_SECTOR_SIZE));
                                if (!optionHandler.getString(ITEM_CENTER_STRATEGY).equals(VALUE_CENTER_CENTRAL)) break block12;
                                radialLayouter.setCenterNodesPolicy((byte)1);
                                if (!bl) break block13;
                            }
                            if (!optionHandler.getString(ITEM_CENTER_STRATEGY).equals(VALUE_CENTER_WEIGHTED_CENTRAL)) break block14;
                            radialLayouter.setCenterNodesPolicy((byte)2);
                            if (!bl) break block13;
                        }
                        if (!optionHandler.getString(ITEM_CENTER_STRATEGY).equals(VALUE_CENTER_SELECTED)) break block15;
                        radialLayouter.setCenterNodesPolicy((byte)3);
                        if (!bl) break block13;
                    }
                    radialLayouter.setCenterNodesPolicy((byte)0);
                }
                if (!optionHandler.getString(ITEM_LAYERING_STRATEGY).equals(VALUE_LAYERING_HIERARCHICAL)) break block16;
                radialLayouter.setLayeringStrategy((byte)1);
                if (!bl) break block17;
            }
            radialLayouter.setLayeringStrategy((byte)4);
        }
        radialLayouter.setConsiderNodeLabelsEnabled(optionHandler.getBool(ITEM_CONSIDER_NODE_LABELS));
    }
}

