/*
 * Decompiled with CFR 0.152.
 */
package y.module;

import y.base.Edge;
import y.base.Node;
import y.layout.Layouter;
import y.layout.router.polyline.EdgeLayoutDescriptor;
import y.layout.router.polyline.EdgeRouter;
import y.layout.router.polyline.Grid;
import y.layout.router.polyline.PenaltySettings;
import y.module.LayoutModule;
import y.module.YModule;
import y.option.ConstraintManager;
import y.option.OptionGroup;
import y.option.OptionHandler;
import y.option.OptionItem;
import y.util.DataProviderAdapter;
import y.view.Graph2D;

public class PolylineEdgeRouterModule
extends LayoutModule {
    private static final String nc = "POLYLINE_EDGE_ROUTER";
    protected static final String SECTION_LAYOUT = "LAYOUT";
    protected static final String ITEM_SCOPE = "SCOPE";
    protected static final String VALUE_SCOPE_ALL_EDGES = "SCOPE_ALL_EDGES";
    protected static final String VALUE_SCOPE_SELECTED_EDGES = "SCOPE_SELECTED_EDGES";
    protected static final String VALUE_SCOPE_EDGES_AT_SELECTED_NODES = "SCOPE_EDGES_AT_SELECTED_NODES";
    protected static final String ITEM_OPTIMIZATION_STRATEGY = "OPTIMIZATION_STRATEGY";
    protected static final String VALUE_STRATEGY_BALANCED = "STRATEGY_BALANCED";
    protected static final String VALUE_STRATEGY_MINIMIZE_BENDS = "STRATEGY_MINIMIZE_BENDS";
    protected static final String VALUE_STRATEGY_MINIMIZE_CROSSINGS = "STRATEGY_MINIMIZE_CROSSINGS";
    protected static final String ITEM_MONOTONIC_RESTRICTION = "MONOTONIC_RESTRICTION";
    protected static final String VALUE_MONOTONIC_NONE = "MONOTONIC_NONE";
    protected static final String VALUE_MONOTONIC_HORIZONTAL = "MONOTONIC_HORIZONTAL";
    protected static final String VALUE_MONOTONIC_VERTICAL = "MONOTONIC_VERTICAL";
    protected static final String VALUE_MONOTONIC_BOTH = "MONOTONIC_BOTH";
    protected static final String TITLE_MINIMAL_DISTANCES = "MINIMAL_DISTANCES";
    protected static final String ITEM_MINIMAL_EDGE_TO_EDGE_DISTANCE = "MINIMAL_EDGE_TO_EDGE_DISTANCE";
    protected static final String ITEM_MINIMAL_NODE_TO_EDGE_DISTANCE = "MINIMAL_NODE_TO_EDGE_DISTANCE";
    protected static final String ITEM_MINIMAL_NODE_CORNER_DISTANCE = "MINIMAL_NODE_CORNER_DISTANCE";
    protected static final String ITEM_MINIMAL_FIRST_SEGMENT_LENGTH = "MINIMAL_FIRST_SEGMENT_LENGTH";
    protected static final String ITEM_MINIMAL_LAST_SEGMENT_LENGTH = "MINIMAL_LAST_SEGMENT_LENGTH";
    protected static final String TITLE_GRID_SETTINGS = "GRID_SETTINGS";
    protected static final String ITEM_GRID_ENABLED = "GRID_ENABLED";
    protected static final String ITEM_GRID_SPACING = "GRID_SPACING";
    protected static final String ITEM_CONSIDER_NODE_LABELS = "CONSIDER_NODE_LABELS";
    protected static final String ITEM_CONSIDER_EDGE_LABELS = "CONSIDER_EDGE_LABELS";
    protected static final String ITEM_ENABLE_REROUTING = "ENABLE_REROUTING";
    protected static final String ITEM_MAXIMAL_DURATION = "MAXIMAL_DURATION";
    protected static final String SECTION_POLYLINE_ROUTING = "POLYLINE_ROUTING";
    protected static final String ITEM_ENABLE_POLYLINE_ROUTING = "ENABLE_POLYLINE_ROUTING";
    protected static final String ITEM_PREFERRED_POLYLINE_SEGMENT_LENGTH = "PREFERRED_POLYLINE_SEGMENT_LENGTH";
    private boolean oc;
    private boolean mc;

    public PolylineEdgeRouterModule() {
        super(nc);
        this.setPortIntersectionCalculatorEnabled(true);
    }

    protected OptionHandler createOptionHandler() {
        OptionHandler optionHandler = new OptionHandler(this.getModuleName());
        ConstraintManager constraintManager = new ConstraintManager(optionHandler);
        EdgeRouter edgeRouter = new EdgeRouter();
        EdgeLayoutDescriptor edgeLayoutDescriptor = edgeRouter.getDefaultEdgeLayoutDescriptor();
        Grid grid = edgeRouter.getGrid();
        optionHandler.useSection(SECTION_LAYOUT);
        byte by = edgeRouter.getSphereOfAction();
        optionHandler.addEnum(ITEM_SCOPE, new String[]{VALUE_SCOPE_ALL_EDGES, VALUE_SCOPE_SELECTED_EDGES, VALUE_SCOPE_EDGES_AT_SELECTED_NODES}, by == 0 ? 0 : 1);
        optionHandler.addEnum(ITEM_OPTIMIZATION_STRATEGY, new String[]{VALUE_STRATEGY_BALANCED, VALUE_STRATEGY_MINIMIZE_BENDS, VALUE_STRATEGY_MINIMIZE_CROSSINGS}, 0);
        optionHandler.addEnum(ITEM_MONOTONIC_RESTRICTION, new String[]{VALUE_MONOTONIC_NONE, VALUE_MONOTONIC_HORIZONTAL, VALUE_MONOTONIC_VERTICAL, VALUE_MONOTONIC_BOTH}, edgeLayoutDescriptor.getMonotonicPathRestriction());
        OptionGroup optionGroup = new OptionGroup();
        optionGroup.setAttribute("OptionGroup.title", TITLE_MINIMAL_DISTANCES);
        optionGroup.addItem(optionHandler.addDouble(ITEM_MINIMAL_EDGE_TO_EDGE_DISTANCE, edgeLayoutDescriptor.getMinimalEdgeToEdgeDistance()));
        optionGroup.addItem(optionHandler.addDouble(ITEM_MINIMAL_NODE_TO_EDGE_DISTANCE, edgeRouter.getMinimalNodeToEdgeDistance()));
        optionGroup.addItem(optionHandler.addDouble(ITEM_MINIMAL_NODE_CORNER_DISTANCE, edgeLayoutDescriptor.getMinimalNodeCornerDistance()));
        optionGroup.addItem(optionHandler.addDouble(ITEM_MINIMAL_FIRST_SEGMENT_LENGTH, edgeLayoutDescriptor.getMinimalFirstSegmentLength()));
        optionGroup.addItem(optionHandler.addDouble(ITEM_MINIMAL_LAST_SEGMENT_LENGTH, edgeLayoutDescriptor.getMinimalLastSegmentLength()));
        OptionGroup optionGroup2 = new OptionGroup();
        optionGroup2.setAttribute("OptionGroup.title", TITLE_GRID_SETTINGS);
        OptionItem optionItem = optionGroup2.addItem(optionHandler.addBool(ITEM_GRID_ENABLED, grid != null));
        OptionItem optionItem2 = optionGroup2.addItem(optionHandler.addDouble(ITEM_GRID_SPACING, grid != null ? grid.getSpacing() : 10.0));
        constraintManager.setEnabledOnValueEquals(optionItem, (Object)Boolean.TRUE, optionItem2);
        optionHandler.addBool(ITEM_CONSIDER_NODE_LABELS, edgeRouter.isConsiderNodeLabelsEnabled());
        optionHandler.addBool(ITEM_CONSIDER_EDGE_LABELS, edgeRouter.isConsiderEdgeLabelsEnabled());
        optionHandler.addBool(ITEM_ENABLE_REROUTING, edgeRouter.isReroutingEnabled());
        optionHandler.addInt(ITEM_MAXIMAL_DURATION, 0);
        optionHandler.useSection(SECTION_POLYLINE_ROUTING);
        OptionItem optionItem3 = optionHandler.addBool(ITEM_ENABLE_POLYLINE_ROUTING, true);
        OptionItem optionItem4 = optionHandler.addDouble(ITEM_PREFERRED_POLYLINE_SEGMENT_LENGTH, edgeRouter.getPreferredPolylineSegmentLength());
        constraintManager.setEnabledOnValueEquals(optionItem3, (Object)Boolean.TRUE, optionItem4);
        return optionHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void mainrun() {
        EdgeRouter edgeRouter = new EdgeRouter();
        OptionHandler optionHandler = this.getOptionHandler();
        this.configure(edgeRouter, optionHandler);
        Graph2D graph2D = this.getGraph2D();
        this.prepareGraph(graph2D, optionHandler);
        try {
            this.launchLayouter(edgeRouter);
        }
        finally {
            this.restoreGraph(graph2D, optionHandler);
        }
    }

    protected void prepareGraph(final Graph2D graph2D, OptionHandler optionHandler) {
        block6: {
            block5: {
                if (!VALUE_SCOPE_SELECTED_EDGES.equals(optionHandler.getString(ITEM_SCOPE))) break block5;
                boolean bl = this.oc = graph2D.getDataProvider(Layouter.SELECTED_EDGES) == null;
                if (!this.oc) break block6;
                graph2D.addDataProvider(Layouter.SELECTED_EDGES, new DataProviderAdapter(){

                    public boolean getBool(Object object) {
                        return graph2D.isSelected((Edge)object);
                    }
                });
                if (!YModule.z) break block6;
            }
            if (VALUE_SCOPE_EDGES_AT_SELECTED_NODES.equals(optionHandler.getString(ITEM_SCOPE))) {
                boolean bl = this.mc = graph2D.getDataProvider(Layouter.SELECTED_NODES) == null;
                if (this.mc) {
                    graph2D.addDataProvider(Layouter.SELECTED_NODES, new DataProviderAdapter(){

                        public boolean getBool(Object object) {
                            return graph2D.isSelected((Node)object);
                        }
                    });
                }
            }
        }
    }

    protected void restoreGraph(Graph2D graph2D, OptionHandler optionHandler) {
        block5: {
            block4: {
                if (!VALUE_SCOPE_SELECTED_EDGES.equals(optionHandler.getString(ITEM_SCOPE))) break block4;
                if (!this.oc) break block5;
                this.oc = false;
                graph2D.removeDataProvider(Layouter.SELECTED_EDGES);
                if (!YModule.z) break block5;
            }
            if (VALUE_SCOPE_EDGES_AT_SELECTED_NODES.equals(optionHandler.getString(ITEM_SCOPE)) && this.mc) {
                this.mc = false;
                graph2D.removeDataProvider(Layouter.SELECTED_NODES);
            }
        }
    }

    protected void configure(EdgeRouter edgeRouter, OptionHandler optionHandler) {
        block23: {
            int n2;
            block22: {
                boolean bl;
                block21: {
                    block20: {
                        EdgeLayoutDescriptor edgeLayoutDescriptor;
                        block17: {
                            block19: {
                                String string;
                                block18: {
                                    block16: {
                                        block14: {
                                            PenaltySettings penaltySettings;
                                            block15: {
                                                String string2;
                                                block13: {
                                                    block11: {
                                                        block12: {
                                                            String string3;
                                                            block10: {
                                                                bl = YModule.z;
                                                                string3 = optionHandler.getString(ITEM_SCOPE);
                                                                if (!VALUE_SCOPE_EDGES_AT_SELECTED_NODES.equals(string3)) break block10;
                                                                edgeRouter.setSphereOfAction((byte)4);
                                                                if (!bl) break block11;
                                                            }
                                                            if (!VALUE_SCOPE_ALL_EDGES.equals(string3)) break block12;
                                                            edgeRouter.setSphereOfAction((byte)0);
                                                            if (!bl) break block11;
                                                        }
                                                        edgeRouter.setSphereOfAction((byte)2);
                                                    }
                                                    edgeLayoutDescriptor = edgeRouter.getDefaultEdgeLayoutDescriptor();
                                                    string2 = optionHandler.getString(ITEM_OPTIMIZATION_STRATEGY);
                                                    penaltySettings = edgeLayoutDescriptor.getPenaltySettings();
                                                    if (!string2.equals(VALUE_STRATEGY_BALANCED)) break block13;
                                                    penaltySettings.setBendPenalty(3.0);
                                                    penaltySettings.setEdgeCrossingPenalty(1.0);
                                                    if (!bl) break block14;
                                                }
                                                if (!string2.equals(VALUE_STRATEGY_MINIMIZE_BENDS)) break block15;
                                                penaltySettings.setBendPenalty(3.0);
                                                penaltySettings.setEdgeCrossingPenalty(0.0);
                                                if (!bl) break block14;
                                            }
                                            penaltySettings.setBendPenalty(3.0);
                                            penaltySettings.setEdgeCrossingPenalty(5.0);
                                        }
                                        if (!(string = optionHandler.getString(ITEM_MONOTONIC_RESTRICTION)).equals(VALUE_MONOTONIC_BOTH)) break block16;
                                        edgeLayoutDescriptor.setMonotonicPathRestriction((byte)3);
                                        if (!bl) break block17;
                                    }
                                    if (!string.equals(VALUE_MONOTONIC_HORIZONTAL)) break block18;
                                    edgeLayoutDescriptor.setMonotonicPathRestriction((byte)2);
                                    if (!bl) break block17;
                                }
                                if (!string.equals(VALUE_MONOTONIC_VERTICAL)) break block19;
                                edgeLayoutDescriptor.setMonotonicPathRestriction((byte)1);
                                if (!bl) break block17;
                            }
                            edgeLayoutDescriptor.setMonotonicPathRestriction((byte)0);
                        }
                        edgeLayoutDescriptor.setMinimalEdgeToEdgeDistance(optionHandler.getDouble(ITEM_MINIMAL_EDGE_TO_EDGE_DISTANCE));
                        edgeRouter.setMinimalNodeToEdgeDistance(optionHandler.getDouble(ITEM_MINIMAL_NODE_TO_EDGE_DISTANCE));
                        edgeLayoutDescriptor.setMinimalNodeCornerDistance(optionHandler.getDouble(ITEM_MINIMAL_NODE_CORNER_DISTANCE));
                        edgeLayoutDescriptor.setMinimalFirstSegmentLength(optionHandler.getDouble(ITEM_MINIMAL_FIRST_SEGMENT_LENGTH));
                        edgeLayoutDescriptor.setMinimalLastSegmentLength(optionHandler.getDouble(ITEM_MINIMAL_LAST_SEGMENT_LENGTH));
                        if (!optionHandler.getBool(ITEM_GRID_ENABLED)) break block20;
                        double d2 = optionHandler.getDouble(ITEM_GRID_SPACING);
                        edgeRouter.setGrid(new Grid(0.0, 0.0, d2));
                        if (!bl) break block21;
                    }
                    edgeRouter.setGrid(null);
                }
                edgeRouter.setConsiderNodeLabelsEnabled(optionHandler.getBool(ITEM_CONSIDER_NODE_LABELS));
                edgeRouter.setConsiderEdgeLabelsEnabled(optionHandler.getBool(ITEM_CONSIDER_EDGE_LABELS));
                edgeRouter.setReroutingEnabled(optionHandler.getBool(ITEM_ENABLE_REROUTING));
                edgeRouter.setPolylineRoutingEnabled(optionHandler.getBool(ITEM_ENABLE_POLYLINE_ROUTING));
                edgeRouter.setPreferredPolylineSegmentLength(optionHandler.getDouble(ITEM_PREFERRED_POLYLINE_SEGMENT_LENGTH));
                n2 = optionHandler.getInt(ITEM_MAXIMAL_DURATION);
                if (n2 != 0) break block22;
                edgeRouter.setMaximumDuration(Long.MAX_VALUE);
                if (!bl) break block23;
            }
            edgeRouter.setMaximumDuration(n2 * 1000);
        }
    }
}

