/*
 * Decompiled with CFR 0.152.
 */
package y.module;

import y.base.Edge;
import y.layout.Layouter;
import y.layout.circular.CircularLayouter;
import y.layout.hierarchic.IncrementalHierarchicLayouter;
import y.layout.organic.SmartOrganicLayouter;
import y.layout.orthogonal.OrthogonalLayouter;
import y.layout.partial.PartialLayouter;
import y.module.LayoutModule;
import y.module.YModule;
import y.option.OptionHandler;
import y.util.DataProviderAdapter;
import y.view.Arrow;
import y.view.EdgeRealizer;
import y.view.Graph2D;
import y.view.Graph2DLayoutExecutor;
import y.view.Selections;
import y.view.tabular.TableLayoutConfigurator;

public class PartialLayoutModule
extends LayoutModule {
    protected static final String MODULE_PARTIAL = "PARTIAL";
    protected static final String SECTION_GENERAL = "GENERAL";
    protected static final String ITEM_ROUTING_TO_SUBGRAPH = "ROUTING_TO_SUBGRAPH";
    protected static final String VALUE_ROUTING_TO_SUBGRAPH_AUTO = "ROUTING_TO_SUBGRAPH_AUTO";
    protected static final String VALUE_ROUTING_TO_SUBGRAPH_STRAIGHT_LINE = "ROUTING_TO_SUBGRAPH_STRAIGHT_LINE";
    protected static final String VALUE_ROUTING_TO_SUBGRAPH_POLYLINE = "ROUTING_TO_SUBGRAPH_POLYLINE";
    protected static final String VALUE_ROUTING_TO_SUBGRAPH_ORTHOGONALLY = "ROUTING_TO_SUBGRAPH_ORTHOGONALLY";
    protected static final String VALUE_ROUTING_TO_SUBGRAPH_ORGANIC = "ROUTING_TO_SUBGRAPH_ORGANIC";
    protected static final String ITEM_MODE_COMPONENT_ASSIGNMENT = "MODE_COMPONENT_ASSIGNMENT";
    protected static final String VALUE_MODE_COMPONENT_CONNECTED = "MODE_COMPONENT_CONNECTED";
    protected static final String VALUE_MODE_COMPONENT_SINGLE = "MODE_COMPONENT_SINGLE";
    protected static final String VALUE_MODE_COMPONENT_CLUSTERING = "MODE_COMPONENT_CLUSTERING";
    protected static final String VALUE_MODE_COMPONENT_CUSTOMIZED = "MODE_COMPONENT_CUSTOMIZED";
    protected static final String ITEM_SUBGRAPH_LAYOUTER = "SUBGRAPH_LAYOUTER";
    protected static final String VALUE_SUBGRAPH_LAYOUTER_IHL = "SUBGRAPH_LAYOUTER_IHL";
    protected static final String VALUE_SUBGRAPH_LAYOUTER_ORGANIC = "SUBGRAPH_LAYOUTER_ORGANIC";
    protected static final String VALUE_SUBGRAPH_LAYOUTER_CIRCULAR = "SUBGRAPH_LAYOUTER_CIRCULAR";
    protected static final String VALUE_SUBGRAPH_LAYOUTER_ORTHOGONAL = "SUBGRAPH_LAYOUTER_ORTHOGONAL";
    protected static final String VALUE_SUBGRAPH_LAYOUTER_NO_LAYOUT = "SUBGRAPH_LAYOUTER_NO_LAYOUT";
    protected static final String ITEM_SUBGRAPH_POSITION_STRATEGY = "SUBGRAPH_POSITION_STRATEGY";
    protected static final String VALUE_SUBGRAPH_POSITIONING_STRATEGY_BARYCENTER = "SUBGRAPH_POSITION_STRATEGY_BARYCENTER";
    protected static final String VALUE_SUBGRAPH_POSITIONING_STRATEGY_FROM_SKETCH = "SUBGRAPH_POSITION_STRATEGY_FROM_SKETCH";
    protected static final String ITEM_MIN_NODE_DIST = "MIN_NODE_DIST";
    protected static final String ITEM_ORIENTATION_MAIN_GRAPH = "ORIENTATION_MAIN_GRAPH";
    protected static final String VALUE_ORIENTATION_MAIN_GRAPH_AUTO_DETECT = "ORIENTATION_MAIN_GRAPH_AUTO_DETECT";
    protected static final String VALUE_ORIENTATION_MAIN_GRAPH_TOP_TO_DOWN = "ORIENTATION_MAIN_GRAPH_TOP_TO_DOWN";
    protected static final String VALUE_ORIENTATION_MAIN_GRAPH_DOWN_TO_TOP = "ORIENTATION_MAIN_GRAPH_DOWN_TO_TOP";
    protected static final String VALUE_ORIENTATION_MAIN_GRAPH_LEFT_TO_RIGHT = "ORIENTATION_MAIN_GRAPH_LEFT_TO_RIGHT";
    protected static final String VALUE_ORIENTATION_MAIN_GRAPH_RIGHT_TO_LEFT = "ORIENTATION_MAIN_GRAPH_RIGHT_TO_LEFT";
    protected static final String VALUE_ORIENTATION_MAIN_GRAPH_NONE = "ORIENTATION_MAIN_GRAPH_NONE";
    protected static final String ITEM_CONSIDER_SNAPLINES = "CONSIDER_SNAPLINES";
    protected static final String ITEM_CONSIDER_EDGE_DIRECTION = "CONSIDER_EDGE_DIRECTION";

    public PartialLayoutModule() {
        super(MODULE_PARTIAL);
    }

    protected OptionHandler createOptionHandler() {
        OptionHandler optionHandler = new OptionHandler(this.getModuleName());
        optionHandler.useSection(SECTION_GENERAL);
        optionHandler.addEnum(ITEM_ROUTING_TO_SUBGRAPH, new String[]{VALUE_ROUTING_TO_SUBGRAPH_AUTO, VALUE_ROUTING_TO_SUBGRAPH_STRAIGHT_LINE, VALUE_ROUTING_TO_SUBGRAPH_POLYLINE, VALUE_ROUTING_TO_SUBGRAPH_ORTHOGONALLY, VALUE_ROUTING_TO_SUBGRAPH_ORGANIC}, 0);
        optionHandler.addEnum(ITEM_MODE_COMPONENT_ASSIGNMENT, new String[]{VALUE_MODE_COMPONENT_CONNECTED, VALUE_MODE_COMPONENT_SINGLE, VALUE_MODE_COMPONENT_CLUSTERING, VALUE_MODE_COMPONENT_CUSTOMIZED}, 0);
        optionHandler.addEnum(ITEM_SUBGRAPH_LAYOUTER, new String[]{VALUE_SUBGRAPH_LAYOUTER_IHL, VALUE_SUBGRAPH_LAYOUTER_ORGANIC, VALUE_SUBGRAPH_LAYOUTER_CIRCULAR, VALUE_SUBGRAPH_LAYOUTER_ORTHOGONAL, VALUE_SUBGRAPH_LAYOUTER_NO_LAYOUT}, 0);
        optionHandler.addEnum(ITEM_SUBGRAPH_POSITION_STRATEGY, new String[]{VALUE_SUBGRAPH_POSITIONING_STRATEGY_BARYCENTER, VALUE_SUBGRAPH_POSITIONING_STRATEGY_FROM_SKETCH}, 0);
        optionHandler.addInt(ITEM_MIN_NODE_DIST, 30, 1, 100);
        optionHandler.addEnum(ITEM_ORIENTATION_MAIN_GRAPH, new String[]{VALUE_ORIENTATION_MAIN_GRAPH_AUTO_DETECT, VALUE_ORIENTATION_MAIN_GRAPH_TOP_TO_DOWN, VALUE_ORIENTATION_MAIN_GRAPH_DOWN_TO_TOP, VALUE_ORIENTATION_MAIN_GRAPH_LEFT_TO_RIGHT, VALUE_ORIENTATION_MAIN_GRAPH_RIGHT_TO_LEFT, VALUE_ORIENTATION_MAIN_GRAPH_NONE}, 0);
        optionHandler.addBool(ITEM_CONSIDER_SNAPLINES, true);
        optionHandler.addBool(ITEM_CONSIDER_EDGE_DIRECTION, false);
        return optionHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void mainrun() {
        Graph2D graph2D = this.getGraph2D();
        if (graph2D.selectedNodes().size() + graph2D.selectedEdges().size() == 0) {
            return;
        }
        PartialLayouter partialLayouter = new PartialLayouter();
        OptionHandler optionHandler = this.getOptionHandler();
        this.configure(partialLayouter, optionHandler);
        Graph2DLayoutExecutor graph2DLayoutExecutor = this.getLayoutExecutor();
        TableLayoutConfigurator tableLayoutConfigurator = graph2DLayoutExecutor.getTableLayoutConfigurator();
        boolean bl = graph2DLayoutExecutor.isConfiguringTableNodeRealizers();
        boolean bl2 = tableLayoutConfigurator.isHorizontalLayoutConfiguration();
        graph2DLayoutExecutor.setConfiguringTableNodeRealizers(true);
        tableLayoutConfigurator.setHorizontalLayoutConfiguration(this.b(optionHandler));
        this.prepareGraph(graph2D, optionHandler);
        try {
            this.launchLayouter(partialLayouter);
            Object var9_8 = null;
            this.restoreGraph(graph2D, optionHandler);
            graph2DLayoutExecutor.setConfiguringTableNodeRealizers(bl);
            tableLayoutConfigurator.setHorizontalLayoutConfiguration(bl2);
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.restoreGraph(graph2D, optionHandler);
            graph2DLayoutExecutor.setConfiguringTableNodeRealizers(bl);
            tableLayoutConfigurator.setHorizontalLayoutConfiguration(bl2);
            throw throwable;
        }
    }

    protected void prepareGraph(final Graph2D graph2D, OptionHandler optionHandler) {
        this.backupDataProvider(graph2D, PartialLayouter.PARTIAL_NODES_DPKEY);
        this.backupDataProvider(graph2D, PartialLayouter.PARTIAL_EDGES_DPKEY);
        graph2D.addDataProvider(PartialLayouter.PARTIAL_NODES_DPKEY, Selections.createSelectionNodeMap(graph2D));
        graph2D.addDataProvider(PartialLayouter.PARTIAL_EDGES_DPKEY, Selections.createSelectionEdgeMap(graph2D));
        if (optionHandler.getBool(ITEM_CONSIDER_EDGE_DIRECTION) && graph2D.getDataProvider(PartialLayouter.DIRECTED_EDGES_DPKEY) == null) {
            graph2D.addDataProvider(PartialLayouter.DIRECTED_EDGES_DPKEY, new _b(){

                public boolean getBool(Object object) {
                    if (!(object instanceof Edge)) {
                        return false;
                    }
                    EdgeRealizer edgeRealizer = graph2D.getRealizer((Edge)object);
                    return edgeRealizer.getSourceArrow() == Arrow.NONE == (edgeRealizer.getTargetArrow() != Arrow.NONE);
                }
            });
        }
    }

    protected void restoreGraph(Graph2D graph2D, OptionHandler optionHandler) {
        if (graph2D.getDataProvider(PartialLayouter.DIRECTED_EDGES_DPKEY) instanceof _b) {
            graph2D.removeDataProvider(PartialLayouter.DIRECTED_EDGES_DPKEY);
        }
        this.restoreDataProvider(graph2D, PartialLayouter.PARTIAL_NODES_DPKEY);
        this.restoreDataProvider(graph2D, PartialLayouter.PARTIAL_EDGES_DPKEY);
    }

    protected void configure(PartialLayouter partialLayouter, OptionHandler optionHandler) {
        partialLayouter.setMinimalNodeDistance(optionHandler.getInt(ITEM_MIN_NODE_DIST));
        partialLayouter.setConsiderNodeAlignment(optionHandler.getBool(ITEM_CONSIDER_SNAPLINES));
        byte by = PartialLayoutModule.e(optionHandler.getString(ITEM_SUBGRAPH_POSITION_STRATEGY));
        partialLayouter.setPositioningStrategy(by);
        byte by2 = PartialLayoutModule.b(optionHandler.getString(ITEM_MODE_COMPONENT_ASSIGNMENT));
        partialLayouter.setComponentAssignmentStrategy(by2);
        byte by3 = PartialLayoutModule.d(optionHandler.getString(ITEM_ORIENTATION_MAIN_GRAPH));
        partialLayouter.setLayoutOrientation(by3);
        byte by4 = PartialLayoutModule.c(optionHandler.getString(ITEM_ROUTING_TO_SUBGRAPH));
        partialLayouter.setEdgeRoutingStrategy(by4);
        partialLayouter.setCoreLayouter(this.b(optionHandler, by4));
    }

    private boolean b(OptionHandler optionHandler) {
        byte by = PartialLayoutModule.d(optionHandler.getString(ITEM_ORIENTATION_MAIN_GRAPH));
        return by == 1 || by == 3;
    }

    private Layouter b(OptionHandler optionHandler, byte by) {
        String string;
        block6: {
            IncrementalHierarchicLayouter incrementalHierarchicLayouter;
            block8: {
                block7: {
                    string = optionHandler.getString(ITEM_SUBGRAPH_LAYOUTER);
                    if (!VALUE_SUBGRAPH_LAYOUTER_IHL.equals(string)) break block6;
                    incrementalHierarchicLayouter = new IncrementalHierarchicLayouter();
                    incrementalHierarchicLayouter.setIntegratedEdgeLabelingEnabled(true);
                    if (0 != by) break block7;
                    incrementalHierarchicLayouter.setOrthogonallyRouted(true);
                    if (!YModule.z) break block8;
                }
                incrementalHierarchicLayouter.setOrthogonallyRouted(false);
            }
            return incrementalHierarchicLayouter;
        }
        if (VALUE_SUBGRAPH_LAYOUTER_ORGANIC.equals(string)) {
            SmartOrganicLayouter smartOrganicLayouter = new SmartOrganicLayouter();
            smartOrganicLayouter.setDeterministic(true);
            return smartOrganicLayouter;
        }
        if (VALUE_SUBGRAPH_LAYOUTER_CIRCULAR.equals(string)) {
            return new CircularLayouter();
        }
        if (VALUE_SUBGRAPH_LAYOUTER_ORTHOGONAL.equals(string)) {
            return new OrthogonalLayouter();
        }
        return null;
    }

    private static byte c(String string) {
        if (VALUE_ROUTING_TO_SUBGRAPH_ORTHOGONALLY.equals(string)) {
            return 0;
        }
        if (VALUE_ROUTING_TO_SUBGRAPH_AUTO.equals(string)) {
            return 2;
        }
        if (VALUE_ROUTING_TO_SUBGRAPH_ORGANIC.equals(string)) {
            return 3;
        }
        if (VALUE_ROUTING_TO_SUBGRAPH_POLYLINE.equals(string)) {
            return 4;
        }
        return 1;
    }

    private static byte e(String string) {
        if (VALUE_SUBGRAPH_POSITIONING_STRATEGY_FROM_SKETCH.equals(string)) {
            return 3;
        }
        return 2;
    }

    private static byte b(String string) {
        if (VALUE_MODE_COMPONENT_SINGLE.equals(string)) {
            return 0;
        }
        if (VALUE_MODE_COMPONENT_CONNECTED.equals(string)) {
            return 1;
        }
        if (VALUE_MODE_COMPONENT_CLUSTERING.equals(string)) {
            return 2;
        }
        return 3;
    }

    private static byte d(String string) {
        if (VALUE_ORIENTATION_MAIN_GRAPH_AUTO_DETECT.equals(string)) {
            return 5;
        }
        if (VALUE_ORIENTATION_MAIN_GRAPH_TOP_TO_DOWN.equals(string)) {
            return 0;
        }
        if (VALUE_ORIENTATION_MAIN_GRAPH_DOWN_TO_TOP.equals(string)) {
            return 2;
        }
        if (VALUE_ORIENTATION_MAIN_GRAPH_LEFT_TO_RIGHT.equals(string)) {
            return 1;
        }
        if (VALUE_ORIENTATION_MAIN_GRAPH_RIGHT_TO_LEFT.equals(string)) {
            return 3;
        }
        if (VALUE_ORIENTATION_MAIN_GRAPH_NONE.equals(string)) {
            return -1;
        }
        return 5;
    }

    private class _b
    extends DataProviderAdapter {
        private _b() {
        }
    }
}

