/*
 * Decompiled with CFR 0.152.
 */
package y.module;

import y.base.Edge;
import y.base.NodeMap;
import y.layout.CanonicMultiStageLayouter;
import y.layout.LayoutGraph;
import y.layout.ParallelEdgeLayouter;
import y.module.LayoutModule;
import y.module.YModule;
import y.option.ConstraintManager;
import y.option.OptionHandler;
import y.util.DataProviderAdapter;
import y.view.Graph2D;
import y.view.Selections;

public class ParallelEdgeLayoutModule
extends LayoutModule {
    private static final String kc = "PARALLEL_EDGES";
    protected static final String ITEM_SCOPE = "SCOPE";
    protected static final String VALUE_SCOPE_ALL_EDGES = "ALL_EDGES";
    protected static final String VALUE_SCOPE_SELECTED_EDGES = "SELECTED_EDGES";
    protected static final String VALUE_SCOPE_AT_SELECTED_NODES = "AT_SELECTED_NODES";
    protected static final String ITEM_USE_SELECTED_EDGES_AS_MASTER = "USE_SELECTED_EDGES_AS_MASTER";
    protected static final String ITEM_CONSIDER_EDGE_DIRECTION = "CONSIDER_EDGE_DIRECTION";
    protected static final String ITEM_USE_ADAPTIVE_LINE_DISTANCE = "USE_ADAPTIVE_LINE_DISTANCE";
    protected static final String ITEM_LINE_DISTANCE = "LINE_DISTANCE";
    protected static final String ITEM_JOINS_ENDS = "JOINS_ENDS";
    protected static final String ITEM_JOIN_DISTANCE = "JOIN_DISTANCE";

    public ParallelEdgeLayoutModule() {
        super(kc);
    }

    public OptionHandler createOptionHandler() {
        OptionHandler optionHandler = new OptionHandler(this.getModuleName());
        ConstraintManager constraintManager = new ConstraintManager(optionHandler);
        ParallelEdgeLayouter parallelEdgeLayouter = new ParallelEdgeLayouter();
        optionHandler.addEnum(ITEM_SCOPE, new String[]{VALUE_SCOPE_ALL_EDGES, VALUE_SCOPE_SELECTED_EDGES, VALUE_SCOPE_AT_SELECTED_NODES}, 0);
        optionHandler.addBool(ITEM_USE_SELECTED_EDGES_AS_MASTER, false);
        optionHandler.addBool(ITEM_CONSIDER_EDGE_DIRECTION, parallelEdgeLayouter.isDirectedModeEnabled());
        optionHandler.addBool(ITEM_USE_ADAPTIVE_LINE_DISTANCE, parallelEdgeLayouter.isUsingAdaptiveLineDistances());
        optionHandler.addInt(ITEM_LINE_DISTANCE, (int)parallelEdgeLayouter.getLineDistance(), 0, 50);
        optionHandler.addBool(ITEM_JOINS_ENDS, parallelEdgeLayouter.isJoinEndsEnabled());
        optionHandler.addInt(ITEM_JOIN_DISTANCE, (int)parallelEdgeLayouter.getAbsJoinEndDistance(), 0, 50);
        constraintManager.setEnabledOnValueEquals(ITEM_JOINS_ENDS, (Object)Boolean.TRUE, ITEM_JOIN_DISTANCE);
        return optionHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mainrun() {
        CanonicMultiStageLayouter canonicMultiStageLayouter = new CanonicMultiStageLayouter(){

            protected void doLayoutCore(LayoutGraph layoutGraph) {
            }

            protected boolean canLayoutCore(LayoutGraph layoutGraph) {
                return true;
            }
        };
        canonicMultiStageLayouter.enableOnlyCore();
        canonicMultiStageLayouter.setParallelEdgeLayouterEnabled(true);
        OptionHandler optionHandler = this.getOptionHandler();
        this.configure((ParallelEdgeLayouter)canonicMultiStageLayouter.getParallelEdgeLayouter(), optionHandler);
        Graph2D graph2D = this.getGraph2D();
        this.prepareGraph(graph2D, optionHandler);
        try {
            this.launchLayouter(canonicMultiStageLayouter);
        }
        finally {
            this.restoreGraph(graph2D, optionHandler);
        }
    }

    protected void prepareGraph(Graph2D graph2D, OptionHandler optionHandler) {
        block6: {
            String string;
            block5: {
                string = optionHandler.getString(ITEM_SCOPE);
                if (!string.equals(VALUE_SCOPE_AT_SELECTED_NODES)) break block5;
                final NodeMap nodeMap = Selections.createSelectionNodeMap(graph2D);
                this.backupDataProvider(graph2D, ParallelEdgeLayouter.SCOPE_DPKEY);
                graph2D.addDataProvider(ParallelEdgeLayouter.SCOPE_DPKEY, new DataProviderAdapter(){

                    public boolean getBool(Object object) {
                        Edge edge = (Edge)object;
                        return nodeMap.getBool(edge.source()) || nodeMap.getBool(edge.target());
                    }
                });
                if (!YModule.z) break block6;
            }
            if (string.equals(VALUE_SCOPE_SELECTED_EDGES)) {
                this.backupDataProvider(graph2D, ParallelEdgeLayouter.SCOPE_DPKEY);
                graph2D.addDataProvider(ParallelEdgeLayouter.SCOPE_DPKEY, Selections.createSelectionEdgeMap(graph2D));
            }
        }
        if (optionHandler.getBool(ITEM_USE_SELECTED_EDGES_AS_MASTER)) {
            this.backupDataProvider(graph2D, ParallelEdgeLayouter.LEADING_EDGE_DPKEY);
            graph2D.addDataProvider(ParallelEdgeLayouter.LEADING_EDGE_DPKEY, Selections.createSelectionEdgeMap(graph2D));
        }
    }

    protected void restoreGraph(Graph2D graph2D, OptionHandler optionHandler) {
        String string;
        if (optionHandler.getBool(ITEM_USE_SELECTED_EDGES_AS_MASTER)) {
            this.restoreDataProvider(graph2D, ParallelEdgeLayouter.LEADING_EDGE_DPKEY);
        }
        if ((string = optionHandler.getString(ITEM_SCOPE)).equals(VALUE_SCOPE_AT_SELECTED_NODES) || string.equals(VALUE_SCOPE_SELECTED_EDGES)) {
            this.restoreDataProvider(graph2D, ParallelEdgeLayouter.SCOPE_DPKEY);
        }
    }

    protected void configure(ParallelEdgeLayouter parallelEdgeLayouter, OptionHandler optionHandler) {
        parallelEdgeLayouter.setLeadingEdgeAdjustmentEnabled(false);
        parallelEdgeLayouter.setDirectedModeEnabled(optionHandler.getBool(ITEM_CONSIDER_EDGE_DIRECTION));
        parallelEdgeLayouter.setUsingAdaptiveLineDistances(optionHandler.getBool(ITEM_USE_ADAPTIVE_LINE_DISTANCE));
        parallelEdgeLayouter.setLineDistance(optionHandler.getInt(ITEM_LINE_DISTANCE));
        parallelEdgeLayouter.setJoinEndsEnabled(optionHandler.getBool(ITEM_JOINS_ENDS));
        parallelEdgeLayouter.setAbsJoinEndDistance(optionHandler.getInt(ITEM_JOIN_DISTANCE));
    }
}

