/*
 * Decompiled with CFR 0.152.
 */
package y.module;

import y.layout.router.EdgeGroupRouterStage;
import y.layout.router.GroupNodeRouterStage;
import y.layout.router.OrthogonalEdgeRouter;
import y.layout.router.PatchRouterStage;
import y.layout.router.ReducedSphereOfActionStage;
import y.module.LayoutModule;
import y.module.YModule;
import y.option.ConstraintManager;
import y.option.IntOptionItem;
import y.option.OptionGroup;
import y.option.OptionHandler;
import y.option.OptionItem;

public class OrthogonalEdgeRouterModule
extends LayoutModule {
    private static final String lc = "ORTHOGONAL_EDGE_ROUTER";
    protected static final String SECTION_LAYOUT_OPTIONS = "LAYOUT_OPTIONS";
    protected static final String ITEM_SCOPE = "SCOPE";
    protected static final String VALUE_SCOPE_ALL_EDGES = "ALL_EDGES";
    protected static final String VALUE_SCOPE_SELECTED_EDGES = "SELECTED_EDGES";
    protected static final String VALUE_SCOPE_AT_SELECTED_NODES = "AT_SELECTED_NODES";
    protected static final String ITEM_MONOTONIC_RESTRICTION = "MONOTONIC_RESTRICTION";
    protected static final String VALUE_MONOTONIC_NONE = "MONOTONIC_NONE";
    protected static final String VALUE_MONOTONIC_HORIZONTAL = "MONOTONIC_HORIZONTAL";
    protected static final String VALUE_MONOTONIC_VERTICAL = "MONOTONIC_VERTICAL";
    protected static final String VALUE_MONOTONIC_BOTH = "MONOTONIC_BOTH";
    protected static final String ITEM_ENFORCE_MONOTONIC_RESTRICTIONS = "ENFORCE_MONOTONIC_RESTRICTIONS";
    protected static final String ITEM_MINIMUM_DISTANCE_TO_EDGE = "MINIMUM_DISTANCE_TO_EDGE";
    protected static final String ITEM_USE_CUSTOM_MINIMUM_DISTANCE_TO_NODE = "USE_CUSTOM_MINIMUM_DISTANCE_TO_NODE";
    protected static final String ITEM_CUSTOM_MINIMUM_DISTANCE_TO_NODE = "CUSTOM_MINIMUM_DISTANCE_TO_NODE";
    protected static final String ITEM_ROUTE_ON_GRID = "ROUTE_ON_GRID";
    protected static final String ITEM_GRID_SPACING = "GRID_SPACING";
    protected static final String ITEM_SPACE_DRIVEN_VS_CENTER_DRIVEN_SEARCH = "SPACE_DRIVEN_VS_CENTER_DRIVEN_SEARCH";
    protected static final String ITEM_CONSIDER_NODE_LABELS = "CONSIDER_NODE_LABELS";
    protected static final String SECTION_SECTION_CROSSING_MINIMIZATION = "CROSSING_MINIMIZATION";
    protected static final String ITEM_LOCAL_CROSSING_MINIMIZATION = "LOCAL_CROSSING_MINIMIZATION";
    protected static final String ITEM_CROSSING_COST = "CROSSING_COST";
    protected static final String ITEM_REROUTING_ENABLED = "REROUTING_ENABLED";

    public OrthogonalEdgeRouterModule() {
        super(lc);
        this.setPortIntersectionCalculatorEnabled(true);
    }

    protected OptionHandler createOptionHandler() {
        int n2;
        boolean bl = YModule.z;
        OptionHandler optionHandler = new OptionHandler(this.getModuleName());
        optionHandler.clear();
        ConstraintManager constraintManager = new ConstraintManager(optionHandler);
        OrthogonalEdgeRouter orthogonalEdgeRouter = new OrthogonalEdgeRouter();
        OptionGroup optionGroup = new OptionGroup();
        optionGroup.setAttribute("OptionGroup.title", SECTION_LAYOUT_OPTIONS);
        switch (orthogonalEdgeRouter.getSphereOfAction()) {
            case 0: {
                n2 = 0;
                if (!bl) break;
            }
            case 4: {
                n2 = 1;
                if (!bl) break;
            }
            default: {
                n2 = 2;
            }
        }
        optionGroup.addItem(optionHandler.addEnum(ITEM_SCOPE, new String[]{VALUE_SCOPE_ALL_EDGES, VALUE_SCOPE_SELECTED_EDGES, VALUE_SCOPE_AT_SELECTED_NODES}, n2));
        optionGroup.addItem(optionHandler.addEnum(ITEM_MONOTONIC_RESTRICTION, new String[]{VALUE_MONOTONIC_NONE, VALUE_MONOTONIC_HORIZONTAL, VALUE_MONOTONIC_VERTICAL, VALUE_MONOTONIC_BOTH}, 0));
        optionGroup.addItem(optionHandler.addBool(ITEM_ENFORCE_MONOTONIC_RESTRICTIONS, orthogonalEdgeRouter.isEnforceMonotonicPathRestrictions()));
        OptionItem optionItem = optionGroup.addItem(optionHandler.addInt(ITEM_MINIMUM_DISTANCE_TO_EDGE, orthogonalEdgeRouter.getMinimumDistance()));
        optionItem.setAttribute(IntOptionItem.ATTRIBUTE_MIN_VALUE, new Integer(4));
        OptionItem optionItem2 = optionGroup.addItem(optionHandler.addBool(ITEM_USE_CUSTOM_MINIMUM_DISTANCE_TO_NODE, !orthogonalEdgeRouter.getCoupledDistances()));
        OptionItem optionItem3 = optionGroup.addItem(optionHandler.addInt(ITEM_CUSTOM_MINIMUM_DISTANCE_TO_NODE, orthogonalEdgeRouter.getMinimumDistanceToNode()));
        optionItem3.setAttribute(IntOptionItem.ATTRIBUTE_MIN_VALUE, new Integer(2));
        OptionItem optionItem4 = optionGroup.addItem(optionHandler.addBool(ITEM_ROUTE_ON_GRID, orthogonalEdgeRouter.isGridRoutingEnabled()));
        OptionItem optionItem5 = optionGroup.addItem(optionHandler.addInt(ITEM_GRID_SPACING, orthogonalEdgeRouter.getGridSpacing()));
        optionItem5.setAttribute(IntOptionItem.ATTRIBUTE_MIN_VALUE, new Integer(2));
        optionGroup.addItem(optionHandler.addDouble(ITEM_SPACE_DRIVEN_VS_CENTER_DRIVEN_SEARCH, orthogonalEdgeRouter.getCenterToSpaceRatio(), 0.0, 1.0));
        optionGroup.addItem(optionHandler.addBool(ITEM_CONSIDER_NODE_LABELS, orthogonalEdgeRouter.isConsiderNodeLabelsEnabled()));
        OptionGroup optionGroup2 = new OptionGroup();
        optionGroup2.setAttribute("OptionGroup.title", SECTION_SECTION_CROSSING_MINIMIZATION);
        optionGroup2.addItem(optionHandler.addBool(ITEM_LOCAL_CROSSING_MINIMIZATION, orthogonalEdgeRouter.isLocalCrossingMinimizationEnabled()));
        optionGroup2.addItem(optionHandler.addDouble(ITEM_CROSSING_COST, orthogonalEdgeRouter.getCrossingCost()));
        optionGroup2.addItem(optionHandler.addBool(ITEM_REROUTING_ENABLED, orthogonalEdgeRouter.isReroutingEnabled()));
        constraintManager.setEnabledOnValueEquals(optionItem4, (Object)Boolean.TRUE, optionItem5);
        constraintManager.setEnabledOnValueEquals(optionItem2, (Object)Boolean.TRUE, optionItem3);
        return optionHandler;
    }

    protected void mainrun() {
        OrthogonalEdgeRouter orthogonalEdgeRouter = new OrthogonalEdgeRouter();
        OptionHandler optionHandler = this.getOptionHandler();
        this.configure(orthogonalEdgeRouter, optionHandler);
        this.launchLayouter(new EdgeGroupRouterStage(new GroupNodeRouterStage(new ReducedSphereOfActionStage(new PatchRouterStage(orthogonalEdgeRouter)))));
    }

    protected void configure(OrthogonalEdgeRouter orthogonalEdgeRouter, OptionHandler optionHandler) {
        block8: {
            block10: {
                boolean bl;
                block9: {
                    block7: {
                        block5: {
                            block6: {
                                String string;
                                block4: {
                                    bl = YModule.z;
                                    string = optionHandler.getString(ITEM_SCOPE);
                                    if (!string.equals(VALUE_SCOPE_AT_SELECTED_NODES)) break block4;
                                    orthogonalEdgeRouter.setSphereOfAction((byte)4);
                                    if (!bl) break block5;
                                }
                                if (!string.equals(VALUE_SCOPE_SELECTED_EDGES)) break block6;
                                orthogonalEdgeRouter.setSphereOfAction((byte)2);
                                if (!bl) break block5;
                            }
                            orthogonalEdgeRouter.setSphereOfAction((byte)0);
                        }
                        orthogonalEdgeRouter.setMinimumDistance(optionHandler.getInt(ITEM_MINIMUM_DISTANCE_TO_EDGE));
                        orthogonalEdgeRouter.setCoupledDistances(!optionHandler.getBool(ITEM_USE_CUSTOM_MINIMUM_DISTANCE_TO_NODE));
                        orthogonalEdgeRouter.setMinimumDistanceToNode(optionHandler.getInt(ITEM_CUSTOM_MINIMUM_DISTANCE_TO_NODE));
                        orthogonalEdgeRouter.setGridRoutingEnabled(optionHandler.getBool(ITEM_ROUTE_ON_GRID));
                        orthogonalEdgeRouter.setGridSpacing(optionHandler.getInt(ITEM_GRID_SPACING));
                        orthogonalEdgeRouter.setCenterToSpaceRatio(optionHandler.getDouble(ITEM_SPACE_DRIVEN_VS_CENTER_DRIVEN_SEARCH));
                        orthogonalEdgeRouter.setLocalCrossingMinimizationEnabled(optionHandler.getBool(ITEM_LOCAL_CROSSING_MINIMIZATION));
                        if (!VALUE_MONOTONIC_BOTH.equals(optionHandler.getString(ITEM_MONOTONIC_RESTRICTION))) break block7;
                        orthogonalEdgeRouter.setMonotonicPathRestriction((byte)3);
                        if (!bl) break block8;
                    }
                    if (!VALUE_MONOTONIC_HORIZONTAL.equals(optionHandler.getString(ITEM_MONOTONIC_RESTRICTION))) break block9;
                    orthogonalEdgeRouter.setMonotonicPathRestriction((byte)2);
                    if (!bl) break block8;
                }
                if (!VALUE_MONOTONIC_VERTICAL.equals(optionHandler.getString(ITEM_MONOTONIC_RESTRICTION))) break block10;
                orthogonalEdgeRouter.setMonotonicPathRestriction((byte)1);
                if (!bl) break block8;
            }
            orthogonalEdgeRouter.setMonotonicPathRestriction((byte)0);
        }
        orthogonalEdgeRouter.setEnforceMonotonicPathRestrictions(optionHandler.getBool(ITEM_ENFORCE_MONOTONIC_RESTRICTIONS));
        orthogonalEdgeRouter.setConsiderNodeLabelsEnabled(optionHandler.getBool(ITEM_CONSIDER_NODE_LABELS));
        orthogonalEdgeRouter.setCrossingCost(optionHandler.getDouble(ITEM_CROSSING_COST));
        orthogonalEdgeRouter.setReroutingEnabled(optionHandler.getBool(ITEM_REROUTING_ENABLED));
    }
}

