/*
 * Decompiled with CFR 0.152.
 */
package y.module;

import y.layout.ComponentLayouter;
import y.layout.organic.OrganicLayouter;
import y.module.LayoutModule;
import y.module.YModule;
import y.option.OptionHandler;
import y.view.Graph2D;
import y.view.Selections;
import y.view.hierarchy.HierarchyManager;

public class OrganicLayoutModule
extends LayoutModule {
    protected static final String MODULE_ORGANIC = "ORGANIC";
    protected static final String SECTION_VISUAL = "VISUAL";
    protected static final String ITEM_SPHERE_OF_ACTION = "SPHERE_OF_ACTION";
    protected static final String VALUE_ALL = "ALL";
    protected static final String VALUE_MAINLY_SELECTION = "MAINLY_SELECTION";
    protected static final String VALUE_ONLY_SELECTION = "ONLY_SELECTION";
    protected static final String ITEM_INITIAL_PLACEMENT = "INITIAL_PLACEMENT";
    protected static final String VALUE_RANDOM = "RANDOM";
    protected static final String VALUE_AT_ORIGIN = "AT_ORIGIN";
    protected static final String VALUE_AS_IS = "AS_IS";
    protected static final String ITEM_PREFERRED_EDGE_LENGTH = "PREFERRED_EDGE_LENGTH";
    protected static final String ITEM_OBEY_NODE_SIZES = "OBEY_NODE_SIZES";
    protected static final String ITEM_ATTRACTION = "ATTRACTION";
    protected static final String ITEM_REPULSION = "REPULSION";
    protected static final String ITEM_GRAVITY_FACTOR = "GRAVITY_FACTOR";
    protected static final String ITEM_ACTIVATE_TREE_BEAUTIFIER = "ACTIVATE_TREE_BEAUTIFIER";
    protected static final String SECTION_ALGORITHM = "ALGORITHM";
    protected static final String ITEM_ITERATION_FACTOR = "ITERATION_FACTOR";
    protected static final String ITEM_MAXIMAL_DURATION = "MAXIMAL_DURATION";
    protected static final String ITEM_ACTIVATE_DETERMINISTIC_MODE = "ACTIVATE_DETERMINISTIC_MODE";
    protected static final String ITEM_ALLOW_MULTI_THREADING = "ALLOW_MULTI_THREADING";
    protected static final String SECTION_GROUPING = "GROUPING";
    protected static final String ITEM_GROUP_LAYOUT_POLICY = "GROUP_LAYOUT_POLICY";
    protected static final String VALUE_LAYOUT_GROUPS = "LAYOUT_GROUPS";
    protected static final String VALUE_FIX_GROUPS = "FIX_GROUPS";
    protected static final String VALUE_IGNORE_GROUPS = "IGNORE_GROUPS";
    protected static final String ITEM_GROUP_NODE_COMPACTNESS = "GROUP_NODE_COMPACTNESS";

    public OrganicLayoutModule() {
        super(MODULE_ORGANIC, "yFiles Layout Team", "Wrapper for OrganicLayouter");
    }

    protected OptionHandler createOptionHandler() {
        OptionHandler optionHandler = new OptionHandler(this.getModuleName());
        OrganicLayouter organicLayouter = new OrganicLayouter();
        optionHandler.useSection(SECTION_VISUAL);
        optionHandler.addEnum(ITEM_SPHERE_OF_ACTION, new String[]{VALUE_ALL, VALUE_MAINLY_SELECTION, VALUE_ONLY_SELECTION}, organicLayouter.getSphereOfAction());
        optionHandler.addEnum(ITEM_INITIAL_PLACEMENT, new String[]{VALUE_RANDOM, VALUE_AT_ORIGIN, VALUE_AS_IS}, organicLayouter.getInitialPlacement());
        optionHandler.addInt(ITEM_PREFERRED_EDGE_LENGTH, organicLayouter.getPreferredEdgeLength(), 0, 500);
        optionHandler.addBool(ITEM_OBEY_NODE_SIZES, organicLayouter.getObeyNodeSize());
        optionHandler.addInt(ITEM_ATTRACTION, organicLayouter.getAttraction(), 0, 2);
        optionHandler.addInt(ITEM_REPULSION, organicLayouter.getRepulsion(), 0, 2);
        optionHandler.addDouble(ITEM_GRAVITY_FACTOR, organicLayouter.getGravityFactor(), -0.2, 2.0, 1);
        optionHandler.addBool(ITEM_ACTIVATE_TREE_BEAUTIFIER, organicLayouter.getActivateTreeBeautifier());
        optionHandler.useSection(SECTION_ALGORITHM);
        optionHandler.addDouble(ITEM_ITERATION_FACTOR, organicLayouter.getIterationFactor());
        optionHandler.addInt(ITEM_MAXIMAL_DURATION, (int)(organicLayouter.getMaximumDuration() / 1000L));
        optionHandler.addBool(ITEM_ACTIVATE_DETERMINISTIC_MODE, organicLayouter.getActivateDeterministicMode());
        optionHandler.addBool(ITEM_ALLOW_MULTI_THREADING, true);
        optionHandler.useSection(SECTION_GROUPING);
        optionHandler.addEnum(ITEM_GROUP_LAYOUT_POLICY, new String[]{VALUE_LAYOUT_GROUPS, VALUE_FIX_GROUPS, VALUE_IGNORE_GROUPS}, 0);
        optionHandler.addDouble(ITEM_GROUP_NODE_COMPACTNESS, organicLayouter.getGroupNodeCompactness(), 0.0, 1.0);
        return optionHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void mainrun() {
        OrganicLayouter organicLayouter = new OrganicLayouter();
        OptionHandler optionHandler = this.getOptionHandler();
        this.configure(organicLayouter, optionHandler);
        Graph2D graph2D = this.getGraph2D();
        this.prepareGraph(graph2D, optionHandler);
        try {
            this.launchLayouter(organicLayouter);
        }
        finally {
            this.restoreGraph(graph2D, optionHandler);
        }
    }

    protected void prepareGraph(Graph2D graph2D, OptionHandler optionHandler) {
        this.backupDataProvider(graph2D, OrganicLayouter.SPHERE_OF_ACTION_NODES);
        graph2D.addDataProvider(OrganicLayouter.SPHERE_OF_ACTION_NODES, Selections.createSelectionNodeMap(graph2D));
    }

    protected void restoreGraph(Graph2D graph2D, OptionHandler optionHandler) {
        this.restoreDataProvider(graph2D, OrganicLayouter.SPHERE_OF_ACTION_NODES);
    }

    protected void configure(OrganicLayouter organicLayouter, OptionHandler optionHandler) {
        block12: {
            block14: {
                boolean bl;
                block13: {
                    block10: {
                        block11: {
                            String string;
                            block9: {
                                block7: {
                                    block8: {
                                        String string2;
                                        block6: {
                                            bl = YModule.z;
                                            organicLayouter.setPreferredEdgeLength(optionHandler.getInt(SECTION_VISUAL, ITEM_PREFERRED_EDGE_LENGTH));
                                            organicLayouter.setMaximumDuration(1000 * optionHandler.getInt(SECTION_ALGORITHM, ITEM_MAXIMAL_DURATION));
                                            string2 = optionHandler.getString(SECTION_VISUAL, ITEM_INITIAL_PLACEMENT);
                                            if (!VALUE_RANDOM.equals(string2)) break block6;
                                            organicLayouter.setInitialPlacement((byte)0);
                                            if (!bl) break block7;
                                        }
                                        if (!VALUE_AT_ORIGIN.equals(string2)) break block8;
                                        organicLayouter.setInitialPlacement((byte)1);
                                        if (!bl) break block7;
                                    }
                                    organicLayouter.setInitialPlacement((byte)2);
                                }
                                if (!VALUE_ALL.equals(string = optionHandler.getString(SECTION_VISUAL, ITEM_SPHERE_OF_ACTION))) break block9;
                                organicLayouter.setSphereOfAction((byte)0);
                                if (!bl) break block10;
                            }
                            if (!VALUE_MAINLY_SELECTION.equals(string)) break block11;
                            organicLayouter.setSphereOfAction((byte)1);
                            if (!bl) break block10;
                        }
                        organicLayouter.setSphereOfAction((byte)2);
                    }
                    organicLayouter.setGravityFactor(optionHandler.getDouble(SECTION_VISUAL, ITEM_GRAVITY_FACTOR));
                    organicLayouter.setObeyNodeSize(optionHandler.getBool(SECTION_VISUAL, ITEM_OBEY_NODE_SIZES));
                    organicLayouter.setIterationFactor(optionHandler.getDouble(SECTION_ALGORITHM, ITEM_ITERATION_FACTOR));
                    organicLayouter.setActivateTreeBeautifier(optionHandler.getBool(SECTION_VISUAL, ITEM_ACTIVATE_TREE_BEAUTIFIER));
                    organicLayouter.setActivateDeterministicMode(optionHandler.getBool(SECTION_ALGORITHM, ITEM_ACTIVATE_DETERMINISTIC_MODE));
                    organicLayouter.setMultiThreadingAllowed(optionHandler.getBool(SECTION_ALGORITHM, ITEM_ALLOW_MULTI_THREADING));
                    organicLayouter.setAttraction(optionHandler.getInt(SECTION_VISUAL, ITEM_ATTRACTION));
                    organicLayouter.setRepulsion(2 - optionHandler.getInt(SECTION_VISUAL, ITEM_REPULSION));
                    organicLayouter.setGroupNodeCompactness(optionHandler.getDouble(SECTION_GROUPING, ITEM_GROUP_NODE_COMPACTNESS));
                    ((ComponentLayouter)organicLayouter.getComponentLayouter()).setStyle((byte)8);
                    if (!HierarchyManager.containsGroupNodes(this.getGraph2D())) break block12;
                    if (!optionHandler.get(SECTION_GROUPING, ITEM_GROUP_LAYOUT_POLICY).equals(VALUE_FIX_GROUPS)) break block13;
                    organicLayouter.setGroupNodePolicy((byte)1);
                    if (!bl) break block12;
                }
                if (!optionHandler.get(SECTION_GROUPING, ITEM_GROUP_LAYOUT_POLICY).equals(VALUE_IGNORE_GROUPS)) break block14;
                organicLayouter.setGroupNodePolicy((byte)2);
                if (!bl) break block12;
            }
            organicLayouter.setGroupNodePolicy((byte)0);
        }
    }
}

