/*
 * Decompiled with CFR 0.152.
 */
package y.module;

import y.base.EdgeMap;
import y.layout.BendConverter;
import y.layout.CompositeLayoutStage;
import y.layout.Layouter;
import y.layout.SequentialLayouter;
import y.layout.grouping.GroupNodeHider;
import y.layout.organic.RemoveOverlapsLayoutStage;
import y.layout.router.OrganicEdgeRouter;
import y.module.LayoutModule;
import y.module.YModule;
import y.option.OptionGroup;
import y.option.OptionHandler;
import y.view.Graph2D;
import y.view.Selections;

public class OrganicEdgeRouterModule
extends LayoutModule {
    protected static final String MODULE_ORGANIC_EDGE_ROUTER = "ORGANIC_EDGE_ROUTER";
    protected static final String TITLE_LAYOUT_OPTIONS = "LAYOUT_OPTIONS";
    protected static final String ITEM_SELECTION_ONLY = "SELECTION_ONLY";
    protected static final String ITEM_MINIMAL_NODE_DISTANCE = "MINIMAL_NODE_DISTANCE";
    protected static final String ITEM_USE_BENDS = "USE_BENDS";
    protected static final String ITEM_ROUTE_ONLY_NECESSARY = "ROUTE_ONLY_NECESSARY";
    protected static final String ITEM_ALLOW_MOVING_NODES = "ALLOW_MOVING_NODES";

    public OrganicEdgeRouterModule() {
        super(MODULE_ORGANIC_EDGE_ROUTER);
    }

    protected OptionHandler createOptionHandler() {
        OptionHandler optionHandler = new OptionHandler(this.getModuleName());
        OrganicEdgeRouter organicEdgeRouter = new OrganicEdgeRouter();
        OptionGroup optionGroup = new OptionGroup();
        optionGroup.setAttribute("OptionGroup.title", TITLE_LAYOUT_OPTIONS);
        optionGroup.addItem(optionHandler.addBool(ITEM_SELECTION_ONLY, false));
        optionGroup.addItem(optionHandler.addInt(ITEM_MINIMAL_NODE_DISTANCE, (int)organicEdgeRouter.getMinimalDistance(), 10, 300));
        optionGroup.addItem(optionHandler.addBool(ITEM_USE_BENDS, organicEdgeRouter.isUsingBends()));
        optionGroup.addItem(optionHandler.addBool(ITEM_ROUTE_ONLY_NECESSARY, !organicEdgeRouter.isRoutingAll()));
        optionGroup.addItem(optionHandler.addBool(ITEM_ALLOW_MOVING_NODES, false));
        return optionHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void mainrun() {
        Object object;
        SequentialLayouter sequentialLayouter;
        OptionHandler optionHandler;
        block9: {
            OrganicEdgeRouter organicEdgeRouter;
            block8: {
                organicEdgeRouter = new OrganicEdgeRouter();
                optionHandler = this.getOptionHandler();
                this.configure(organicEdgeRouter, optionHandler);
                sequentialLayouter = new SequentialLayouter();
                if (optionHandler.getBool(ITEM_ALLOW_MOVING_NODES)) {
                    object = new CompositeLayoutStage();
                    ((CompositeLayoutStage)object).appendStage(organicEdgeRouter.createNodeEnlargementStage());
                    ((CompositeLayoutStage)object).appendStage(new RemoveOverlapsLayoutStage(0.0));
                    sequentialLayouter.appendLayouter((Layouter)object);
                }
                if (!organicEdgeRouter.isUsingBends()) break block8;
                object = new BendConverter();
                ((BendConverter)object).setSelectedEdgesDpKey(OrganicEdgeRouter.ROUTE_EDGE_DPKEY);
                ((BendConverter)object).setAdoptSelectionEnabled(optionHandler.getBool(ITEM_SELECTION_ONLY));
                ((BendConverter)object).setCoreLayouter(organicEdgeRouter);
                sequentialLayouter.appendLayouter((Layouter)object);
                if (!YModule.z) break block9;
            }
            sequentialLayouter.appendLayouter(organicEdgeRouter);
        }
        object = this.getGraph2D();
        this.prepareGraph((Graph2D)object, optionHandler);
        try {
            this.launchLayouter(new GroupNodeHider(sequentialLayouter));
        }
        finally {
            this.restoreGraph((Graph2D)object, optionHandler);
        }
    }

    protected void prepareGraph(Graph2D graph2D, OptionHandler optionHandler) {
        if (optionHandler.getBool(ITEM_SELECTION_ONLY)) {
            EdgeMap edgeMap = Selections.createSelectionEdgeMap(graph2D);
            this.backupDataProvider(graph2D, BendConverter.SCOPE_DPKEY);
            graph2D.addDataProvider(BendConverter.SCOPE_DPKEY, edgeMap);
            this.backupDataProvider(graph2D, OrganicEdgeRouter.ROUTE_EDGE_DPKEY);
            graph2D.addDataProvider(OrganicEdgeRouter.ROUTE_EDGE_DPKEY, edgeMap);
        }
    }

    protected void restoreGraph(Graph2D graph2D, OptionHandler optionHandler) {
        if (optionHandler.getBool(ITEM_SELECTION_ONLY)) {
            this.restoreDataProvider(graph2D, OrganicEdgeRouter.ROUTE_EDGE_DPKEY);
            this.restoreDataProvider(graph2D, BendConverter.SCOPE_DPKEY);
        }
    }

    protected void configure(OrganicEdgeRouter organicEdgeRouter, OptionHandler optionHandler) {
        organicEdgeRouter.setMinimalDistance(optionHandler.getInt(ITEM_MINIMAL_NODE_DISTANCE));
        organicEdgeRouter.setUsingBends(optionHandler.getBool(ITEM_USE_BENDS));
        organicEdgeRouter.setRoutingAll(!optionHandler.getBool(ITEM_ROUTE_ONLY_NECESSARY));
    }
}

