/*
 * Decompiled with CFR 0.152.
 */
package y.module;

import y.base.DataProvider;
import y.base.Edge;
import y.base.EdgeCursor;
import y.layout.EdgeLabelModel;
import y.layout.LabelRanking;
import y.layout.Layouter;
import y.layout.RotatedDiscreteEdgeLabelModel;
import y.layout.RotatedSliderEdgeLabelModel;
import y.layout.labeling.GreedyMISLabeling;
import y.layout.labeling.MISLabelingAlgorithm;
import y.layout.labeling.SALabeling;
import y.module.YModule;
import y.option.ConstraintManager;
import y.option.EnumOptionItem;
import y.option.OptionHandler;
import y.option.OptionItem;
import y.util.DataProviderAdapter;
import y.view.EdgeLabel;
import y.view.EdgeRealizer;
import y.view.Graph2D;
import y.view.Graph2DLayoutExecutor;
import y.view.Graph2DView;
import y.view.NodeLabel;
import y.view.YLabel;

public class LabelingModule
extends YModule {
    protected static final String MODULE_DIVERSE_LABELING = "DIVERSE_LABELING";
    protected static final String SECTION_SCOPE = "SCOPE";
    protected static final String ITEM_PLACE_NODE_LABELS = "PLACE_NODE_LABELS";
    protected static final String ITEM_PLACE_EDGE_LABELS = "PLACE_EDGE_LABELS";
    protected static final String ITEM_CONSIDER_SELECTED_FEATURES_ONLY = "CONSIDER_SELECTED_FEATURES_ONLY";
    protected static final String ITEM_CONSIDER_INVISIBLE_LABELS = "CONSIDER_INVISIBLE_LABELS";
    protected static final String SECTION_QUALITY = "QUALITY";
    protected static final String ITEM_USE_OPTIMIZATION = "USE_OPTIMIZATION";
    protected static final String ITEM_OPTIMIZATION_STRATEGY = "OPTIMIZATION_STRATEGY";
    protected static final String VALUE_OPTIMIZATION_BALANCED = "OPTIMIZATION_BALANCED";
    protected static final String VALUE_OPTIMIZATION_NONE = "OPTIMIZATION_NONE";
    protected static final String VALUE_OPTIMIZATION_EDGE_OVERLAP = "OPTIMIZATION_EDGE_OVERLAP";
    protected static final String VALUE_OPTIMIZATION_LABEL_OVERLAP = "OPTIMIZATION_LABEL_OVERLAP";
    protected static final String VALUE_OPTIMIZATION_NODE_OVERLAP = "OPTIMIZATION_NODE_OVERLAP";
    protected static final String ITEM_ALLOW_NODE_OVERLAPS = "ALLOW_NODE_OVERLAPS";
    protected static final String ITEM_ALLOW_EDGE_OVERLAPS = "ALLOW_EDGE_OVERLAPS";
    protected static final String ITEM_USE_POSTPROCESSING = "USE_POSTPROCESSING";
    protected static final String SECTION_MODEL = "MODEL";
    protected static final String ITEM_EDGE_LABEL_MODEL = "EDGE_LABEL_MODEL";
    protected static final String VALUE_CENTERED = "CENTERED";
    protected static final String VALUE_TWO_POS = "TWO_POS";
    protected static final String VALUE_SIX_POS = "SIX_POS";
    protected static final String VALUE_THREE_CENTER = "THREE_CENTER";
    protected static final String VALUE_FREE = "FREE";
    protected static final String VALUE_CENTER_SLIDER = "CENTER_SLIDER";
    protected static final String VALUE_SIDE_SLIDER = "SIDE_SLIDER";
    protected static final String VALUE_AS_IS = "AS_IS";
    protected static final String VALUE_BEST = "BEST";
    protected static final String ITEM_AUTO_ROTATE = "AUTO_ROTATE";
    protected static final String LABEL_SELECTION_DP_KEY = "LABEL_SELECTION";

    public LabelingModule() {
        super(MODULE_DIVERSE_LABELING);
    }

    protected OptionHandler createOptionHandler() {
        OptionHandler optionHandler = new OptionHandler(this.getModuleName());
        ConstraintManager constraintManager = new ConstraintManager(optionHandler);
        optionHandler.useSection(SECTION_SCOPE);
        optionHandler.addBool(ITEM_PLACE_NODE_LABELS, true);
        optionHandler.addBool(ITEM_PLACE_EDGE_LABELS, true);
        optionHandler.addBool(ITEM_CONSIDER_SELECTED_FEATURES_ONLY, false);
        optionHandler.addBool(ITEM_CONSIDER_INVISIBLE_LABELS, false);
        optionHandler.useSection(SECTION_QUALITY);
        optionHandler.addBool(ITEM_USE_OPTIMIZATION, false);
        optionHandler.addEnum(ITEM_OPTIMIZATION_STRATEGY, new String[]{VALUE_OPTIMIZATION_BALANCED, VALUE_OPTIMIZATION_NONE, VALUE_OPTIMIZATION_EDGE_OVERLAP, VALUE_OPTIMIZATION_LABEL_OVERLAP, VALUE_OPTIMIZATION_NODE_OVERLAP}, 0);
        optionHandler.addBool(ITEM_ALLOW_NODE_OVERLAPS, false);
        optionHandler.addBool(ITEM_ALLOW_EDGE_OVERLAPS, true);
        optionHandler.addBool(ITEM_USE_POSTPROCESSING, false);
        optionHandler.useSection(SECTION_MODEL);
        EnumOptionItem enumOptionItem = optionHandler.addEnum(ITEM_EDGE_LABEL_MODEL, new String[]{VALUE_CENTERED, VALUE_TWO_POS, VALUE_SIX_POS, VALUE_THREE_CENTER, VALUE_FREE, VALUE_CENTER_SLIDER, VALUE_SIDE_SLIDER, VALUE_AS_IS, VALUE_BEST}, 8);
        optionHandler.addBool(ITEM_AUTO_ROTATE, false);
        ConstraintManager.Condition condition = constraintManager.createConditionValueIs((OptionItem)enumOptionItem, (Object[])new String[]{VALUE_AS_IS, VALUE_BEST, VALUE_FREE});
        constraintManager.setEnabledOnCondition(condition.inverse(), optionHandler.getItem(ITEM_AUTO_ROTATE));
        return optionHandler;
    }

    private static byte f(String string) {
        if (VALUE_OPTIMIZATION_LABEL_OVERLAP.equals(string)) {
            return 2;
        }
        if (VALUE_OPTIMIZATION_BALANCED.equals(string)) {
            return 0;
        }
        if (VALUE_OPTIMIZATION_EDGE_OVERLAP.equals(string)) {
            return 3;
        }
        if (VALUE_OPTIMIZATION_NODE_OVERLAP.equals(string)) {
            return 1;
        }
        return 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void mainrun() {
        Graph2D graph2D;
        block6: {
            OptionHandler optionHandler = this.getOptionHandler();
            MISLabelingAlgorithm mISLabelingAlgorithm = optionHandler.getBool(ITEM_USE_OPTIMIZATION) ? new SALabeling() : new GreedyMISLabeling();
            mISLabelingAlgorithm.setAutoFlippingEnabled(true);
            mISLabelingAlgorithm.setOptimizationStrategy(LabelingModule.f(optionHandler.getString(ITEM_OPTIMIZATION_STRATEGY)));
            if (mISLabelingAlgorithm.getOptimizationStrategy() == 4) {
                mISLabelingAlgorithm.setProfitModel(new LabelRanking());
            }
            mISLabelingAlgorithm.setRemoveNodeOverlaps(!optionHandler.getBool(ITEM_ALLOW_NODE_OVERLAPS));
            mISLabelingAlgorithm.setRemoveEdgeOverlaps(!optionHandler.getBool(ITEM_ALLOW_EDGE_OVERLAPS));
            mISLabelingAlgorithm.setApplyPostprocessing(optionHandler.getBool(ITEM_USE_POSTPROCESSING));
            mISLabelingAlgorithm.setSelection(LABEL_SELECTION_DP_KEY);
            graph2D = this.getGraph2D();
            this.prepareGraph(graph2D, optionHandler);
            try {
                Graph2DView graph2DView = this.getGraph2DView();
                Graph2DLayoutExecutor graph2DLayoutExecutor = new Graph2DLayoutExecutor(0);
                if (graph2DView == null) {
                    graph2DLayoutExecutor.doLayout(graph2D, (Layouter)mISLabelingAlgorithm);
                    if (!YModule.z) break block6;
                }
                graph2DLayoutExecutor.doLayout(graph2DView, (Layouter)mISLabelingAlgorithm);
            }
            finally {
                this.restoreGraph(graph2D, optionHandler);
            }
        }
        graph2D.updateViews();
    }

    protected void prepareGraph(Graph2D graph2D, OptionHandler optionHandler) {
        _b _b2 = new _b(graph2D, optionHandler.getBool(ITEM_CONSIDER_SELECTED_FEATURES_ONLY), optionHandler.getBool(ITEM_PLACE_NODE_LABELS), optionHandler.getBool(ITEM_PLACE_EDGE_LABELS), optionHandler.getBool(ITEM_CONSIDER_INVISIBLE_LABELS));
        graph2D.addDataProvider(LABEL_SELECTION_DP_KEY, _b2);
        LabelingModule.b(graph2D, optionHandler.getString(ITEM_EDGE_LABEL_MODEL), _b2, optionHandler.getBool(ITEM_AUTO_ROTATE));
    }

    protected void restoreGraph(Graph2D graph2D, OptionHandler optionHandler) {
        graph2D.removeDataProvider(LABEL_SELECTION_DP_KEY);
    }

    private static void b(Graph2D graph2D, String string, DataProvider dataProvider, boolean bl) {
        byte by;
        boolean bl2;
        block10: {
            block15: {
                block14: {
                    block13: {
                        block12: {
                            block11: {
                                block9: {
                                    bl2 = YModule.z;
                                    if (VALUE_AS_IS.equals(string)) {
                                        return;
                                    }
                                    if (!VALUE_CENTERED.equals(string)) break block9;
                                    by = 1;
                                    if (!bl2) break block10;
                                }
                                if (!VALUE_TWO_POS.equals(string)) break block11;
                                by = 0;
                                if (!bl2) break block10;
                            }
                            if (!VALUE_SIX_POS.equals(string)) break block12;
                            by = 2;
                            if (!bl2) break block10;
                        }
                        if (!VALUE_THREE_CENTER.equals(string)) break block13;
                        by = 3;
                        if (!bl2) break block10;
                    }
                    if (!VALUE_CENTER_SLIDER.equals(string)) break block14;
                    by = 5;
                    if (!bl2) break block10;
                }
                if (!VALUE_SIDE_SLIDER.equals(string)) break block15;
                by = 6;
                if (!bl2) break block10;
            }
            by = 4;
        }
        EdgeLabelModel edgeLabelModel = null;
        if (bl) {
            edgeLabelModel = LabelingModule.b(by);
        }
        EdgeCursor edgeCursor = graph2D.edges();
        block0: while (true) {
            boolean bl3 = edgeCursor.ok();
            block1: while (bl3) {
                Edge edge = edgeCursor.edge();
                EdgeRealizer edgeRealizer = graph2D.getRealizer(edge);
                for (int i2 = 0; i2 < edgeRealizer.labelCount(); ++i2) {
                    EdgeLabel edgeLabel = edgeRealizer.getLabel(i2);
                    bl3 = dataProvider.getBool(edgeLabel);
                    if (bl2) continue block1;
                    if (!bl3) continue;
                    if (edgeLabelModel != null) {
                        edgeLabel.setLabelModel(edgeLabelModel, edgeLabelModel.getDefaultParameter());
                        if (!bl2) continue;
                    }
                    edgeLabel.setModel(by);
                    edgeLabel.setModelParameter(edgeLabel.getLabelModel().getDefaultParameter());
                    if (!bl2) continue;
                }
                edgeCursor.next();
                if (!bl2) continue block0;
            }
            break;
        }
    }

    private static EdgeLabelModel b(byte by) {
        EdgeLabelModel edgeLabelModel;
        block3: {
            block8: {
                boolean bl;
                block7: {
                    block6: {
                        block5: {
                            block4: {
                                block2: {
                                    bl = YModule.z;
                                    if (1 != by) break block2;
                                    edgeLabelModel = new RotatedDiscreteEdgeLabelModel(128);
                                    edgeLabelModel.setAutoRotationEnabled(true);
                                    if (!bl) break block3;
                                }
                                if (0 != by) break block4;
                                edgeLabelModel = new RotatedDiscreteEdgeLabelModel(18);
                                edgeLabelModel.setAutoRotationEnabled(true);
                                if (!bl) break block3;
                            }
                            if (2 != by) break block5;
                            edgeLabelModel = new RotatedDiscreteEdgeLabelModel(63);
                            edgeLabelModel.setAutoRotationEnabled(true);
                            if (!bl) break block3;
                        }
                        if (3 != by) break block6;
                        edgeLabelModel = new RotatedDiscreteEdgeLabelModel(448);
                        edgeLabelModel.setAutoRotationEnabled(true);
                        if (!bl) break block3;
                    }
                    if (5 != by) break block7;
                    edgeLabelModel = new RotatedSliderEdgeLabelModel(0);
                    ((RotatedSliderEdgeLabelModel)edgeLabelModel).setAutoRotationEnabled(true);
                    if (!bl) break block3;
                }
                if (6 != by) break block8;
                edgeLabelModel = new RotatedSliderEdgeLabelModel(1);
                ((RotatedSliderEdgeLabelModel)edgeLabelModel).setAutoRotationEnabled(true);
                if (!bl) break block3;
            }
            edgeLabelModel = null;
        }
        return edgeLabelModel;
    }

    static class _b
    extends DataProviderAdapter {
        private final boolean ic;
        private final Graph2D hc;
        private final boolean fc;
        private final boolean ec;
        private final boolean gc;

        _b(Graph2D graph2D, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
            this.ic = bl;
            this.hc = graph2D;
            this.fc = bl2;
            this.ec = bl3;
            this.gc = bl4;
        }

        public boolean getBool(Object object) {
            YLabel yLabel;
            YLabel yLabel2 = (YLabel)object;
            if (!yLabel2.isVisible() && !this.gc) {
                return false;
            }
            if (object instanceof NodeLabel && (yLabel = (NodeLabel)object).getModel() == 1) {
                return false;
            }
            if (this.ic) {
                if (object instanceof NodeLabel && this.fc) {
                    yLabel = (NodeLabel)object;
                    return this.hc.isSelected(((NodeLabel)yLabel).getNode());
                }
                if (object instanceof EdgeLabel && this.ec) {
                    yLabel = (EdgeLabel)object;
                    return this.hc.isSelected(((EdgeLabel)yLabel).getEdge());
                }
                return false;
            }
            if (object instanceof NodeLabel && this.fc) {
                return true;
            }
            return object instanceof EdgeLabel && this.ec;
        }
    }
}

