/*
 * Decompiled with CFR 0.152.
 */
package y.module;

import y.base.DataProvider;
import y.base.Edge;
import y.base.EdgeCursor;
import y.layout.AbstractLayoutStage;
import y.layout.ComponentLayouter;
import y.layout.CompositeLayoutStage;
import y.layout.LabelLayoutDataRefinement;
import y.layout.LabelLayoutTranslator;
import y.layout.LabelRanking;
import y.layout.LayoutStage;
import y.layout.PortConstraint;
import y.layout.PortConstraintKeys;
import y.layout.PreferredPlacementDescriptor;
import y.layout.grouping.FixedGroupLayoutStage;
import y.layout.grouping.GroupNodeHider;
import y.layout.hierarchic.BFSLayerer;
import y.layout.hierarchic.ClassicLayerSequencer;
import y.layout.hierarchic.HierarchicGroupLayouter;
import y.layout.hierarchic.LayerSequencer;
import y.layout.labeling.AbstractLabelingAlgorithm;
import y.layout.labeling.GreedyMISLabeling;
import y.module.LayoutModule;
import y.module.YModule;
import y.option.ConstraintManager;
import y.option.EnumOptionItem;
import y.option.OptionHandler;
import y.option.OptionItem;
import y.util.DataProviderAdapter;
import y.view.EdgeLabel;
import y.view.EdgeRealizer;
import y.view.Graph2D;
import y.view.Selections;
import y.view.SmartEdgeLabelModel;
import y.view.hierarchy.HierarchyManager;

public class HierarchicLayoutModule
extends LayoutModule {
    protected static final String MODULE_HIERARCHIC = "HIERARCHIC";
    protected static final String SECTION_LAYOUT = "LAYOUT";
    protected static final String ITEM_MINIMAL_LAYER_DISTANCE = "MINIMAL_LAYER_DISTANCE";
    protected static final String ITEM_MINIMAL_NODE_DISTANCE = "MINIMAL_NODE_DISTANCE";
    protected static final String ITEM_MINIMAL_EDGE_DISTANCE = "MINIMAL_EDGE_DISTANCE";
    protected static final String ITEM_MINIMAL_FIRST_SEGMENT_LENGTH = "MINIMAL_FIRST_SEGMENT_LENGTH";
    protected static final String ITEM_MAXIMAL_DURATION = "MAXIMAL_DURATION";
    protected static final String ITEM_ORIENTATION = "ORIENTATION";
    protected static final String VALUE_TOP_TO_BOTTOM = "TOP_TO_BOTTOM";
    protected static final String VALUE_LEFT_TO_RIGHT = "LEFT_TO_RIGHT";
    protected static final String VALUE_BOTTOM_TO_TOP = "BOTTOM_TO_TOP";
    protected static final String VALUE_RIGHT_TO_LEFT = "RIGHT_TO_LEFT";
    protected static final String ITEM_NODE_PLACEMENT = "NODE_PLACEMENT";
    protected static final String VALUE_PENDULUM = "PENDULUM";
    protected static final String VALUE_LINEAR_SEGMENTS = "LINEAR_SEGMENTS";
    protected static final String VALUE_POLYLINE = "POLYLINE";
    protected static final String VALUE_TREE = "TREE";
    protected static final String VALUE_SIMPLEX = "SIMPLEX";
    protected static final String VALUE_MEDIAN_SIMPLEX = "MEDIAN_SIMPLEX";
    protected static final String ITEM_EDGE_ROUTING = "EDGE_ROUTING";
    protected static final String VALUE_POLYLINE_EDGE = "POLYLINE";
    protected static final String VALUE_ORTHOGONAL = "ORTHOGONAL";
    protected static final String ITEM_BACKLOOP_ROUTING = "BACKLOOP_ROUTING";
    protected static final String ITEM_ACT_ON_SELECTION_ONLY = "ACT_ON_SELECTION_ONLY";
    protected static final String SECTION_NODE_RANK = "NODE_RANK";
    protected static final String ITEM_RANKING_POLICY = "RANKING_POLICY";
    protected static final String VALUE_NO_RERANKING = "NO_RERANKING";
    protected static final String VALUE_DOWNSHIFT_NODES = "DOWNSHIFT_NODES";
    protected static final String VALUE_TIGHT_TREE = "TIGHT_TREE";
    protected static final String VALUE_SIMPLEX_RANK = "SIMPLEX";
    protected static final String VALUE_AS_IS_RANK = "AS_IS";
    protected static final String VALUE_BFS = "BFS";
    protected static final String SECTION_NODE_ORDER = "NODE_ORDER";
    protected static final String ITEM_WEIGHT_HEURISTIC = "WEIGHT_HEURISTIC";
    protected static final String VALUE_BARYCENTER = "BARYCENTER";
    protected static final String VALUE_MEDIAN = "MEDIAN";
    protected static final String ITEM_USE_TRANSPOSITION = "USE_TRANSPOSITION";
    protected static final String ITEM_REMOVE_FALSE_CROSSINGS = "REMOVE_FALSE_CROSSINGS";
    protected static final String ITEM_RANDOMIZATION_ROUNDS = "RANDOMIZATION_ROUNDS";
    protected static final String SECTION_LABELING = "LABELING";
    protected static final String ITEM_EDGE_LABELING = "EDGE_LABELING";
    protected static final String VALUE_NONE = "NONE";
    protected static final String VALUE_HIERARCHIC = "HIERARCHIC";
    protected static final String VALUE_GENERIC = "GENERIC";
    protected static final String ITEM_EDGE_LABEL_MODEL = "EDGE_LABEL_MODEL";
    protected static final String VALUE_BEST = "BEST";
    protected static final String VALUE_AS_IS = "AS_IS";
    protected static final String VALUE_CENTER_SLIDER = "CENTER_SLIDER";
    protected static final String VALUE_SIDE_SLIDER = "SIDE_SLIDER";
    protected static final String VALUE_FREE = "FREE";
    protected static final String SECTION_GROUPING = "GROUPING";
    protected static final String ITEM_GROUP_POLICY = "GROUP_LAYOUT_POLICY";
    protected static final String VALUE_LAYOUT_GROUPS = "LAYOUT_GROUPS";
    protected static final String VALUE_FIX_GROUPS = "FIX_GROUPS";
    protected static final String VALUE_IGNORE_GROUPS = "IGNORE_GROUPS";
    protected static final String ITEM_ENABLE_GLOBAL_SEQUENCING = "ENABLE_GLOBAL_SEQUENCING";

    public HierarchicLayoutModule() {
        super("HIERARCHIC");
        this.setPortIntersectionCalculatorEnabled(true);
    }

    protected OptionHandler createOptionHandler() {
        OptionHandler optionHandler = new OptionHandler(this.getModuleName());
        ConstraintManager constraintManager = new ConstraintManager(optionHandler);
        HierarchicGroupLayouter hierarchicGroupLayouter = new HierarchicGroupLayouter();
        ClassicLayerSequencer classicLayerSequencer = (ClassicLayerSequencer)hierarchicGroupLayouter.getLayerSequencer();
        optionHandler.useSection(SECTION_LAYOUT);
        optionHandler.addInt(ITEM_MINIMAL_LAYER_DISTANCE, (int)hierarchicGroupLayouter.getMinimalLayerDistance());
        optionHandler.addInt(ITEM_MINIMAL_NODE_DISTANCE, (int)hierarchicGroupLayouter.getMinimalNodeDistance());
        optionHandler.addInt(ITEM_MINIMAL_EDGE_DISTANCE, (int)hierarchicGroupLayouter.getMinimalEdgeDistance());
        optionHandler.addInt(ITEM_MINIMAL_FIRST_SEGMENT_LENGTH, (int)hierarchicGroupLayouter.getMinimalFirstSegmentLength());
        optionHandler.addInt(ITEM_MAXIMAL_DURATION, 5);
        optionHandler.addEnum(ITEM_ORIENTATION, new String[]{VALUE_TOP_TO_BOTTOM, VALUE_LEFT_TO_RIGHT, VALUE_BOTTOM_TO_TOP, VALUE_RIGHT_TO_LEFT}, 0);
        optionHandler.addEnum(ITEM_NODE_PLACEMENT, new String[]{VALUE_PENDULUM, VALUE_LINEAR_SEGMENTS, "POLYLINE", VALUE_TREE, "SIMPLEX", VALUE_MEDIAN_SIMPLEX}, hierarchicGroupLayouter.getLayoutStyle());
        optionHandler.addEnum(ITEM_EDGE_ROUTING, new String[]{"POLYLINE", VALUE_ORTHOGONAL}, hierarchicGroupLayouter.getRoutingStyle());
        optionHandler.addBool(ITEM_BACKLOOP_ROUTING, false);
        optionHandler.addBool(ITEM_ACT_ON_SELECTION_ONLY, false);
        optionHandler.useSection(SECTION_NODE_RANK);
        optionHandler.addEnum(ITEM_RANKING_POLICY, new String[]{VALUE_NO_RERANKING, VALUE_DOWNSHIFT_NODES, VALUE_TIGHT_TREE, "SIMPLEX", "AS_IS", VALUE_BFS}, 2);
        optionHandler.useSection(SECTION_NODE_ORDER);
        optionHandler.addEnum(ITEM_WEIGHT_HEURISTIC, new String[]{VALUE_BARYCENTER, VALUE_MEDIAN}, classicLayerSequencer.getWeightHeuristic());
        optionHandler.addBool(ITEM_USE_TRANSPOSITION, classicLayerSequencer.getUseTransposition());
        optionHandler.addBool(ITEM_REMOVE_FALSE_CROSSINGS, hierarchicGroupLayouter.getRemoveFalseCrossings());
        optionHandler.addInt(ITEM_RANDOMIZATION_ROUNDS, classicLayerSequencer.getRandomizationRounds());
        optionHandler.useSection(SECTION_LABELING);
        EnumOptionItem enumOptionItem = optionHandler.addEnum(ITEM_EDGE_LABELING, new String[]{VALUE_NONE, "HIERARCHIC", VALUE_GENERIC}, 0);
        EnumOptionItem enumOptionItem2 = optionHandler.addEnum(ITEM_EDGE_LABEL_MODEL, new String[]{VALUE_BEST, "AS_IS", VALUE_CENTER_SLIDER, VALUE_SIDE_SLIDER, VALUE_FREE}, 0);
        constraintManager.setEnabledOnValueEquals((OptionItem)enumOptionItem, (Object)VALUE_NONE, enumOptionItem2, true);
        optionHandler.useSection(SECTION_GROUPING);
        optionHandler.addEnum(ITEM_GROUP_POLICY, new String[]{VALUE_LAYOUT_GROUPS, VALUE_FIX_GROUPS, VALUE_IGNORE_GROUPS}, 0);
        optionHandler.addBool(ITEM_ENABLE_GLOBAL_SEQUENCING, true);
        return optionHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void mainrun() {
        HierarchicGroupLayouter hierarchicGroupLayouter = new HierarchicGroupLayouter();
        OptionHandler optionHandler = this.getOptionHandler();
        this.configure(hierarchicGroupLayouter, optionHandler);
        Graph2D graph2D = this.getGraph2D();
        this.prepareGraph(graph2D, optionHandler);
        try {
            this.launchLayouter(hierarchicGroupLayouter);
        }
        finally {
            this.restoreGraph(graph2D, optionHandler);
        }
    }

    protected void prepareGraph(Graph2D graph2D, OptionHandler optionHandler) {
        String string = optionHandler.getString(ITEM_EDGE_LABELING);
        if (!string.equals(VALUE_NONE)) {
            this.d(graph2D, string, optionHandler.getString(ITEM_EDGE_LABEL_MODEL));
        }
        if (optionHandler.getString(ITEM_RANKING_POLICY).equals(VALUE_BFS)) {
            this.backupDataProvider(graph2D, BFSLayerer.CORE_NODES);
            graph2D.addDataProvider(BFSLayerer.CORE_NODES, Selections.createSelectionNodeMap(graph2D));
        }
        if (optionHandler.getBool(ITEM_BACKLOOP_ROUTING)) {
            DataProvider dataProvider = graph2D.getDataProvider(PortConstraintKeys.SOURCE_PORT_CONSTRAINT_KEY);
            DataProvider dataProvider2 = graph2D.getDataProvider(PortConstraintKeys.TARGET_PORT_CONSTRAINT_KEY);
            PortConstraint portConstraint = null;
            PortConstraint portConstraint2 = null;
            if (optionHandler.get(ITEM_ORIENTATION).equals(VALUE_TOP_TO_BOTTOM)) {
                portConstraint = PortConstraint.create((byte)2);
                portConstraint2 = PortConstraint.create((byte)1);
            } else if (optionHandler.get(ITEM_ORIENTATION).equals(VALUE_LEFT_TO_RIGHT)) {
                portConstraint = PortConstraint.create((byte)4);
                portConstraint2 = PortConstraint.create((byte)8);
            } else if (optionHandler.get(ITEM_ORIENTATION).equals(VALUE_BOTTOM_TO_TOP)) {
                portConstraint = PortConstraint.create((byte)1);
                portConstraint2 = PortConstraint.create((byte)2);
            } else if (optionHandler.get(ITEM_ORIENTATION).equals(VALUE_RIGHT_TO_LEFT)) {
                portConstraint = PortConstraint.create((byte)8);
                portConstraint2 = PortConstraint.create((byte)4);
            }
            _b _b2 = new _b(portConstraint, dataProvider);
            _b _b3 = new _b(portConstraint2, dataProvider2);
            graph2D.addDataProvider(PortConstraintKeys.SOURCE_PORT_CONSTRAINT_KEY, _b2);
            graph2D.addDataProvider(PortConstraintKeys.TARGET_PORT_CONSTRAINT_KEY, _b3);
        }
    }

    protected void restoreGraph(Graph2D graph2D, OptionHandler optionHandler) {
        block7: {
            block10: {
                DataProvider dataProvider;
                _b _b2;
                boolean bl;
                block9: {
                    block8: {
                        bl = YModule.z;
                        if (!optionHandler.getBool(ITEM_BACKLOOP_ROUTING)) break block7;
                        _b _b3 = (_b)graph2D.getDataProvider(PortConstraintKeys.SOURCE_PORT_CONSTRAINT_KEY);
                        _b2 = (_b)graph2D.getDataProvider(PortConstraintKeys.TARGET_PORT_CONSTRAINT_KEY);
                        DataProvider dataProvider2 = _b3.dc;
                        if (dataProvider2 == null) break block8;
                        graph2D.addDataProvider(PortConstraintKeys.SOURCE_PORT_CONSTRAINT_KEY, dataProvider2);
                        if (!bl) break block9;
                    }
                    graph2D.removeDataProvider(PortConstraintKeys.SOURCE_PORT_CONSTRAINT_KEY);
                }
                if ((dataProvider = _b2.dc) == null) break block10;
                graph2D.addDataProvider(PortConstraintKeys.TARGET_PORT_CONSTRAINT_KEY, dataProvider);
                if (!bl) break block7;
            }
            graph2D.removeDataProvider(PortConstraintKeys.TARGET_PORT_CONSTRAINT_KEY);
        }
        if (optionHandler.getString(ITEM_RANKING_POLICY).equals(VALUE_BFS)) {
            this.restoreDataProvider(graph2D, BFSLayerer.CORE_NODES);
        }
    }

    protected void configure(HierarchicGroupLayouter hierarchicGroupLayouter, OptionHandler optionHandler) {
        block45: {
            Object object;
            block46: {
                boolean bl;
                block42: {
                    block44: {
                        block43: {
                            block37: {
                                String string;
                                block41: {
                                    block40: {
                                        block39: {
                                            block38: {
                                                block36: {
                                                    block35: {
                                                        String string2;
                                                        block34: {
                                                            block29: {
                                                                String string3;
                                                                block33: {
                                                                    block32: {
                                                                        block31: {
                                                                            block30: {
                                                                                block28: {
                                                                                    block25: {
                                                                                        block27: {
                                                                                            block26: {
                                                                                                block24: {
                                                                                                    bl = YModule.z;
                                                                                                    ((ComponentLayouter)hierarchicGroupLayouter.getComponentLayouter()).setStyle((byte)8);
                                                                                                    hierarchicGroupLayouter.setRemoveFalseCrossings(optionHandler.getBool(ITEM_REMOVE_FALSE_CROSSINGS));
                                                                                                    hierarchicGroupLayouter.setMaximalDuration(optionHandler.getInt(ITEM_MAXIMAL_DURATION) * 1000);
                                                                                                    hierarchicGroupLayouter.setMinimalNodeDistance(optionHandler.getInt(ITEM_MINIMAL_NODE_DISTANCE));
                                                                                                    hierarchicGroupLayouter.setMinimalEdgeDistance(optionHandler.getInt(ITEM_MINIMAL_EDGE_DISTANCE));
                                                                                                    hierarchicGroupLayouter.setMinimalFirstSegmentLength(optionHandler.getInt(ITEM_MINIMAL_FIRST_SEGMENT_LENGTH));
                                                                                                    hierarchicGroupLayouter.setMinimalLayerDistance(optionHandler.getInt(ITEM_MINIMAL_LAYER_DISTANCE));
                                                                                                    if (!optionHandler.get(ITEM_ORIENTATION).equals(VALUE_TOP_TO_BOTTOM)) break block24;
                                                                                                    hierarchicGroupLayouter.setLayoutOrientation((byte)0);
                                                                                                    if (!bl) break block25;
                                                                                                }
                                                                                                if (!optionHandler.get(ITEM_ORIENTATION).equals(VALUE_LEFT_TO_RIGHT)) break block26;
                                                                                                hierarchicGroupLayouter.setLayoutOrientation((byte)1);
                                                                                                if (!bl) break block25;
                                                                                            }
                                                                                            if (!optionHandler.get(ITEM_ORIENTATION).equals(VALUE_BOTTOM_TO_TOP)) break block27;
                                                                                            hierarchicGroupLayouter.setLayoutOrientation((byte)2);
                                                                                            if (!bl) break block25;
                                                                                        }
                                                                                        if (optionHandler.get(ITEM_ORIENTATION).equals(VALUE_RIGHT_TO_LEFT)) {
                                                                                            hierarchicGroupLayouter.setLayoutOrientation((byte)3);
                                                                                        }
                                                                                    }
                                                                                    hierarchicGroupLayouter.setGlobalSequencingActive(optionHandler.getBool(SECTION_GROUPING, ITEM_ENABLE_GLOBAL_SEQUENCING));
                                                                                    this.b(hierarchicGroupLayouter, optionHandler);
                                                                                    string3 = optionHandler.getString(ITEM_NODE_PLACEMENT);
                                                                                    if (!string3.equals(VALUE_PENDULUM)) break block28;
                                                                                    hierarchicGroupLayouter.setLayoutStyle((byte)0);
                                                                                    if (!bl) break block29;
                                                                                }
                                                                                if (!string3.equals("POLYLINE")) break block30;
                                                                                hierarchicGroupLayouter.setLayoutStyle((byte)2);
                                                                                if (!bl) break block29;
                                                                            }
                                                                            if (!string3.equals(VALUE_LINEAR_SEGMENTS)) break block31;
                                                                            hierarchicGroupLayouter.setLayoutStyle((byte)1);
                                                                            if (!bl) break block29;
                                                                        }
                                                                        if (!string3.equals(VALUE_TREE)) break block32;
                                                                        hierarchicGroupLayouter.setLayoutStyle((byte)3);
                                                                        if (!bl) break block29;
                                                                    }
                                                                    if (!string3.equals("SIMPLEX")) break block33;
                                                                    hierarchicGroupLayouter.setLayoutStyle((byte)4);
                                                                    if (!bl) break block29;
                                                                }
                                                                if (string3.equals(VALUE_MEDIAN_SIMPLEX)) {
                                                                    hierarchicGroupLayouter.setLayoutStyle((byte)5);
                                                                }
                                                            }
                                                            if (!(string2 = optionHandler.getString(ITEM_EDGE_ROUTING)).equals("POLYLINE")) break block34;
                                                            hierarchicGroupLayouter.setRoutingStyle((byte)0);
                                                            if (!bl) break block35;
                                                        }
                                                        if (string2.equals(VALUE_ORTHOGONAL)) {
                                                            hierarchicGroupLayouter.setRoutingStyle((byte)1);
                                                        }
                                                    }
                                                    hierarchicGroupLayouter.setSubgraphLayouterEnabled(optionHandler.getBool(ITEM_ACT_ON_SELECTION_ONLY));
                                                    string = optionHandler.getString(ITEM_RANKING_POLICY);
                                                    if (!string.equals("AS_IS")) break block36;
                                                    hierarchicGroupLayouter.setLayeringStrategy((byte)5);
                                                    if (!bl) break block37;
                                                }
                                                if (!string.equals("SIMPLEX")) break block38;
                                                hierarchicGroupLayouter.setLayeringStrategy((byte)1);
                                                if (!bl) break block37;
                                            }
                                            if (!string.equals(VALUE_NO_RERANKING)) break block39;
                                            hierarchicGroupLayouter.setLayeringStrategy((byte)0);
                                            if (!bl) break block37;
                                        }
                                        if (!string.equals(VALUE_DOWNSHIFT_NODES)) break block40;
                                        hierarchicGroupLayouter.setLayeringStrategy((byte)3);
                                        if (!bl) break block37;
                                    }
                                    if (!string.equals(VALUE_TIGHT_TREE)) break block41;
                                    hierarchicGroupLayouter.setLayeringStrategy((byte)2);
                                    if (!bl) break block37;
                                }
                                if (string.equals(VALUE_BFS)) {
                                    hierarchicGroupLayouter.setLayeringStrategy((byte)4);
                                }
                            }
                            String string = optionHandler.getString(ITEM_WEIGHT_HEURISTIC);
                            LayerSequencer layerSequencer = hierarchicGroupLayouter.getLayerSequencer();
                            if (!(layerSequencer instanceof ClassicLayerSequencer)) break block42;
                            object = (ClassicLayerSequencer)layerSequencer;
                            if (!string.equals(VALUE_MEDIAN)) break block43;
                            ((ClassicLayerSequencer)object).setWeightHeuristic((byte)1);
                            if (!bl) break block44;
                        }
                        ((ClassicLayerSequencer)object).setWeightHeuristic((byte)0);
                    }
                    ((ClassicLayerSequencer)object).setUseTransposition(optionHandler.getBool(ITEM_USE_TRANSPOSITION));
                    ((ClassicLayerSequencer)object).setRandomizationRounds(optionHandler.getInt(SECTION_NODE_ORDER, ITEM_RANDOMIZATION_ROUNDS));
                    hierarchicGroupLayouter.setLayerSequencer((LayerSequencer)object);
                }
                if (!HierarchyManager.containsGroupNodes(this.getGraph2D())) break block45;
                if (!optionHandler.get(ITEM_GROUP_POLICY).equals(VALUE_IGNORE_GROUPS)) break block46;
                hierarchicGroupLayouter.prependStage(new GroupNodeHider());
                if (!bl) break block45;
            }
            if (optionHandler.get(ITEM_GROUP_POLICY).equals(VALUE_FIX_GROUPS)) {
                object = new FixedGroupLayoutStage();
                if (optionHandler.get(ITEM_EDGE_ROUTING).equals(VALUE_ORTHOGONAL)) {
                    ((FixedGroupLayoutStage)object).setInterEdgeRoutingStyle((byte)3);
                }
                hierarchicGroupLayouter.prependStage((LayoutStage)object);
            }
        }
    }

    private void b(HierarchicGroupLayouter hierarchicGroupLayouter, OptionHandler optionHandler) {
        block4: {
            block2: {
                AbstractLayoutStage abstractLayoutStage;
                String string;
                boolean bl;
                block3: {
                    bl = YModule.z;
                    string = optionHandler.getString(ITEM_EDGE_LABELING);
                    if (string.equals(VALUE_NONE)) break block2;
                    if (!string.equals(VALUE_GENERIC)) break block3;
                    abstractLayoutStage = new GreedyMISLabeling();
                    ((AbstractLabelingAlgorithm)abstractLayoutStage).setPlaceNodeLabels(false);
                    ((AbstractLabelingAlgorithm)abstractLayoutStage).setPlaceEdgeLabels(true);
                    ((AbstractLabelingAlgorithm)abstractLayoutStage).setAutoFlippingEnabled(true);
                    ((AbstractLabelingAlgorithm)abstractLayoutStage).setProfitModel(new LabelRanking());
                    hierarchicGroupLayouter.setLabelLayouter(abstractLayoutStage);
                    hierarchicGroupLayouter.setLabelLayouterEnabled(true);
                    if (!bl) break block4;
                }
                if (!string.equals("HIERARCHIC")) break block4;
                abstractLayoutStage = new CompositeLayoutStage();
                ((CompositeLayoutStage)abstractLayoutStage).appendStage(new LabelLayoutTranslator());
                ((CompositeLayoutStage)abstractLayoutStage).appendStage(new LabelLayoutDataRefinement());
                hierarchicGroupLayouter.setLabelLayouter(abstractLayoutStage);
                hierarchicGroupLayouter.setLabelLayouterEnabled(true);
                if (!bl) break block4;
            }
            hierarchicGroupLayouter.setLabelLayouterEnabled(false);
        }
    }

    private void d(Graph2D graph2D, String string, String string2) {
        byte by;
        int n2;
        boolean bl;
        block16: {
            block15: {
                block13: {
                    block14: {
                        bl = YModule.z;
                        if (string.equals(VALUE_NONE) || string2.equals("AS_IS")) {
                            return;
                        }
                        if (!string2.equals(VALUE_BEST)) break block13;
                        if (!string.equals(VALUE_GENERIC)) break block14;
                        string2 = VALUE_SIDE_SLIDER;
                        if (!bl) break block13;
                    }
                    if (string.equals("HIERARCHIC")) {
                        string2 = VALUE_FREE;
                    }
                }
                n2 = 6;
                by = 32;
                if (!string2.equals(VALUE_CENTER_SLIDER)) break block15;
                n2 = 5;
                by = 8;
                if (!bl) break block16;
            }
            if (string2.equals(VALUE_FREE)) {
                n2 = 4;
                by = 8;
            }
        }
        EdgeCursor edgeCursor = graph2D.edges();
        while (edgeCursor.ok()) {
            Edge edge = edgeCursor.edge();
            EdgeRealizer edgeRealizer = graph2D.getRealizer(edge);
            int n3 = 0;
            block1: while (true) {
                int n4 = n3;
                int n5 = edgeRealizer.labelCount();
                while (n4 < n5) {
                    EdgeLabel edgeLabel = edgeRealizer.getLabel(n3);
                    n4 = 4;
                    n5 = n2;
                    if (bl) continue;
                    if (n4 != n5 || !(edgeLabel.getLabelModel() instanceof SmartEdgeLabelModel)) {
                        edgeLabel.setModel((byte)n2);
                    }
                    HierarchicLayoutModule.d(edgeLabel, by);
                    ++n3;
                    if (!bl) continue block1;
                }
                break;
            }
            edgeCursor.next();
            if (!bl) continue;
        }
    }

    private static void d(EdgeLabel edgeLabel, byte by) {
        PreferredPlacementDescriptor preferredPlacementDescriptor = edgeLabel.getPreferredPlacementDescriptor();
        if (preferredPlacementDescriptor.getSideOfEdge() != by) {
            PreferredPlacementDescriptor preferredPlacementDescriptor2 = new PreferredPlacementDescriptor(preferredPlacementDescriptor);
            preferredPlacementDescriptor2.setSideOfEdge(by);
            edgeLabel.setPreferredPlacementDescriptor(preferredPlacementDescriptor2);
        }
    }

    static final class _b
    extends DataProviderAdapter {
        private final PortConstraint cc;
        private final DataProvider dc;
        private static final PortConstraint bc = PortConstraint.create((byte)0);

        _b(PortConstraint portConstraint, DataProvider dataProvider) {
            this.cc = portConstraint;
            this.dc = dataProvider;
        }

        public Object get(Object object) {
            Object object2;
            if (this.dc != null && (object2 = this.dc.get(object)) != null) {
                return object2;
            }
            object2 = (Edge)object;
            if (((Edge)object2).isSelfLoop()) {
                return bc;
            }
            return this.cc;
        }
    }
}

