/*
 * Decompiled with CFR 0.152.
 */
package y.module;

import java.awt.Color;
import y.base.Node;
import y.layout.ComponentLayouter;
import y.layout.genealogy.FamilyTreeLayouter;
import y.layout.hierarchic.IncrementalHierarchicLayouter;
import y.layout.hierarchic.incremental.EdgeLayoutDescriptor;
import y.layout.hierarchic.incremental.NodeLayoutDescriptor;
import y.layout.hierarchic.incremental.RoutingStyle;
import y.layout.hierarchic.incremental.SimplexNodePlacer;
import y.module.LayoutModule;
import y.module.YModule;
import y.option.ConstraintManager;
import y.option.OptionGroup;
import y.option.OptionHandler;
import y.option.OptionItem;
import y.util.DataProviderAdapter;
import y.view.Graph2D;
import y.view.NodeRealizer;

public class FamilyTreeLayoutModule
extends LayoutModule {
    protected static final String MODULE_FAMILY_TREE_LAYOUTER = "FAMILY_TREE_LAYOUTER";
    protected static final String SECTION_FAMILY_PROPERTIES = "FAMILY_PROPERTIES";
    protected static final String ITEM_FAMILY_COLOR = "FAMILY_COLOR";
    protected static final String ITEM_MALE_COLOR = "MALE_COLOR";
    protected static final String ITEM_FEMALE_COLOR = "FEMALE_COLOR";
    protected static final String SECTION_LAYOUT = "LAYOUT";
    protected static final String ITEM_ORIENTATION = "ORIENTATION";
    protected static final String VALUE_TOP_TO_BOTTOM = "TOP_TO_BOTTOM";
    protected static final String VALUE_LEFT_TO_RIGHT = "LEFT_TO_RIGHT";
    protected static final String VALUE_BOTTOM_TO_TOP = "BOTTOM_TO_TOP";
    protected static final String VALUE_RIGHT_TO_LEFT = "RIGHT_TO_LEFT";
    protected static final String ITEM_SINGLE_DIRECT_BELOW = "SINGLE_DIRECT_BELOW";
    protected static final String ITEM_FAMILIES_ALWAYS_BELOW = "FAMILIES_ALWAYS_BELOW";
    protected static final String ITEM_NODE_ALIGNMENT = "NODE_ALIGNMENT";
    protected static final String VALUE_NODE_ALIGN_TOP = "NODE_ALIGN_TOP";
    protected static final String VALUE_NODE_ALIGN_CENTER = "NODE_ALIGN_CENTER";
    protected static final String VALUE_NODE_ALIGN_BOTTOM = "NODE_ALIGN_BOTTOM";
    protected static final String ITEM_SORT_BY_SEX = "SORT_BY_SEX";
    protected static final String VALUE_DO_NOT_SORT = "DO_NOT_SORT";
    protected static final String VALUE_FEMALE_LEFT = "FEMALE_LEFT";
    protected static final String VALUE_FEMALE_ALWAYS_LEFT = "FEMALE_ALWAYS_LEFT";
    protected static final String VALUE_MALE_LEFT = "MALE_LEFT";
    protected static final String VALUE_MALE_ALWAYS_LEFT = "MALE_ALWAYS_LEFT";
    protected static final String SECTION_DISTANCES = "DISTANCES";
    protected static final String TITLE_SIBLING_DISTANCES = "SIBLING_DISTANCES";
    protected static final String ITEM_HORIZONTAL_SPACING = "HORIZONTAL_SPACING";
    protected static final String ITEM_NODE_TO_NODE_DISTANCE = "NODE_TO_NODE_DISTANCE";
    protected static final String TITLE_GENERATION_DISTANCES = "GENERATION_DISTANCES";
    protected static final String ITEM_VERTICAL_SPACING = "VERTICAL_SPACING";
    protected static final String ITEM_MINIMUM_LAYER_DISTANCE = "MINIMUM_LAYER_DISTANCE";
    protected static final String ITEM_MINIMUM_FIRST_SEGMENT = "MINIMUM_FIRST_SEGMENT";
    protected static final String ITEM_MINIMUM_LAST_SEGMENT = "MINIMUM_LAST_SEGMENT";
    protected static final String SECTION_ADVANCED_LAYOUT = "ADVANCED_LAYOUT";
    protected static final String ITEM_USE_COMPONENT_LAYOUTER = "USE_COMPONENT_LAYOUTER";
    protected static final String TITLE_COMPONENT_LAYOUTER = "COMPONENT_LAYOUTER";
    protected static final String ITEM_COMPONENT_DISTANCE = "COMPONENT_DISTANCE";
    protected static final String ITEM_COMPONENT_STYLE = "COMPONENT_STYLE";
    protected static final String VALUE_COMPONENT_STYLE_NONE = "COMPONENT_STYLE_NONE";
    protected static final String VALUE_COMPONENT_STYLE_ROWS = "COMPONENT_STYLE_ROWS";
    protected static final String VALUE_COMPONENT_STYLE_SINGLE_ROW = "COMPONENT_STYLE_SINGLE_ROW";
    protected static final String VALUE_COMPONENT_STYLE_SINGLE_COLUMN = "COMPONENT_STYLE_SINGLE_COLUMN";
    protected static final String VALUE_COMPONENT_STYLE_PACKED_RECTANGLE = "COMPONENT_STYLE_PACKED_RECTANGLE";
    protected static final String VALUE_COMPONENT_STYLE_PACKED_COMPACT_RECTANGLE = "COMPONENT_STYLE_PACKED_COMPACT_RECTANGLE";
    protected static final String VALUE_COMPONENT_STYLE_PACKED_CIRCLE = "COMPONENT_STYLE_PACKED_CIRCLE";
    protected static final String VALUE_COMPONENT_STYLE_PACKED_COMPACT_CIRCLE = "COMPONENT_STYLE_PACKED_COMPACT_CIRCLE";
    private boolean pc = false;

    public FamilyTreeLayoutModule() {
        super(MODULE_FAMILY_TREE_LAYOUTER);
    }

    protected OptionHandler createOptionHandler() {
        OptionHandler optionHandler = new OptionHandler(this.getModuleName());
        ConstraintManager constraintManager = new ConstraintManager(optionHandler);
        optionHandler.useSection(SECTION_FAMILY_PROPERTIES);
        optionHandler.addColor(ITEM_FAMILY_COLOR, Color.black, true);
        optionHandler.addColor(ITEM_MALE_COLOR, new Color(0xFFCC99), true);
        optionHandler.addColor(ITEM_FEMALE_COLOR, new Color(0xCCCCFF), true);
        optionHandler.useSection(SECTION_LAYOUT);
        optionHandler.addEnum(ITEM_ORIENTATION, new String[]{VALUE_TOP_TO_BOTTOM, VALUE_LEFT_TO_RIGHT, VALUE_BOTTOM_TO_TOP, VALUE_RIGHT_TO_LEFT}, 0);
        optionHandler.addBool(ITEM_SINGLE_DIRECT_BELOW, true);
        optionHandler.addBool(ITEM_FAMILIES_ALWAYS_BELOW, false);
        optionHandler.addEnum(ITEM_NODE_ALIGNMENT, new String[]{VALUE_NODE_ALIGN_TOP, VALUE_NODE_ALIGN_CENTER, VALUE_NODE_ALIGN_BOTTOM}, 0);
        optionHandler.addEnum(ITEM_SORT_BY_SEX, new String[]{VALUE_DO_NOT_SORT, VALUE_FEMALE_LEFT, VALUE_FEMALE_ALWAYS_LEFT, VALUE_MALE_LEFT, VALUE_MALE_ALWAYS_LEFT}, 0);
        optionHandler.useSection(SECTION_DISTANCES);
        OptionGroup optionGroup = new OptionGroup();
        optionGroup.setAttribute("OptionGroup.title", TITLE_SIBLING_DISTANCES);
        optionGroup.addItem(optionHandler.addDouble(ITEM_HORIZONTAL_SPACING, 40.0, 0.0, 400.0));
        optionGroup.addItem(optionHandler.addDouble(ITEM_NODE_TO_NODE_DISTANCE, 40.0, 0.0, 400.0));
        OptionGroup optionGroup2 = new OptionGroup();
        optionGroup2.setAttribute("OptionGroup.title", TITLE_GENERATION_DISTANCES);
        optionGroup2.addItem(optionHandler.addDouble(ITEM_VERTICAL_SPACING, 10.0, 0.0, 100.0));
        optionGroup2.addItem(optionHandler.addDouble(ITEM_MINIMUM_LAYER_DISTANCE, 40.0, 0.0, 400.0));
        optionGroup2.addItem(optionHandler.addDouble(ITEM_MINIMUM_FIRST_SEGMENT, 40.0, 0.0, 400.0));
        optionGroup2.addItem(optionHandler.addDouble(ITEM_MINIMUM_LAST_SEGMENT, 20.0, 0.0, 400.0));
        optionHandler.useSection(SECTION_ADVANCED_LAYOUT);
        OptionItem optionItem = optionHandler.addBool(ITEM_USE_COMPONENT_LAYOUTER, true);
        OptionGroup optionGroup3 = new OptionGroup();
        optionGroup3.setAttribute("OptionGroup.title", TITLE_COMPONENT_LAYOUTER);
        OptionItem optionItem2 = optionGroup3.addItem(optionHandler.addInt(ITEM_COMPONENT_DISTANCE, 40));
        optionGroup3.addItem(optionHandler.addEnum(ITEM_COMPONENT_STYLE, new String[]{VALUE_COMPONENT_STYLE_NONE, VALUE_COMPONENT_STYLE_ROWS, VALUE_COMPONENT_STYLE_SINGLE_ROW, VALUE_COMPONENT_STYLE_SINGLE_COLUMN, VALUE_COMPONENT_STYLE_PACKED_RECTANGLE, VALUE_COMPONENT_STYLE_PACKED_COMPACT_RECTANGLE, VALUE_COMPONENT_STYLE_PACKED_CIRCLE, VALUE_COMPONENT_STYLE_PACKED_COMPACT_CIRCLE}, 1));
        constraintManager.setEnabledOnValueEquals(optionItem, (Object)Boolean.TRUE, optionItem2);
        return optionHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void mainrun() {
        FamilyTreeLayouter familyTreeLayouter = new FamilyTreeLayouter();
        OptionHandler optionHandler = this.getOptionHandler();
        this.configure(familyTreeLayouter, optionHandler);
        Graph2D graph2D = this.getGraph2D();
        this.prepareGraph(graph2D, optionHandler);
        try {
            this.launchLayouter(familyTreeLayouter);
        }
        finally {
            this.restoreGraph(graph2D, optionHandler);
        }
    }

    protected void prepareGraph(final Graph2D graph2D, final OptionHandler optionHandler) {
        boolean bl = this.pc = graph2D.getDataProvider("y.layout.genealogy.FamilyTreeLayouter.DP_KEY_FAMILY_TYPE") == null;
        if (this.pc) {
            graph2D.addDataProvider("y.layout.genealogy.FamilyTreeLayouter.DP_KEY_FAMILY_TYPE", new DataProviderAdapter(){

                public Object get(Object object) {
                    NodeRealizer nodeRealizer = graph2D.getRealizer((Node)object);
                    Color color = nodeRealizer.getFillColor();
                    if (color != null && color.equals(optionHandler.get(FamilyTreeLayoutModule.ITEM_MALE_COLOR))) {
                        return "MALE";
                    }
                    if (color != null && color.equals(optionHandler.get(FamilyTreeLayoutModule.ITEM_FEMALE_COLOR))) {
                        return "FEMALE";
                    }
                    if (color != null && color.equals(optionHandler.get(FamilyTreeLayoutModule.ITEM_FAMILY_COLOR))) {
                        return "FAMILY";
                    }
                    return null;
                }
            });
        }
    }

    protected void restoreGraph(Graph2D graph2D, OptionHandler optionHandler) {
        if (this.pc) {
            this.pc = false;
            graph2D.removeDataProvider("y.layout.genealogy.FamilyTreeLayouter.DP_KEY_FAMILY_TYPE");
        }
    }

    protected void configure(FamilyTreeLayouter familyTreeLayouter, OptionHandler optionHandler) {
        block32: {
            block35: {
                boolean bl;
                block34: {
                    block33: {
                        block31: {
                            IncrementalHierarchicLayouter incrementalHierarchicLayouter;
                            block29: {
                                NodeLayoutDescriptor nodeLayoutDescriptor;
                                block30: {
                                    block28: {
                                        block21: {
                                            ComponentLayouter componentLayouter;
                                            block27: {
                                                block26: {
                                                    block25: {
                                                        block24: {
                                                            block23: {
                                                                block22: {
                                                                    block20: {
                                                                        block17: {
                                                                            block19: {
                                                                                block18: {
                                                                                    block16: {
                                                                                        bl = YModule.z;
                                                                                        familyTreeLayouter.setSpacingBetweenFamilyMembers(optionHandler.getDouble(ITEM_HORIZONTAL_SPACING));
                                                                                        familyTreeLayouter.setOffsetForFamilyNodes(optionHandler.getDouble(ITEM_VERTICAL_SPACING));
                                                                                        familyTreeLayouter.setFamilyNodesAlwaysBelow(optionHandler.getBool(ITEM_FAMILIES_ALWAYS_BELOW));
                                                                                        familyTreeLayouter.setPartnerlessBelow(optionHandler.getBool(ITEM_SINGLE_DIRECT_BELOW));
                                                                                        if (!optionHandler.get(ITEM_ORIENTATION).equals(VALUE_TOP_TO_BOTTOM)) break block16;
                                                                                        familyTreeLayouter.setLayoutOrientation((byte)0);
                                                                                        if (!bl) break block17;
                                                                                    }
                                                                                    if (!optionHandler.get(ITEM_ORIENTATION).equals(VALUE_LEFT_TO_RIGHT)) break block18;
                                                                                    familyTreeLayouter.setLayoutOrientation((byte)1);
                                                                                    if (!bl) break block17;
                                                                                }
                                                                                if (!optionHandler.get(ITEM_ORIENTATION).equals(VALUE_BOTTOM_TO_TOP)) break block19;
                                                                                familyTreeLayouter.setLayoutOrientation((byte)2);
                                                                                if (!bl) break block17;
                                                                            }
                                                                            if (optionHandler.get(ITEM_ORIENTATION).equals(VALUE_RIGHT_TO_LEFT)) {
                                                                                familyTreeLayouter.setLayoutOrientation((byte)3);
                                                                            }
                                                                        }
                                                                        familyTreeLayouter.setComponentLayouterEnabled(optionHandler.getBool(ITEM_USE_COMPONENT_LAYOUTER));
                                                                        componentLayouter = (ComponentLayouter)familyTreeLayouter.getComponentLayouter();
                                                                        componentLayouter.setComponentSpacing(optionHandler.getInt(ITEM_COMPONENT_DISTANCE));
                                                                        if (!optionHandler.get(ITEM_COMPONENT_STYLE).equals(VALUE_COMPONENT_STYLE_NONE)) break block20;
                                                                        componentLayouter.setStyle((byte)0);
                                                                        if (!bl) break block21;
                                                                    }
                                                                    if (!optionHandler.get(ITEM_COMPONENT_STYLE).equals(VALUE_COMPONENT_STYLE_PACKED_CIRCLE)) break block22;
                                                                    componentLayouter.setStyle((byte)6);
                                                                    if (!bl) break block21;
                                                                }
                                                                if (!optionHandler.get(ITEM_COMPONENT_STYLE).equals(VALUE_COMPONENT_STYLE_PACKED_COMPACT_CIRCLE)) break block23;
                                                                componentLayouter.setStyle((byte)7);
                                                                if (!bl) break block21;
                                                            }
                                                            if (!optionHandler.get(ITEM_COMPONENT_STYLE).equals(VALUE_COMPONENT_STYLE_PACKED_COMPACT_RECTANGLE)) break block24;
                                                            componentLayouter.setStyle((byte)5);
                                                            if (!bl) break block21;
                                                        }
                                                        if (!optionHandler.get(ITEM_COMPONENT_STYLE).equals(VALUE_COMPONENT_STYLE_PACKED_RECTANGLE)) break block25;
                                                        componentLayouter.setStyle((byte)4);
                                                        if (!bl) break block21;
                                                    }
                                                    if (!optionHandler.get(ITEM_COMPONENT_STYLE).equals(VALUE_COMPONENT_STYLE_ROWS)) break block26;
                                                    componentLayouter.setStyle((byte)8);
                                                    if (!bl) break block21;
                                                }
                                                if (!optionHandler.get(ITEM_COMPONENT_STYLE).equals(VALUE_COMPONENT_STYLE_SINGLE_COLUMN)) break block27;
                                                componentLayouter.setStyle((byte)3);
                                                if (!bl) break block21;
                                            }
                                            if (optionHandler.get(ITEM_COMPONENT_STYLE).equals(VALUE_COMPONENT_STYLE_SINGLE_ROW)) {
                                                componentLayouter.setStyle((byte)2);
                                            }
                                        }
                                        incrementalHierarchicLayouter = new IncrementalHierarchicLayouter();
                                        familyTreeLayouter.setTopLayouter(incrementalHierarchicLayouter);
                                        ((SimplexNodePlacer)incrementalHierarchicLayouter.getNodePlacer()).setBendReductionEnabled(false);
                                        nodeLayoutDescriptor = incrementalHierarchicLayouter.getNodeLayoutDescriptor();
                                        if (!optionHandler.get(ITEM_NODE_ALIGNMENT).equals(VALUE_NODE_ALIGN_TOP)) break block28;
                                        nodeLayoutDescriptor.setLayerAlignment(0.0);
                                        familyTreeLayouter.setAlignment(-1);
                                        if (!bl) break block29;
                                    }
                                    if (!optionHandler.get(ITEM_NODE_ALIGNMENT).equals(VALUE_NODE_ALIGN_CENTER)) break block30;
                                    nodeLayoutDescriptor.setLayerAlignment(0.5);
                                    familyTreeLayouter.setAlignment(0);
                                    if (!bl) break block29;
                                }
                                if (optionHandler.get(ITEM_NODE_ALIGNMENT).equals(VALUE_NODE_ALIGN_BOTTOM)) {
                                    nodeLayoutDescriptor.setLayerAlignment(1.0);
                                    familyTreeLayouter.setAlignment(1);
                                }
                            }
                            incrementalHierarchicLayouter.setMinimumLayerDistance(optionHandler.getDouble(ITEM_MINIMUM_LAYER_DISTANCE));
                            incrementalHierarchicLayouter.setNodeToNodeDistance(optionHandler.getDouble(ITEM_NODE_TO_NODE_DISTANCE));
                            EdgeLayoutDescriptor edgeLayoutDescriptor = incrementalHierarchicLayouter.getEdgeLayoutDescriptor();
                            edgeLayoutDescriptor.setMinimumFirstSegmentLength(optionHandler.getDouble(ITEM_MINIMUM_FIRST_SEGMENT));
                            edgeLayoutDescriptor.setMinimumLastSegmentLength(optionHandler.getDouble(ITEM_MINIMUM_LAST_SEGMENT));
                            edgeLayoutDescriptor.setRoutingStyle(new RoutingStyle(0));
                            if (!optionHandler.get(ITEM_SORT_BY_SEX).equals(VALUE_DO_NOT_SORT)) break block31;
                            familyTreeLayouter.setSortFamilyMembers(0);
                            if (!bl) break block32;
                        }
                        if (!optionHandler.get(ITEM_SORT_BY_SEX).equals(VALUE_FEMALE_LEFT)) break block33;
                        familyTreeLayouter.setSortFamilyMembers(1);
                        if (!bl) break block32;
                    }
                    if (!optionHandler.get(ITEM_SORT_BY_SEX).equals(VALUE_FEMALE_ALWAYS_LEFT)) break block34;
                    familyTreeLayouter.setSortFamilyMembers(2);
                    if (!bl) break block32;
                }
                if (!optionHandler.get(ITEM_SORT_BY_SEX).equals(VALUE_MALE_LEFT)) break block35;
                familyTreeLayouter.setSortFamilyMembers(3);
                if (!bl) break block32;
            }
            if (optionHandler.get(ITEM_SORT_BY_SEX).equals(VALUE_MALE_ALWAYS_LEFT)) {
                familyTreeLayouter.setSortFamilyMembers(4);
            }
        }
    }
}

