/*
 * Decompiled with CFR 0.152.
 */
package y.module;

import y.layout.ComponentLayouter;
import y.layout.circular.CircularLayouter;
import y.layout.circular.SingleCycleLayouter;
import y.layout.tree.BalloonLayouter;
import y.module.LayoutModule;
import y.module.YModule;
import y.option.ConstraintManager;
import y.option.EnumOptionItem;
import y.option.OptionHandler;
import y.option.OptionItem;
import y.view.Graph2D;

public class CircularLayoutModule
extends LayoutModule {
    protected static final String MODULE_CIRCULAR = "CIRCULAR";
    protected static final String SECTION_GENERAL = "GENERAL";
    protected static final String ITEM_LAYOUT_STYLE = "LAYOUT_STYLE";
    protected static final String VALUE_BCC_COMPACT = "BCC_COMPACT";
    protected static final String VALUE_BCC_ISOLATED = "BCC_ISOLATED";
    protected static final String VALUE_CIRCULAR_CUSTOM_GROUPS = "CIRCULAR_CUSTOM_GROUPS";
    protected static final String VALUE_SINGLE_CYCLE = "SINGLE_CYCLE";
    protected static final String ITEM_ACT_ON_SELECTION_ONLY = "ACT_ON_SELECTION_ONLY";
    protected static final String ITEM_FROM_SKETCH = "FROM_SKETCH";
    protected static final String ITEM_HANDLE_NODE_LABELS = "HANDLE_NODE_LABELS";
    protected static final String SECTION_CYCLE = "CYCLE";
    private static final String ee = "PARTITION_LAYOUT_STYLE";
    private static final String fe = "PARTITION_LAYOUTSTYLE_CYCLIC";
    private static final String ge = "PARTITION_LAYOUTSTYLE_DISK";
    private static final String de = "PARTITION_LAYOUTSTYLE_ORGANIC";
    protected static final String ITEM_MINIMAL_NODE_DISTANCE = "MINIMAL_NODE_DISTANCE";
    protected static final String ITEM_CHOOSE_RADIUS_AUTOMATICALLY = "CHOOSE_RADIUS_AUTOMATICALLY";
    protected static final String ITEM_FIXED_RADIUS = "FIXED_RADIUS";
    protected static final String SECTION_TREE = "TREE";
    protected static final String ITEM_PREFERRED_CHILD_WEDGE = "PREFERRED_CHILD_WEDGE";
    protected static final String ITEM_MINIMAL_EDGE_LENGTH = "MINIMAL_EDGE_LENGTH";
    protected static final String ITEM_MAXIMAL_DEVIATION_ANGLE = "MAXIMAL_DEVIATION_ANGLE";
    protected static final String ITEM_COMPACTNESS_FACTOR = "COMPACTNESS_FACTOR";
    protected static final String ITEM_MINIMAL_TREE_NODE_DISTANCE = "MINIMAL_TREE_NODE_DISTANCE";
    protected static final String ITEM_ALLOW_OVERLAPS = "ALLOW_OVERLAPS";
    protected static final String ITEM_PLACE_CHILDREN_ON_COMMON_RADIUS = "PLACE_CHILDREN_ON_COMMON_RADIUS";

    public CircularLayoutModule() {
        super(MODULE_CIRCULAR);
    }

    protected OptionHandler createOptionHandler() {
        OptionHandler optionHandler = new OptionHandler(this.getModuleName());
        ConstraintManager constraintManager = new ConstraintManager(optionHandler);
        CircularLayouter circularLayouter = new CircularLayouter();
        SingleCycleLayouter singleCycleLayouter = circularLayouter.getSingleCycleLayouter();
        BalloonLayouter balloonLayouter = circularLayouter.getBalloonLayouter();
        optionHandler.useSection(SECTION_GENERAL);
        optionHandler.addEnum(ITEM_LAYOUT_STYLE, new String[]{VALUE_BCC_COMPACT, VALUE_BCC_ISOLATED, VALUE_CIRCULAR_CUSTOM_GROUPS, VALUE_SINGLE_CYCLE}, circularLayouter.getLayoutStyle());
        optionHandler.addBool(ITEM_ACT_ON_SELECTION_ONLY, false);
        optionHandler.addBool(ITEM_FROM_SKETCH, false);
        optionHandler.addBool(ITEM_HANDLE_NODE_LABELS, false);
        optionHandler.useSection(SECTION_CYCLE);
        EnumOptionItem enumOptionItem = optionHandler.addEnum(ee, new String[]{fe, ge, de}, circularLayouter.getPartitionLayoutStyle());
        OptionItem optionItem = optionHandler.addBool(ITEM_CHOOSE_RADIUS_AUTOMATICALLY, singleCycleLayouter.getAutomaticRadius());
        OptionItem optionItem2 = optionHandler.addInt(ITEM_FIXED_RADIUS, (int)singleCycleLayouter.getFixedRadius(), 50, 800);
        OptionItem optionItem3 = optionHandler.addInt(ITEM_MINIMAL_NODE_DISTANCE, singleCycleLayouter.getMinimalNodeDistance(), 0, 999);
        constraintManager.setEnabledOnValueEquals(optionItem, (Object)Boolean.FALSE, optionItem2);
        constraintManager.setEnabledOnValueEquals(optionItem, (Object)Boolean.TRUE, optionItem3);
        optionHandler.useSection(SECTION_TREE);
        OptionItem optionItem4 = optionHandler.addInt(ITEM_PREFERRED_CHILD_WEDGE, balloonLayouter.getPreferredChildWedge(), 1, 359);
        OptionItem optionItem5 = optionHandler.addInt(ITEM_MINIMAL_EDGE_LENGTH, balloonLayouter.getMinimalEdgeLength(), 5, 400);
        OptionItem optionItem6 = optionHandler.addInt(ITEM_MAXIMAL_DEVIATION_ANGLE, circularLayouter.getMaximalDeviationAngle(), 10, 360);
        OptionItem optionItem7 = optionHandler.addDouble(ITEM_COMPACTNESS_FACTOR, balloonLayouter.getCompactnessFactor(), 0.1, 0.9);
        OptionItem optionItem8 = optionHandler.addInt(ITEM_MINIMAL_TREE_NODE_DISTANCE, balloonLayouter.getMinimalNodeDistance(), 0, 100);
        OptionItem optionItem9 = optionHandler.addBool(ITEM_ALLOW_OVERLAPS, balloonLayouter.getAllowOverlaps());
        OptionItem optionItem10 = optionHandler.addBool(ITEM_PLACE_CHILDREN_ON_COMMON_RADIUS, true);
        constraintManager.setEnabledOnValueEquals((OptionItem)enumOptionItem, (Object)VALUE_SINGLE_CYCLE, optionItem8, true);
        constraintManager.setEnabledOnValueEquals((OptionItem)enumOptionItem, (Object)VALUE_SINGLE_CYCLE, optionItem10, true);
        constraintManager.setEnabledOnValueEquals((OptionItem)enumOptionItem, (Object)VALUE_SINGLE_CYCLE, optionItem4, true);
        constraintManager.setEnabledOnValueEquals((OptionItem)enumOptionItem, (Object)VALUE_SINGLE_CYCLE, optionItem5, true);
        constraintManager.setEnabledOnValueEquals((OptionItem)enumOptionItem, (Object)VALUE_SINGLE_CYCLE, optionItem6, true);
        constraintManager.setEnabledOnValueEquals((OptionItem)enumOptionItem, (Object)VALUE_SINGLE_CYCLE, optionItem7, true);
        constraintManager.setEnabledOnValueEquals((OptionItem)enumOptionItem, (Object)VALUE_SINGLE_CYCLE, optionItem9, true);
        return optionHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void mainrun() {
        CircularLayouter circularLayouter = new CircularLayouter();
        OptionHandler optionHandler = this.getOptionHandler();
        this.configure(circularLayouter, optionHandler);
        Graph2D graph2D = this.getGraph2D();
        this.prepareGraph(graph2D, optionHandler);
        try {
            this.launchLayouter(circularLayouter);
        }
        finally {
            this.restoreGraph(graph2D, optionHandler);
        }
    }

    protected void prepareGraph(Graph2D graph2D, OptionHandler optionHandler) {
        if (optionHandler.getString(ITEM_LAYOUT_STYLE).equals(VALUE_CIRCULAR_CUSTOM_GROUPS) && graph2D.getHierarchyManager() != null) {
            this.backupDataProvider(graph2D, CircularLayouter.CIRCULAR_CUSTOM_GROUPS_DPKEY);
            graph2D.addDataProvider(CircularLayouter.CIRCULAR_CUSTOM_GROUPS_DPKEY, graph2D.getHierarchyManager().getParentNodeIdDataProvider());
        }
    }

    protected void restoreGraph(Graph2D graph2D, OptionHandler optionHandler) {
        if (optionHandler.getString(ITEM_LAYOUT_STYLE).equals(VALUE_CIRCULAR_CUSTOM_GROUPS) && graph2D.getHierarchyManager() != null) {
            this.restoreDataProvider(graph2D, CircularLayouter.CIRCULAR_CUSTOM_GROUPS_DPKEY);
        }
    }

    protected void configure(CircularLayouter circularLayouter, OptionHandler optionHandler) {
        block12: {
            block13: {
                boolean bl;
                block11: {
                    block8: {
                        block10: {
                            block9: {
                                block7: {
                                    bl = YModule.z;
                                    ((ComponentLayouter)circularLayouter.getComponentLayouter()).setStyle((byte)8);
                                    if (!optionHandler.getString(ITEM_LAYOUT_STYLE).equals(VALUE_BCC_COMPACT)) break block7;
                                    circularLayouter.setLayoutStyle((byte)0);
                                    if (!bl) break block8;
                                }
                                if (!optionHandler.getString(ITEM_LAYOUT_STYLE).equals(VALUE_BCC_ISOLATED)) break block9;
                                circularLayouter.setLayoutStyle((byte)1);
                                if (!bl) break block8;
                            }
                            if (!optionHandler.getString(ITEM_LAYOUT_STYLE).equals(VALUE_CIRCULAR_CUSTOM_GROUPS)) break block10;
                            circularLayouter.setLayoutStyle((byte)2);
                            if (!bl) break block8;
                        }
                        circularLayouter.setLayoutStyle((byte)3);
                    }
                    circularLayouter.setSubgraphLayouterEnabled(optionHandler.getBool(ITEM_ACT_ON_SELECTION_ONLY));
                    circularLayouter.setMaximalDeviationAngle(optionHandler.getInt(ITEM_MAXIMAL_DEVIATION_ANGLE));
                    circularLayouter.setFromSketchModeEnabled(optionHandler.getBool(ITEM_FROM_SKETCH));
                    circularLayouter.setPlaceChildrenOnCommonRadiusEnabled(optionHandler.getBool(ITEM_PLACE_CHILDREN_ON_COMMON_RADIUS));
                    circularLayouter.setConsiderNodeLabelsEnabled(optionHandler.getBool(ITEM_HANDLE_NODE_LABELS));
                    if (!optionHandler.getString(ee).equals(fe)) break block11;
                    circularLayouter.setPartitionLayoutStyle((byte)0);
                    if (!bl) break block12;
                }
                if (!optionHandler.getString(ee).equals(ge)) break block13;
                circularLayouter.setPartitionLayoutStyle((byte)1);
                if (!bl) break block12;
            }
            if (optionHandler.getString(ee).equals(de)) {
                circularLayouter.setPartitionLayoutStyle((byte)2);
            }
        }
        SingleCycleLayouter singleCycleLayouter = circularLayouter.getSingleCycleLayouter();
        singleCycleLayouter.setMinimalNodeDistance(optionHandler.getInt(ITEM_MINIMAL_NODE_DISTANCE));
        singleCycleLayouter.setAutomaticRadius(optionHandler.getBool(ITEM_CHOOSE_RADIUS_AUTOMATICALLY));
        singleCycleLayouter.setFixedRadius(optionHandler.getInt(ITEM_FIXED_RADIUS));
        BalloonLayouter balloonLayouter = circularLayouter.getBalloonLayouter();
        balloonLayouter.setPreferredChildWedge(optionHandler.getInt(ITEM_PREFERRED_CHILD_WEDGE));
        balloonLayouter.setMinimalEdgeLength(optionHandler.getInt(ITEM_MINIMAL_EDGE_LENGTH));
        balloonLayouter.setCompactnessFactor(optionHandler.getDouble(ITEM_COMPACTNESS_FACTOR));
        balloonLayouter.setAllowOverlaps(optionHandler.getBool(ITEM_ALLOW_OVERLAPS));
        balloonLayouter.setMinimalNodeDistance(optionHandler.getInt(ITEM_MINIMAL_TREE_NODE_DISTANCE));
    }
}

