/*
 * Decompiled with CFR 0.152.
 */
package y.module;

import java.util.HashSet;
import y.algo.GraphConnectivity;
import y.base.DataProvider;
import y.base.Edge;
import y.layout.router.BusDescriptor;
import y.layout.router.BusRouter;
import y.module.LayoutModule;
import y.module.YModule;
import y.option.ConstraintManager;
import y.option.DoubleOptionItem;
import y.option.IntOptionItem;
import y.option.OptionGroup;
import y.option.OptionHandler;
import y.option.OptionItem;
import y.util.DataProviderAdapter;
import y.util.Maps;
import y.view.Graph2D;

public class BusRouterModule
extends LayoutModule {
    protected static final String MODULE_BUS_ROUTER = "BUS_ROUTER";
    protected static final String TITLE_LAYOUT = "GROUP_LAYOUT";
    protected static final String ITEM_SCOPE = "SCOPE";
    protected static final String VALUE_SCOPE_ALL = "ALL";
    protected static final String VALUE_SCOPE_SUBSET = "SUBSET";
    protected static final String VALUE_SCOPE_EDGES_AT_SELECTED_NODES = "EDGES_AT_SELECTED_NODES";
    protected static final String VALUE_SCOPE_SUBSET_BUS = "SUBSET_BUS";
    protected static final String VALUE_SCOPE_PARTIAL = "PARTIAL";
    protected static final String ITEM_BUSES = "BUSES";
    protected static final String VALUE_SINGLE = "SINGLE";
    protected static final String VALUE_COLOR = "COLOR";
    protected static final String VALUE_CONNECTED_COMPONENT = "CONNECTED_COMPONENT";
    protected static final String ITEM_GRID_ENABLED = "GRID_ENABLED";
    protected static final String ITEM_GRID_SPACING = "GRID_SPACING";
    protected static final String ITEM_MIN_DISTANCE_TO_NODES = "MIN_DISTANCE_TO_NODES";
    protected static final String ITEM_MIN_DISTANCE_TO_EDGES = "MIN_DISTANCE_TO_EDGES";
    protected static final String TITLE_SELECTION = "GROUP_SELECTION";
    protected static final String ITEM_PREFERRED_BACKBONE_COUNT = "PREFERRED_BACKBONE_COUNT";
    protected static final String ITEM_MINIMUM_BACKBONE_LENGTH = "MINIMUM_BACKBONE_LENGTH";
    protected static final String TITLE_ROUTING = "GROUP_ROUTING";
    protected static final String ITEM_CROSSING_COST = "CROSSING_COST";
    protected static final String ITEM_CROSSING_REROUTING = "CROSSING_REROUTING";
    protected static final String ITEM_MINIMUM_CONNECTIONS_COUNT = "MINIMUM_CONNECTIONS_COUNT";
    protected boolean optionsLayout = true;
    protected boolean optionsSelection = true;
    protected boolean optionsRouting = true;

    public BusRouterModule() {
        super(MODULE_BUS_ROUTER);
    }

    protected OptionHandler createOptionHandler() {
        OptionHandler optionHandler = new OptionHandler(this.getModuleName());
        this.addOptionItems(new BusRouter(), optionHandler);
        return optionHandler;
    }

    protected void addOptionItems(BusRouter busRouter, OptionHandler optionHandler) {
        OptionItem optionItem;
        OptionItem optionItem2;
        OptionItem optionItem3;
        OptionGroup optionGroup;
        ConstraintManager constraintManager = new ConstraintManager(optionHandler);
        if (this.optionsLayout) {
            optionGroup = new OptionGroup();
            optionGroup.setAttribute("OptionGroup.title", TITLE_LAYOUT);
            optionGroup.addItem(optionHandler.addEnum(ITEM_SCOPE, new String[]{VALUE_SCOPE_ALL, VALUE_SCOPE_SUBSET, VALUE_SCOPE_EDGES_AT_SELECTED_NODES, VALUE_SCOPE_SUBSET_BUS, VALUE_SCOPE_PARTIAL}, busRouter.getScope()));
            optionGroup.addItem(optionHandler.addEnum(ITEM_BUSES, new String[]{VALUE_SINGLE, VALUE_COLOR, VALUE_CONNECTED_COMPONENT}, 0));
            optionGroup.addItem(optionHandler.addBool(ITEM_GRID_ENABLED, busRouter.isGridRoutingEnabled()));
            optionItem3 = optionGroup.addItem(optionHandler.addInt(ITEM_GRID_SPACING, busRouter.getGridSpacing()));
            optionItem3.setAttribute(IntOptionItem.ATTRIBUTE_MIN_VALUE, new Integer(1));
            optionItem2 = optionGroup.addItem(optionHandler.addInt(ITEM_MIN_DISTANCE_TO_NODES, busRouter.getMinimumDistanceToNode()));
            optionItem2.setAttribute(IntOptionItem.ATTRIBUTE_MIN_VALUE, new Integer(1));
            optionItem = optionGroup.addItem(optionHandler.addInt(ITEM_MIN_DISTANCE_TO_EDGES, busRouter.getMinimumDistanceToEdge()));
            optionItem.setAttribute(IntOptionItem.ATTRIBUTE_MIN_VALUE, new Integer(1));
            constraintManager.setEnabledOnValueEquals(ITEM_GRID_ENABLED, (Object)Boolean.TRUE, ITEM_GRID_SPACING);
        }
        if (this.optionsSelection) {
            optionGroup = new OptionGroup();
            optionGroup.setAttribute("OptionGroup.title", TITLE_SELECTION);
            optionItem3 = optionGroup.addItem(optionHandler.addInt(ITEM_PREFERRED_BACKBONE_COUNT, busRouter.getPreferredBackboneSegmentCount()));
            optionItem3.setAttribute(IntOptionItem.ATTRIBUTE_MIN_VALUE, new Integer(1));
            optionItem2 = optionGroup.addItem(optionHandler.addDouble(ITEM_MINIMUM_BACKBONE_LENGTH, busRouter.getMinimumBackboneSegmentLength()));
            optionItem2.setAttribute(DoubleOptionItem.ATTRIBUTE_MIN_VALUE, new Double(1.0));
        }
        if (this.optionsRouting) {
            optionGroup = new OptionGroup();
            optionGroup.setAttribute("OptionGroup.title", TITLE_ROUTING);
            optionItem3 = optionGroup.addItem(optionHandler.addDouble(ITEM_CROSSING_COST, busRouter.getCrossingCost()));
            optionItem3.setAttribute(DoubleOptionItem.ATTRIBUTE_MIN_VALUE, new Double(0.0));
            optionItem2 = optionGroup.addItem(optionHandler.addBool(ITEM_CROSSING_REROUTING, busRouter.isReroutingEnabled()));
            optionItem2.setAttribute(DoubleOptionItem.ATTRIBUTE_MIN_VALUE, new Double(0.0));
            optionItem = optionGroup.addItem(optionHandler.addInt(ITEM_MINIMUM_CONNECTIONS_COUNT, busRouter.getMinimumBusConnectionsCount()));
            optionItem.setAttribute(IntOptionItem.ATTRIBUTE_MIN_VALUE, new Integer(1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void mainrun() {
        BusRouter busRouter = new BusRouter();
        OptionHandler optionHandler = this.getOptionHandler();
        this.configure(busRouter, optionHandler);
        Graph2D graph2D = this.getGraph2D();
        this.prepareGraph(graph2D, optionHandler);
        try {
            this.launchLayouter(busRouter);
        }
        finally {
            this.restoreGraph(graph2D, optionHandler);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void prepareGraph(final Graph2D var1_1, OptionHandler var2_2) {
        block22: {
            block25: {
                block24: {
                    block21: {
                        block20: {
                            var11_3 = YModule.z;
                            if (!this.optionsLayout) {
                                return;
                            }
                            this.backupDataProvider(var1_1, BusRouter.EDGE_DESCRIPTOR_DPKEY);
                            var3_4 = var2_2.getString("BUSES");
                            var4_5 = var2_2.get("SCOPE");
                            var5_6 = Maps.createHashedEdgeMap();
                            var1_1.addDataProvider(BusRouter.EDGE_DESCRIPTOR_DPKEY, var5_6);
                            var6_7 = Maps.createHashedNodeMap();
                            GraphConnectivity.connectedComponents(var1_1, var6_7);
                            if (!"SUBSET".equals(var4_5)) ** GOTO lbl21
                            var7_8 = var1_1.selectedEdges();
                            while (var7_8.ok()) {
                                var8_9 = var7_8.edge();
                                var5_6.set(var8_9, new BusDescriptor(BusRouterModule.b(var1_1, (Edge)var8_9, var6_7, var3_4), false));
                                var7_8.next();
                                if (!var11_3) {
                                    if (!var11_3) continue;
                                }
                                break block20;
lbl21:
                                // 2 sources

                                if (!"EDGES_AT_SELECTED_NODES".equals(var4_5)) ** GOTO lbl32
                                var7_8 = var1_1.edges();
                                while (var7_8.ok()) {
                                    var8_9 = var7_8.edge();
                                    v0 = var1_1.isSelected(var8_9.source());
                                    if (!var11_3) {
                                        if (v0 || var1_1.isSelected(var8_9.target())) {
                                            var5_6.set(var8_9, new BusDescriptor(BusRouterModule.b(var1_1, (Edge)var8_9, var6_7, var3_4), false));
                                        }
                                        var7_8.next();
                                        if (!var11_3) continue;
                                    }
                                    break block21;
lbl32:
                                    // 2 sources

                                    if (!"PARTIAL".equals(var4_5)) ** GOTO lbl43
                                    var7_8 = var1_1.edges();
                                    while (var7_8.ok()) {
                                        var8_9 = var7_8.edge();
                                        v0 = var1_1.isSelected(var8_9.source());
                                        if (!var11_3) {
                                            var9_10 = v0 == false && var1_1.isSelected(var8_9.target()) == false;
                                            var5_6.set(var8_9, new BusDescriptor(BusRouterModule.b(var1_1, (Edge)var8_9, var6_7, var3_4), var9_10));
                                            var7_8.next();
                                            if (!var11_3) continue;
                                        }
                                        break block21;
lbl43:
                                        // 2 sources

                                        var7_8 = var1_1.edges();
                                        while (var7_8.ok()) {
                                            var8_9 = var7_8.edge();
                                            var5_6.set(var8_9, new BusDescriptor(BusRouterModule.b(var1_1, (Edge)var8_9, var6_7, var3_4), false));
                                            var7_8.next();
                                            if (!var11_3) {
                                                if (!var11_3) continue;
                                            }
                                            break block20;
                                        }
                                        break block0;
                                    }
                                    break block0;
                                }
                                break block0;
                            }
                            this.backupDataProvider(var1_1, BusRouter.EDGE_SUBSET_DPKEY);
                        }
                        v0 = "SUBSET".equals(var4_5);
                    }
                    if (!v0) break block24;
                    var1_1.addDataProvider(BusRouter.EDGE_SUBSET_DPKEY, new DataProviderAdapter(){

                        public boolean getBool(Object object) {
                            return object instanceof Edge && var1_1.isSelected((Edge)object);
                        }
                    });
                    if (!var11_3) break block22;
                }
                if (!"EDGES_AT_SELECTED_NODES".equals(var4_5)) break block25;
                var1_1.addDataProvider(BusRouter.EDGE_SUBSET_DPKEY, new DataProviderAdapter(){

                    public boolean getBool(Object object) {
                        if (object instanceof Edge) {
                            Edge edge = (Edge)object;
                            return var1_1.isSelected(edge.source()) || var1_1.isSelected(edge.target());
                        }
                        return false;
                    }
                });
                if (!var11_3) break block22;
            }
            if ("SUBSET_BUS".equals(var4_5)) {
                var7_8 = new HashSet<E>();
                var8_9 = var1_1.selectedEdges();
                while (var8_9.ok()) {
                    var7_8.add(((BusDescriptor)var5_6.get(var8_9.edge())).getID());
                    var8_9.next();
                    if (!var11_3) {
                        if (!var11_3) continue;
                    }
                    break block22;
                }
                var1_1.addDataProvider(BusRouter.EDGE_SUBSET_DPKEY, new DataProviderAdapter(){

                    public boolean getBool(Object object) {
                        return var7_8.contains(((BusDescriptor)var5_6.get(object)).getID());
                    }
                });
            } else if ("PARTIAL".equals(var4_5)) {
                var7_8 = new HashSet<Object>();
                var8_9 = var1_1.selectedNodes();
                while (var8_9.ok()) {
                    block23: {
                        var9_11 = var8_9.node();
                        if (var11_3) break block22;
                        var10_12 = var9_11.edges();
                        while (var10_12.ok()) {
                            var7_8.add(((BusDescriptor)var5_6.get(var10_12.edge())).getID());
                            var10_12.next();
                            if (!var11_3) {
                                if (!var11_3) continue;
                            }
                            break block23;
                        }
                        var8_9.next();
                    }
                    if (!var11_3) continue;
                }
                var1_1.addDataProvider(BusRouter.EDGE_SUBSET_DPKEY, new DataProviderAdapter(){

                    public boolean getBool(Object object) {
                        return var7_8.contains(((BusDescriptor)var5_6.get(object)).getID());
                    }
                });
            }
        }
    }

    protected void restoreGraph(Graph2D graph2D, OptionHandler optionHandler) {
        if (this.optionsLayout) {
            this.restoreDataProvider(graph2D, BusRouter.EDGE_DESCRIPTOR_DPKEY);
            this.restoreDataProvider(graph2D, BusRouter.EDGE_SUBSET_DPKEY);
        }
    }

    protected void configure(BusRouter busRouter, OptionHandler optionHandler) {
        if (this.optionsLayout) {
            busRouter.setScope(BusRouterModule.b(optionHandler.get(ITEM_SCOPE)));
            busRouter.setGridRoutingEnabled(optionHandler.getBool(ITEM_GRID_ENABLED));
            busRouter.setGridSpacing(optionHandler.getInt(ITEM_GRID_SPACING));
            busRouter.setMinimumDistanceToNode(optionHandler.getInt(ITEM_MIN_DISTANCE_TO_NODES));
            busRouter.setMinimumDistanceToEdge(optionHandler.getInt(ITEM_MIN_DISTANCE_TO_EDGES));
        }
        if (this.optionsSelection) {
            busRouter.setPreferredBackboneSegmentCount(optionHandler.getInt(ITEM_PREFERRED_BACKBONE_COUNT));
            busRouter.setMinimumBackboneSegmentLength(optionHandler.getDouble(ITEM_MINIMUM_BACKBONE_LENGTH));
        }
        if (this.optionsRouting) {
            busRouter.setCrossingCost(optionHandler.getDouble(ITEM_CROSSING_COST));
            busRouter.setReroutingEnabled(optionHandler.getBool(ITEM_CROSSING_REROUTING));
            busRouter.setMinimumBusConnectionsCount(optionHandler.getInt(ITEM_MINIMUM_CONNECTIONS_COUNT));
        }
    }

    private static Object b(Graph2D graph2D, Edge edge, DataProvider dataProvider, String string) {
        if (VALUE_COLOR.equals(string)) {
            return graph2D.getRealizer(edge).getLineColor();
        }
        if (VALUE_CONNECTED_COMPONENT.equals(string)) {
            return dataProvider.get(edge.source());
        }
        return VALUE_SINGLE;
    }

    private static byte b(Object object) {
        if (VALUE_SCOPE_ALL.equals(object)) {
            return 0;
        }
        if (VALUE_SCOPE_SUBSET.equals(object) || VALUE_SCOPE_SUBSET_BUS.equals(object) || VALUE_SCOPE_PARTIAL.equals(object) || VALUE_SCOPE_EDGES_AT_SELECTED_NODES.equals(object)) {
            return 1;
        }
        return 0;
    }
}

