/*
 * Decompiled with CFR 0.152.
 */
package y.module;

import y.base.EdgeCursor;
import y.base.NodeCursor;
import y.layout.ComponentLayouter;
import y.layout.EdgeLabelModel;
import y.layout.FreeEdgeLabelModel;
import y.layout.FreeNodeLabelModel;
import y.layout.NodeLabelModel;
import y.layout.router.OrganicEdgeRouter;
import y.layout.router.polyline.EdgeRouter;
import y.layout.tree.BalloonLayouter;
import y.layout.tree.TreeReductionStage;
import y.module.LayoutModule;
import y.module.YModule;
import y.option.OptionHandler;
import y.view.EdgeLabel;
import y.view.EdgeRealizer;
import y.view.Graph2D;
import y.view.NodeLabel;
import y.view.NodeRealizer;
import y.view.SmartEdgeLabelModel;
import y.view.SmartNodeLabelModel;

public class BalloonLayoutModule
extends LayoutModule {
    protected static final String MODULE_BALLOON = "BALLOON";
    protected static final String SECTION_GENERAL = "GENERAL";
    protected static final String ITEM_ROOT_NODE_POLICY = "ROOT_NODE_POLICY";
    protected static final String VALUE_DIRECTED_ROOT = "DIRECTED_ROOT";
    protected static final String VALUE_CENTER_ROOT = "CENTER_ROOT";
    protected static final String VALUE_WEIGHTED_CENTER_ROOT = "WEIGHTED_CENTER_ROOT";
    protected static final String ITEM_ROUTING_STYLE_FOR_NON_TREE_EDGES = "ROUTING_STYLE_FOR_NON_TREE_EDGES";
    protected static final String VALUE_ROUTE_ORGANIC = "ROUTE_ORGANIC";
    protected static final String VALUE_ROUTE_ORTHOGONAL = "ROUTE_ORTHOGONAL";
    protected static final String VALUE_ROUTE_STRAIGHTLINE = "ROUTE_STRAIGHTLINE";
    protected static final String ITEM_ACT_ON_SELECTION_ONLY = "ACT_ON_SELECTION_ONLY";
    protected static final String ITEM_PREFERRED_CHILD_WEDGE = "PREFERRED_CHILD_WEDGE";
    protected static final String ITEM_PREFERRED_ROOT_WEDGE = "PREFERRED_ROOT_WEDGE";
    protected static final String ITEM_MINIMAL_EDGE_LENGTH = "MINIMAL_EDGE_LENGTH";
    protected static final String ITEM_COMPACTNESS_FACTOR = "COMPACTNESS_FACTOR";
    protected static final String ITEM_ALLOW_OVERLAPS = "ALLOW_OVERLAPS";
    protected static final String ITEM_BALLOON_FROM_SKETCH = "FROM_SKETCH";
    protected static final String ITEM_PLACE_CHILDREN_INTERLEAVED = "PLACE_CHILDREN_INTERLEAVED";
    protected static final String ITEM_STRAIGHTEN_CHAINS = "STRAIGHTEN_CHAINS";
    protected static final String SECTION_LABELING = "LABELING";
    protected static final String ITEM_NODE_LABELING_STYLE = "NODE_LABELING_STYLE";
    protected static final String VALUE_NODE_LABELING_STYLE_NONE = "NODE_LABELING_STYLE_NONE";
    protected static final String VALUE_NODE_LABELING_STYLE_HORIZONTAL = "NODE_LABELING_STYLE_HORIZONTAL";
    protected static final String VALUE_NODE_LABELING_STYLE_RAYLIKE_LEAVES = "NODE_LABELING_STYLE_RAYLIKE_LEAVES";
    protected static final String VALUE_NODE_LABELING_STYLE_CONSIDER_CURRENT_POSITION = "NODE_LABELING_STYLE_CONSIDER_CURRENT_POSITION";
    protected static final String ITEM_INTEGRATED_EDGE_LABELING = "INTEGRATED_EDGE_LABELING";

    public BalloonLayoutModule() {
        super(MODULE_BALLOON);
        this.setPortIntersectionCalculatorEnabled(true);
    }

    protected OptionHandler createOptionHandler() {
        OptionHandler optionHandler = new OptionHandler(this.getModuleName());
        BalloonLayouter balloonLayouter = new BalloonLayouter();
        optionHandler.useSection(SECTION_GENERAL);
        optionHandler.addEnum(ITEM_ROOT_NODE_POLICY, new String[]{VALUE_DIRECTED_ROOT, VALUE_CENTER_ROOT, VALUE_WEIGHTED_CENTER_ROOT}, 0);
        optionHandler.addEnum(ITEM_ROUTING_STYLE_FOR_NON_TREE_EDGES, new String[]{VALUE_ROUTE_ORGANIC, VALUE_ROUTE_ORTHOGONAL, VALUE_ROUTE_STRAIGHTLINE}, 0);
        optionHandler.addBool(ITEM_ACT_ON_SELECTION_ONLY, false);
        optionHandler.addInt(ITEM_PREFERRED_CHILD_WEDGE, balloonLayouter.getPreferredChildWedge(), 1, 359);
        optionHandler.addInt(ITEM_PREFERRED_ROOT_WEDGE, balloonLayouter.getPreferredRootWedge(), 1, 360);
        optionHandler.addInt(ITEM_MINIMAL_EDGE_LENGTH, balloonLayouter.getMinimalEdgeLength(), 10, 400);
        optionHandler.addDouble(ITEM_COMPACTNESS_FACTOR, balloonLayouter.getCompactnessFactor(), 0.1, 0.9);
        optionHandler.addBool(ITEM_ALLOW_OVERLAPS, balloonLayouter.getAllowOverlaps());
        optionHandler.addBool(ITEM_BALLOON_FROM_SKETCH, balloonLayouter.isFromSketchModeEnabled());
        optionHandler.addBool(ITEM_PLACE_CHILDREN_INTERLEAVED, balloonLayouter.getInterleavedMode() == 1);
        optionHandler.addBool(ITEM_STRAIGHTEN_CHAINS, balloonLayouter.isChainStraighteningModeEnabled());
        optionHandler.useSection(SECTION_LABELING);
        optionHandler.addBool(ITEM_INTEGRATED_EDGE_LABELING, true);
        optionHandler.addEnum(ITEM_NODE_LABELING_STYLE, new String[]{VALUE_NODE_LABELING_STYLE_NONE, VALUE_NODE_LABELING_STYLE_HORIZONTAL, VALUE_NODE_LABELING_STYLE_RAYLIKE_LEAVES, VALUE_NODE_LABELING_STYLE_CONSIDER_CURRENT_POSITION}, 3);
        return optionHandler;
    }

    protected void mainrun() {
        BalloonLayouter balloonLayouter = new BalloonLayouter();
        OptionHandler optionHandler = this.getOptionHandler();
        this.configure(balloonLayouter, optionHandler);
        Graph2D graph2D = this.getGraph2D();
        this.b(graph2D, optionHandler);
        this.launchLayouter(balloonLayouter);
    }

    private void b(Graph2D graph2D, OptionHandler optionHandler) {
        if (optionHandler.getBool(ITEM_INTEGRATED_EDGE_LABELING)) {
            this.c(graph2D);
        }
        if (VALUE_NODE_LABELING_STYLE_RAYLIKE_LEAVES.equals(optionHandler.getString(ITEM_NODE_LABELING_STYLE))) {
            this.b(graph2D);
        }
    }

    protected void configure(BalloonLayouter balloonLayouter, OptionHandler optionHandler) {
        block23: {
            TreeReductionStage treeReductionStage;
            block24: {
                boolean bl;
                block22: {
                    block20: {
                        String string;
                        block21: {
                            block19: {
                                block18: {
                                    block17: {
                                        block15: {
                                            block16: {
                                                block14: {
                                                    bl = YModule.z;
                                                    ((ComponentLayouter)balloonLayouter.getComponentLayouter()).setStyle((byte)8);
                                                    if (!optionHandler.get(ITEM_ROOT_NODE_POLICY).equals(VALUE_DIRECTED_ROOT)) break block14;
                                                    balloonLayouter.setRootNodePolicy((byte)0);
                                                    if (!bl) break block15;
                                                }
                                                if (!optionHandler.get(ITEM_ROOT_NODE_POLICY).equals(VALUE_CENTER_ROOT)) break block16;
                                                balloonLayouter.setRootNodePolicy((byte)1);
                                                if (!bl) break block15;
                                            }
                                            balloonLayouter.setRootNodePolicy((byte)2);
                                        }
                                        balloonLayouter.setPreferredChildWedge(optionHandler.getInt(ITEM_PREFERRED_CHILD_WEDGE));
                                        balloonLayouter.setPreferredRootWedge(optionHandler.getInt(ITEM_PREFERRED_ROOT_WEDGE));
                                        balloonLayouter.setMinimalEdgeLength(optionHandler.getInt(ITEM_MINIMAL_EDGE_LENGTH));
                                        balloonLayouter.setCompactnessFactor(optionHandler.getDouble(ITEM_COMPACTNESS_FACTOR));
                                        balloonLayouter.setAllowOverlaps(optionHandler.getBool(ITEM_ALLOW_OVERLAPS));
                                        balloonLayouter.setFromSketchModeEnabled(optionHandler.getBool(ITEM_BALLOON_FROM_SKETCH));
                                        if (!optionHandler.getBool(ITEM_INTEGRATED_EDGE_LABELING)) break block17;
                                        balloonLayouter.setIntegratedEdgeLabelingEnabled(true);
                                        if (!bl) break block18;
                                    }
                                    balloonLayouter.setIntegratedEdgeLabelingEnabled(false);
                                }
                                balloonLayouter.setChainStraighteningModeEnabled(optionHandler.getBool(ITEM_STRAIGHTEN_CHAINS));
                                balloonLayouter.setInterleavedMode(optionHandler.getBool(ITEM_PLACE_CHILDREN_INTERLEAVED) ? (byte)1 : 0);
                                balloonLayouter.setIntegratedNodeLabelingEnabled(false);
                                balloonLayouter.setConsiderNodeLabelsEnabled(false);
                                string = optionHandler.getString(ITEM_NODE_LABELING_STYLE);
                                if (!VALUE_NODE_LABELING_STYLE_RAYLIKE_LEAVES.equals(string)) break block19;
                                balloonLayouter.setIntegratedNodeLabelingEnabled(true);
                                balloonLayouter.setNodeLabelingPolicy((byte)1);
                                if (!bl) break block20;
                            }
                            if (!VALUE_NODE_LABELING_STYLE_CONSIDER_CURRENT_POSITION.equals(string)) break block21;
                            balloonLayouter.setConsiderNodeLabelsEnabled(true);
                            if (!bl) break block20;
                        }
                        if (VALUE_NODE_LABELING_STYLE_HORIZONTAL.equals(string)) {
                            balloonLayouter.setIntegratedNodeLabelingEnabled(true);
                            balloonLayouter.setNodeLabelingPolicy((byte)2);
                        }
                    }
                    balloonLayouter.setSubgraphLayouterEnabled(optionHandler.getBool(ITEM_ACT_ON_SELECTION_ONLY));
                    treeReductionStage = new TreeReductionStage();
                    balloonLayouter.appendStage(treeReductionStage);
                    if (!VALUE_ROUTE_ORGANIC.equals(optionHandler.get(ITEM_ROUTING_STYLE_FOR_NON_TREE_EDGES))) break block22;
                    treeReductionStage.setNonTreeEdgeRouter(new OrganicEdgeRouter());
                    treeReductionStage.setNonTreeEdgeSelectionKey(OrganicEdgeRouter.ROUTE_EDGE_DPKEY);
                    if (!bl) break block23;
                }
                if (!VALUE_ROUTE_ORTHOGONAL.equals(optionHandler.get(ITEM_ROUTING_STYLE_FOR_NON_TREE_EDGES))) break block24;
                EdgeRouter edgeRouter = new EdgeRouter();
                edgeRouter.setReroutingEnabled(true);
                edgeRouter.setSphereOfAction((byte)2);
                treeReductionStage.setNonTreeEdgeSelectionKey(edgeRouter.getSelectedEdgesDpKey());
                treeReductionStage.setNonTreeEdgeRouter(edgeRouter);
                if (!bl) break block23;
            }
            if (VALUE_ROUTE_STRAIGHTLINE.equals(optionHandler.get(ITEM_ROUTING_STYLE_FOR_NON_TREE_EDGES))) {
                treeReductionStage.setNonTreeEdgeRouter(treeReductionStage.createStraightlineRouter());
            }
        }
    }

    private void c(Graph2D graph2D) {
        boolean bl = YModule.z;
        EdgeCursor edgeCursor = graph2D.edges();
        block0: while (true) {
            boolean bl2 = edgeCursor.ok();
            block1: while (bl2) {
                EdgeRealizer edgeRealizer = graph2D.getRealizer(edgeCursor.edge());
                for (int i2 = 0; i2 < edgeRealizer.labelCount(); ++i2) {
                    EdgeLabel edgeLabel = edgeRealizer.getLabel(i2);
                    EdgeLabelModel edgeLabelModel = edgeLabel.getLabelModel();
                    bl2 = BalloonLayoutModule.b(edgeLabelModel);
                    if (bl) continue block1;
                    if (bl2) continue;
                    SmartEdgeLabelModel smartEdgeLabelModel = new SmartEdgeLabelModel();
                    edgeLabel.setLabelModel(smartEdgeLabelModel, smartEdgeLabelModel.getDefaultParameter());
                    if (!bl) continue;
                }
                edgeCursor.next();
                if (!bl) continue block0;
            }
            break;
        }
    }

    private static boolean b(EdgeLabelModel edgeLabelModel) {
        return edgeLabelModel instanceof FreeEdgeLabelModel || edgeLabelModel instanceof SmartEdgeLabelModel;
    }

    private void b(Graph2D graph2D) {
        boolean bl = YModule.z;
        NodeCursor nodeCursor = graph2D.nodes();
        block0: while (true) {
            boolean bl2 = nodeCursor.ok();
            block1: while (bl2) {
                NodeRealizer nodeRealizer = graph2D.getRealizer(nodeCursor.node());
                for (int i2 = 0; i2 < nodeRealizer.labelCount(); ++i2) {
                    NodeLabel nodeLabel = nodeRealizer.getLabel(i2);
                    NodeLabelModel nodeLabelModel = nodeLabel.getLabelModel();
                    bl2 = BalloonLayoutModule.b(nodeLabelModel);
                    if (bl) continue block1;
                    if (bl2) continue;
                    SmartNodeLabelModel smartNodeLabelModel = new SmartNodeLabelModel();
                    nodeLabel.setLabelModel(smartNodeLabelModel, smartNodeLabelModel.getDefaultParameter());
                    if (!bl) continue;
                }
                nodeCursor.next();
                if (!bl) continue block0;
            }
            break;
        }
    }

    private static boolean b(NodeLabelModel nodeLabelModel) {
        return nodeLabelModel instanceof FreeNodeLabelModel || nodeLabelModel instanceof SmartNodeLabelModel;
    }
}

