/*
 * Decompiled with CFR 0.152.
 */
package y.layout.tree;

import java.util.Comparator;
import y.algo.Trees;
import y.base.DataProvider;
import y.base.Edge;
import y.base.EdgeCursor;
import y.base.EdgeList;
import y.base.Node;
import y.base.NodeCursor;
import y.base.NodeMap;
import y.base.WrongGraphStructure;
import y.layout.CanonicMultiStageLayouter;
import y.layout.EdgeLayout;
import y.layout.LayoutGraph;
import y.layout.LayoutStage;
import y.layout.LayoutTool;
import y.layout.grouping.GroupNodeHider;
import y.layout.tree.AbstractRotatableNodePlacer;
import y.layout.tree.g;

public class HVTreeLayouter
extends CanonicMultiStageLayouter {
    public static final Object SUBTREE_ORIENTATION = "y.layout.tree.HVTreeLayouter.SUBTREE_ORIENTATION";
    public static final Object HORIZONTAL_SUBTREE = "y.layout.tree.HVTreeLayouter.HORIZONTAL_SUBTREE";
    public static final Object VERTICAL_SUBTREE = "y.layout.tree.HVTreeLayouter.VERTICAL_SUBTREE";
    private NodeMap elb;
    private g flb;
    protected LayoutGraph graph;
    private double dlb = 10.0;
    private double clb = 10.0;
    private Comparator blb;

    public HVTreeLayouter() {
        LayoutStage layoutStage = this.getGroupNodeHider();
        if (layoutStage instanceof GroupNodeHider) {
            ((GroupNodeHider)layoutStage).setHidingEmptyGroupNodes(false);
        }
    }

    public void setHorizontalSpace(double d2) {
        this.dlb = d2;
    }

    public double getHorizontalSpace() {
        return this.dlb;
    }

    public void setVerticalSpace(double d2) {
        this.clb = d2;
    }

    public double getVerticalSpace() {
        return this.clb;
    }

    public void doLayoutCore(LayoutGraph layoutGraph) {
        boolean bl = AbstractRotatableNodePlacer.z;
        if (!Trees.isTree(layoutGraph)) {
            throw new WrongGraphStructure("Graph is not a tree");
        }
        LayoutTool.resetPaths(layoutGraph);
        this.graph = layoutGraph;
        EdgeList edgeList = Trees.directTree(layoutGraph);
        this.flb = new g(layoutGraph);
        Node node = this.flb.d();
        this.elb = layoutGraph.createNodeMap();
        this.ub(node);
        this.yb(node);
        layoutGraph.disposeNodeMap(this.elb);
        while (!edgeList.isEmpty()) {
            Edge edge = edgeList.popEdge();
            LayoutTool.reverseEdgeLayout(layoutGraph.getLayout(edge));
            layoutGraph.reverseEdge(edge);
            if (!bl) continue;
        }
    }

    public boolean canLayoutCore(LayoutGraph layoutGraph) {
        return Trees.isTree(layoutGraph);
    }

    protected boolean isVerticalRoot(Node node) {
        DataProvider dataProvider = this.graph.getDataProvider(SUBTREE_ORIENTATION);
        if (dataProvider == null) {
            return false;
        }
        return dataProvider.get(node) == VERTICAL_SUBTREE;
    }

    protected boolean isHorizontalRoot(Node node) {
        DataProvider dataProvider = this.graph.getDataProvider(SUBTREE_ORIENTATION);
        if (dataProvider == null) {
            return true;
        }
        return dataProvider.get(node) == HORIZONTAL_SUBTREE;
    }

    void yb(Node node) {
        block5: {
            block4: {
                if (!this.isVerticalRoot(node)) break block4;
                this.vb(node);
                if (!AbstractRotatableNodePlacer.z) break block5;
            }
            if (this.isHorizontalRoot(node)) {
                this.wb(node);
            }
        }
    }

    void ub(Node node) {
        block5: {
            block4: {
                if (!this.isVerticalRoot(node)) break block4;
                this.xb(node);
                if (!AbstractRotatableNodePlacer.z) break block5;
            }
            if (this.isHorizontalRoot(node)) {
                this.zb(node);
            }
        }
    }

    void zb(Node node) {
        boolean bl = AbstractRotatableNodePlacer.z;
        _b _b2 = new _b();
        _b2.c = this.graph.getWidth(node);
        _b2.b = this.graph.getHeight(node);
        this.elb.set(node, _b2);
        if (!this.flb.d(node)) {
            double d2;
            block3: {
                double d3 = 0.0;
                d2 = 0.0;
                NodeCursor nodeCursor = this.getSuccessors(node);
                while (nodeCursor.ok()) {
                    Node node2 = nodeCursor.node();
                    this.ub(node2);
                    _b _b3 = (_b)this.elb.get(node2);
                    d3 = Math.max(d3, _b3.b);
                    d2 += _b3.c + this.dlb;
                    nodeCursor.next();
                    if (!bl) {
                        if (!bl) continue;
                    }
                    break block3;
                }
                _b2.b = _b2.b + this.clb + d3;
            }
            _b2.c += d2;
        }
    }

    void xb(Node node) {
        boolean bl = AbstractRotatableNodePlacer.z;
        _b _b2 = new _b();
        _b2.c = this.graph.getWidth(node);
        _b2.b = this.graph.getHeight(node);
        this.elb.set(node, _b2);
        if (!this.flb.d(node)) {
            double d2;
            block3: {
                double d3 = 0.0;
                d2 = 0.0;
                NodeCursor nodeCursor = this.getSuccessors(node);
                while (nodeCursor.ok()) {
                    Node node2 = nodeCursor.node();
                    this.ub(node2);
                    _b _b3 = (_b)this.elb.get(node2);
                    d3 = Math.max(d3, _b3.c);
                    d2 += _b3.b + this.clb;
                    nodeCursor.next();
                    if (!bl) {
                        if (!bl) continue;
                    }
                    break block3;
                }
                _b2.c = _b2.c + this.dlb + d3;
            }
            _b2.b += d2;
        }
    }

    protected NodeCursor getSuccessors(Node node) {
        if (this.blb != null) {
            node.sortOutEdges(this.blb);
        }
        return node.successors();
    }

    public Comparator getComparator() {
        return this.blb;
    }

    public void setComparator(Comparator comparator) {
        this.blb = comparator;
    }

    void vb(Node node) {
        boolean bl = AbstractRotatableNodePlacer.z;
        _b _b2 = (_b)this.elb.get(node);
        double d2 = this.graph.getY(node) + this.graph.getHeight(node) + this.clb;
        double d3 = this.graph.getX(node) + this.graph.getWidth(node) + this.dlb;
        EdgeCursor edgeCursor = node.outEdges();
        while (edgeCursor.ok()) {
            Edge edge = edgeCursor.edge();
            Node node2 = edge.target();
            _b _b3 = (_b)this.elb.get(node2);
            this.graph.setLocation(node2, d3, d2);
            d2 += _b3.b + this.clb;
            this.yb(node2);
            EdgeLayout edgeLayout = this.graph.getLayout(edge);
            edgeLayout.clearPoints();
            edgeLayout.addPoint(this.graph.getCenterX(node), this.graph.getCenterY(node2));
            edgeCursor.next();
            if (!bl) continue;
        }
    }

    void wb(Node node) {
        boolean bl = AbstractRotatableNodePlacer.z;
        _b _b2 = (_b)this.elb.get(node);
        double d2 = this.graph.getY(node) + this.graph.getHeight(node) + this.clb;
        double d3 = this.graph.getX(node) + this.graph.getWidth(node) + this.dlb;
        EdgeCursor edgeCursor = node.outEdges();
        while (edgeCursor.ok()) {
            Edge edge = edgeCursor.edge();
            Node node2 = edge.target();
            _b _b3 = (_b)this.elb.get(node2);
            this.graph.setLocation(node2, d3, d2);
            d3 += _b3.c + this.dlb;
            this.yb(node2);
            EdgeLayout edgeLayout = this.graph.getLayout(edge);
            edgeLayout.clearPoints();
            edgeLayout.addPoint(this.graph.getCenterX(node2), this.graph.getCenterY(node));
            edgeCursor.next();
            if (!bl) continue;
        }
    }

    static class _b {
        double c;
        double b;
        double e;
        double d;

        _b() {
        }
    }
}

