/*
 * Decompiled with CFR 0.152.
 */
package y.layout.tree;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import y.base.DataProvider;
import y.base.Edge;
import y.base.EdgeCursor;
import y.base.EdgeList;
import y.base.Node;
import y.base.YList;
import y.geom.YPoint;
import y.layout.EdgeLayout;
import y.layout.LayoutGraph;
import y.layout.NodeLayout;
import y.layout.PortConstraint;
import y.layout.PortConstraintKeys;
import y.layout.tree.AbstractRotatableNodePlacer;
import y.layout.tree.PortAssignment;

public class DefaultPortAssignment
implements PortAssignment {
    public static final byte MODE_PORT_CONSTRAINTS = 1;
    public static final byte MODE_PORT_DISTRIBUTED_NORTH = 2;
    public static final byte MODE_PORT_DISTRIBUTED_SOUTH = 3;
    public static final byte MODE_PORT_DISTRIBUTED_EAST = 4;
    public static final byte MODE_PORT_DISTRIBUTED_WEST = 5;
    public static final byte MODE_NONE = 0;
    private byte b;
    private double d;
    private boolean c;

    public DefaultPortAssignment() {
        this(0, 0.5);
    }

    public DefaultPortAssignment(byte by) {
        this(by, 0.5);
    }

    public DefaultPortAssignment(byte by, double d2) {
        this.b = by;
        this.d = d2;
        this.c = false;
    }

    public void assignPorts(LayoutGraph layoutGraph, Node node) {
        block6: {
            boolean bl;
            block5: {
                bl = AbstractRotatableNodePlacer.z;
                if (node.firstInEdge() != null) {
                    this.assignParentEdgeTargetPort(layoutGraph, node, node.firstInEdge());
                }
                if (!DefaultPortAssignment.b(layoutGraph) || node.degree() <= 2) break block5;
                this.c(layoutGraph, node);
                if (!bl) break block6;
            }
            int n2 = 0;
            Edge edge = node.firstOutEdge();
            while (edge != null) {
                this.assignChildEdgeSourcePort(layoutGraph, node, edge, n2);
                edge = edge.nextOutEdge();
                ++n2;
                if (!bl) continue;
            }
        }
    }

    protected void assignParentEdgeTargetPort(LayoutGraph layoutGraph, Node node, Edge edge) {
        boolean bl = AbstractRotatableNodePlacer.z;
        EdgeLayout edgeLayout = layoutGraph.getEdgeLayout(edge);
        switch (this.b) {
            default: {
                edgeLayout.setTargetPoint(YPoint.ORIGIN);
                if (!bl) break;
            }
            case 1: {
                PortConstraint portConstraint = this.getTargetPortConstraint(layoutGraph, edge);
                if (portConstraint != null && portConstraint.isStrong()) break;
                if (portConstraint == null || portConstraint.isAtAnySide()) {
                    edgeLayout.setTargetPoint(YPoint.ORIGIN);
                    if (!bl) break;
                }
                NodeLayout nodeLayout = layoutGraph.getNodeLayout(node);
                if (portConstraint.isAtNorth()) {
                    edgeLayout.setTargetPoint(new YPoint(0.0, -nodeLayout.getHeight() * 0.5));
                    if (!bl) break;
                }
                if (portConstraint.isAtEast()) {
                    edgeLayout.setTargetPoint(new YPoint(nodeLayout.getWidth() * 0.5, 0.0));
                    if (!bl) break;
                }
                if (portConstraint.isAtSouth()) {
                    edgeLayout.setTargetPoint(new YPoint(0.0, nodeLayout.getHeight() * 0.5));
                    if (!bl) break;
                }
                edgeLayout.setTargetPoint(new YPoint(-nodeLayout.getWidth() * 0.5, 0.0));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void assignChildEdgeSourcePort(LayoutGraph layoutGraph, Node node, Edge edge, int n2) {
        boolean bl = AbstractRotatableNodePlacer.z;
        EdgeLayout edgeLayout = layoutGraph.getEdgeLayout(edge);
        NodeLayout nodeLayout = layoutGraph.getNodeLayout(node);
        double d2 = nodeLayout.getWidth();
        double d3 = nodeLayout.getHeight();
        int n3 = DefaultPortAssignment.b(node, layoutGraph);
        int n4 = this.c ? -1 : 1;
        switch (this.b) {
            case 2: {
                double d4 = this.getPortBorderGap(d2, n3);
                double d5 = this.getPortDistanceDelta(d2, n3, d4);
                edgeLayout.setSourcePoint(new YPoint((double)n4 * (d4 + (double)n2 * d5 - d2 / 2.0), -d3 / 2.0));
                return;
            }
            case 3: {
                double d6 = this.getPortBorderGap(d2, n3);
                double d7 = this.getPortDistanceDelta(d2, n3, d6);
                edgeLayout.setSourcePoint(new YPoint((double)n4 * (d6 + (double)n2 * d7 - d2 / 2.0), d3 / 2.0));
                return;
            }
            case 4: {
                double d8 = this.getPortBorderGap(d3, n3);
                double d9 = this.getPortDistanceDelta(d3, n3, d8);
                edgeLayout.setSourcePoint(new YPoint(d2 / 2.0, (double)n4 * (d8 + (double)n2 * d9 - d3 / 2.0)));
                return;
            }
            case 5: {
                double d10 = this.getPortBorderGap(d3, n3);
                double d11 = this.getPortDistanceDelta(d3, n3, d10);
                edgeLayout.setSourcePoint(new YPoint(-d2 / 2.0, (double)n4 * (d10 + (double)n2 * d11 - d3 / 2.0)));
                return;
            }
            case 0: {
                edgeLayout.setSourcePoint(YPoint.ORIGIN);
                return;
            }
            case 1: {
                PortConstraint portConstraint = this.getSourcePortConstraint(layoutGraph, edge, n2);
                if (portConstraint != null && portConstraint.isStrong()) return;
                if (portConstraint == null || portConstraint.isAtAnySide()) {
                    edgeLayout.setSourcePoint(YPoint.ORIGIN);
                    if (!bl) return;
                }
                if (portConstraint.isAtNorth()) {
                    edgeLayout.setSourcePoint(new YPoint(0.0, -nodeLayout.getHeight() * 0.5));
                    if (!bl) return;
                }
                if (portConstraint.isAtEast()) {
                    edgeLayout.setSourcePoint(new YPoint(nodeLayout.getWidth() * 0.5, 0.0));
                    if (!bl) return;
                }
                if (portConstraint.isAtSouth()) {
                    edgeLayout.setSourcePoint(new YPoint(0.0, nodeLayout.getHeight() * 0.5));
                    if (!bl) return;
                }
                edgeLayout.setSourcePoint(new YPoint(-nodeLayout.getWidth() * 0.5, 0.0));
                return;
            }
        }
    }

    private void c(LayoutGraph layoutGraph, Node node) {
        boolean bl = AbstractRotatableNodePlacer.z;
        EdgeList edgeList = DefaultPortAssignment.b(layoutGraph, node);
        int n2 = -1;
        Object object = null;
        YPoint yPoint = null;
        EdgeCursor edgeCursor = edgeList.edges();
        while (edgeCursor.ok()) {
            block4: {
                Edge edge;
                block5: {
                    EdgeLayout edgeLayout;
                    block3: {
                        edge = edgeCursor.edge();
                        edgeLayout = layoutGraph.getEdgeLayout(edge);
                        Object object2 = DefaultPortAssignment.b(layoutGraph, edge);
                        if (object2 != null && object2.equals(object)) break block3;
                        object = object2;
                        this.assignChildEdgeSourcePort(layoutGraph, node, edge, ++n2);
                        if (1 != this.getMode()) break block4;
                        yPoint = edgeLayout.getSourcePoint();
                        if (!bl) break block4;
                    }
                    if (yPoint == null) break block5;
                    edgeLayout.setSourcePoint(yPoint);
                    if (!bl) break block4;
                }
                this.assignChildEdgeSourcePort(layoutGraph, node, edge, n2);
            }
            edgeCursor.next();
            if (!bl) continue;
        }
    }

    static EdgeList b(LayoutGraph layoutGraph, Node node) {
        Object object;
        block4: {
            List<Object> list;
            Object object2;
            Object object3;
            boolean bl = AbstractRotatableNodePlacer.z;
            HashMap<Object, ArrayList<Object>> hashMap = new HashMap<Object, ArrayList<Object>>();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Object object4 = node.outEdges();
            while (object4.ok()) {
                object3 = object4.edge();
                object2 = DefaultPortAssignment.b(layoutGraph, (Edge)object3);
                list = (ArrayList<Object>)hashMap.get(object2);
                if (list == null) {
                    list = new ArrayList<Object>();
                    hashMap.put(object2, (ArrayList<Object>)list);
                    arrayList.add(object2);
                }
                list.add(object3);
                object4.next();
                if (!bl) continue;
            }
            object4 = new EdgeList();
            object3 = arrayList.iterator();
            while (object3.hasNext()) {
                object2 = object3.next();
                list = (List)hashMap.get(object2);
                object = object4;
                if (!bl) {
                    ((YList)object).addAll(list);
                    if (!bl) continue;
                }
                break block4;
            }
            object = object4;
        }
        return object;
    }

    static Object b(LayoutGraph layoutGraph, Edge edge) {
        DataProvider dataProvider = layoutGraph.getDataProvider(PortConstraintKeys.SOURCE_GROUPID_KEY);
        return dataProvider != null ? dataProvider.get(edge) : null;
    }

    private static boolean b(LayoutGraph layoutGraph) {
        return layoutGraph.getDataProvider(PortConstraintKeys.SOURCE_GROUPID_KEY) != null;
    }

    private static int b(Node node, LayoutGraph layoutGraph) {
        boolean bl = AbstractRotatableNodePlacer.z;
        if (DefaultPortAssignment.b(layoutGraph)) {
            HashSet<Object> hashSet = new HashSet<Object>();
            int n2 = 0;
            EdgeCursor edgeCursor = node.outEdges();
            while (edgeCursor.ok()) {
                Edge edge = edgeCursor.edge();
                Object object = DefaultPortAssignment.b(layoutGraph, edge);
                if (object == null || hashSet.add(object)) {
                    ++n2;
                }
                edgeCursor.next();
                if (!bl) continue;
            }
            return n2;
        }
        return node.outDegree();
    }

    protected double getPortBorderGap(double d2, int n2) {
        if (n2 <= 1) {
            return d2 * 0.5;
        }
        return this.d * (d2 / ((double)(n2 - 1) + 2.0 * this.d));
    }

    protected double getPortDistanceDelta(double d2, int n2, double d3) {
        if (n2 <= 1) {
            return 0.0;
        }
        return (d2 - 2.0 * d3) / (double)(n2 - 1);
    }

    protected PortConstraint getSourcePortConstraint(LayoutGraph layoutGraph, Edge edge, int n2) {
        return PortConstraint.getSPC(layoutGraph, edge);
    }

    protected PortConstraint getTargetPortConstraint(LayoutGraph layoutGraph, Edge edge) {
        return PortConstraint.getTPC(layoutGraph, edge);
    }

    public byte getMode() {
        return this.b;
    }

    public void setMode(byte by) {
        this.b = by;
    }

    public double getBorderGapToPortGapRatio() {
        return this.d;
    }

    public void setBorderGapToPortGapRatio(double d2) {
        this.d = d2;
    }

    public boolean isReversedPortOrder() {
        return this.c;
    }

    public void setReversedPortOrder(boolean bl) {
        this.c = bl;
    }
}

