/*
 * Decompiled with CFR 0.152.
 */
package y.layout.tree;

import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import y.base.DataMap;
import y.base.DataProvider;
import y.base.Edge;
import y.base.Node;
import y.geom.YPoint;
import y.layout.GraphLayout;
import y.layout.LayoutGraph;
import y.layout.PortConstraint;
import y.layout.tree.DefaultNodePlacer;
import y.layout.tree.FromSketchNodePlacer;
import y.layout.tree.GenericTreeLayouter;
import y.layout.tree.Processor;
import y.layout.tree.c;
import y.layout.tree.f;
import y.layout.tree.h;

public abstract class AbstractRotatableNodePlacer
implements FromSketchNodePlacer {
    protected double spacing = 20.0;
    protected LayoutGraph graph;
    protected final Matrix modificationMatrix;
    protected DataProvider subtreeShapeProvider;
    protected DataProvider nodeShapeProvider;
    protected List createdChildren;
    public static boolean z;

    protected AbstractRotatableNodePlacer(Matrix matrix) {
        this.modificationMatrix = matrix;
    }

    public Processor createProcessor(GenericTreeLayouter genericTreeLayouter, LayoutGraph layoutGraph, Node node) {
        return null;
    }

    protected YPoint getSourcePointAbs(Edge edge) {
        return AbstractRotatableNodePlacer.translatePoint(this.modificationMatrix, this.graph.getSourcePointAbs(edge));
    }

    h._b b(Edge edge, c c2) {
        return new h._b(this.modificationMatrix, this.graph, edge, c2);
    }

    h._c b(Node node, c c2) {
        return new h._c(this.createRootNodeShape(node), c2);
    }

    protected abstract c placeSubtree(Node var1, byte var2);

    protected c createRootNodeShape(Node node) {
        return new c(this.modificationMatrix, (GenericTreeLayouter.SubtreeShape)this.nodeShapeProvider.get(node));
    }

    protected c createSubtreeShape(Node node) {
        c c2 = new c(this.modificationMatrix, (GenericTreeLayouter.SubtreeShape)this.subtreeShapeProvider.get(node));
        this.createdChildren.add(c2);
        return c2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void determineChildConnectors(Node node, DataMap dataMap) {
        boolean bl = z;
        this.graph = (LayoutGraph)node.getGraph();
        try {
            for (Edge edge = node.firstOutEdge(); edge != null; edge = edge.nextOutEdge()) {
                Node node2 = edge.target();
                byte by = this.determineChildConnector(node2);
                byte by2 = this.translateDirectionToReal(by);
                dataMap.setInt(node2, by2);
                if (!bl && !bl) continue;
                break;
            }
        }
        finally {
            this.graph = null;
        }
    }

    protected PortConstraint getPortConstraint(Node node) {
        PortConstraint portConstraint;
        block5: {
            Edge edge;
            block4: {
                edge = node.firstInEdge();
                if (edge != null) break block4;
                portConstraint = PortConstraint.create((byte)0);
                if (!z) break block5;
            }
            if ((portConstraint = PortConstraint.getTPC(this.graph, edge)) == null) {
                portConstraint = PortConstraint.create((byte)0);
            }
        }
        return this.b(portConstraint);
    }

    private PortConstraint b(PortConstraint portConstraint) {
        _b _b2;
        _b _b3;
        block8: {
            block11: {
                boolean bl;
                block10: {
                    block9: {
                        block7: {
                            bl = z;
                            if (!portConstraint.isAtNorth()) break block7;
                            _b3 = _b.g;
                            if (!bl) break block8;
                        }
                        if (!portConstraint.isAtEast()) break block9;
                        _b3 = _b.h;
                        if (!bl) break block8;
                    }
                    if (!portConstraint.isAtSouth()) break block10;
                    _b3 = _b.d;
                    if (!bl) break block8;
                }
                if (!portConstraint.isAtWest()) break block11;
                _b3 = _b.e;
                if (!bl) break block8;
            }
            return portConstraint;
        }
        if ((_b2 = _b3.b(this.modificationMatrix.b())).equals(_b.g)) {
            return PortConstraint.create((byte)1);
        }
        if (_b2.equals(_b.h)) {
            return PortConstraint.create((byte)4);
        }
        if (_b2.equals(_b.d)) {
            return PortConstraint.create((byte)2);
        }
        if (_b2.equals(_b.e)) {
            return PortConstraint.create((byte)8);
        }
        throw new RuntimeException("Should not reach... " + portConstraint);
    }

    protected byte translateDirectionToReal(byte by) {
        _b _b2;
        _b _b3;
        boolean bl = z;
        switch (by) {
            case 0: {
                _b3 = _b.g;
                if (!bl) break;
            }
            case 1: {
                _b3 = _b.h;
                if (!bl) break;
            }
            case 2: {
                _b3 = _b.d;
                if (!bl) break;
            }
            case 3: {
                _b3 = _b.e;
                if (!bl) break;
            }
            case -1: {
                return -1;
            }
            case -2: {
                return -2;
            }
            default: {
                throw new IllegalArgumentException("Not implemented for " + by);
            }
        }
        if ((_b2 = _b3.b(this.modificationMatrix)).equals(_b.g)) {
            return 0;
        }
        if (_b2.equals(_b.h)) {
            return 1;
        }
        if (_b2.equals(_b.d)) {
            return 2;
        }
        if (_b2.equals(_b.e)) {
            return 3;
        }
        throw new RuntimeException("Should not reach... " + by);
    }

    protected byte translateDirectionToModel(byte by) {
        _b _b2;
        _b _b3;
        boolean bl = z;
        switch (by) {
            case 0: {
                _b3 = _b.g;
                if (!bl) break;
            }
            case 1: {
                _b3 = _b.h;
                if (!bl) break;
            }
            case 2: {
                _b3 = _b.d;
                if (!bl) break;
            }
            case 3: {
                _b3 = _b.e;
                if (!bl) break;
            }
            case -1: {
                return -1;
            }
            case -2: {
                return -2;
            }
            default: {
                throw new IllegalArgumentException("Not implemented for " + by);
            }
        }
        if ((_b2 = _b3.b(this.modificationMatrix.b())).equals(_b.g)) {
            return 0;
        }
        if (_b2.equals(_b.h)) {
            return 1;
        }
        if (_b2.equals(_b.d)) {
            return 2;
        }
        if (_b2.equals(_b.e)) {
            return 3;
        }
        throw new RuntimeException("Should not reach... " + by);
    }

    protected abstract byte determineChildConnector(Node var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenericTreeLayouter.SubtreeShape placeSubtree(DataProvider dataProvider, DataProvider dataProvider2, LayoutGraph layoutGraph, Node node, byte by) {
        this.subtreeShapeProvider = dataProvider2;
        this.nodeShapeProvider = dataProvider;
        this.graph = layoutGraph;
        try {
            this.createdChildren = new ArrayList();
            c c2 = this.placeSubtree(node, this.translateDirectionToModel(by));
            c2.h();
            GenericTreeLayouter.SubtreeShape subtreeShape = c2.m();
            Object var9_8 = null;
            dataProvider2 = null;
            dataProvider = null;
            layoutGraph = null;
            return subtreeShape;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            dataProvider2 = null;
            dataProvider = null;
            layoutGraph = null;
            throw throwable;
        }
    }

    public Matrix getModificationMatrix() {
        return this.modificationMatrix;
    }

    public Comparator createComparator() {
        DefaultNodePlacer._b _b2;
        block5: {
            block4: {
                if (this.modificationMatrix.b(0, 0) != 0.0) break block4;
                _b2 = new DefaultNodePlacer._b(true);
                if (!(this.modificationMatrix.b(1).b() < 0.0)) break block5;
                _b2.b(-1);
                if (!z) break block5;
            }
            _b2 = new DefaultNodePlacer._b(false);
            if (this.modificationMatrix.b(0).b() < 0.0) {
                _b2.b(-1);
            }
        }
        return _b2;
    }

    public static YPoint translatePoint(Matrix matrix, YPoint yPoint) {
        if (yPoint == null) {
            return null;
        }
        _b _b2 = _b.b(yPoint.getX(), yPoint.getY());
        _b _b3 = _b2.b(matrix.b());
        return new YPoint(_b3.b(0), _b3.b(1));
    }

    public double getSpacing() {
        return this.spacing;
    }

    public void setSpacing(double d2) {
        this.spacing = d2;
    }

    public Comparator createFromSketchComparator() {
        return this.createComparator();
    }

    static class _b {
        static final _b g = new _b(0.0, -1.0);
        static final _b h = new _b(1.0, 0.0);
        static final _b d = new _b(0.0, 1.0);
        static final _b e = new _b(-1.0, 0.0);
        static final _b b = new _b(0.0, 0.0);
        private final double[] f;
        private double c = Double.NaN;

        private _b(double[] dArray) {
            this.f = dArray;
        }

        private _b(double d2, double d3) {
            this(new double[]{d2, d3});
        }

        double b(_b _b2) {
            double d2;
            block2: {
                boolean bl = z;
                double d3 = 0.0;
                for (int i2 = 0; i2 < this.f.length; ++i2) {
                    double d4 = this.f[i2];
                    double d5 = _b2.b(i2);
                    d2 = d3 + d4 * d5;
                    if (!bl) {
                        d3 = d2;
                        if (!bl) continue;
                    }
                    break block2;
                }
                d2 = d3;
            }
            return d2;
        }

        double b(int n2) {
            return this.f[n2];
        }

        _b b(Matrix matrix) {
            double d2 = this.b(matrix.b(0));
            double d3 = this.b(matrix.b(1));
            return _b.b(d2, d3);
        }

        public boolean b(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            _b _b2 = (_b)object;
            return Arrays.equals(this.f, _b2.f);
        }

        public String toString() {
            StringBuffer stringBuffer;
            block6: {
                boolean bl = z;
                stringBuffer = new StringBuffer("Vector:\n");
                for (int i2 = 0; i2 < this.f.length; ++i2) {
                    double d2 = this.f[i2];
                    stringBuffer.append(d2).append(' ');
                    if (!bl) {
                        if (!bl) continue;
                    }
                    break block6;
                }
                if (this == g) {
                    stringBuffer.append("\n NORTH");
                }
            }
            if (this == h) {
                stringBuffer.append("\n EAST");
            }
            if (this == d) {
                stringBuffer.append("\n SOUTH");
            }
            if (this == e) {
                stringBuffer.append("\n WEST");
            }
            return stringBuffer.toString();
        }

        _b b(double d2) {
            double[] dArray;
            block2: {
                boolean bl = z;
                double[] dArray2 = new double[this.f.length];
                for (int i2 = 0; i2 < this.f.length; ++i2) {
                    double d3 = this.f[i2];
                    dArray = dArray2;
                    if (!bl) {
                        dArray[i2] = d3 * d2;
                        if (!bl) continue;
                    }
                    break block2;
                }
                dArray = dArray2;
            }
            return _b.b(dArray);
        }

        double b() {
            _b _b2;
            boolean bl = z;
            if (Double.isNaN(this.c)) {
                this.c = 0.0;
                for (int i2 = 0; i2 < this.f.length; ++i2) {
                    _b2 = this;
                    if (!bl) {
                        _b2.c += this.f[i2];
                        if (!bl) continue;
                    }
                    break;
                }
            } else {
                _b2 = this;
            }
            return _b2.c;
        }

        int c() {
            if (this == g) {
                return 0;
            }
            if (this == h) {
                return 1;
            }
            if (this == d) {
                return 2;
            }
            if (this == e) {
                return 3;
            }
            throw new IllegalArgumentException("not a direction " + this);
        }

        static _b c(int n2) {
            if (n2 == 0) {
                return g;
            }
            if (n2 == 1) {
                return h;
            }
            if (n2 == 2) {
                return d;
            }
            if (n2 == 3) {
                return e;
            }
            throw new IllegalArgumentException("Invalid direction " + n2);
        }

        static _b b(double[] dArray) {
            if (dArray.length == 2) {
                return _b.b(dArray[0], dArray[1]);
            }
            return new _b(dArray);
        }

        static _b b(double d2, double d3) {
            if (_b.b.f[0] == d2 && _b.b.f[1] == d3) {
                return b;
            }
            if (_b.g.f[0] == d2 && _b.g.f[1] == d3) {
                return g;
            }
            if (_b.h.f[0] == d2 && _b.h.f[1] == d3) {
                return h;
            }
            if (_b.d.f[0] == d2 && _b.d.f[1] == d3) {
                return d;
            }
            if (_b.e.f[0] == d2 && _b.e.f[1] == d3) {
                return e;
            }
            return new _b(d2, d3);
        }

        static _b b(YPoint yPoint) {
            return _b.b(yPoint.getX(), yPoint.getY());
        }
    }

    public static class Matrix {
        public static final Matrix DEFAULT = new Matrix(1.0, 0.0, 0.0, 1.0);
        public static final Matrix ROT90 = new Matrix(0.0, -1.0, 1.0, 0.0);
        public static final Matrix ROT180 = new Matrix(-1.0, 0.0, 0.0, -1.0);
        public static final Matrix ROT270 = new Matrix(0.0, 1.0, -1.0, 0.0);
        public static final Matrix MIR_HOR = new Matrix(1.0, 0.0, 0.0, -1.0);
        public static final Matrix MIR_VERT = new Matrix(-1.0, 0.0, 0.0, 1.0);
        public static final Matrix MIR_HOR_ROT90 = new Matrix(0.0, -1.0, -1.0, 0.0);
        public static final Matrix MIR_VERT_ROT90 = new Matrix(0.0, 1.0, 1.0, 0.0);
        public static final List AVAILABLE;
        private final double[][] d = new double[2][2];
        private Matrix b;
        private _b[] c;
        private _b[] e;

        private static Matrix b(double d2, double d3, double d4, double d5) {
            boolean bl = z;
            for (int i2 = 0; i2 < AVAILABLE.size(); ++i2) {
                Matrix matrix = (Matrix)AVAILABLE.get(i2);
                if (matrix.b(0, 0) != d2 || matrix.b(1, 0) != d4 || matrix.b(0, 1) != d3 || matrix.b(1, 1) != d5) continue;
                return matrix;
            }
            throw new IllegalArgumentException("No matrix found for the values " + d2 + " " + d3 + " " + d4 + " " + d5);
        }

        Matrix(double d2, double d3, double d4, double d5) {
            this.d[0][0] = d2;
            this.d[0][1] = d3;
            this.d[1][0] = d4;
            this.d[1][1] = d5;
            this.c = new _b[]{_b.b(new double[]{this.d[0][0], this.d[1][0]}), _b.b(new double[]{this.d[0][1], this.d[1][1]})};
            this.e = new _b[]{_b.b(this.d[0]), _b.b(this.d[1])};
        }

        double b(int n2, int n3) {
            return this.d[n2][n3];
        }

        _b c(int n2) {
            return this.e[n2];
        }

        _b b(int n2) {
            return this.c[n2];
        }

        public Matrix multiply(Matrix matrix) {
            double d2 = this.c(0).b(matrix.b(0));
            double d3 = this.c(0).b(matrix.b(1));
            double d4 = this.c(1).b(matrix.b(0));
            double d5 = this.c(1).b(matrix.b(1));
            return Matrix.b(d2, d3, d4, d5);
        }

        public String toString() {
            StringBuffer stringBuffer;
            block3: {
                boolean bl = z;
                StringBuffer stringBuffer2 = new StringBuffer("Matrix:\n");
                int n2 = 0;
                while (n2 < this.d.length) {
                    block4: {
                        double[] dArray = this.d[n2];
                        stringBuffer = stringBuffer2.append(n2).append(": ");
                        if (bl) break block3;
                        for (int i2 = 0; i2 < dArray.length; ++i2) {
                            double d2 = dArray[i2];
                            stringBuffer2.append(d2);
                            stringBuffer2.append(' ');
                            if (!bl) {
                                if (!bl) continue;
                            }
                            break block4;
                        }
                        stringBuffer2.append('\n');
                        ++n2;
                    }
                    if (!bl) continue;
                }
                stringBuffer = stringBuffer2;
            }
            return stringBuffer.toString();
        }

        Matrix b() {
            return this.b;
        }

        public boolean equalValues(Matrix matrix) {
            return this.e[0].b((Object)matrix.e[0]) && this.e[1].b((Object)matrix.e[1]);
        }

        static /* synthetic */ Matrix access$100(Matrix matrix) {
            return matrix.b;
        }

        static {
            ArrayList<Matrix> arrayList = new ArrayList<Matrix>(10);
            arrayList.add(DEFAULT);
            arrayList.add(ROT90);
            arrayList.add(ROT180);
            arrayList.add(ROT270);
            arrayList.add(MIR_HOR);
            arrayList.add(MIR_VERT);
            arrayList.add(MIR_HOR_ROT90);
            arrayList.add(MIR_VERT_ROT90);
            AVAILABLE = Collections.unmodifiableList(arrayList);
            Matrix.DEFAULT.b = DEFAULT;
            Matrix.ROT90.b = ROT270;
            Matrix.ROT270.b = ROT90;
            Matrix.ROT180.b = ROT180;
            Matrix.MIR_HOR.b = MIR_HOR;
            Matrix.MIR_VERT.b = MIR_VERT;
            Matrix.MIR_HOR_ROT90.b = MIR_HOR_ROT90;
            Matrix.MIR_VERT_ROT90.b = MIR_VERT_ROT90;
        }
    }

    public static abstract class RootAlignment {
        public static final RootAlignment CENTER = new RootAlignment(){

            protected void placeParentHorizontal(c c2, List list, Rectangle2D rectangle2D, double d2) {
                Rectangle2D rectangle2D2 = RootAlignment.access$000(list);
                GenericTreeLayouter.SubtreeShape._c _c2 = c2.j();
                c2.i(-(_c2.i() + _c2.g()) * 0.5 + rectangle2D2.getCenterX());
            }
        };
        public static final RootAlignment MEDIAN = new RootAlignment(){

            protected void placeParentHorizontal(c c2, List list, Rectangle2D rectangle2D, double d2) {
                double d3;
                Object object;
                block3: {
                    block2: {
                        if (list.size() % 2 != 0) break block2;
                        object = (c)list.get(list.size() / 2);
                        c c3 = (c)list.get(list.size() / 2 - 1);
                        d3 = (((c)object).k() + c3.k()) / 2.0;
                        if (!z) break block3;
                    }
                    object = (c)list.get(list.size() / 2);
                    d3 = ((c)object).k();
                }
                object = c2.j();
                c2.i(-((GenericTreeLayouter.SubtreeShape._c)object).f() + d3);
            }
        };
        public static final RootAlignment LEADING = new RootAlignment(){

            protected void placeParentHorizontal(c c2, List list, Rectangle2D rectangle2D, double d2) {
                GenericTreeLayouter.SubtreeShape._c _c2 = c2.j();
                Rectangle2D rectangle2D2 = RootAlignment.access$000(list);
                c2.i(-_c2.i() + rectangle2D2.getMinX() - _c2.b() - d2);
            }
        };
        public static final RootAlignment TRAILING = new RootAlignment(){

            protected void placeParentHorizontal(c c2, List list, Rectangle2D rectangle2D, double d2) {
                GenericTreeLayouter.SubtreeShape._c _c2 = c2.j();
                Rectangle2D rectangle2D2 = RootAlignment.access$000(list);
                c2.i(-_c2.i() + (rectangle2D2.getMaxX() + d2));
            }
        };
        public static final RootAlignment LEFT = new RootAlignment(){

            protected void placeParentHorizontal(c c2, List list, Rectangle2D rectangle2D, double d2) {
                GenericTreeLayouter.SubtreeShape._c _c2 = c2.j();
                Rectangle2D rectangle2D2 = RootAlignment.access$000(list);
                c2.i(-_c2.i() + rectangle2D2.getMinX());
            }
        };
        public static final RootAlignment RIGHT = new RootAlignment(){

            protected void placeParentHorizontal(c c2, List list, Rectangle2D rectangle2D, double d2) {
                GenericTreeLayouter.SubtreeShape._c _c2 = c2.j();
                Rectangle2D rectangle2D2 = RootAlignment.access$000(list);
                c2.i(-_c2.i() + rectangle2D2.getMaxX() - _c2.b());
            }
        };
        public static final RootAlignment CENTER_OVER_CHILDREN = new RootAlignment(){

            protected void placeParentHorizontal(c c2, List list, Rectangle2D rectangle2D, double d2) {
                double d3;
                double d4;
                double d5;
                GenericTreeLayouter.SubtreeShape._c _c2;
                block3: {
                    boolean bl = z;
                    Matrix matrix = c2.q();
                    Node node = c2.m().d();
                    GraphLayout graphLayout = (GraphLayout)((Object)node.getGraph());
                    _c2 = c2.j();
                    d5 = Double.MAX_VALUE;
                    d4 = -1.7976931348623157E308;
                    for (Edge edge = node.firstOutEdge(); edge != null; edge = edge.nextOutEdge()) {
                        Node node2 = edge.target();
                        f f2 = new f(Matrix.access$100(matrix), graphLayout.getNodeLayout(node2));
                        double d6 = f2.l();
                        double d7 = f2.b();
                        d3 = d6;
                        if (!bl) {
                            if (d3 < d5) {
                                d5 = d6;
                            }
                            if (!(d6 + d7 > d4)) continue;
                            d4 = d6 + d7;
                            if (!bl) continue;
                        }
                        break block3;
                    }
                    d3 = _c2.b();
                }
                double d8 = d3;
                double d9 = (d5 + d4) * 0.5 - d8 * 0.5;
                c2.i(-_c2.i() + d9);
            }
        };
        static final RootAlignment b = new RootAlignment(){

            protected void placeParentHorizontal(c c2, List list, Rectangle2D rectangle2D, double d2) {
                Node node = c2.m().d();
                Edge edge = GenericTreeLayouter.b(node, (LayoutGraph)node.getGraph());
                Node node2 = edge.target();
                Matrix matrix = Matrix.access$100(c2.q());
                GraphLayout graphLayout = (GraphLayout)((Object)node.getGraph());
                f f2 = new f(matrix, graphLayout.getNodeLayout(node));
                f f3 = new f(matrix, graphLayout.getNodeLayout(node2));
                c2.i(-f2.h() + f3.h());
            }
        };
        public static final RootAlignment[] ALL = new RootAlignment[]{CENTER, CENTER_OVER_CHILDREN, LEADING, LEFT, RIGHT, TRAILING};

        private static Rectangle2D b(List list) {
            boolean bl = z;
            double d2 = Double.MAX_VALUE;
            double d3 = -1.7976931348623157E308;
            double d4 = Double.MAX_VALUE;
            double d5 = -1.7976931348623157E308;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                c c2 = (c)iterator.next();
                GenericTreeLayouter.SubtreeShape._c _c2 = c2.j();
                d2 = Math.min(d2, _c2.i());
                d3 = Math.max(d3, _c2.g());
                d4 = Math.min(d4, _c2.h());
                d5 = Math.max(d5, _c2.e());
                if (!bl) continue;
            }
            return new Rectangle2D.Double(d2, d4, d3 - d2, d5 - d4);
        }

        final void b(c c2, List list, double d2) {
            this.placeParentHorizontal(c2, list, RootAlignment.getBounds(list), d2);
        }

        final void b(c c2, c[] cArray, double d2) {
            this.b(c2, Arrays.asList(cArray), d2);
        }

        protected abstract void placeParentHorizontal(c var1, List var2, Rectangle2D var3, double var4);

        protected static Rectangle2D getBounds(List list) {
            Rectangle2D.Double double_;
            block5: {
                boolean bl = z;
                Rectangle2D.Double double_2 = new Rectangle2D.Double(Double.MAX_VALUE, Double.MAX_VALUE, 0.0, 0.0);
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    double d2;
                    double d3;
                    double d4;
                    c c2 = (c)iterator.next();
                    double d5 = c2.c();
                    if (d5 < double_2.x) {
                        double_2.x = d5;
                    }
                    if ((d4 = c2.l()) < double_2.y) {
                        double_2.y = d4;
                    }
                    if ((d3 = c2.f()) > double_2.x + double_2.width) {
                        double_2.width = d3 - double_2.x;
                    }
                    if (!((d2 = c2.o()) > double_2.y + double_2.height)) continue;
                    double_ = double_2;
                    if (!bl) {
                        double_.height = d2 - double_2.y;
                        if (!bl) continue;
                    }
                    break block5;
                }
                double_ = double_2;
            }
            return double_;
        }

        static /* synthetic */ Rectangle2D access$000(List list) {
            return RootAlignment.b(list);
        }
    }
}

