/*
 * Decompiled with CFR 0.152.
 */
package y.layout.router.polyline;

import y.geom.YPoint;
import y.geom.YRectangle;
import y.layout.router.polyline.Interval;

public class OrthogonalInterval {
    private static final double e = 1.0E-6;
    private final Interval c;
    private final double b;
    private final boolean d;

    OrthogonalInterval(double d2, double d3, double d4, double d5) {
        if (Math.abs(d3 - d5) < 1.0E-6 && Math.abs(d2 - d4) < 1.0E-6) {
            throw new IllegalStateException("Not able to calculate the orientation.");
        }
        this.d = Math.abs(d2 - d4) < 1.0E-6;
        this.c = this.d ? new Interval(d3, d5) : new Interval(d2, d4);
        this.b = this.d ? d2 : d3;
    }

    public OrthogonalInterval(double d2, double d3, double d4, boolean bl) {
        this(new Interval(d2, d3), d4, bl);
    }

    public OrthogonalInterval(Interval interval, double d2, boolean bl) {
        if (interval == null) {
            throw new IllegalArgumentException("range must not be null");
        }
        this.c = interval;
        this.b = d2;
        this.d = bl;
    }

    public boolean isVertical() {
        return this.d;
    }

    public double getMin() {
        return this.c.getMin();
    }

    public double getMax() {
        return this.c.getMax();
    }

    public double getSize() {
        return this.c.getMax() - this.c.getMin();
    }

    public Interval getRange() {
        return this.c;
    }

    public double getLocation() {
        return this.b;
    }

    public YPoint getCenter() {
        double d2 = this.c.getCenter();
        return this.d ? new YPoint(this.b, d2) : new YPoint(d2, this.b);
    }

    public boolean crosses(OrthogonalInterval orthogonalInterval) {
        if (this.d == orthogonalInterval.d) {
            throw new IllegalArgumentException("orthogonal intervals have same orientation");
        }
        return this.c.contains(orthogonalInterval.b) && orthogonalInterval.c.contains(this.b);
    }

    public double distanceTo(OrthogonalInterval orthogonalInterval) {
        if (this.d != orthogonalInterval.d) {
            throw new IllegalArgumentException("orthogonal intervals have different orientation");
        }
        return this.getRange().distanceTo(orthogonalInterval.getRange());
    }

    public double manhattanDistanceTo(OrthogonalInterval orthogonalInterval) {
        if (this.d != orthogonalInterval.d) {
            return this.getRange().distanceTo(orthogonalInterval.getLocation()) + orthogonalInterval.getRange().distanceTo(this.getLocation());
        }
        return this.getRange().distanceTo(orthogonalInterval.getRange()) + Math.abs(this.getLocation() - orthogonalInterval.getLocation());
    }

    double b(OrthogonalInterval orthogonalInterval) {
        if (this.d != orthogonalInterval.d) {
            throw new IllegalArgumentException("orthogonal intervals have different orientation");
        }
        return Math.abs(this.b - orthogonalInterval.b);
    }

    public boolean intersects(OrthogonalInterval orthogonalInterval) {
        return this.intersects(orthogonalInterval, 0.0);
    }

    public boolean intersects(OrthogonalInterval orthogonalInterval, double d2) {
        if (this.d != orthogonalInterval.d) {
            throw new IllegalArgumentException("orthogonal intervals have different orientation");
        }
        return this.c.intersects(orthogonalInterval.c, d2);
    }

    public boolean coveredBy(OrthogonalInterval orthogonalInterval) {
        if (this.d != orthogonalInterval.d) {
            throw new IllegalArgumentException("orthogonal intervals have different orientation");
        }
        return this.c.coveredBy(orthogonalInterval.c);
    }

    public boolean hasSameRange(OrthogonalInterval orthogonalInterval) {
        if (this.d != orthogonalInterval.d) {
            throw new IllegalArgumentException("orthogonal intervals have different orientation");
        }
        return this.c.hasSameRange(orthogonalInterval.c);
    }

    public static OrthogonalInterval calculateIntersection(OrthogonalInterval orthogonalInterval, OrthogonalInterval orthogonalInterval2) {
        if (orthogonalInterval.d != orthogonalInterval2.d) {
            throw new IllegalArgumentException("orthogonal intervals have different orientation");
        }
        Interval interval = Interval.calculateIntersection(orthogonalInterval.c, orthogonalInterval2.c);
        if (interval != null) {
            return new OrthogonalInterval(interval.getMin(), interval.getMax(), orthogonalInterval2.b, orthogonalInterval2.isVertical());
        }
        return null;
    }

    public static OrthogonalInterval calculateUnion(OrthogonalInterval orthogonalInterval, OrthogonalInterval orthogonalInterval2) {
        if (orthogonalInterval.d != orthogonalInterval2.d) {
            throw new IllegalArgumentException("orthogonal intervals have different orientation");
        }
        Interval interval = Interval.calculateUnion(orthogonalInterval.c, orthogonalInterval2.c);
        return new OrthogonalInterval(interval.getMin(), interval.getMax(), orthogonalInterval2.b, orthogonalInterval2.isVertical());
    }

    public String toString() {
        return "OrthogonalInterval{range=" + this.c + ", location=" + this.b + ", isVertical=" + this.d + '}';
    }

    private double c() {
        return this.d ? this.getMax() : this.b;
    }

    private double e() {
        return this.d ? this.b : this.getMax();
    }

    private double b() {
        return this.d ? this.getMin() : this.b;
    }

    private double d() {
        return this.d ? this.b : this.getMin();
    }

    static boolean c(YRectangle yRectangle, OrthogonalInterval orthogonalInterval) {
        double d2 = orthogonalInterval.d();
        double d3 = orthogonalInterval.b();
        double d4 = orthogonalInterval.e();
        double d5 = orthogonalInterval.c();
        return yRectangle.contains(d2, d3) || yRectangle.contains(d4, d5);
    }

    static boolean b(YRectangle yRectangle, OrthogonalInterval orthogonalInterval) {
        double d2 = orthogonalInterval.d();
        double d3 = orthogonalInterval.b();
        double d4 = orthogonalInterval.e();
        double d5 = orthogonalInterval.c();
        return yRectangle.contains(d2, d3) && yRectangle.contains(d4, d5);
    }
}

