/*
 * Decompiled with CFR 0.152.
 */
package y.layout.router.polyline;

import y.geom.YRectangle;

public class Interval {
    private final double c;
    private final double b;

    public Interval(double d2, double d3) {
        this.c = Math.min(d2, d3);
        this.b = Math.max(d2, d3);
    }

    public double getMin() {
        return this.c;
    }

    public double getMax() {
        return this.b;
    }

    public double getCenter() {
        return 0.5 * (this.c + this.b);
    }

    public boolean contains(double d2) {
        return d2 >= this.c && d2 <= this.b;
    }

    public double getSize() {
        return this.b - this.c;
    }

    public boolean intersects(Interval interval) {
        return this.intersects(interval, 0.0);
    }

    public boolean intersects(Interval interval, double d2) {
        return this.c + d2 <= interval.b && this.b - d2 >= interval.c;
    }

    public double distanceTo(double d2) {
        if (d2 < this.c) {
            return this.c - d2;
        }
        if (d2 > this.b) {
            return d2 - this.b;
        }
        return 0.0;
    }

    public double distanceTo(Interval interval) {
        if (this.b < interval.c) {
            return interval.c - this.b;
        }
        if (this.c > interval.b) {
            return this.c - interval.b;
        }
        return 0.0;
    }

    public boolean coveredBy(Interval interval) {
        return this.coveredBy(interval, 1.0E-6);
    }

    public boolean coveredBy(Interval interval, double d2) {
        return interval.c - d2 <= this.c && interval.b + d2 >= this.b;
    }

    public double getClosest(double d2) {
        if (d2 < this.c) {
            return this.c;
        }
        if (d2 > this.b) {
            return this.b;
        }
        return d2;
    }

    public boolean isLessThan(Interval interval) {
        return this.b < interval.c;
    }

    public boolean isGreaterThan(Interval interval) {
        return this.c > interval.b;
    }

    public String toString() {
        return "[" + this.c + ", " + this.b + "]";
    }

    public boolean hasSameRange(Interval interval) {
        return this.hasSameRange(interval, 1.0E-6);
    }

    public boolean hasSameRange(Interval interval, double d2) {
        return Math.abs(this.c - interval.c) < d2 && Math.abs(this.b - interval.b) < d2;
    }

    public static Interval calculateIntersection(Interval interval, Interval interval2) {
        if (!interval.intersects(interval2)) {
            return null;
        }
        return new Interval(Math.max(interval.c, interval2.c), Math.min(interval.b, interval2.b));
    }

    public static Interval calculateUnion(Interval interval, Interval interval2) {
        return new Interval(Math.min(interval.c, interval2.c), Math.max(interval.b, interval2.b));
    }

    public static Interval calculateUnion(Interval interval, double d2) {
        return new Interval(Math.min(interval.c, d2), Math.max(interval.b, d2));
    }

    public static Interval calculateBridge(Interval interval, Interval interval2) {
        double d2;
        double d3 = Math.min(interval.b, interval2.b);
        if (d3 > (d2 = Math.max(interval.c, interval2.c))) {
            return null;
        }
        return new Interval(d3, d2);
    }

    public static YRectangle calculateSpanningRectangle(Interval interval, Interval interval2) {
        return new YRectangle(interval.c, interval2.c, interval.getSize(), interval2.getSize());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Interval interval = (Interval)object;
        if (Interval.b(interval.b, this.b) != 0) {
            return false;
        }
        return Interval.b(interval.c, this.c) == 0;
    }

    public int hashCode() {
        long l2 = this.c != 0.0 ? Double.doubleToLongBits(this.c) : 0L;
        int n2 = (int)(l2 ^ l2 >>> 32);
        l2 = this.b != 0.0 ? Double.doubleToLongBits(this.b) : 0L;
        n2 = 31 * n2 + (int)(l2 ^ l2 >>> 32);
        return n2;
    }

    private static int b(double d2, double d3) {
        long l2;
        if (d2 > d3) {
            return 1;
        }
        if (d2 < d3) {
            return -1;
        }
        long l3 = Double.doubleToLongBits(d2);
        return l3 == (l2 = Double.doubleToLongBits(d3)) ? 0 : (l3 > l2 ? 1 : -1);
    }
}

