/*
 * Decompiled with CFR 0.152.
 */
package y.layout.router;

import y.base.DataProvider;
import y.base.Edge;
import y.base.EdgeCursor;
import y.geom.YPoint;
import y.layout.AbstractLayoutStage;
import y.layout.LayoutGraph;
import y.layout.LayoutTool;
import y.layout.Layouter;
import y.layout.NodeLayout;
import y.layout.PortConstraint;
import y.layout.PortConstraintKeys;
import y.layout.router.OrthogonalEdgeRouter;
import y.util.Filter;

public class StraightLineEdgeRouter
extends AbstractLayoutStage {
    public static final byte ROUTE_ALL_EDGES = 0;
    public static final byte ROUTE_SELECTED_EDGES = 2;
    public static final byte ROUTE_EDGES_AT_SELECTED_NODES = 4;
    private byte mgc = 0;
    private Object lgc = Layouter.SELECTED_EDGES;
    private Object kgc = Layouter.SELECTED_NODES;

    public StraightLineEdgeRouter(Layouter layouter) {
        super(layouter);
    }

    public StraightLineEdgeRouter() {
        this(null);
    }

    public byte getSphereOfAction() {
        return this.mgc;
    }

    public void setSphereOfAction(byte by) {
        switch (by) {
            case 0: 
            case 2: 
            case 4: {
                this.mgc = by;
                if (OrthogonalEdgeRouter.z == 0) break;
            }
            default: {
                throw new IllegalArgumentException("Argument '" + by + "' not allowed.");
            }
        }
    }

    public Object getSelectedNodesDpKey() {
        return this.kgc;
    }

    public void setSelectedNodesDpKey(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("null");
        }
        this.kgc = object;
    }

    public Object getSelectedEdgesDpKey() {
        return this.lgc;
    }

    public void setSelectedEdgesDpKey(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("null");
        }
        this.lgc = object;
    }

    public boolean canLayout(LayoutGraph layoutGraph) {
        return this.canLayoutCore(layoutGraph);
    }

    public void doLayout(LayoutGraph layoutGraph) {
        block8: {
            int n2 = OrthogonalEdgeRouter.z;
            this.doLayoutCore(layoutGraph);
            if (layoutGraph.edgeCount() <= 0) break block8;
            Filter filter = this.re(layoutGraph);
            if (filter == null) {
                return;
            }
            YPoint yPoint = YPoint.ORIGIN;
            DataProvider dataProvider = layoutGraph.getDataProvider(PortConstraintKeys.SOURCE_PORT_CONSTRAINT_KEY);
            DataProvider dataProvider2 = layoutGraph.getDataProvider(PortConstraintKeys.TARGET_PORT_CONSTRAINT_KEY);
            EdgeCursor edgeCursor = layoutGraph.edges();
            while (edgeCursor.ok()) {
                block9: {
                    Edge edge;
                    block12: {
                        Object object;
                        PortConstraint portConstraint;
                        block11: {
                            block10: {
                                Object object2;
                                edge = edgeCursor.edge();
                                if (!filter.accept(edge)) break block9;
                                LayoutTool.resetPath(layoutGraph, edge, false);
                                Object object3 = object2 = dataProvider == null ? null : dataProvider.get(edge);
                                if (!(object2 instanceof PortConstraint)) break block10;
                                portConstraint = (PortConstraint)object2;
                                if (portConstraint.isStrong()) break block11;
                                object = layoutGraph.getNodeLayout(edge.source());
                                layoutGraph.setSourcePointRel(edge, StraightLineEdgeRouter.b(portConstraint, (NodeLayout)object));
                                if (n2 == 0) break block11;
                            }
                            layoutGraph.setSourcePointRel(edge, yPoint);
                        }
                        PortConstraint portConstraint2 = portConstraint = dataProvider2 == null ? null : dataProvider2.get(edge);
                        if (!(portConstraint instanceof PortConstraint)) break block12;
                        object = portConstraint;
                        if (((PortConstraint)object).isStrong()) break block9;
                        NodeLayout nodeLayout = layoutGraph.getNodeLayout(edge.target());
                        layoutGraph.setTargetPointRel(edge, StraightLineEdgeRouter.b((PortConstraint)object, nodeLayout));
                        if (n2 == 0) break block9;
                    }
                    layoutGraph.setTargetPointRel(edge, yPoint);
                }
                edgeCursor.next();
                if (n2 == 0) continue;
            }
        }
    }

    private Filter re(LayoutGraph layoutGraph) {
        switch (this.getSphereOfAction()) {
            case 0: {
                return new _b();
            }
            case 2: {
                DataProvider dataProvider = layoutGraph.getDataProvider(this.getSelectedEdgesDpKey());
                if (dataProvider == null) {
                    return null;
                }
                return new _c(dataProvider);
            }
            case 4: {
                DataProvider dataProvider = layoutGraph.getDataProvider(this.getSelectedNodesDpKey());
                if (dataProvider == null) {
                    return null;
                }
                return new _d(dataProvider);
            }
        }
        return new _b();
    }

    private static YPoint b(PortConstraint portConstraint, NodeLayout nodeLayout) {
        double d2 = nodeLayout.getWidth() * 0.5;
        double d3 = nodeLayout.getHeight() * 0.5;
        switch (portConstraint.getSide()) {
            case 1: {
                return new YPoint(0.0, -d3);
            }
            case 2: {
                return new YPoint(0.0, d3);
            }
            case 4: {
                return new YPoint(d2, 0.0);
            }
            case 8: {
                return new YPoint(-d2, 0.0);
            }
        }
        return YPoint.ORIGIN;
    }

    private static class _d
    implements Filter {
        private final DataProvider c;

        _d(DataProvider dataProvider) {
            this.c = dataProvider;
        }

        public boolean accept(Object object) {
            Edge edge = (Edge)object;
            return this.c.getBool(edge.source()) || this.c.getBool(edge.target());
        }
    }

    private static class _c
    implements Filter {
        private final DataProvider b;

        _c(DataProvider dataProvider) {
            this.b = dataProvider;
        }

        public boolean accept(Object object) {
            return this.b.getBool(object);
        }
    }

    private static class _b
    implements Filter {
        private _b() {
        }

        public boolean accept(Object object) {
            return true;
        }
    }
}

