/*
 * Decompiled with CFR 0.152.
 */
package y.layout.router;

import java.util.Iterator;
import y.base.DataProvider;
import y.base.GraphInterface;
import y.layout.AbstractLayoutStage;
import y.layout.GraphLayout;
import y.layout.LayoutGraph;
import y.layout.Layouter;
import y.layout.NodeLayout;
import y.layout.grouping.GroupingKeys;
import y.layout.router.GroupNodeRouterStage;
import y.layout.router.OrthogonalEdgeRouter;
import y.layout.router.OrthogonalPatternEdgeRouter;
import y.layout.router.OrthogonalSegmentDistributionStage;
import y.util.DataProviders;

public class ChannelEdgeRouter
extends AbstractLayoutStage {
    public static final Object AFFECTED_EDGES = "y.layout.router.ChannelEdgeRouter.AFFECTED_EDGES";
    private static final String ogc = "y.layout.router.CHANNEL_EDGE_ROUTER_NODE_SIZE_CHECKED_DPKEY";
    private Layouter ngc;
    private Layouter pgc;

    public ChannelEdgeRouter() {
        OrthogonalPatternEdgeRouter orthogonalPatternEdgeRouter = new OrthogonalPatternEdgeRouter();
        orthogonalPatternEdgeRouter.setAffectedEdgesDPKey(AFFECTED_EDGES);
        this.ngc = orthogonalPatternEdgeRouter;
        OrthogonalSegmentDistributionStage orthogonalSegmentDistributionStage = new OrthogonalSegmentDistributionStage();
        orthogonalSegmentDistributionStage.setAffectedEdgesDPKey(AFFECTED_EDGES);
        this.pgc = orthogonalSegmentDistributionStage;
    }

    public boolean canLayout(LayoutGraph layoutGraph) {
        Layouter layouter;
        if (layoutGraph.getDataProvider(ogc) == null) {
            try {
                this.se(layoutGraph);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        }
        return (layouter = this.getCoreLayouter()) == null || layouter.canLayout(layoutGraph);
    }

    public void doLayout(LayoutGraph layoutGraph) {
        boolean bl;
        block6: {
            block7: {
                block8: {
                    bl = false;
                    if (layoutGraph.getDataProvider(ogc) == null) {
                        this.se(layoutGraph);
                        layoutGraph.addDataProvider(ogc, DataProviders.createConstantDataProvider(Boolean.TRUE));
                        bl = true;
                    }
                    this.doLayoutCore(layoutGraph);
                    if (layoutGraph.edgeCount() <= 0) break block6;
                    if (this.ngc == null) break block7;
                    if (!(this.ngc instanceof OrthogonalEdgeRouter)) break block8;
                    new GroupNodeRouterStage(this.ngc).doLayout(layoutGraph);
                    if (OrthogonalEdgeRouter.z == 0) break block7;
                }
                this.ngc.doLayout(layoutGraph);
            }
            if (this.pgc != null) {
                this.pgc.doLayout(layoutGraph);
            }
        }
        if (bl) {
            layoutGraph.removeDataProvider(ogc);
        }
    }

    private void se(LayoutGraph layoutGraph) {
        this.h(layoutGraph, layoutGraph);
    }

    private void h(GraphInterface graphInterface, GraphLayout graphLayout) {
        int n2 = OrthogonalEdgeRouter.z;
        DataProvider dataProvider = graphInterface.getDataProvider(GroupingKeys.GROUP_DPKEY);
        if (dataProvider == null) {
            dataProvider = DataProviders.createConstantDataProvider(Boolean.FALSE);
        }
        Iterator iterator = graphInterface.nodeObjects();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (!dataProvider.getBool(e2)) {
                this.checkNodeSize(graphLayout, e2);
                if (n2 == 0) continue;
            }
            this.checkGroupNodeSize(graphLayout, e2);
            if (n2 == 0) continue;
        }
    }

    protected void checkNodeSize(GraphLayout graphLayout, Object object) throws IllegalArgumentException {
        NodeLayout nodeLayout = graphLayout.getNodeLayout(object);
        if (nodeLayout.getWidth() == 0.0 || nodeLayout.getHeight() == 0.0) {
            throw new IllegalArgumentException("Graph contains nodes with zero width/height. Please enlarge those nodes manually or by using LayoutStage y.layout.MinNodeSizeStage.");
        }
    }

    protected void checkGroupNodeSize(GraphLayout graphLayout, Object object) throws IllegalArgumentException {
        NodeLayout nodeLayout = graphLayout.getNodeLayout(object);
        if (nodeLayout.getWidth() == 0.0 || nodeLayout.getHeight() == 0.0) {
            throw new IllegalArgumentException("Graph contains group nodes with zero width/height. Please enlarge those nodes manually or by using LayoutStage y.layout.MinNodeSizeStage.");
        }
    }

    public void setPathFinderStrategy(Layouter layouter) {
        this.ngc = layouter;
    }

    public void setEdgeDistributionStrategy(Layouter layouter) {
        this.pgc = layouter;
    }

    public Layouter getPathFinderStrategy() {
        return this.ngc;
    }

    public Layouter getEdgeDistributionStrategy() {
        return this.pgc;
    }

    public static class OrthogonalShortestPathPathFinder
    extends OrthogonalEdgeRouter {
        private Object jgc = AFFECTED_EDGES;

        public boolean canLayout(LayoutGraph layoutGraph) {
            Layouter layouter = this.getCoreLayouter();
            return layouter == null || layouter.canLayout(layoutGraph);
        }

        public void doLayout(LayoutGraph layoutGraph) {
            Object object;
            block3: {
                block2: {
                    this.doLayoutCore(layoutGraph);
                    object = this.getSelectedEdgesDpKey();
                    DataProvider dataProvider = layoutGraph.getDataProvider(this.jgc);
                    if (dataProvider == null) break block2;
                    this.setSphereOfAction((byte)2);
                    this.setSelectedEdgesDpKey(this.jgc);
                    if (OrthogonalEdgeRouter.z == 0) break block3;
                }
                this.setSphereOfAction((byte)0);
            }
            this.setProperty("AllowRigModification", Boolean.FALSE);
            this.setLocalCrossingMinimizationEnabled(false);
            super.doLayout(layoutGraph);
            this.setSelectedEdgesDpKey(object);
        }

        public void setAffectedEdgesDPKey(Object object) {
            this.jgc = object;
        }

        public Object getAffectedEdgesDPKey() {
            return this.jgc;
        }
    }
}

