/*
 * Decompiled with CFR 0.152.
 */
package y.layout.random;

import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.Random;
import y.base.Graph;
import y.base.NodeCursor;
import y.geom.YPoint;
import y.layout.CanonicMultiStageLayouter;
import y.layout.LayoutGraph;
import y.layout.LayoutStage;
import y.layout.LayoutTool;
import y.layout.grouping.GroupNodeHider;

public class RandomLayouter
extends CanonicMultiStageLayouter {
    private Rectangle hz;
    private long gz;
    public static boolean z;

    public RandomLayouter() {
        boolean bl = z;
        this.hz = new Rectangle(0, 0, 500, 500);
        this.setComponentLayouterEnabled(false);
        this.gz = System.currentTimeMillis();
        LayoutStage layoutStage = this.getGroupNodeHider();
        if (layoutStage instanceof GroupNodeHider) {
            ((GroupNodeHider)layoutStage).setHidingEmptyGroupNodes(false);
        }
        if (Graph.z != 0) {
            z = !bl;
        }
    }

    public void setComponentLayouterEnabled(boolean bl) {
        super.setComponentLayouterEnabled(bl);
    }

    public boolean isComponentLayouterEnabled() {
        return super.isComponentLayouterEnabled();
    }

    public void setLayoutBounds(Rectangle rectangle) {
        this.hz = rectangle;
    }

    public Rectangle getLayoutBounds() {
        return this.hz;
    }

    public boolean canLayoutCore(LayoutGraph layoutGraph) {
        return true;
    }

    public void doLayoutCore(LayoutGraph layoutGraph) {
        boolean bl = z;
        LayoutTool.resetPaths(layoutGraph);
        double d2 = 0.0;
        double d3 = 0.0;
        Object object = layoutGraph.nodes();
        while (object.ok()) {
            d2 = Math.max(d2, layoutGraph.getWidth(object.node()));
            d3 = Math.max(d3, layoutGraph.getHeight(object.node()));
            object.next();
            if (!bl) continue;
            int n2 = Graph.z;
            Graph.z = ++n2;
            break;
        }
        object = new Rectangle2D.Double();
        ((Rectangle2D)object).setFrame((double)this.hz.x + d2 / 2.0, (double)this.hz.y + d3 / 2.0, (double)this.hz.width - d2, (double)this.hz.height - d2);
        Random random = new Random(this.gz);
        NodeCursor nodeCursor = layoutGraph.nodes();
        while (nodeCursor.ok()) {
            YPoint yPoint = new YPoint(random.nextDouble() * ((RectangularShape)object).getWidth() + ((RectangularShape)object).getX(), random.nextDouble() * ((RectangularShape)object).getHeight() + ((RectangularShape)object).getY());
            layoutGraph.setCenter(nodeCursor.node(), yPoint);
            nodeCursor.next();
            if (!bl) continue;
        }
    }

    public long getSeed() {
        return this.gz;
    }

    public void setSeed(long l2) {
        this.gz = l2;
    }
}

