/*
 * Decompiled with CFR 0.152.
 */
package y.layout.radial;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import y.algo.AbortHandler;
import y.algo.Bfs;
import y.algo.GraphConnectivity;
import y.algo.SpanningTrees;
import y.algo.Trees;
import y.base.DataProvider;
import y.base.Edge;
import y.base.EdgeCursor;
import y.base.EdgeList;
import y.base.EdgeMap;
import y.base.Graph;
import y.base.ListCell;
import y.base.Node;
import y.base.NodeCursor;
import y.base.NodeList;
import y.base.NodeMap;
import y.base.YList;
import y.geom.Geom;
import y.geom.YDimension;
import y.geom.YPoint;
import y.geom.YRectangle;
import y.layout.CanonicMultiStageLayouter;
import y.layout.LayoutGraph;
import y.layout.LayoutTool;
import y.layout.Layouter;
import y.layout.NodeHalo;
import y.layout.NodeLabelLayout;
import y.layout.PortConstraintKeys;
import y.layout.hierarchic.BFSLayerer;
import y.layout.hierarchic.IncrementalHierarchicLayouter;
import y.layout.hierarchic.incremental.LayerConstraintFactory;
import y.layout.radial.b;
import y.layout.radial.c;
import y.layout.radial.d;
import y.layout.radial.e;
import y.layout.radial.g;
import y.layout.radial.i;
import y.layout.radial.j;
import y.layout.radial.k;
import y.layout.radial.l;
import y.layout.radial.m;
import y.layout.radial.n;
import y.util.DataProviderAdapter;
import y.util.GraphPartitionManager;

public class RadialLayouter
extends CanonicMultiStageLayouter {
    public static final Object NODE_INFO_DPKEY = "y.layout.radial.NODE_INFO_DPKEY";
    public static final byte CENTER_NODES_POLICY_DIRECTED = 0;
    public static final byte CENTER_NODES_POLICY_CENTRALITY = 1;
    public static final byte CENTER_NODES_POLICY_WEIGHTED_CENTRALITY = 2;
    public static final byte CENTER_NODES_POLICY_SELECTED_NODES = 3;
    public static final byte LAYERING_STRATEGY_BFS = 4;
    public static final byte LAYERING_STRATEGY_HIERARCHICAL = 1;
    private static final byte ufb = 0;
    public static final byte EDGE_ROUTING_STRATEGY_POLYLINE = 1;
    private static final byte dgb = 2;
    private static final byte sfb = 3;
    private static final byte fgb = 4;
    public static final byte EDGE_ROUTING_STRATEGY_ARC = 5;
    static final double cgb = 1.0E-4;
    private static final double egb = Math.PI * 2;
    private static final int yfb = 50;
    private m xfb;
    private double rfb;
    private double kfb;
    private double jfb;
    private double hfb;
    private byte nfb;
    private Object tfb;
    private byte ifb;
    private byte qfb;
    private b[] lfb;
    private boolean bgb;
    private IncrementalHierarchicLayouter mfb;
    private int zfb;
    private double agb;
    private double pfb;
    private double vfb;
    private LayerConstraintFactory ofb;
    private boolean wfb;
    public static boolean z;

    public void setMinimalNodeToNodeDistance(double d2) {
        block3: {
            block2: {
                if (!(d2 >= 0.0)) break block2;
                this.rfb = d2;
                if (!z) break block3;
            }
            throw new IllegalArgumentException("Distance may not be negative");
        }
    }

    public double getMinimalNodeToNodeDistance() {
        return this.rfb;
    }

    public double getLayerSpacing() {
        return this.kfb;
    }

    public void setLayerSpacing(double d2) {
        block3: {
            block2: {
                if (!(d2 >= 0.0)) break block2;
                this.kfb = d2;
                if (!z) break block3;
            }
            throw new IllegalArgumentException("Spacing value may not be negative");
        }
    }

    public double getMinimalLayerDistance() {
        return this.jfb;
    }

    public void setMinimalLayerDistance(double d2) {
        block3: {
            block2: {
                if (!(d2 >= 0.0)) break block2;
                this.jfb = d2;
                if (!z) break block3;
            }
            throw new IllegalArgumentException("Minimal layer distance may not be negative");
        }
    }

    public double getMaximalChildSectorAngle() {
        return this.hfb;
    }

    public void setMaximalChildSectorAngle(double d2) {
        if (d2 < 0.0) {
            throw new IllegalArgumentException("Child sector size may not be negative");
        }
        if (d2 > 360.0) {
            throw new IllegalArgumentException("Child sector size must be less or equal to 360 degrees");
        }
        this.hfb = d2;
    }

    private double sh() {
        return this.agb;
    }

    private void j(double d2) {
        block3: {
            block2: {
                if (!(d2 > 0.0)) break block2;
                this.agb = d2;
                if (!z) break block3;
            }
            throw new IllegalArgumentException("Spacing must be greater than 0");
        }
    }

    public double getMinimalBendAngle() {
        return this.pfb;
    }

    public void setMinimalBendAngle(double d2) {
        if (d2 < 0.0) {
            throw new IllegalArgumentException("Minimal Bend Angle must be positive");
        }
        if (d2 > 90.0) {
            throw new IllegalArgumentException("Minimal Bend Angle must be less or equal to 90 degrees");
        }
        this.pfb = d2;
    }

    private boolean th() {
        return this.bgb;
    }

    private void ob(boolean bl) {
        this.bgb = bl;
    }

    public void setCenterNodesPolicy(byte by) {
        switch (by) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.nfb = by;
                if (!z) break;
            }
            default: {
                throw new IllegalArgumentException("No valid center node policy");
            }
        }
    }

    public byte getCenterNodesPolicy() {
        return this.nfb;
    }

    public Object getCenterNodesDpKey() {
        return this.tfb;
    }

    public void setCenterNodesDpKey(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Invalid data provider key: " + null);
        }
        this.tfb = object;
    }

    public byte getLayeringStrategy() {
        return this.ifb;
    }

    public void setLayeringStrategy(byte by) {
        switch (by) {
            case 1: 
            case 4: {
                this.ifb = by;
                if (!z) break;
            }
            default: {
                throw new IllegalArgumentException("Invalid layering strategy");
            }
        }
    }

    public byte getEdgeRoutingStrategy() {
        return this.qfb;
    }

    public void setEdgeRoutingStrategy(byte by) {
        switch (by) {
            case 1: 
            case 5: {
                this.qfb = by;
                if (!z) break;
            }
            default: {
                throw new IllegalArgumentException("Invalid edge routing strategy");
            }
        }
    }

    public boolean isConsiderNodeLabelsEnabled() {
        return this.wfb;
    }

    public void setConsiderNodeLabelsEnabled(boolean bl) {
        this.wfb = bl;
    }

    public RadialLayouter() {
        boolean bl = z;
        this.rfb = 10.0;
        this.kfb = 25.0;
        this.jfb = 100.0;
        this.hfb = 180.0;
        this.nfb = (byte)2;
        this.tfb = Layouter.SELECTED_NODES;
        this.ifb = (byte)4;
        this.qfb = (byte)5;
        this.bgb = false;
        this.zfb = 2;
        this.agb = 25.0;
        this.pfb = 5.0;
        this.vfb = 50.0;
        this.setGroupNodeHidingEnabled(true);
        this.setComponentLayouterEnabled(false);
        this.mfb = new IncrementalHierarchicLayouter();
        this.mfb.setMinimumLayerDistance(150.0);
        this.xfb = new m(this.mfb.getFromScratchSequencer());
        this.mfb.setFromScratchSequencer(this.xfb);
        this.lfb = new b[]{new l(), new e(), new j(), new k(1.0), new k()};
        if (bl) {
            int n2 = Graph.z;
            Graph.z = ++n2;
        }
    }

    public void setComponentLayouterEnabled(boolean bl) {
        super.setComponentLayouterEnabled(bl);
    }

    public boolean isComponentLayouterEnabled() {
        return super.isComponentLayouterEnabled();
    }

    public boolean canLayoutCore(LayoutGraph layoutGraph) {
        return this.mfb.canLayout(layoutGraph);
    }

    public void doLayoutCore(LayoutGraph layoutGraph) {
        boolean bl = z;
        if (layoutGraph.isEmpty()) {
            return;
        }
        DataProvider dataProvider = layoutGraph.getDataProvider(PortConstraintKeys.SOURCE_GROUPID_KEY);
        layoutGraph.removeDataProvider(PortConstraintKeys.SOURCE_GROUPID_KEY);
        DataProvider dataProvider2 = layoutGraph.getDataProvider(PortConstraintKeys.TARGET_GROUPID_KEY);
        layoutGraph.removeDataProvider(PortConstraintKeys.TARGET_GROUPID_KEY);
        NodeMap nodeMap = layoutGraph.createNodeMap();
        this.f(layoutGraph, nodeMap);
        EdgeList edgeList = null;
        NodeList nodeList = this.determineCenter(layoutGraph);
        if (!nodeList.isEmpty()) {
            this.b(layoutGraph, nodeList);
            edgeList = RadialLayouter.b(layoutGraph, nodeList);
        }
        this.mfb.setFromScratchLayeringStrategy(this.getLayeringStrategy());
        this.mfb.doLayout(layoutGraph);
        this.b(layoutGraph, this.xfb.i());
        if (edgeList != null) {
            while (!edgeList.isEmpty()) {
                Edge edge = edgeList.popEdge();
                LayoutTool.reverseEdgeLayout(layoutGraph.getLayout(edge));
                layoutGraph.reverseEdge(edge);
                if (!bl) {
                    if (!bl) continue;
                }
                break;
            }
        } else if (this.getLayeringStrategy() == 4) {
            layoutGraph.removeDataProvider(BFSLayerer.CORE_NODES);
        }
        if (this.ofb != null) {
            this.ofb.dispose();
            this.ofb = null;
        }
        this.xfb.h();
        this.g(layoutGraph, nodeMap);
        layoutGraph.disposeNodeMap(nodeMap);
        if (dataProvider != null) {
            layoutGraph.addDataProvider(PortConstraintKeys.SOURCE_GROUPID_KEY, dataProvider);
            dataProvider = null;
        }
        if (dataProvider2 != null) {
            layoutGraph.addDataProvider(PortConstraintKeys.TARGET_GROUPID_KEY, dataProvider2);
            dataProvider2 = null;
        }
    }

    private boolean vb(LayoutGraph layoutGraph) {
        return this.wfb || NodeHalo.hasHalos(layoutGraph);
    }

    private void f(LayoutGraph layoutGraph, NodeMap nodeMap) {
        boolean bl = z;
        if (this.vb(layoutGraph)) {
            NodeCursor nodeCursor = layoutGraph.nodes();
            while (nodeCursor.ok()) {
                Node node = nodeCursor.node();
                YRectangle yRectangle = NodeHalo.getHaloBox(layoutGraph, node);
                if (this.wfb) {
                    NodeLabelLayout[] nodeLabelLayoutArray = layoutGraph.getNodeLabelLayout(node);
                    for (int i2 = 0; i2 < nodeLabelLayoutArray.length; ++i2) {
                        NodeLabelLayout nodeLabelLayout = nodeLabelLayoutArray[i2];
                        yRectangle = this.c(yRectangle, nodeLabelLayout.getBox());
                        if (!bl) {
                            if (!bl) continue;
                        }
                        break;
                    }
                } else {
                    nodeMap.set(node, layoutGraph.getSize(node));
                    RadialLayouter.c(node, yRectangle, layoutGraph);
                    nodeCursor.next();
                }
                if (!bl) continue;
            }
        }
    }

    private static void c(Node node, YRectangle yRectangle, LayoutGraph layoutGraph) {
        YPoint yPoint = layoutGraph.getCenter(node);
        double d2 = Math.floor(Math.max(yPoint.getX() - yRectangle.getX(), yRectangle.getX() + yRectangle.getWidth() - yPoint.getX()) + 1.0E-4);
        double d3 = Math.floor(Math.max(yPoint.getY() - yRectangle.getY(), yRectangle.getY() + yRectangle.getHeight() - yPoint.getY()) + 1.0E-4);
        layoutGraph.setSize(node, 2.0 * d2, 2.0 * d3);
        layoutGraph.setCenter(node, yPoint);
    }

    private void g(LayoutGraph layoutGraph, NodeMap nodeMap) {
        boolean bl = z;
        if (this.vb(layoutGraph)) {
            NodeCursor nodeCursor = layoutGraph.nodes();
            while (nodeCursor.ok()) {
                Node node = nodeCursor.node();
                YPoint yPoint = layoutGraph.getCenter(node);
                layoutGraph.setSize(node, (YDimension)nodeMap.get(node));
                layoutGraph.setCenter(node, yPoint);
                nodeCursor.next();
                if (!bl) continue;
            }
        }
    }

    private YRectangle c(YRectangle yRectangle, YRectangle yRectangle2) {
        if (yRectangle == null || yRectangle2 == null) {
            return yRectangle == null ? yRectangle2 : yRectangle;
        }
        double d2 = Math.min(yRectangle.getX(), yRectangle2.getX());
        double d3 = Math.max(yRectangle.getX() + yRectangle.getWidth(), yRectangle2.getX() + yRectangle2.getWidth());
        double d4 = Math.min(yRectangle.getY(), yRectangle2.getY());
        double d5 = Math.max(yRectangle.getY() + yRectangle.getHeight(), yRectangle2.getY() + yRectangle2.getHeight());
        return new YRectangle(d2, d4, d3 - d2, d5 - d4);
    }

    protected NodeList determineCenter(LayoutGraph layoutGraph) {
        DataProvider dataProvider;
        NodeList nodeList;
        block15: {
            block14: {
                boolean bl;
                block13: {
                    int n2;
                    bl = z;
                    nodeList = new NodeList();
                    if (this.nfb == 3) {
                        boolean bl2;
                        dataProvider = layoutGraph.getDataProvider(this.getCenterNodesDpKey());
                        if (dataProvider != null) {
                            NodeCursor nodeCursor = layoutGraph.nodes();
                            while (nodeCursor.ok()) {
                                bl2 = dataProvider.getBool(nodeCursor.node());
                                if (!bl) {
                                    if (bl2) {
                                        nodeList.add(nodeCursor.node());
                                    }
                                    nodeCursor.next();
                                    if (!bl) continue;
                                }
                                break;
                            }
                        } else {
                            bl2 = nodeList.isEmpty();
                        }
                        if (!bl2) {
                            return nodeList;
                        }
                    }
                    if ((n2 = GraphConnectivity.connectedComponents(layoutGraph, (NodeMap)(dataProvider = layoutGraph.createNodeMap()))) <= 1) break block14;
                    GraphPartitionManager graphPartitionManager = new GraphPartitionManager(layoutGraph, dataProvider);
                    for (int i2 = 0; i2 < n2; ++i2) {
                        graphPartitionManager.displayPartition(new Integer(i2));
                        nodeList.add(this.ub(layoutGraph));
                        if (!bl) {
                            if (!bl) continue;
                        }
                        break block13;
                    }
                    graphPartitionManager.unhideAll();
                }
                if (!bl) break block15;
            }
            nodeList.add(this.ub(layoutGraph));
        }
        layoutGraph.disposeNodeMap((NodeMap)dataProvider);
        return nodeList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private Node ub(LayoutGraph var1_1) {
        var8_2 = RadialLayouter.z;
        var2_3 = SpanningTrees.uniform(var1_1);
        var3_4 = new EdgeList(var1_1.edges());
        var3_4.removeAll((Collection)var2_3);
        var4_5 = var3_4.edges();
        while (var4_5.ok()) {
            var1_1.hide(var4_5.edge());
            var4_5.next();
            if (!var8_2) {
                if (!var8_2) continue;
            }
            ** GOTO lbl-1000
        }
        try {
            switch (this.nfb) {
                case 0: lbl-1000:
                // 2 sources

                {
                    var4_5 = Trees.getRoot(var1_1);
                    break;
                }
                case 1: {
                    var4_5 = Trees.getCenterRoot(var1_1);
                    break;
                }
                default: {
                    var4_5 = Trees.getWeightedCenterNode(var1_1);
                }
            }
            var6_6 = null;
            var7_8 = var3_4.edges();
        }
        catch (Throwable var5_10) {
            var6_7 = null;
            var7_9 = var3_4.edges();
            while (var7_9.ok()) {
                var1_1.unhide(var7_9.edge());
                var7_9.next();
                if (!var8_2) continue;
            }
            throw var5_10;
        }
        while (var7_8.ok()) {
            var1_1.unhide(var7_8.edge());
            var7_8.next();
            if (!var8_2) continue;
            {
            }
        }
        return var4_5;
    }

    private void b(LayoutGraph layoutGraph, final List list) {
        block7: {
            Object object;
            Object object2;
            boolean bl;
            block6: {
                bl = z;
                if (this.getLayeringStrategy() != 4) break block6;
                layoutGraph.addDataProvider(BFSLayerer.CORE_NODES, new DataProviderAdapter(){

                    public boolean getBool(Object object) {
                        return list.contains(object);
                    }
                });
                if (!bl) break block7;
            }
            this.ofb = this.mfb.createLayerConstraintFactory(layoutGraph);
            DataProvider dataProvider = layoutGraph.getDataProvider(Layouter.NODE_ID_DPKEY);
            if (dataProvider == null) break block7;
            Object object3 = null;
            HashSet<Object> hashSet = new HashSet<Object>(list.size());
            Object object4 = list.iterator();
            while (object4.hasNext()) {
                object2 = object4.next();
                object = dataProvider.get(object2);
                if (object == null) continue;
                if (object3 == null) {
                    object3 = object;
                }
                hashSet.add(object);
                if (!bl) continue;
            }
            object4 = layoutGraph.nodes();
            while (object4.ok()) {
                block9: {
                    block8: {
                        object2 = object4.node();
                        object = dataProvider.get(object2);
                        if (!hashSet.contains(object)) break block8;
                        this.ofb.addPlaceNodeAtTopConstraint(object);
                        if (!bl) break block9;
                    }
                    this.ofb.addPlaceNodeBelowConstraint(object, object3);
                }
                object4.next();
                if (!bl) continue;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private static EdgeList b(Graph var0, NodeList var1_1) {
        block4: {
            var6_2 = RadialLayouter.z;
            var2_3 = new EdgeList();
            var3_4 = var0.createNodeMap();
            Bfs.getLayers(var0, var1_1, var3_4);
            var4_5 = var0.edges();
            while (var4_5.ok()) {
                var5_6 = var4_5.edge();
                v0 = var3_4.getInt(var5_6.target());
                if (!var6_2) {
                    if (v0 < var3_4.getInt(var5_6.source())) {
                        var2_3.push(var5_6);
                    }
                    var4_5.next();
                    if (!var6_2) continue;
                }
                ** GOTO lbl20
            }
            var4_5 = var2_3.edges();
            do {
                v0 = var4_5.ok();
lbl20:
                // 2 sources

                if (v0 == 0) break;
                var0.reverseEdge(var4_5.edge());
                var4_5.next();
                if (var6_2) break block4;
            } while (!var6_2);
            var0.disposeNodeMap(var3_4);
        }
        return var2_3;
    }

    private void b(LayoutGraph layoutGraph, c[] cArray) {
        block2: {
            boolean bl = z;
            NodeMap nodeMap = layoutGraph.createNodeMap();
            EdgeMap edgeMap = layoutGraph.createEdgeMap();
            this.d(layoutGraph, cArray, nodeMap, edgeMap);
            this.e(cArray);
            for (int i2 = 0; i2 < this.zfb; ++i2) {
                this.d(cArray);
                this.e(cArray);
                if (!bl) {
                    if (!bl) continue;
                }
                break block2;
            }
            this.c(layoutGraph, cArray, nodeMap, edgeMap);
            layoutGraph.disposeEdgeMap(edgeMap);
            layoutGraph.disposeNodeMap(nodeMap);
        }
    }

    private void d(LayoutGraph layoutGraph, c[] cArray, NodeMap nodeMap, EdgeMap edgeMap) {
        block5: {
            boolean bl = z;
            i i2 = (i)cArray[0].f().getInfo();
            int n2 = 0;
            block0: while (true) {
                int n3 = n2;
                block1: while (n3 < cArray.length) {
                    c c2 = cArray[n2];
                    if (bl) break block5;
                    for (ListCell listCell = c2.f(); listCell != null; listCell = listCell.succ()) {
                        i i3;
                        i i4 = (i)listCell.getInfo();
                        n3 = i4 instanceof g;
                        if (bl) continue block1;
                        if (n3 != 0) {
                            i3 = (g)i4;
                            ((g)i3).l = this.getNodeDiameter(layoutGraph, ((g)i3).f());
                            nodeMap.set(((g)i3).f(), i3);
                            c2.b(Math.max(c2.e(), ((g)i3).l / 2.0));
                            if (!bl) continue;
                        }
                        if (!(i4 instanceof n)) continue;
                        i3 = (n)i4;
                        YList yList = (YList)edgeMap.get(((n)i3).g());
                        if (yList == null) {
                            yList = new YList();
                            edgeMap.set(((n)i3).g(), yList);
                        }
                        yList.add(i3);
                        if (!bl) continue;
                    }
                    ++n2;
                    if (!bl) continue block0;
                }
                break;
            }
            this.b(layoutGraph, cArray, nodeMap, edgeMap, i2);
            this.c(layoutGraph, nodeMap, edgeMap);
            this.c(cArray);
        }
    }

    protected double getNodeDiameter(LayoutGraph layoutGraph, Node node) {
        double d2 = layoutGraph.getWidth(node);
        double d3 = layoutGraph.getHeight(node);
        double d4 = 1.0;
        if (d2 > 0.0 || d3 > 0.0) {
            d4 = Math.sqrt(d2 * d2 + d3 * d3);
        }
        return d4 += this.getMinimalNodeToNodeDistance();
    }

    private void b(LayoutGraph layoutGraph, c[] cArray, NodeMap nodeMap, EdgeMap edgeMap, i i2) {
        boolean bl = z;
        int n2 = 1;
        block0: while (true) {
            int n3 = n2;
            block1: while (n3 < cArray.length) {
                c c2 = cArray[n2];
                block2: for (ListCell listCell = c2.f(); listCell != null; listCell = listCell.succ()) {
                    int n4;
                    int n5;
                    i i3;
                    Object object;
                    Object object2;
                    Object object3;
                    Object object4;
                    i i4;
                    g g2;
                    block9: {
                        i i5 = (i)listCell.getInfo();
                        n3 = i5 instanceof g;
                        if (bl) continue block1;
                        if (n3 == 0) continue;
                        g2 = (g)i5;
                        Node node = g2.f();
                        YPoint yPoint = layoutGraph.getCenter(node);
                        i4 = i2;
                        object4 = null;
                        double d2 = Double.MAX_VALUE;
                        object3 = node.edges();
                        while (object3.ok()) {
                            object2 = object3.edge();
                            object = ((Edge)object2).opposite(node);
                            i3 = (g)nodeMap.get(object);
                            n5 = i3.h;
                            n4 = g2.h;
                            if (!bl) {
                                if (n5 < n4) {
                                    YPoint yPoint2 = layoutGraph.getCenter((Node)object);
                                    double d3 = yPoint.x - yPoint2.x;
                                    double d4 = yPoint.y - yPoint2.y;
                                    double d5 = d3 * d3 + d4 * d4;
                                    if (d5 < d2) {
                                        i4 = i3;
                                        d2 = d5;
                                        object4 = object2;
                                    }
                                }
                                object3.next();
                                if (!bl) continue;
                            }
                            break block9;
                        }
                        n5 = g2.h - i4.h;
                        n4 = 1;
                    }
                    if (n5 > n4 && object4 != null) {
                        object3 = (YList)edgeMap.get(object4);
                        object2 = i4;
                        object = ((YList)object3).iterator();
                        while (object.hasNext()) {
                            i3 = (n)object.next();
                            ((i)object2).c(i3);
                            ((n)i3).e = object2;
                            object2 = i3;
                            if (bl) continue block2;
                            if (!bl) continue;
                        }
                        g2.e = object2;
                        ((i)object2).c(g2);
                        continue;
                    }
                    g2.e = i4;
                    i4.c(g2);
                    if (!bl) continue;
                }
                ++n2;
                if (!bl) continue block0;
            }
            break;
        }
    }

    private void c(LayoutGraph layoutGraph, NodeMap nodeMap, EdgeMap edgeMap) {
        boolean bl = z;
        EdgeCursor edgeCursor = layoutGraph.edges();
        while (edgeCursor.ok()) {
            block4: {
                Edge edge = edgeCursor.edge();
                YList yList = (YList)edgeMap.get(edge);
                if (yList != null && ((n)yList.first()).e == null) {
                    g g2 = (g)nodeMap.get(edge.source());
                    g g3 = (g)nodeMap.get(edge.target());
                    g g4 = g2.h < g3.h ? g2 : g3;
                    g g5 = g2.h < g3.h ? g3 : g2;
                    i i2 = g4;
                    for (ListCell listCell = yList.firstCell(); listCell != null; listCell = listCell.succ()) {
                        n n2 = (n)listCell.getInfo();
                        n2.e = i2;
                        i2.b(n2);
                        i2 = n2;
                        if (!bl) {
                            if (!bl) continue;
                        }
                        break block4;
                    }
                    i2.b(g5);
                }
                edgeCursor.next();
            }
            if (!bl) continue;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    private void c(c[] var1_1) {
        var27_2 = RadialLayouter.z;
        ((i)var1_1[0].f().getInfo()).c();
        var2_3 = 1;
        do {
            v0 = var2_3;
            block1: while (true) lbl-1000:
            // 3 sources

            {
                v1 = var1_1.length;
                block2: while (true) {
                    if (v0 >= v1) return;
                    var3_4 = var1_1[var2_3];
                    var4_5 = null;
                    var5_6 = null;
                    var6_7 = -1;
                    var7_8 = -1;
                    var8_9 = var3_4.f();
                    while (var8_9 != null) {
                        block29: {
                            block30: {
                                block31: {
                                    block32: {
                                        block33: {
                                            block28: {
                                                var9_10 = (i)var8_9.getInfo();
                                                v0 = (int)var9_10.d();
                                                if (var27_2) ** GOTO lbl-1000
                                                if (v0 == 0) break block29;
                                                var9_10.c();
                                                var10_11 = var8_9;
                                                var11_12 = var8_9.succ();
                                                if (var5_6 == null || var7_8 <= (var12_13 = ((i)var9_10.i.first()).d)) break block30;
                                                var13_14 = var12_13 < var6_7;
                                                var14_15 = new YList();
                                                var15_16 = 0;
                                                for (var16_18 = var5_6.i.lastCell(); var16_18 != null; ++var15_16, var16_18 = var16_18.pred()) {
                                                    var17_19 = (i)var16_18.getInfo();
                                                    v2 = var17_19.d;
                                                    v3 = var12_13;
                                                    if (!var27_2) {
                                                        if (v2 <= v3) break;
                                                        var14_15.addFirst(var17_19);
                                                        if (!var27_2) continue;
                                                    }
                                                    break block28;
                                                }
                                                for (var16_18 = var9_10.i.firstCell(); var16_18 != null; var16_18 = var16_18.succ()) {
                                                    var17_19 = (i)var16_18.getInfo();
                                                    v2 = var17_19.d;
                                                    v3 = var7_8;
                                                    if (!var27_2) {
                                                        if (v2 >= v3) break;
                                                        var14_15.addLast(var17_19);
                                                        if (!var27_2) continue;
                                                    }
                                                    break block28;
                                                }
                                                var14_15.sort(new Comparator(){

                                                    public int compare(Object object, Object object2) {
                                                        i i2 = (i)object;
                                                        i i3 = (i)object2;
                                                        int n2 = i2.d - i3.d;
                                                        return n2 < 0 ? -1 : (n2 > 0 ? 1 : 0);
                                                    }
                                                });
                                                v2 = var7_8 - var12_13;
                                                v3 = 2;
                                            }
                                            var16_17 = v2 / v3;
                                            var18_20 = 0x7FFFFFFF;
                                            var19_21 = 0x7FFFFFFF;
                                            var20_22 = 1.7976931348623157E308;
                                            var22_23 = 0;
                                            var23_24 = var15_16;
                                            for (var24_25 = var14_15.firstCell(); var24_25 != null; var24_25 = var24_25.succ()) {
                                                var25_26 = (i)var24_25.getInfo();
                                                v4 = var25_26.e;
                                                v5 = var9_10;
                                                if (!var27_2) {
                                                    if (v4 == v5) {
                                                        var26_27 = Math.abs(var23_24 - var22_23);
                                                        if (var26_27 < var19_21 || var26_27 == var19_21 && Math.abs((double)var25_26.d - var16_17) < var20_22) {
                                                            var18_20 = var25_26.d;
                                                            var19_21 = var26_27;
                                                            var20_22 = Math.abs((double)var25_26.d - var16_17);
                                                        }
                                                        ++var22_23;
                                                        if (!var27_2) continue;
                                                    }
                                                    --var23_24;
                                                    if (!var27_2) continue;
                                                }
                                                ** GOTO lbl92
                                            }
                                            if (var19_21 > var22_23) {
                                                var18_20 = var7_8 + 1;
                                            }
                                            for (var24_25 = var14_15.firstCell(); var24_25 != null; var24_25 = var24_25.succ()) {
                                                var25_26 = (i)var24_25.getInfo();
                                                v0 = var25_26.d;
                                                v1 = var18_20;
                                                if (var27_2) continue block2;
                                                if (v0 < v1 && var25_26.e != var5_6) {
                                                    var9_10.i.remove(var25_26);
                                                    if (var9_10 instanceof n) {
                                                        var9_10.b((i)var25_26);
                                                    }
                                                    var5_6.c((i)var25_26);
                                                    var25_26.e = var5_6;
                                                    if (!var27_2) continue;
                                                }
                                                if (var25_26.d < var18_20) continue;
                                                v4 = var25_26.e;
                                                v5 = var9_10;
lbl92:
                                                // 2 sources

                                                if (v4 == v5) continue;
                                                var5_6.i.remove(var25_26);
                                                if (var5_6 instanceof n) {
                                                    var5_6.b((i)var25_26);
                                                }
                                                var9_10.c((i)var25_26);
                                                var25_26.e = var9_10;
                                                if (!var27_2) continue;
                                            }
                                            if (var5_6 instanceof n && !var5_6.d()) {
                                                var24_25 = var5_6;
                                                var25_26 = var5_6.e;
                                                do {
                                                    var25_26.i.remove(var24_25);
                                                    var25_26.b((i)var24_25);
                                                    var24_25 = var25_26;
                                                    var25_26 = var25_26.e;
                                                } while (var24_25 instanceof n && !var24_25.d());
                                            }
                                            if (var9_10 instanceof n && !var9_10.d()) {
                                                var24_25 = var9_10;
                                                var25_26 = var9_10.e;
                                                do {
                                                    var25_26.i.remove(var24_25);
                                                    var25_26.b((i)var24_25);
                                                    var24_25 = var25_26;
                                                    var25_26 = var25_26.e;
                                                } while (var24_25 instanceof n && !var24_25.d());
                                            }
                                            var5_6.c();
                                            var9_10.c();
                                            if (!var13_14) break block31;
                                            var24_25 = null;
                                            for (var25_26 = var4_5.pred(); var25_26 != null; var25_26 = var25_26.pred()) {
                                                var26_28 = (i)var25_26.getInfo();
                                                v0 = (int)var26_28.d();
                                                if (var27_2) continue block1;
                                                if (v0 == 0) continue;
                                                var24_25 = var25_26;
                                                break;
                                            }
                                            if (var24_25 == null) break block32;
                                            var10_11 = var24_25;
                                            if (!var5_6.d()) break block33;
                                            var11_12 = var4_5;
                                            if (!var27_2) break block30;
                                        }
                                        var11_12 = var8_9;
                                        if (!var27_2) break block30;
                                    }
                                    if (var9_10.d()) break block30;
                                    var10_11 = var4_5;
                                    if (!var27_2) break block30;
                                }
                                if (!var9_10.d()) {
                                    var10_11 = var4_5;
                                }
                            }
                            if (var10_11 != var4_5) {
                                var4_5 = var10_11;
                                var5_6 = (i)var10_11.getInfo();
                                var6_7 = ((i)var5_6.i.first()).d;
                                var7_8 = ((i)var5_6.i.last()).d;
                            }
                            var8_9 = var11_12;
                            if (!var27_2) continue;
                        }
                        var8_9 = var8_9.succ();
                        if (!var27_2) continue;
                    }
                    break block1;
                    break;
                }
                break;
            }
            ++var2_3;
        } while (!var27_2);
    }

    /*
     * Unable to fully structure code
     */
    private void d(c[] var1_1) {
        var29_2 = RadialLayouter.z;
        this.b(var1_1);
        var2_3 = (i)var1_1[0].f().getInfo();
        var2_3.f = 0.0;
        var2_3.j = 6.283185307179586;
        var2_3.b = 6.283185307179586;
        var3_4 = var1_1.length - 1;
        block0: while (true) {
            v0 = var3_4;
            block1: while (v0 > 0) {
                var4_5 = var1_1[var3_4].b();
                v1 = var3_4;
                v2 = var1_1.length - 1;
                if (var29_2) ** GOTO lbl38
                var6_6 = v1 < v2 ? var1_1[var3_4 + 1].b() : var4_5;
                var8_7 = this.getMaximalChildSectorAngle() / 180.0 * 3.141592653589793;
                var10_9 = var8_7 - 2.0 * Math.asin(var4_5 / var6_6 * Math.sin(var8_7 / 2.0));
                for (var12_10 = var1_1[var3_4].f(); var12_10 != null; var12_10 = var12_10.succ()) {
                    var13_13 = (i)var12_10.getInfo();
                    var13_13.b = var13_13.k = var13_13.l / var4_5;
                    cfr_temp_0 = var13_13.c - 0.0;
                    v0 = cfr_temp_0 == 0.0 ? 0 : (cfr_temp_0 > 0.0 ? 1 : -1);
                    if (var29_2) continue block1;
                    if (v0 > 0) {
                        var13_13.b = Math.max(var10_9, var13_13.k);
                        var14_14 = var13_13.c / var6_6;
                        var13_13.k = Math.max(var13_13.k, var14_14);
                    }
                    if (var13_13.e == null) continue;
                    var13_13.e.c += var1_1[var3_4].b() * var13_13.k;
                    if (!var29_2) continue;
                }
                --var3_4;
                if (!var29_2) continue block0;
            }
            break;
        }
        var3_4 = 0;
        block3: do {
            v1 = var3_4;
            block4: while (true) lbl-1000:
            // 3 sources

            {
                v2 = var1_1.length;
lbl38:
                // 2 sources

                if (v1 >= v2) break block3;
                var4_5 = var1_1[var3_4].b();
                var6_6 = var3_4 < var1_1.length - 1 ? var1_1[var3_4 + 1].b() : var4_5;
                var8_8 = var1_1[var3_4].f();
                while (var8_8 != null) {
                    block16: {
                        block17: {
                            var9_15 = (i)var8_8.getInfo();
                            v1 = (int)var9_15.d();
                            if (var29_2) ** GOTO lbl-1000
                            if (v1 == 0) break block17;
                            var10_9 = var9_15.c / var6_6;
                            var12_12 = Math.max(0.0, (var9_15.j - var9_15.b) / 2.0);
                            var14_14 = Math.min(var9_15.j, var9_15.b) / var10_9;
                            var16_16 = var9_15.f + var12_12;
                            if (!(var14_14 <= 1.0)) ** GOTO lbl60
                            for (var18_17 = var9_15.i.firstCell(); var18_17 != null; var18_17 = var18_17.succ()) {
                                var19_18 = (i)var18_17.getInfo();
                                var19_18.f = var16_16;
                                var19_18.j = var20_20 = var19_18.k * var14_14;
                                var16_16 += var20_20;
                                if (!var29_2) {
                                    if (!var29_2) continue;
                                }
                                break block16;
lbl60:
                                // 2 sources

                                var18_17 = new YList(var9_15.i);
                                var18_17.sort(new Comparator(){

                                    public int compare(Object object, Object object2) {
                                        i i2 = (i)object;
                                        i i3 = (i)object2;
                                        double d2 = i2.k - i3.k;
                                        return d2 > 0.0 ? -1 : (d2 < 0.0 ? 1 : 0);
                                    }
                                });
                                var19_19 = var9_15.j;
                                var21_21 = var9_15.c;
                                for (var23_22 = var18_17.firstCell(); var23_22 != null; var23_22 = var23_22.succ()) {
                                    block19: {
                                        block18: {
                                            var24_24 = (i)var23_22.getInfo();
                                            var21_21 -= var24_24.k * var6_6;
                                            var25_25 = var24_24.k * var14_14;
                                            cfr_temp_1 = var25_25 - var24_24.b;
                                            v1 = cfr_temp_1 == 0.0 ? 0 : (cfr_temp_1 > 0.0 ? 1 : -1);
                                            if (var29_2) continue block4;
                                            if (v1 <= 0) break block18;
                                            var25_25 = var24_24.b;
                                            var14_14 = (var19_19 -= var25_25) * var6_6 / Math.max(1.0, var21_21);
                                            if (!var29_2) break block19;
                                        }
                                        var19_19 -= var25_25;
                                    }
                                    var24_24.j = var25_25;
                                    if (!var29_2) continue;
                                }
                                var23_23 = var19_19 / (double)(2 * var9_15.i.size());
                                var25_25 = var9_15.f;
                                for (var27_26 = var9_15.i.firstCell(); var27_26 != null; var27_26 = var27_26.succ()) {
                                    var28_27 = (i)var27_26.getInfo();
                                    var28_27.f = var25_25 += var23_23;
                                    var25_25 += var23_23 + var28_27.j;
                                    if (!var29_2) {
                                        if (!var29_2) continue;
                                    }
                                    break block16;
                                }
                            }
                        }
                        var8_8 = var8_8.succ();
                    }
                    if (!var29_2) continue;
                }
                break;
            }
            ++var3_4;
        } while (!var29_2);
    }

    private void b(c[] cArray) {
        boolean bl = z;
        int n2 = 0;
        while (n2 < cArray.length) {
            block3: {
                for (ListCell listCell = cArray[n2].f(); listCell != null; listCell = listCell.succ()) {
                    ((i)listCell.getInfo()).e();
                    if (!bl) {
                        if (!bl) continue;
                    }
                    break block3;
                }
                ++n2;
            }
            if (!bl) continue;
        }
    }

    private void e(c[] cArray) {
        boolean bl = z;
        int n2 = 0;
        block0: while (true) {
            int n3 = n2;
            block1: while (n3 < cArray.length) {
                double d2;
                double d3 = cArray[n2].b();
                if (n2 > 0) {
                    d2 = Math.max(this.getMinimalLayerDistance(), this.getLayerSpacing());
                    d2 = Math.max(d2, cArray[n2 - 1].e() + cArray[n2].e() + this.vfb);
                    d3 = Math.max(d3, cArray[n2 - 1].b() + d2);
                }
                d3 = this.i(d3);
                cArray[n2].c(d3);
                if (n2 < cArray.length - 1) {
                    d2 = this.i(d3 + 1.0E-4);
                    for (ListCell listCell = cArray[n2].f(); listCell != null; listCell = listCell.succ()) {
                        i i2 = (i)listCell.getInfo();
                        n3 = i2.d() ? 1 : 0;
                        if (bl) continue block1;
                        if (n3 == 0) continue;
                        double d4 = 0.0;
                        for (ListCell listCell2 = i2.i.firstCell(); listCell2 != null; listCell2 = listCell2.succ()) {
                            i i3 = (i)listCell2.getInfo();
                            d4 += i3.l;
                            double d5 = i3.j - 0.0;
                            n3 = d5 == 0.0 ? 0 : (d5 > 0.0 ? 1 : -1);
                            if (bl) continue block1;
                            if (n3 <= 0) continue;
                            d2 = Math.max(d2, i3.l / i3.j);
                            if (!bl) continue;
                        }
                        double d6 = this.d(d3, d4);
                        d2 = Math.max(d2, d6);
                        if (!(i2.j > 0.0)) continue;
                        double d7 = d4 / i2.j;
                        d2 = Math.max(d2, d7);
                        if (!bl) continue;
                    }
                    cArray[n2 + 1].c(d2);
                }
                ++n2;
                if (!bl) continue block0;
            }
            break;
        }
    }

    private double i(double d2) {
        double d3 = this.getLayerSpacing();
        if (d3 > 0.0) {
            return Math.ceil(d2 / d3 - 1.0E-4) * d3;
        }
        return d2;
    }

    private double d(double d2, double d3) {
        double d4;
        double d5;
        boolean bl = z;
        if (d3 == 0.0) {
            return 0.0;
        }
        if (d2 < 1.0E-4 || this.getMaximalChildSectorAngle() + 1.0E-4 > 360.0) {
            return d3 / (Math.PI * 2);
        }
        double d6 = this.getMaximalChildSectorAngle() * Math.PI / 360.0;
        double d7 = Math.sin(d6) / d3;
        double d8 = d3 / (d2 + d3 / (d6 + Math.sin(d6)));
        double d9 = Double.MAX_VALUE;
        while (!((d5 = Math.abs(d8 - (d4 = this.b(d2, d6, d7, d8)))) >= d9)) {
            if (d5 < 1.0E-4) {
                d8 = d4;
                if (!bl) break;
            }
            d8 = d4;
            d9 = d5;
            if (!bl) continue;
        }
        d4 = d3 / d8;
        return d4;
    }

    private double b(double d2, double d3, double d4, double d5) {
        double d6 = d3 - d5 / 2.0;
        double d7 = d5 + (Math.sin(d6) - d2 * d4 * d5) / (Math.cos(d6) / 2.0 + d4 * d2);
        return d7;
    }

    private void c(LayoutGraph layoutGraph, c[] cArray, NodeMap nodeMap, EdgeMap edgeMap) {
        block4: {
            boolean bl = z;
            DataProvider dataProvider = layoutGraph.getDataProvider(NODE_INFO_DPKEY);
            int n2 = 0;
            block0: while (true) {
                int n3 = n2;
                block1: while (n3 < cArray.length) {
                    c c2 = cArray[n2];
                    if (bl) break block4;
                    for (ListCell listCell = c2.f(); listCell != null; listCell = listCell.succ()) {
                        i i2 = (i)listCell.getInfo();
                        n3 = i2 instanceof g;
                        if (bl) continue block1;
                        if (n3 != 0) {
                            this.b(layoutGraph, cArray, (g)i2, dataProvider);
                            if (!bl) continue;
                        }
                        if (!(i2 instanceof n) || i2.j != 0.0) continue;
                        this.b(cArray, listCell);
                        if (!bl) continue;
                    }
                    ++n2;
                    if (!bl) continue block0;
                }
                break;
            }
            this.b(layoutGraph, cArray, nodeMap, edgeMap);
        }
    }

    private void b(LayoutGraph layoutGraph, c[] cArray, g g2, DataProvider dataProvider) {
        NodeInfo nodeInfo;
        Node node = g2.f();
        double d2 = cArray[g2.h].b();
        YPoint yPoint = _b.d(d2, g2.b());
        layoutGraph.setCenter(node, yPoint);
        if (dataProvider != null && (nodeInfo = (NodeInfo)dataProvider.get(node)) != null) {
            nodeInfo.e = g2.h;
            nodeInfo.c = d2;
            nodeInfo.b = yPoint;
            nodeInfo.f = Geom.toDegrees(g2.f) - 90.0;
            nodeInfo.d = Geom.toDegrees(g2.j);
        }
    }

    private void b(c[] cArray, ListCell listCell) {
        double d2;
        double d3;
        double d4;
        int n2;
        ListCell listCell2;
        ListCell listCell3;
        c c2;
        boolean bl;
        block25: {
            double d5;
            double d6;
            i i2;
            i i3;
            block24: {
                double d7;
                bl = z;
                n n3 = (n)listCell.getInfo();
                n3.b(cArray);
                c2 = cArray[n3.h];
                double d8 = cArray[n3.h].b();
                listCell3 = null;
                listCell2 = null;
                n2 = 1;
                ListCell listCell4 = c2.c(listCell);
                while (listCell4 != null && listCell4 != listCell) {
                    i3 = (i)listCell4.getInfo();
                    if (i3.j > 0.0) {
                        listCell3 = listCell4;
                        break;
                    }
                    if (i3 instanceof n) {
                        ((n)i3).b(cArray);
                    }
                    ++n2;
                    listCell4 = c2.c(listCell4);
                }
                listCell4 = c2.b(listCell);
                while (listCell4 != null && listCell4 != listCell) {
                    i3 = (i)listCell4.getInfo();
                    if (i3.j > 0.0) {
                        listCell2 = listCell4;
                        break;
                    }
                    if (i3 instanceof n) {
                        ((n)i3).b(cArray);
                    }
                    ++n2;
                    listCell4 = c2.b(listCell4);
                }
                i3 = (i)listCell3.getInfo();
                i2 = (i)listCell2.getInfo();
                d4 = this.vfb / (2.0 * d8);
                d6 = i3 instanceof g ? i3.l / (2.0 * d8) : d4;
                d5 = i2 instanceof g ? i2.l / (2.0 * d8) : d4;
                double d9 = d7 = i3 == i2 ? Math.PI * 2 : _b.b(i3.b(), i2.b(), true);
                if (!(d7 < d6 + d5)) break block24;
                d2 = d3 = i3.b() + d6 - (d6 + d5 - d7) / 2.0;
                if (!bl) break block25;
            }
            d3 = i3.b() + d6;
            d2 = i2.b() - d5;
        }
        double d10 = _b.b(d3, d2, true);
        if (n2 > 1 && d10 < d4 * (double)(n2 - 1)) {
            d4 = d10 / (double)(n2 - 1);
        }
        ListCell listCell5 = c2.b(listCell3);
        ListCell listCell6 = c2.c(listCell2);
        while (n2 > 0) {
            double d11;
            double d12;
            double d13;
            double d14;
            double d15;
            block33: {
                double d16;
                block32: {
                    double d17;
                    double d18;
                    block31: {
                        double d19;
                        block30: {
                            double d20;
                            double d21;
                            double d22;
                            block26: {
                                block28: {
                                    block29: {
                                        block27: {
                                            n n4 = (n)listCell5.getInfo();
                                            d22 = n4.h();
                                            if (d10 < 0.0) {
                                                d10 = 0.0;
                                                d2 = d3;
                                            }
                                            if (n2 != 1) break block26;
                                            if (!_b.b(d3, d22, d2)) break block27;
                                            d21 = d22;
                                            if (!bl) break block28;
                                        }
                                        if (!(_b.b(d2, d22, true) < _b.b(d22, d3, true))) break block29;
                                        d21 = d2;
                                        if (!bl) break block28;
                                    }
                                    d21 = d3;
                                }
                                n4.f = d21 - 5.0E-5;
                                n4.j = 1.0E-4;
                                if (!bl) break;
                            }
                            d21 = Math.max(0.0, d10 - (double)(n2 - 1) * d4);
                            d18 = d21 / (double)n2;
                            double d23 = _b.b(d3 + d18);
                            double d24 = _b.b(d2, d3, true) / 2.0 + 1.0E-4;
                            d17 = _b.b(d3 - d24);
                            if (_b.b(d17, d22, d23)) {
                                d20 = _b.b(d3, d22, d23) ? d22 : d3;
                                n4.f = d20 - 5.0E-5;
                                n4.j = 1.0E-4;
                                d19 = _b.b(d20 + d4);
                                d10 -= _b.b(d3, d19, true);
                                d3 = d19;
                                --n2;
                                listCell5 = c2.b(listCell5);
                                if (!bl) continue;
                            }
                            if (!((d20 = _b.b(d23, d22, true)) < (d19 = _b.b(d22, d3, true)))) break block30;
                            d15 = d20;
                            d14 = d23;
                            if (!bl) break block31;
                        }
                        d15 = d19;
                        d14 = d3;
                    }
                    n n5 = (n)listCell6.getInfo();
                    double d25 = n5.h();
                    double d26 = _b.b(d2 - d18);
                    if (_b.b(d26, d25, d17 + 2.0E-4)) {
                        d13 = _b.b(d26, d25, d2) ? d25 : d2;
                        n5.f = d13 - 5.0E-5;
                        n5.j = 1.0E-4;
                        d16 = _b.b(d13 - d4);
                        d10 -= _b.b(d16, d2, true);
                        d2 = d16;
                        --n2;
                        listCell6 = c2.c(listCell6);
                        if (!bl) continue;
                    }
                    if (!((d13 = _b.b(d25, d26, true)) < (d16 = _b.b(d2, d25, true)))) break block32;
                    d12 = d13;
                    d11 = d26;
                    if (!bl) break block33;
                }
                d12 = d16;
                d11 = d2;
            }
            if (d15 < d12) {
                n4.f = d14 - 5.0E-5;
                n4.j = 1.0E-4;
                d13 = _b.b(d14 + d4);
                d10 -= _b.b(d3, d13, true);
                d3 = d13;
                --n2;
                listCell5 = c2.b(listCell5);
                if (!bl) continue;
            }
            n5.f = d11 - 5.0E-5;
            n5.j = 1.0E-4;
            d13 = _b.b(d11 - d4);
            d10 -= _b.b(d13, d2, true);
            d2 = d13;
            --n2;
            listCell6 = c2.c(listCell6);
            if (!bl) continue;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void b(LayoutGraph var1_1, c[] var2_2, NodeMap var3_3, EdgeMap var4_4) {
        var19_5 = RadialLayouter.z;
        var5_6 = AbortHandler.getFromGraph(var1_1);
        var6_7 = 50;
        var7_8 = var1_1.edges();
        while (var7_8.ok()) {
            var8_9 = var7_8.edge();
            LayoutTool.resetPath(var1_1, var8_9);
            if (var6_7-- == 0) {
                var5_6.check();
                var6_7 = 50;
            }
            var9_10 = new YList();
            var10_11 = (g)var3_3.get(var8_9.source());
            var11_12 = (g)var3_3.get(var8_9.target());
            var12_13 = (YList)var4_4.get(var8_9);
            var9_10.add(var10_11);
            if (var12_13 == null) ** GOTO lbl-1000
            if (var10_11.h >= var11_12.h) ** GOTO lbl-1000
            var9_10.addAll((Collection)var12_13);
            if (var19_5) lbl-1000:
            // 3 sources

            {
                for (var13_15 = var12_13.lastCell(); var13_15 != null; var13_15 = var13_15.pred()) {
                    var9_10.add(var13_15.getInfo());
                    if (!var19_5) {
                        if (!var19_5) continue;
                    }
                    break;
                }
            } else lbl-1000:
            // 4 sources

            {
                var9_10.add(var11_12);
            }
            if ((var14_16 = this.b(var13_14 = var10_11.h == var11_12.h, this.getEdgeRoutingStrategy())) instanceof d) {
                ((d)var14_16).b(this.bgb);
                ((d)var14_16).c(this.agb);
                ((d)var14_16).b(this.pfb);
            }
            if (!(var15_17 = var14_16.b(var9_10, var2_2)).isEmpty()) {
                var16_18 = var1_1.getEdgeLayout(var8_9);
                var17_19 = var15_17.iterator();
                while (var17_19.hasNext()) {
                    var18_20 = (YPoint)var17_19.next();
                    var16_18.addPoint(var18_20.getX(), var18_20.getY());
                    if (!var19_5) {
                        if (!var19_5) continue;
                    }
                    break;
                }
            } else {
                var7_8.next();
            }
            if (!var19_5) continue;
        }
    }

    private b b(boolean bl, byte by) {
        switch (by) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return this.lfb[by];
            }
        }
        if (bl) {
            return this.lfb[3];
        }
        return this.lfb[4];
    }

    public static class NodeInfo {
        int e;
        double c;
        YPoint b;
        double f;
        double d;

        public int getCircleIndex() {
            return this.e;
        }

        public double getRadius() {
            return this.c;
        }

        public YPoint getCenterOffset() {
            return this.b;
        }

        public double getSectorStart() {
            return this.f;
        }

        public double getSectorSize() {
            return this.d;
        }
    }

    static class _b {
        double b;
        double c;

        _b(double d2, double d3) {
            this.b = d2;
            this.c = d3;
        }

        static double b(double d2, double d3, boolean bl) {
            double d4;
            block5: {
                block4: {
                    d4 = d3 - d2;
                    if (!bl || !(d4 < 0.0)) break block4;
                    d4 += Math.PI * 2;
                    if (!z) break block5;
                }
                if (!bl && d4 > 0.0) {
                    d4 -= Math.PI * 2;
                }
            }
            return d4;
        }

        boolean b(_b _b2) {
            return _b.c(this.c, _b2.c);
        }

        static boolean c(double d2, double d3) {
            double d4 = d3 - d2;
            return 0.0 <= d4 && d4 <= Math.PI || d4 < 0.0 && d4 < -Math.PI;
        }

        static boolean b(_b _b2, _b _b3, _b _b4) {
            return _b.b(_b2.c, _b3.c, _b4.c);
        }

        static boolean b(double d2, double d3, double d4) {
            return d2 <= d3 && d3 <= d4 || d4 < d2 && (d2 < d3 || d3 < d4);
        }

        static _b b(_b _b2, _b _b3, boolean bl) {
            double d2 = (_b2.b + _b3.b) / 2.0;
            double d3 = _b.b(_b2.c, _b3.c, bl);
            double d4 = _b.b(_b2.c + d3 / 2.0);
            return new _b(d2, d4);
        }

        static double b(double d2) {
            block5: {
                block4: {
                    if (!(d2 < 0.0)) break block4;
                    d2 += Math.PI * 2;
                    if (!z) break block5;
                }
                if (d2 >= Math.PI * 2) {
                    d2 -= Math.PI * 2;
                }
            }
            return d2;
        }

        public static YPoint d(double d2, double d3) {
            double d4 = Math.sin(d3) * d2;
            double d5 = Math.cos(d3) * d2;
            return new YPoint(d4, d5);
        }

        public static _b b(double d2, double d3) {
            double d4 = Math.atan2(d3, d2);
            double d5 = d2 * d2 + d3 * d3;
            double d6 = d5 > 0.0 ? Math.sqrt(d5) : 0.0;
            return new _b(d6, d4);
        }
    }
}

