/*
 * Decompiled with CFR 0.152.
 */
package y.layout.planar;

import java.util.ArrayList;
import y.base.Edge;
import y.base.EdgeCursor;
import y.base.Graph;
import y.base.Node;
import y.base.NodeCursor;
import y.base.NodeList;
import y.layout.planar.SimplePlanarInformation;
import y.util.YRandom;

public class VertexOrder {
    protected Graph graph;
    protected boolean allowRandomization;
    protected int[] degree;
    protected boolean[] selected;
    protected ArrayList graphNodes;
    protected ArrayList neighbors;
    protected ArrayList candidateList;
    protected YRandom random;
    protected long seed = 1306737L;

    public void setGraph(Graph graph) {
        this.graph = graph;
        this.degree = new int[graph.nodeCount()];
        this.selected = new boolean[graph.nodeCount()];
        this.graphNodes = new ArrayList(graph.nodeCount());
        this.neighbors = new ArrayList(graph.nodeCount());
        this.candidateList = new ArrayList(graph.nodeCount());
        this.random = new YRandom(this.seed);
    }

    public void setAllowRandomization(boolean bl) {
        this.allowRandomization = bl;
    }

    public void computeVertexOrder(NodeList nodeList) {
        int n2;
        block6: {
            n2 = SimplePlanarInformation.z;
            this.initDegrees();
            nodeList.clear();
            this.graphNodes.clear();
            NodeCursor nodeCursor = this.graph.nodes();
            while (nodeCursor.ok()) {
                this.graphNodes.add(nodeCursor.node());
                nodeCursor.next();
                if (n2 == 0) {
                    if (n2 == 0) continue;
                }
                break block6;
            }
            this.getMinDegreeNodes(this.graphNodes, this.candidateList);
        }
        if (this.candidateList.isEmpty()) {
            throw new RuntimeException("Graph consists only of directed circles");
        }
        this.selectNode(this.graphNodes, this.candidateList, this.neighbors, nodeList);
        while (!this.graphNodes.isEmpty()) {
            this.getMinDegreeNodes(this.neighbors, this.candidateList);
            if (this.candidateList.isEmpty()) {
                this.getMinDegreeNodes(this.graphNodes, this.candidateList);
            }
            if (this.candidateList.isEmpty()) {
                throw new RuntimeException("Graph contains a directed circle");
            }
            this.selectNode(this.graphNodes, this.candidateList, this.neighbors, nodeList);
            if (n2 == 0) continue;
        }
    }

    protected void initDegrees() {
        VertexOrder vertexOrder;
        int n2;
        block3: {
            n2 = SimplePlanarInformation.z;
            for (int i2 = 0; i2 < this.graph.N(); ++i2) {
                this.degree[i2] = 0;
                vertexOrder = this;
                if (n2 == 0) {
                    vertexOrder.selected[i2] = false;
                    if (n2 == 0) continue;
                }
                break block3;
            }
            vertexOrder = this;
        }
        EdgeCursor edgeCursor = vertexOrder.graph.edges();
        while (edgeCursor.ok()) {
            Edge edge = edgeCursor.edge();
            int n3 = edge.target().index();
            this.degree[n3] = this.degree[n3] + 1;
            int n4 = edge.source().index();
            this.degree[n4] = this.degree[n4] + 1;
            edgeCursor.next();
            if (n2 == 0) continue;
        }
    }

    protected void getMinDegreeNodes(ArrayList arrayList, ArrayList arrayList2) {
        int n2 = SimplePlanarInformation.z;
        arrayList2.clear();
        int n3 = Integer.MAX_VALUE;
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            Node node = (Node)arrayList.get(i2);
            int n4 = this.degree[node.index()];
            if (n4 < n3) {
                n3 = n4;
                arrayList2.clear();
            }
            if (n4 != n3) continue;
            arrayList2.add(node);
            if (n2 == 0) continue;
        }
    }

    public void selectNode(ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3, NodeList nodeList) {
        int n2 = SimplePlanarInformation.z;
        Node node = this.allowRandomization ? this.randomSelectNode(arrayList2) : (Node)arrayList2.get(0);
        int n3 = arrayList.indexOf(node);
        if (n3 >= 0) {
            arrayList.remove(n3);
        }
        nodeList.add(node);
        arrayList3.clear();
        this.selected[node.index()] = true;
        EdgeCursor edgeCursor = node.edges();
        while (edgeCursor.ok()) {
            Edge edge = edgeCursor.edge();
            Node node2 = edge.opposite(node);
            int n4 = node2.index();
            if (!this.selected[n4]) {
                int n5 = n4;
                this.degree[n5] = this.degree[n5] - 1;
                arrayList3.add(node2);
            }
            edgeCursor.next();
            if (n2 == 0) continue;
        }
    }

    protected Node randomSelectNode(ArrayList arrayList) {
        if (arrayList.size() == 0) {
            throw new RuntimeException("Given an empty list!");
        }
        int n2 = this.random.nextInt(arrayList.size());
        return (Node)arrayList.get(n2);
    }
}

