/*
 * Decompiled with CFR 0.152.
 */
package y.layout.planar;

import java.util.ArrayList;
import java.util.Comparator;
import y.base.Edge;
import y.base.EdgeCursor;
import y.base.EdgeList;
import y.base.EdgeMap;
import y.base.Graph;
import y.base.ListCell;
import y.base.Node;
import y.base.NodeCursor;
import y.base.NodeList;
import y.base.NodeMap;
import y.base.YCursor;
import y.layout.DefaultEdgeLayout;
import y.layout.DefaultGraphLayout;
import y.layout.DefaultNodeLayout;
import y.layout.EdgeLayout;
import y.layout.NodeLayout;
import y.layout.planar.InitialPlanarSubgraph;
import y.layout.planar.OverlapGraphMIS;
import y.layout.planar.PlanarInformation;
import y.layout.planar.SimplePlanarInformation;
import y.layout.planar.VertexOrder;
import y.util.Comparators;
import y.util.D;
import y.util.EdgeMapAdapter;

public class GT
implements InitialPlanarSubgraph {
    protected EdgeListComparator edgeListComparator;
    protected MIS1Comparator mis1Comparator = new MIS1Comparator();
    protected MIS2Comparator mis2Comparator = new MIS2Comparator();
    protected PlanarInformation planar;
    protected Graph graph;
    protected boolean isValid = false;
    protected VertexOrder vertexOrder;
    protected EdgeMap weight;
    protected Edge outerFaceDeterminationEdge = null;
    protected Node outerFaceDeterminationNode = null;
    protected EdgeList hiddenEdges;
    protected Node globalSource = null;
    protected Node globalSink = null;
    private int ab = 50;
    private boolean bb;

    public GT() {
        this.edgeListComparator = new EdgeListComparator();
        this.vertexOrder = new VertexOrder();
        this.weight = new EdgeMapAdapter(){

            public int getInt(Object object) {
                return 1;
            }
        };
    }

    public void setAllowRandomization(boolean bl) {
        this.bb = bl;
    }

    public boolean getAllowRandomization() {
        return this.bb;
    }

    public void setIterations(int n2) {
        this.ab = n2;
    }

    public int getIterations() {
        return this.ab;
    }

    public EdgeList getHiddenEdges() {
        if (this.isValid) {
            return this.hiddenEdges;
        }
        throw new RuntimeException("Invalid Execution Order: call 'createPlanarization' first!");
    }

    public Node getSource() {
        if (this.isValid) {
            return this.globalSource;
        }
        throw new RuntimeException("Invalid Execution Order: call 'assignUpward' first!");
    }

    public Node getSink() {
        if (this.isValid) {
            return this.globalSink;
        }
        throw new RuntimeException("Invalid Execution Order: call 'assignUpward' first!");
    }

    public void createPlanarization(PlanarInformation planarInformation) {
        this.planar = planarInformation;
        this.graph = planarInformation.getGraph();
        if (this.graph.nodeCount() == 0 || this.graph.edgeCount() == 0) {
            this.hiddenEdges = new EdgeList();
            this.isValid = true;
            return;
        }
        this.vertexOrder.setGraph(this.graph);
        this.vertexOrder.setAllowRandomization(this.bb);
        int[] nArray = new int[this.graph.N()];
        OverlapGraphMIS overlapGraphMIS = new OverlapGraphMIS(this.graph, this.weight);
        NodeList nodeList = this.calcOrdering(nArray, overlapGraphMIS);
        overlapGraphMIS.computeMaximumIndependentSets(nodeList, nArray);
        this.hiddenEdges = overlapGraphMIS.getHiddenEdges();
        NodeMap nodeMap = this.graph.createNodeMap();
        NodeMap nodeMap2 = this.graph.createNodeMap();
        this.initOrdering(nodeMap, nodeMap2, nodeList);
        EdgeList edgeList = new EdgeList(overlapGraphMIS.getMIS1().iterator());
        EdgeList edgeList2 = new EdgeList(overlapGraphMIS.getMIS2().iterator());
        this.createCircularEdgeOrder(edgeList, edgeList2, nodeMap, nodeMap2, nArray);
        this.graph.disposeNodeMap(nodeMap);
        this.graph.disposeNodeMap(nodeMap2);
        planarInformation.calcFaces();
        if (this.outerFaceDeterminationEdge == null) {
            this.outerFaceDeterminationEdge = this.graph.firstEdge();
        }
        planarInformation.setOuterFace(planarInformation.faceOf(this.outerFaceDeterminationEdge));
        this.isValid = true;
        this.dispose();
    }

    protected NodeList calcOrdering(int[] nArray, OverlapGraphMIS overlapGraphMIS) {
        NodeCursor nodeCursor;
        NodeList nodeList;
        int n2;
        block16: {
            int n3;
            int n4;
            NodeList nodeList2;
            block13: {
                n2 = SimplePlanarInformation.z;
                nodeList = new NodeList();
                nodeList2 = null;
                if (this.bb) {
                    n4 = Integer.MAX_VALUE;
                    int n5 = 0;
                    block0: while (n5 < this.ab) {
                        block15: {
                            YCursor yCursor;
                            block14: {
                                n3 = n4;
                                if (n2 != 0) break block13;
                                if (n3 <= 0) break;
                                this.vertexOrder.computeVertexOrder(nodeList);
                                int n6 = 1;
                                yCursor = nodeList.nodes();
                                while (yCursor.ok()) {
                                    nArray[yCursor.node().index()] = n6++;
                                    yCursor.next();
                                    if (n2 == 0) {
                                        if (n2 == 0) continue;
                                    }
                                    break block14;
                                }
                                overlapGraphMIS.computeMaximumIndependentSets(nodeList, nArray);
                                this.hiddenEdges = overlapGraphMIS.getHiddenEdges();
                            }
                            if (n4 > this.hiddenEdges.size()) {
                                n4 = this.hiddenEdges.size();
                                nodeList2 = new NodeList();
                                yCursor = nodeList.nodes();
                                while (yCursor.ok()) {
                                    nodeList2.addLast(yCursor.node());
                                    yCursor.next();
                                    if (n2 != 0) continue block0;
                                    if (n2 == 0) continue;
                                }
                            }
                            yCursor = this.hiddenEdges.edges();
                            while (yCursor.ok()) {
                                this.graph.unhide(yCursor.edge());
                                yCursor.next();
                                if (n2 == 0) {
                                    if (n2 == 0) continue;
                                }
                                break block15;
                            }
                            ++n5;
                        }
                        if (n2 == 0) continue;
                    }
                    nodeList = nodeList2;
                } else {
                    this.vertexOrder.computeVertexOrder(nodeList);
                    nodeList2 = nodeList;
                }
                n3 = 1;
            }
            n4 = n3;
            nodeCursor = nodeList2.nodes();
            while (nodeCursor.ok()) {
                nArray[nodeCursor.node().index()] = n4++;
                nodeCursor.next();
                if (n2 == 0) {
                    if (n2 == 0) continue;
                }
                break block16;
            }
            nodeCursor = nodeList.nodes();
            nodeCursor.toFirst();
            this.globalSource = nodeCursor.node();
            nodeCursor.toLast();
            this.globalSink = nodeCursor.node();
        }
        nodeCursor = nodeList.nodes();
        while (nodeCursor.ok()) {
            Node node = nodeCursor.node();
            if (node.degree() != 0) {
                this.outerFaceDeterminationNode = node;
                if (n2 == 0) break;
            }
            nodeCursor.next();
            if (n2 == 0) continue;
        }
        return nodeList;
    }

    protected void initOrdering(NodeMap nodeMap, NodeMap nodeMap2, NodeList nodeList) {
        Node node;
        NodeCursor nodeCursor;
        int n2;
        block10: {
            n2 = SimplePlanarInformation.z;
            nodeCursor = nodeList.nodes();
            while (nodeCursor.ok()) {
                node = nodeCursor.node();
                nodeMap.set(node, null);
                nodeMap2.set(node, null);
                nodeCursor.next();
                if (n2 == 0) {
                    if (n2 == 0) continue;
                }
                break block10;
            }
            nodeCursor = nodeList.nodes();
        }
        while (nodeCursor.ok()) {
            node = nodeCursor.node();
            ListCell listCell = nodeList.findCell(node);
            Node node2 = node;
            block2: while (true) {
                EdgeCursor edgeCursor = node2.edges();
                while (edgeCursor.ok()) {
                    block12: {
                        Edge edge;
                        block11: {
                            edge = edgeCursor.edge();
                            node2 = node;
                            if (n2 != 0) continue block2;
                            if (node2 == (Node)nodeList.first() || edge.opposite(node) != (Node)nodeList.predCell(listCell).getInfo()) break block11;
                            nodeMap.set(node, edge);
                            if (n2 == 0) break block12;
                        }
                        if (node != (Node)nodeList.last() && edge.opposite(node) == (Node)nodeList.succCell(listCell).getInfo()) {
                            nodeMap2.set(node, edge);
                        }
                    }
                    edgeCursor.next();
                    if (n2 == 0) continue;
                }
                break;
            }
            nodeCursor.next();
            if (n2 == 0) continue;
        }
    }

    protected void calcMISIncidents(EdgeList edgeList, NodeMap nodeMap) {
        int n2 = SimplePlanarInformation.z;
        EdgeCursor edgeCursor = edgeList.edges();
        while (edgeCursor.ok()) {
            block8: {
                Node node;
                Edge edge;
                block7: {
                    EdgeList edgeList2;
                    block6: {
                        Node node2;
                        block5: {
                            edge = edgeCursor.edge();
                            node2 = edge.source();
                            node = edge.target();
                            if (nodeMap.get(node2) != null) break block5;
                            edgeList2 = new EdgeList();
                            edgeList2.add(edge);
                            nodeMap.set(node2, edgeList2);
                            if (n2 == 0) break block6;
                        }
                        ((EdgeList)nodeMap.get(node2)).add(edge);
                    }
                    if (nodeMap.get(node) != null) break block7;
                    edgeList2 = new EdgeList();
                    edgeList2.add(edge);
                    nodeMap.set(node, edgeList2);
                    if (n2 == 0) break block8;
                }
                ((EdgeList)nodeMap.get(node)).add(edge);
            }
            edgeCursor.next();
            if (n2 == 0) continue;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void createCircularEdgeOrder(EdgeList var1_1, EdgeList var2_2, NodeMap var3_3, NodeMap var4_4, int[] var5_5) {
        block21: {
            var15_6 = SimplePlanarInformation.z;
            var9_7 = this.graph.createNodeMap();
            var10_8 = this.graph.createNodeMap();
            this.calcMISIncidents(var1_1, var9_7);
            this.calcMISIncidents(var2_2, var10_8);
            this.createReverseEdges();
            this.mis1Comparator.setOrderNumbers(var5_5);
            this.mis2Comparator.setOrderNumbers(var5_5);
            var11_9 = this.graph.nodes();
            while (var11_9.ok()) {
                block22: {
                    block25: {
                        block23: {
                            block24: {
                                var12_13 = var11_9.node();
                                var13_14 = new EdgeList();
                                var6_10 = (EdgeList)var9_7.get(var12_13);
                                if (var15_6 != 0) break block21;
                                if (var6_10 != null) {
                                    this.mis1Comparator.setCurrentNode(var12_13);
                                    var6_10.sort((Comparator)this.mis1Comparator);
                                }
                                if ((var7_11 = (EdgeList)var10_8.get(var12_13)) != null) {
                                    this.mis2Comparator.setCurrentNode(var12_13);
                                    var7_11.sort((Comparator)this.mis2Comparator);
                                }
                                if ((var8_12 = (Edge)var3_3.get(var12_13)) == null) break block23;
                                if (var8_12.source() != var12_13) break block24;
                                var13_14.add(var8_12);
                                if (var15_6 == 0) break block23;
                            }
                            var13_14.add(this.planar.getReverse(var8_12));
                        }
                        if (var6_10 == null) break block25;
                        var14_15 = var6_10.edges();
                        while (var14_15.ok()) {
                            block27: {
                                block26: {
                                    var8_12 = var14_15.edge();
                                    v0 = var8_12.source();
                                    v1 = var12_13;
                                    if (var15_6 != 0) break block22;
                                    if (v0 != v1) break block26;
                                    var13_14.add(var8_12);
                                    if (var15_6 == 0) break block27;
                                }
                                var13_14.add(this.planar.getReverse(var8_12));
                            }
                            if (var12_13 == this.outerFaceDeterminationNode && this.outerFaceDeterminationEdge == null) {
                                this.outerFaceDeterminationEdge = (Edge)var13_14.last();
                            }
                            var14_15.next();
                            if (var15_6 == 0) continue;
                        }
                    }
                    if ((var8_12 = (Edge)var4_4.get(var12_13)) == null) ** GOTO lbl65
                    v0 = var8_12.source();
                    v1 = var12_13;
                }
                block2: while (true) {
                    block29: {
                        block28: {
                            if (v0 != v1) break block28;
                            var13_14.add(var8_12);
                            if (var15_6 == 0) break block29;
                        }
                        var13_14.add(this.planar.getReverse(var8_12));
                    }
                    if (var12_13 == this.outerFaceDeterminationNode && this.outerFaceDeterminationEdge == null) {
                        this.outerFaceDeterminationEdge = (Edge)var13_14.last();
                    }
lbl65:
                    // 4 sources

                    if (var7_11 == null) break;
                    var14_15 = var7_11.edges();
                    while (var14_15.ok()) {
                        block31: {
                            block30: {
                                var8_12 = var14_15.edge();
                                v0 = var8_12.source();
                                v1 = var12_13;
                                if (var15_6 != 0) continue block2;
                                if (v0 != v1) break block30;
                                var13_14.add(var8_12);
                                if (var15_6 == 0) break block31;
                            }
                            var13_14.add(this.planar.getReverse(var8_12));
                        }
                        if (var12_13 == this.outerFaceDeterminationNode && this.outerFaceDeterminationEdge == null) {
                            this.outerFaceDeterminationEdge = (Edge)var13_14.last();
                        }
                        var14_15.next();
                        if (var15_6 == 0) continue;
                    }
                    break;
                }
                this.edgeListComparator.setEdgeList(var13_14);
                var12_13.sortOutEdges(this.edgeListComparator);
                var11_9.next();
                if (var15_6 == 0) continue;
            }
            this.graph.disposeNodeMap(var9_7);
            this.graph.disposeNodeMap(var10_8);
        }
    }

    protected void createReverseEdges() {
        int n2 = SimplePlanarInformation.z;
        EdgeList edgeList = new EdgeList(this.graph.edges());
        EdgeCursor edgeCursor = edgeList.edges();
        while (edgeCursor.ok()) {
            this.planar.createReverse(edgeCursor.edge());
            edgeCursor.next();
            if (n2 == 0) continue;
        }
    }

    public void dispose() {
    }

    protected void showVertexOrder(int[] nArray) {
        int n2 = SimplePlanarInformation.z;
        D.bug(0, "VERTEX ORDER");
        NodeCursor nodeCursor = this.graph.nodes();
        while (nodeCursor.ok()) {
            Node node = nodeCursor.node();
            D.bug(0, "Node: " + node + " index: " + nArray[node.index()]);
            nodeCursor.next();
            if (n2 == 0) continue;
        }
    }

    protected void showEdgePartitionResult(ArrayList arrayList, ArrayList arrayList2) {
        int n2;
        block6: {
            int n3;
            block5: {
                n2 = SimplePlanarInformation.z;
                D.bug(0, "EDGE PARTITION RESULT");
                D.bug(0, "SET ONE");
                for (n3 = 0; n3 < arrayList.size(); ++n3) {
                    D.bug(0, " edge: " + arrayList.get(n3));
                    if (n2 == 0) {
                        if (n2 == 0) continue;
                    }
                    break block5;
                }
                D.bug(0, "SET TWO");
            }
            for (n3 = 0; n3 < arrayList2.size(); ++n3) {
                D.bug(0, " edge: " + arrayList2.get(n3));
                if (n2 == 0) {
                    if (n2 == 0) continue;
                }
                break block6;
            }
            D.bug(0, "HIDDEN EDGES");
        }
        EdgeCursor edgeCursor = this.hiddenEdges.edges();
        while (edgeCursor.ok()) {
            D.bug(0, " edge: " + edgeCursor.edge());
            edgeCursor.next();
            if (n2 == 0) continue;
        }
    }

    protected void showGraphicDebug(EdgeList edgeList, EdgeList edgeList2, int[] nArray) {
        Object object;
        Object object2;
        DefaultGraphLayout defaultGraphLayout;
        int n2;
        block4: {
            n2 = SimplePlanarInformation.z;
            defaultGraphLayout = new DefaultGraphLayout();
            NodeCursor nodeCursor = this.graph.nodes();
            while (nodeCursor.ok()) {
                object2 = nodeCursor.node();
                object = new DefaultNodeLayout();
                ((DefaultNodeLayout)object).setSize(20.0, 20.0);
                double d2 = nArray[((Node)object2).index()] * 40;
                ((DefaultNodeLayout)object).setLocation(d2, 0.0);
                defaultGraphLayout.setNodeLayout(object2, (NodeLayout)object);
                nodeCursor.next();
                if (n2 == 0) continue;
            }
            object2 = edgeList.edges();
            while (object2.ok()) {
                object = new DefaultEdgeLayout();
                int n3 = nArray[object2.edge().target().index()] - nArray[object2.edge().source().index()];
                ((DefaultEdgeLayout)object).addPoint(nArray[object2.edge().index()] * 40 + n3 * 20 + 10, -n3 * 20);
                defaultGraphLayout.setEdgeLayout(object2.edge(), (EdgeLayout)object);
                object2.next();
                if (n2 == 0) {
                    if (n2 == 0) continue;
                }
                break block4;
            }
            object2 = edgeList2.edges();
        }
        while (object2.ok()) {
            object = new DefaultEdgeLayout();
            int n4 = nArray[object2.edge().target().index()] - nArray[object2.edge().source().index()];
            ((DefaultEdgeLayout)object).addPoint(nArray[object2.edge().source().index()] * 40 + n4 * 20 + 10, n4 * 20);
            defaultGraphLayout.setEdgeLayout(object2.edge(), (EdgeLayout)object);
            object2.next();
            if (n2 == 0) continue;
        }
    }

    protected void showIncidentEdges(NodeMap nodeMap, NodeMap nodeMap2, EdgeMap edgeMap, EdgeMap edgeMap2) {
        int n2 = SimplePlanarInformation.z;
        D.bug(0, "INCIDENT EDGES");
        NodeCursor nodeCursor = this.graph.nodes();
        while (nodeCursor.ok()) {
            EdgeCursor edgeCursor;
            Node node = nodeCursor.node();
            D.bug(0, " Node: " + node + " ->: " + (Edge)edgeMap2.get(node));
            D.bug(0, " Node: " + node + " <-: " + (Edge)edgeMap.get(node));
            EdgeList edgeList = (EdgeList)nodeMap.get(node);
            if (edgeList != null) {
                edgeCursor = edgeList.edges();
                while (edgeCursor.ok()) {
                    D.bug(0, "  MIS1: Node: " + node + " Edge: " + edgeCursor.edge());
                    edgeCursor.next();
                    if (n2 == 0) {
                        if (n2 == 0) continue;
                    }
                    break;
                }
            } else {
                edgeList = (EdgeList)nodeMap2.get(node);
            }
            if (edgeList != null) {
                edgeCursor = edgeList.edges();
                while (edgeCursor.ok()) {
                    D.bug(0, "  MIS2: Node: " + node + " Edge: " + edgeCursor.edge());
                    edgeCursor.next();
                    if (n2 == 0) {
                        if (n2 == 0) continue;
                    }
                    break;
                }
            } else {
                nodeCursor.next();
            }
            if (n2 == 0) continue;
        }
    }

    public static class EdgeListComparator
    implements Comparator {
        EdgeList b;

        public void setEdgeList(EdgeList edgeList) {
            this.b = edgeList;
        }

        public int compare(Object object, Object object2) {
            Edge edge = (Edge)object;
            Edge edge2 = (Edge)object2;
            return Comparators.compare(this.b.indexOf(edge), this.b.indexOf(edge2));
        }
    }

    public static class MIS2Comparator
    implements Comparator {
        Node c;
        int[] b;

        public void setCurrentNode(Node node) {
            this.c = node;
        }

        public void setOrderNumbers(int[] nArray) {
            this.b = nArray;
        }

        public int compare(Object object, Object object2) {
            Edge edge = (Edge)object;
            Edge edge2 = (Edge)object2;
            int n2 = this.b[this.c.index()];
            int n3 = this.b[edge.opposite(this.c).index()];
            int n4 = this.b[edge2.opposite(this.c).index()];
            if (n3 > n2 && n4 > n2 || n3 < n2 && n4 < n2) {
                if (n3 > n4) {
                    return 1;
                }
                if (n3 < n4) {
                    return -1;
                }
                return 0;
            }
            if (n3 > n4) {
                return -1;
            }
            if (n3 < n4) {
                return 1;
            }
            return 0;
        }
    }

    public static class MIS1Comparator
    implements Comparator {
        Node c;
        int[] b;

        public void setOrderNumbers(int[] nArray) {
            this.b = nArray;
        }

        public void setCurrentNode(Node node) {
            this.c = node;
        }

        public int compare(Object object, Object object2) {
            Edge edge = (Edge)object;
            Edge edge2 = (Edge)object2;
            int n2 = this.b[this.c.index()];
            int n3 = this.b[edge.opposite(this.c).index()];
            int n4 = this.b[edge2.opposite(this.c).index()];
            if (n3 > n2 && n4 > n2 || n3 < n2 && n4 < n2) {
                if (n3 > n4) {
                    return -1;
                }
                if (n3 < n4) {
                    return 1;
                }
                return 0;
            }
            if (n3 > n4) {
                return 1;
            }
            if (n3 < n4) {
                return -1;
            }
            return 0;
        }
    }
}

