/*
 * Decompiled with CFR 0.152.
 */
package y.layout.labeling;

import java.util.HashMap;
import java.util.Iterator;
import y.algo.AbortHandler;
import y.base.DataMap;
import y.base.DataProvider;
import y.base.Edge;
import y.base.GraphInterface;
import y.base.ListCell;
import y.base.Node;
import y.base.NodeCursor;
import y.base.YCursor;
import y.base.YList;
import y.geom.IntersectionAlgorithm;
import y.geom.LineSegment;
import y.geom.OrientedRectangle;
import y.geom.YPointPath;
import y.geom.YRectangle;
import y.layout.AbstractLayoutStage;
import y.layout.DefaultNodeLayout;
import y.layout.EdgeLabelCandidate;
import y.layout.EdgeLabelLayout;
import y.layout.EdgeLabelModel;
import y.layout.FreeNodeLabelModel;
import y.layout.GraphLayout;
import y.layout.LabelCandidate;
import y.layout.LabelLayout;
import y.layout.LabelRanking;
import y.layout.LayoutGraph;
import y.layout.LayoutTool;
import y.layout.NodeLabelCandidate;
import y.layout.NodeLabelLayout;
import y.layout.NodeLabelModel;
import y.layout.NodeLayout;
import y.layout.PortConstraintKeys;
import y.layout.ProfitModel;
import y.layout.SliderEdgeLabelModel;
import y.layout.grouping.Grouping;
import y.layout.grouping.GroupingKeys;
import y.layout.labeling.c;
import y.layout.labeling.d;
import y.layout.labeling.e;
import y.layout.labeling.f;
import y.layout.labeling.g;
import y.layout.labeling.h;
import y.util.DataProviderAdapter;
import y.util.DataProviders;
import y.util.Maps;

public abstract class AbstractLabelingAlgorithm
extends AbstractLayoutStage {
    public static final Object LABEL_MODEL_DPKEY = "y.layout.labeling.AbstractLabelingAlgorithm.LABEL_MODEL_DPKEY";
    private static final String zsb = "y.layout.labeling.ABSTRACT_LABELING_ALGORITHM_NODE_SIZE_CHECKED_DPKEY";
    private ProfitModel qsb = new LabelRanking();
    private boolean nsb = false;
    private boolean atb = false;
    private boolean vsb = false;
    private boolean btb = false;
    private boolean psb = false;
    private boolean dtb = true;
    private boolean ctb = true;
    private boolean wsb = false;
    private Object xsb = null;
    protected boolean setCustomizedProfitModel = false;
    Grouping ysb;
    YList osb;
    boolean usb = false;
    private boolean rsb = false;
    private static final OrientedRectangle[] tsb = new OrientedRectangle[]{new OrientedRectangle(15.0, 5.0, 30.0, 10.0, 1.0, 0.0), new OrientedRectangle(-15.0, -15.0, 100.0, 30.0, 0.5, 0.5), new OrientedRectangle(50.0, 90.0, 40.0, 15.0, 0.0, -1.0)};
    private static final NodeLayout ssb = new DefaultNodeLayout(0.0, 0.0, 30.0, 30.0);
    protected static final double EPS = 0.001;
    public static boolean z;

    protected AbstractLabelingAlgorithm() {
    }

    public ProfitModel getProfitModel() {
        return this.qsb;
    }

    public boolean isMoveInternalNodeLabels() {
        return this.psb;
    }

    public void setMoveInternalNodeLabels(boolean bl) {
        this.psb = bl;
    }

    public boolean isApplyPostprocessing() {
        return this.btb;
    }

    public void setApplyPostprocessing(boolean bl) {
        this.btb = bl;
    }

    public boolean isUseAlternativeSideHandling() {
        return this.wsb;
    }

    public void setUseAlternativeSideHandling(boolean bl) {
        this.wsb = bl;
    }

    public void setRemoveNodeOverlaps(boolean bl) {
        this.atb = bl;
    }

    public void setRemoveEdgeOverlaps(boolean bl) {
        this.nsb = bl;
    }

    public boolean getRemoveNodeOverlaps() {
        return this.atb;
    }

    public boolean getRemoveEdgeOverlaps() {
        return this.nsb;
    }

    public void setPlaceNodeLabels(boolean bl) {
        this.dtb = bl;
    }

    public void setPlaceEdgeLabels(boolean bl) {
        this.ctb = bl;
    }

    public boolean getPlaceNodeLabels() {
        return this.dtb;
    }

    public boolean getPlaceEdgeLabels() {
        return this.ctb;
    }

    public void setSelection(Object object) {
        this.xsb = object;
    }

    public Object getSelectionKey() {
        return this.xsb;
    }

    public boolean isAutoFlippingEnabled() {
        return this.rsb;
    }

    public void setAutoFlippingEnabled(boolean bl) {
        this.rsb = bl;
    }

    public boolean canLayout(LayoutGraph layoutGraph) {
        if (layoutGraph.getDataProvider(zsb) == null) {
            try {
                this.xc(layoutGraph);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        }
        if (this.getCoreLayouter() != null) {
            return this.getCoreLayouter().canLayout(layoutGraph);
        }
        return true;
    }

    public void doLayout(LayoutGraph layoutGraph) {
        if (this.getCoreLayouter() != null) {
            this.getCoreLayouter().doLayout(layoutGraph);
        }
        this.label(layoutGraph);
    }

    private void xc(LayoutGraph layoutGraph) {
        this.d((GraphInterface)layoutGraph, layoutGraph);
    }

    private void d(GraphInterface graphInterface, GraphLayout graphLayout) {
        boolean bl = z;
        DataProvider dataProvider = graphInterface.getDataProvider(GroupingKeys.GROUP_DPKEY);
        if (dataProvider == null) {
            dataProvider = DataProviders.createConstantDataProvider(Boolean.FALSE);
        }
        Iterator iterator = graphInterface.nodeObjects();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (!dataProvider.getBool(e2)) {
                this.checkNodeSize(graphLayout, e2);
                if (!bl) continue;
            }
            this.checkGroupNodeSize(graphLayout, e2);
            if (!bl) continue;
        }
    }

    protected void checkNodeSize(GraphLayout graphLayout, Object object) throws IllegalArgumentException {
        NodeLayout nodeLayout = graphLayout.getNodeLayout(object);
        if (nodeLayout.getWidth() == 0.0 || nodeLayout.getHeight() == 0.0) {
            throw new IllegalArgumentException("Graph contains nodes with zero width/height. Please enlarge those nodes manually or by using LayoutStage y.layout.MinNodeSizeStage.");
        }
    }

    protected void checkGroupNodeSize(GraphLayout graphLayout, Object object) throws IllegalArgumentException {
        NodeLayout nodeLayout = graphLayout.getNodeLayout(object);
        if (nodeLayout.getWidth() == 0.0 || nodeLayout.getHeight() == 0.0) {
            throw new IllegalArgumentException("Graph contains group nodes with zero width/height. Please enlarge those nodes manually or by using LayoutStage y.layout.MinNodeSizeStage.");
        }
    }

    public void label(LayoutGraph layoutGraph) {
        this.label(layoutGraph, this.xsb);
    }

    public void label(LayoutGraph layoutGraph, Object object) {
        this.e(layoutGraph, layoutGraph.getDataProvider(object));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void e(LayoutGraph layoutGraph, DataProvider dataProvider) {
        if (layoutGraph.getDataProvider(zsb) == null) {
            this.xc(layoutGraph);
        }
        try {
            if (layoutGraph.getDataProvider(GroupingKeys.GROUP_DPKEY) != null) {
                this.ysb = new Grouping(layoutGraph);
            }
            e[] eArray = this.f(layoutGraph, dataProvider);
            this.d(layoutGraph, eArray);
            this.b(eArray);
            if (!AbortHandler.check(layoutGraph) && this.btb) {
                this.b(layoutGraph, dataProvider, eArray.length);
            }
            Object var5_4 = null;
            if (this.ysb != null) {
                this.ysb.dispose();
                this.ysb = null;
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (this.ysb != null) {
                this.ysb.dispose();
                this.ysb = null;
            }
            throw throwable;
        }
    }

    public void label(LayoutGraph layoutGraph, YList yList, YList yList2) {
        LabelLayout labelLayout;
        Object object;
        Object object2;
        HashMap<NodeLabelLayout, Object> hashMap;
        boolean bl;
        block3: {
            bl = z;
            hashMap = new HashMap<NodeLabelLayout, Object>();
            object2 = new Object();
            object = yList.cursor();
            while (object.ok()) {
                labelLayout = (NodeLabelLayout)object.current();
                hashMap.put((NodeLabelLayout)labelLayout, object2);
                object.next();
                if (!bl) {
                    if (!bl) continue;
                }
                break block3;
            }
            object = yList2.cursor();
        }
        while (object.ok()) {
            labelLayout = (EdgeLabelLayout)object.current();
            hashMap.put((NodeLabelLayout)labelLayout, object2);
            object.next();
            if (!bl) continue;
        }
        object = new DataProviderAdapter(){

            public boolean getBool(Object object) {
                return hashMap.get(object) != null;
            }
        };
        this.e(layoutGraph, (DataProvider)object);
    }

    void b(LayoutGraph layoutGraph, DataProvider dataProvider, int n2) {
        h h2;
        block3: {
            block4: {
                int n3;
                boolean bl;
                block2: {
                    bl = z;
                    h2 = new h();
                    n3 = layoutGraph.nodeCount() + layoutGraph.edgeCount() + n2;
                    if (n3 <= 5000) break block2;
                    h2.b(20.0);
                    if (!bl) break block3;
                }
                if (n3 <= 1000) break block4;
                h2.b(10.0);
                if (!bl) break block3;
            }
            h2.b(5.0);
        }
        h2.c(35.0);
        h2.d(5.0);
        h2.d(true);
        h2.c(true);
        h2.e(false);
        h2.b(layoutGraph, dataProvider);
    }

    private static boolean b(YRectangle yRectangle, NodeLabelLayout nodeLabelLayout) {
        return OrientedRectangle.contains(new OrientedRectangle(yRectangle), nodeLabelLayout.getOrientedBox(), 0.001) && !AbstractLabelingAlgorithm.b(nodeLabelLayout.getLabelModel());
    }

    private static boolean b(NodeLabelModel nodeLabelModel) {
        boolean bl;
        block3: {
            boolean bl2 = z;
            if (nodeLabelModel instanceof FreeNodeLabelModel) {
                return true;
            }
            for (int i2 = 0; i2 < tsb.length; ++i2) {
                Object object = nodeLabelModel.createModelParameter(tsb[i2], ssb);
                OrientedRectangle orientedRectangle = nodeLabelModel.getLabelPlacement(tsb[i2].getSize(), ssb, object);
                bl = OrientedRectangle.contains(tsb[i2], orientedRectangle, 1.0);
                if (!bl2) {
                    if (bl) continue;
                    return false;
                }
                break block3;
            }
            bl = true;
        }
        return bl;
    }

    private e[] f(LayoutGraph layoutGraph, DataProvider dataProvider) {
        int n2;
        e[] eArray;
        block9: {
            Object object;
            int n3;
            LayoutGraph layoutGraph2;
            EdgeLabelLayout[] edgeLabelLayoutArray;
            y.base.c c2;
            YCursor yCursor;
            int n4;
            DataProvider dataProvider2;
            boolean bl;
            block8: {
                bl = z;
                dataProvider2 = layoutGraph.getDataProvider(LABEL_MODEL_DPKEY);
                eArray = new e[AbstractLabelingAlgorithm.yc(layoutGraph)];
                n4 = 0;
                yCursor = layoutGraph.nodes();
                block0: while (true) {
                    boolean bl2 = yCursor.ok();
                    block1: while (bl2) {
                        c2 = yCursor.node();
                        edgeLabelLayoutArray = layoutGraph.getRectangle((Node)c2);
                        layoutGraph2 = layoutGraph;
                        if (bl) break block8;
                        NodeLabelLayout[] nodeLabelLayoutArray = layoutGraph2.getLabelLayout((Node)c2);
                        n3 = 0;
                        while (n3 < nodeLabelLayoutArray.length) {
                            eArray[n4] = new g(n4, nodeLabelLayoutArray[n3]);
                            bl2 = this.dtb;
                            if (bl) continue block1;
                            boolean bl3 = !bl2 || !this.psb && AbstractLabelingAlgorithm.b((YRectangle)edgeLabelLayoutArray, nodeLabelLayoutArray[n3]) || dataProvider != null && !dataProvider.getBool(nodeLabelLayoutArray[n3]);
                            eArray[n4].b(bl3);
                            object = dataProvider2 == null ? null : (NodeLabelModel)dataProvider2.get(nodeLabelLayoutArray[n3]);
                            YList yList = f.b(layoutGraph, c2, nodeLabelLayoutArray[n3], (NodeLabelModel)object, bl3);
                            eArray[n4].b(yList);
                            ++n3;
                            ++n4;
                            if (!bl) continue;
                        }
                        yCursor.next();
                        if (!bl) continue block0;
                    }
                    break;
                }
                layoutGraph2 = layoutGraph;
            }
            yCursor = layoutGraph2.edges();
            block3: while (true) {
                boolean bl4 = yCursor.ok();
                block4: while (bl4) {
                    c2 = yCursor.edge();
                    edgeLabelLayoutArray = layoutGraph.getLabelLayout((Edge)c2);
                    n2 = 0;
                    if (bl) break block9;
                    int n5 = n2;
                    while (n5 < edgeLabelLayoutArray.length) {
                        eArray[n4] = new d(n4, edgeLabelLayoutArray[n5]);
                        bl4 = this.ctb;
                        if (bl) continue block4;
                        n3 = !bl4 || dataProvider != null && !dataProvider.getBool(edgeLabelLayoutArray[n5]) ? 1 : 0;
                        eArray[n4].b(n3 != 0);
                        EdgeLabelModel edgeLabelModel = dataProvider2 == null ? null : (EdgeLabelModel)dataProvider2.get(edgeLabelLayoutArray[n5]);
                        object = c.b(layoutGraph, (Edge)c2, edgeLabelLayoutArray[n5], edgeLabelModel, n3 != 0, this.wsb, this.rsb);
                        eArray[n4].b((YList)object);
                        ++n5;
                        ++n4;
                        if (!bl) continue;
                    }
                    yCursor.next();
                    if (!bl) continue block3;
                }
                break;
            }
            n2 = this.atb;
        }
        if (n2 != 0) {
            this.c(layoutGraph, eArray);
        }
        if (this.nsb) {
            this.b(layoutGraph, eArray);
        }
        return eArray;
    }

    void c(LayoutGraph layoutGraph, e[] eArray) {
        Object object;
        Object object2;
        int n2;
        YList yList;
        boolean bl;
        block9: {
            bl = z;
            yList = new YList();
            NodeCursor nodeCursor = layoutGraph.nodes();
            while (nodeCursor.ok()) {
                n2 = yList.add(new _c(layoutGraph.getRectangle(nodeCursor.node()), nodeCursor.node())) ? 1 : 0;
                if (!bl) {
                    nodeCursor.next();
                    if (!bl) continue;
                }
                break block9;
            }
            n2 = 0;
        }
        int n3 = n2;
        block1: while (true) {
            int n4 = n3;
            block2: while (n4 < eArray.length) {
                YList yList2 = eArray[n3].c();
                object2 = yList2.cursor();
                while (object2.ok()) {
                    object = (LabelCandidate)object2.current();
                    double d2 = ((LabelCandidate)object).getWidth() - 0.0;
                    n4 = d2 == 0.0 ? 0 : (d2 > 0.0 ? 1 : -1);
                    if (bl) continue block2;
                    if (n4 > 0 && ((LabelCandidate)object).getHeight() > 0.0) {
                        yList.add(object);
                    }
                    object2.next();
                    if (!bl) continue;
                }
                ++n3;
                if (!bl) continue block1;
            }
            break;
        }
        DataMap dataMap = Maps.createHashedDataMap();
        IntersectionAlgorithm.intersect(yList, new _d(layoutGraph, this.ysb, dataMap));
        int n5 = 0;
        block4: while (true) {
            int n6 = n5;
            block5: while (n6 < eArray.length) {
                object2 = eArray[n5].c();
                for (object = ((YList)object2).firstCell(); object != null; object = ((ListCell)object).succ()) {
                    LabelCandidate labelCandidate = (LabelCandidate)((ListCell)object).getInfo();
                    double d3 = labelCandidate.getNodeOverlapPenalty() - 0.0;
                    n6 = d3 == 0.0 ? 0 : (d3 > 0.0 ? 1 : -1);
                    if (bl) continue block5;
                    if (n6 <= 0 || !dataMap.getBool(labelCandidate)) continue;
                    ((YList)object2).removeCell((ListCell)object);
                    if (!bl) continue;
                }
                ++n5;
                if (!bl) continue block4;
            }
            break;
        }
    }

    void b(LayoutGraph layoutGraph, e[] eArray) {
        Object object;
        Object object2;
        Object object3;
        boolean bl = z;
        YList yList = new YList();
        int n2 = 0;
        block0: while (true) {
            int n3 = n2;
            block1: while (n3 < eArray.length) {
                object3 = eArray[n2].c();
                object2 = ((YList)object3).cursor();
                while (object2.ok()) {
                    object = (LabelCandidate)object2.current();
                    double d2 = ((LabelCandidate)object).getWidth() - 0.0;
                    n3 = d2 == 0.0 ? 0 : (d2 > 0.0 ? 1 : -1);
                    if (bl) continue block1;
                    if (n3 > 0 && ((LabelCandidate)object).getHeight() > 0.0) {
                        yList.add(object);
                    }
                    object2.next();
                    if (!bl) continue;
                }
                ++n2;
                if (!bl) continue block0;
            }
            break;
        }
        Object object4 = layoutGraph.edges();
        while (object4.ok()) {
            block10: {
                object3 = LayoutTool.getEdgeClippedOnBB(layoutGraph, object4.edge());
                object2 = ((YPointPath)object3).lineSegments();
                while (object2.ok()) {
                    object = object2.lineSegment();
                    yList.add(new _e((LineSegment)object, object4.edge()));
                    object2.next();
                    if (!bl) {
                        if (!bl) continue;
                    }
                    break block10;
                }
                object4.next();
            }
            if (!bl) continue;
        }
        object4 = Maps.createHashedDataMap();
        IntersectionAlgorithm.intersect(yList, new _b(layoutGraph, this.vsb, (DataMap)object4));
        int n4 = 0;
        block5: while (true) {
            int n5 = n4;
            block6: while (n5 < eArray.length) {
                object2 = eArray[n4].c();
                for (object = ((YList)object2).firstCell(); object != null; object = ((ListCell)object).succ()) {
                    LabelCandidate labelCandidate = (LabelCandidate)((ListCell)object).getInfo();
                    double d3 = labelCandidate.getEdgeOverlapPenalty() - 0.0;
                    n5 = d3 == 0.0 ? 0 : (d3 > 0.0 ? 1 : -1);
                    if (bl) continue block6;
                    if (n5 <= 0 || !object4.getBool(labelCandidate)) continue;
                    ((YList)object2).removeCell((ListCell)object);
                    if (!bl) continue;
                }
                ++n4;
                if (!bl) continue block5;
            }
            break;
        }
    }

    private static int yc(LayoutGraph layoutGraph) {
        int n2;
        block3: {
            boolean bl = z;
            int n3 = 0;
            YCursor yCursor = layoutGraph.nodes();
            while (yCursor.ok()) {
                n3 += layoutGraph.getLabelLayout(yCursor.node()).length;
                yCursor.next();
                if (!bl) continue;
            }
            yCursor = layoutGraph.edges();
            while (yCursor.ok()) {
                n2 = n3 + layoutGraph.getLabelLayout(yCursor.edge()).length;
                if (!bl) {
                    n3 = n2;
                    yCursor.next();
                    if (!bl) continue;
                }
                break block3;
            }
            n2 = n3;
        }
        return n2;
    }

    public void setProfitModel(ProfitModel profitModel) {
        block3: {
            block2: {
                this.qsb = profitModel;
                if (profitModel != null) break block2;
                this.setCustomizedProfitModel = false;
                if (!z) break block3;
            }
            this.setCustomizedProfitModel = true;
        }
    }

    public double getProfit(LabelCandidate labelCandidate) {
        double d2;
        block5: {
            block4: {
                d2 = 0.0;
                if (this.qsb != null) {
                    return this.qsb.getProfit(labelCandidate);
                }
                Object object = labelCandidate.getParameter();
                if (!(object instanceof SliderEdgeLabelModel)) break block4;
                SliderEdgeLabelModel.ModelParameter modelParameter = (SliderEdgeLabelModel.ModelParameter)object;
                d2 = 1.0 - Math.abs((0.5 - modelParameter.getAbsRatio()) * 2.0);
                if (!z) break block5;
            }
            d2 = 1.0;
        }
        return d2;
    }

    abstract void d(LayoutGraph var1, e[] var2);

    public YList getRects() {
        return this.osb;
    }

    public void setStoreRects(boolean bl) {
        this.usb = bl;
    }

    public boolean isStoreRects() {
        return this.usb;
    }

    private void b(e[] eArray) {
        boolean bl;
        block10: {
            block9: {
                bl = z;
                if (!this.usb) {
                    return;
                }
                if (this.osb != null) break block9;
                this.osb = new YList();
                if (!bl) break block10;
            }
            this.osb.clear();
        }
        int n2 = 0;
        while (n2 < eArray.length) {
            block8: {
                YList yList = eArray[n2].c();
                YCursor yCursor = yList.cursor();
                while (yCursor.ok()) {
                    this.osb.add(yCursor.current());
                    yCursor.next();
                    if (!bl) {
                        if (!bl) continue;
                    }
                    break block8;
                }
                ++n2;
            }
            if (!bl) continue;
        }
    }

    public boolean isEdgeGroupOverlapAllowed() {
        return this.vsb;
    }

    public void setEdgeGroupOverlapAllowed(boolean bl) {
        this.vsb = bl;
    }

    static final class _c
    extends YRectangle {
        Node oe;

        public _c(YRectangle yRectangle, Node node) {
            super(yRectangle.x, yRectangle.y, yRectangle.width, yRectangle.height);
            this.oe = node;
        }
    }

    static class _e
    extends LineSegment {
        Edge ie;

        _e(LineSegment lineSegment, Edge edge) {
            super(lineSegment.getFirstEndPoint(), lineSegment.getSecondEndPoint());
            this.ie = edge;
        }

        Edge gc() {
            return this.ie;
        }
    }

    static class _b
    implements IntersectionAlgorithm.IntersectionHandler {
        private final AbortHandler g;
        private final DataMap h;
        LayoutGraph i;
        boolean j;

        _b(LayoutGraph layoutGraph, boolean bl, DataMap dataMap) {
            this.j = bl;
            this.i = layoutGraph;
            this.h = dataMap;
            this.g = AbortHandler.getFromGraph(layoutGraph);
        }

        public void checkIntersection(Object object, Object object2) {
            _e _e2;
            LabelCandidate labelCandidate;
            block14: {
                block13: {
                    this.g.check();
                    labelCandidate = null;
                    _e2 = null;
                    if (object instanceof LabelCandidate) {
                        labelCandidate = (LabelCandidate)object;
                    } else if (object instanceof _e) {
                        _e2 = (_e)object;
                    }
                    if (!(object2 instanceof LabelCandidate)) break block13;
                    labelCandidate = (LabelCandidate)object2;
                    if (!z) break block14;
                }
                if (object2 instanceof _e) {
                    _e2 = (_e)object2;
                }
            }
            if (labelCandidate == null || _e2 == null) {
                return;
            }
            if (this.j && _e2.gc() instanceof Edge) {
                Edge edge = _e2.gc();
                DataProvider dataProvider = this.i.getDataProvider(PortConstraintKeys.SOURCE_GROUPID_KEY);
                Object object3 = dataProvider.get(edge);
                if (object3 != null && object3.equals(dataProvider.get(this.i.getFeature((EdgeLabelLayout)labelCandidate.getOwner())))) {
                    return;
                }
                dataProvider = this.i.getDataProvider(PortConstraintKeys.TARGET_GROUPID_KEY);
                object3 = dataProvider.get(edge);
                if (object3 != null && object3.equals(dataProvider.get(this.i.getFeature((EdgeLabelLayout)labelCandidate.getOwner())))) {
                    return;
                }
            }
            if (labelCandidate.isInternal() && labelCandidate.getOwner() instanceof EdgeLabelLayout && this.i.getFeature((EdgeLabelLayout)labelCandidate.getOwner()) == _e2.gc()) {
                return;
            }
            if (OrientedRectangle.intersects(labelCandidate.getBox(), _e2, 0.001)) {
                this.h.setBool(labelCandidate, true);
            }
        }
    }

    static class _d
    implements IntersectionAlgorithm.IntersectionHandler {
        private final AbortHandler k;
        private final DataMap m;
        Grouping l;
        LayoutGraph n;

        public _d(LayoutGraph layoutGraph, Grouping grouping, DataMap dataMap) {
            this.l = grouping;
            this.n = layoutGraph;
            this.m = dataMap;
            this.k = AbortHandler.getFromGraph(layoutGraph);
        }

        /*
         * Unable to fully structure code
         */
        public void checkIntersection(Object var1_1, Object var2_2) {
            block21: {
                block20: {
                    block19: {
                        var11_3 = AbstractLabelingAlgorithm.z;
                        this.k.check();
                        var3_4 = null;
                        var4_5 = null;
                        if (var1_1 instanceof LabelCandidate) {
                            var3_4 = (LabelCandidate)var1_1;
                        } else if (var1_1 instanceof _c) {
                            var4_5 = ((_c)var1_1).oe;
                        }
                        if (!(var2_2 instanceof LabelCandidate)) break block19;
                        var3_4 = (LabelCandidate)var2_2;
                        if (!var11_3) break block20;
                    }
                    if (var2_2 instanceof _c) {
                        var4_5 = ((_c)var2_2).oe;
                    }
                }
                if (var3_4 == null || var4_5 == null) {
                    return;
                }
                var5_6 = new YRectangle(this.n.getX(var4_5) + 0.001, this.n.getY(var4_5) + 0.001, Math.max(0.0, this.n.getWidth(var4_5) - 0.002), Math.max(0.0, this.n.getHeight(var4_5) - 0.002));
                if (!OrientedRectangle.intersects(var3_4.getBox(), var5_6, 0.0)) {
                    return;
                }
                if (!(var3_4 instanceof NodeLabelCandidate)) ** GOTO lbl-1000
                var6_7 = (NodeLabelCandidate)var3_4;
                if (var6_7.isInternal()) {
                    return;
                }
                if (this.l != null && this.l.isGroupNode(var4_5)) {
                    var7_8 = this.n.getNodeLayout(var4_5);
                    var8_9 = var6_7.getBoundingBox();
                    var9_10 = this.n.getFeature((NodeLabelLayout)var6_7.getOwner());
                    while (var9_10 != null) {
                        if (var9_10 == var4_5 && var7_8.getX() <= var8_9.getX() && var7_8.getY() <= var8_9.getY() && var7_8.getX() + var7_8.getWidth() >= var8_9.getX() + var8_9.getWidth() && var7_8.getY() + var7_8.getHeight() >= var8_9.getY() + var8_9.getHeight()) {
                            return;
                        }
                        var9_10 = this.l.getParent((Node)var9_10);
                        if (!var11_3) continue;
                    }
                }
                break block21;
lbl-1000:
                // 2 sources

                {
                    if (!(var3_4 instanceof EdgeLabelCandidate) || this.l == null || !this.l.isGroupNode(var4_5)) break;
                    var6_7 = (EdgeLabelCandidate)var3_4;
                    var7_8 = this.n.getFeature((EdgeLabelLayout)var6_7.getOwner());
                    var8_9 = this.n.getNodeLayout(var4_5);
                    var9_10 = var6_7.getBoundingBox();
                    var10_11 = this.l.getParent(var7_8.source());
                    while (var10_11 != null) {
                        v0 = var10_11;
                        v1 = var4_5;
                        if (!var11_3) {
                            if (v0 == v1 && var8_9.getX() <= var9_10.getX() && var8_9.getY() <= var9_10.getY() && var8_9.getX() + var8_9.getWidth() >= var9_10.getX() + var9_10.getWidth() && var8_9.getY() + var8_9.getHeight() >= var9_10.getY() + var9_10.getHeight()) {
                                return;
                            }
                            var10_11 = this.l.getParent(var10_11);
                            if (!var11_3) continue;
                        }
                        ** GOTO lbl56
                    }
                    var10_11 = this.l.getParent(var7_8.target());
                    while (var10_11 != null) {
                        v0 = var10_11;
                        v1 = var4_5;
lbl56:
                        // 2 sources

                        if (v0 == v1 && var8_9.getX() <= var9_10.getX() && var8_9.getY() <= var9_10.getY() && var8_9.getX() + var8_9.getWidth() >= var9_10.getX() + var9_10.getWidth() && var8_9.getY() + var8_9.getHeight() >= var9_10.getY() + var9_10.getHeight()) {
                            return;
                        }
                        var10_11 = this.l.getParent(var10_11);
                        if (!var11_3) continue;
                    }
                    break block0;
                }
            }
            this.m.setBool(var3_4, true);
        }
    }
}

