/*
 * Decompiled with CFR 0.152.
 */
package y.layout.hierarchic.incremental;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import y.base.DataProvider;
import y.base.Edge;
import y.base.ListCell;
import y.base.Node;
import y.base.NodeCursor;
import y.base.NodeList;
import y.base.NodeMap;
import y.layout.LayoutGraph;
import y.layout.PortCandidate;
import y.layout.hierarchic.incremental.EdgeData;
import y.layout.hierarchic.incremental.HierarchicLayouter;
import y.layout.hierarchic.incremental.ItemFactory;
import y.layout.hierarchic.incremental.Layer;
import y.layout.hierarchic.incremental.Layers;
import y.layout.hierarchic.incremental.LayoutDataProvider;
import y.layout.hierarchic.incremental.NodeData;
import y.layout.hierarchic.incremental.PortConstraintOptimizer;
import y.layout.hierarchic.incremental.q;
import y.util.Comparators;
import y.util.Maps;

public abstract class AbstractPortConstraintOptimizer
implements PortConstraintOptimizer {
    private byte c = 0;
    private int b = 4;

    protected AbstractPortConstraintOptimizer() {
    }

    public int getMirrorMask() {
        return this.b;
    }

    public void setMirrorMask(int n2) {
        this.b = n2;
    }

    public void setLayoutOrientation(byte by) {
        this.c = by;
    }

    public byte getLayoutOrientation() {
        return this.c;
    }

    public abstract void optimizeAfterLayering(LayoutGraph var1, Layers var2, LayoutDataProvider var3, ItemFactory var4);

    public void optimizeAfterSequencing(LayoutGraph layoutGraph, Layers layers, LayoutDataProvider layoutDataProvider, ItemFactory itemFactory) {
        SameLayerData sameLayerData = this.insertSameLayerStructures(layoutGraph, layers, layoutDataProvider, itemFactory);
        Comparator[] comparatorArray = this.b(sameLayerData, layoutGraph, layers, layoutDataProvider);
        this.optimizeAfterSequencing(comparatorArray[0], comparatorArray[1], layoutGraph, layers, layoutDataProvider, itemFactory);
        this.removeSameLayerStructures(sameLayerData, layoutGraph, layoutDataProvider, itemFactory);
    }

    protected void optimizeAfterSequencing(Comparator comparator, Comparator comparator2, LayoutGraph layoutGraph, Layers layers, LayoutDataProvider layoutDataProvider, ItemFactory itemFactory) {
        int n2 = HierarchicLayouter.z;
        int n3 = 0;
        block0: while (true) {
            int n4 = n3;
            block1: while (n4 < layers.size()) {
                Layer layer = layers.getLayer(n3);
                for (ListCell listCell = layer.getList().firstCell(); listCell != null; listCell = listCell.succ()) {
                    Node node = (Node)listCell.getInfo();
                    n4 = layoutDataProvider.getNodeData(node).getType();
                    if (n2 != 0) continue block1;
                    if (n4 != 0) continue;
                    this.optimizeAfterSequencing(node, comparator, comparator2, layoutGraph, layoutDataProvider, itemFactory);
                    if (n2 == 0) continue;
                }
                ++n3;
                if (n2 == 0) continue block0;
            }
            break;
        }
    }

    protected abstract void optimizeAfterSequencing(Node var1, Comparator var2, Comparator var3, LayoutGraph var4, LayoutDataProvider var5, ItemFactory var6);

    protected SameLayerData insertSameLayerStructures(LayoutGraph layoutGraph, Layers layers, LayoutDataProvider layoutDataProvider, ItemFactory itemFactory) {
        int n2 = HierarchicLayouter.z;
        SameLayerData sameLayerData = new SameLayerData();
        int n3 = 0;
        block0: while (true) {
            int n4 = n3;
            block1: while (n4 < layers.size()) {
                Layer layer = layers.getLayer(n3);
                for (ListCell listCell = layer.getList().firstCell(); listCell != null; listCell = listCell.succ()) {
                    Node node = (Node)listCell.getInfo();
                    NodeData nodeData = layoutDataProvider.getNodeData(node);
                    n4 = nodeData.sameLayerEdgeCount();
                    if (n2 != 0) continue block1;
                    if (n4 <= 0) continue;
                    for (ListCell listCell2 = nodeData.getFirstSameLayerEdgeCell(); listCell2 != null; listCell2 = listCell2.succ()) {
                        Edge edge = (Edge)listCell2.getInfo();
                        n4 = edge.source().equals(node) ? 1 : 0;
                        if (n2 != 0) continue block1;
                        if (n4 == 0) continue;
                        Node node2 = layoutGraph.createNode();
                        sameLayerData.addDummyNode(node2, edge);
                        if (layoutDataProvider.getEdgeData(edge).isUpperSameLayerEdge()) {
                            itemFactory.createReverseDummyEdge(node2, node, edge, false, true);
                            itemFactory.createDummyEdge(node2, edge.target(), edge, false, true);
                            if (n2 == 0) continue;
                        }
                        itemFactory.createDummyEdge(node, node2, edge, true, false);
                        itemFactory.createReverseDummyEdge(edge.target(), node2, edge, true, false);
                        if (n2 == 0) continue;
                    }
                    if (n2 == 0) continue;
                }
                ++n3;
                if (n2 == 0) continue block0;
            }
            break;
        }
        return sameLayerData;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    protected void removeSameLayerStructures(SameLayerData sameLayerData, LayoutGraph layoutGraph, LayoutDataProvider layoutDataProvider, ItemFactory itemFactory) {
        int n2;
        int n3 = HierarchicLayouter.z;
        NodeCursor nodeCursor = sameLayerData.getDummyNodes().nodes();
        while (nodeCursor.ok()) {
            Edge edge;
            block17: {
                EdgeData edgeData;
                EdgeData edgeData2;
                Edge edge2;
                Edge edge3;
                EdgeData edgeData3;
                block18: {
                    Node node;
                    block15: {
                        block16: {
                            node = nodeCursor.node();
                            edge = sameLayerData.getOriginalEdge(node);
                            layoutGraph.unhide(edge);
                            edgeData3 = layoutDataProvider.getEdgeData(edge);
                            n2 = node.outDegree();
                            if (n3 != 0) {
                                return;
                            }
                            if (n2 <= 0) break block15;
                            edge3 = node.firstOutEdge();
                            edge2 = node.lastOutEdge();
                            edgeData2 = layoutDataProvider.getEdgeData(edge3);
                            edgeData = layoutDataProvider.getEdgeData(edge2);
                            if (edge3.target() != edge.source()) break block16;
                            if (edgeData2.getTPC() != edgeData3.getSPC()) {
                                itemFactory.setTemporaryPortConstraint(edge, true, edgeData2.getTPC());
                            }
                            if (edgeData.getTPC() != edgeData3.getTPC()) {
                                itemFactory.setTemporaryPortConstraint(edge, false, edgeData.getTPC());
                            }
                            layoutGraph.setSourcePointRel(edge, layoutGraph.getTargetPointRel(edge3));
                            layoutGraph.setTargetPointRel(edge, layoutGraph.getTargetPointRel(edge2));
                            if (n3 == 0) break block17;
                        }
                        if (edgeData.getTPC() != edgeData3.getSPC()) {
                            itemFactory.setTemporaryPortConstraint(edge, true, edgeData.getTPC());
                        }
                        if (edgeData2.getTPC() != edgeData3.getTPC()) {
                            itemFactory.setTemporaryPortConstraint(edge, false, edgeData2.getTPC());
                        }
                        layoutGraph.setSourcePointRel(edge, layoutGraph.getTargetPointRel(edge2));
                        layoutGraph.setTargetPointRel(edge, layoutGraph.getTargetPointRel(edge3));
                        if (n3 == 0) break block17;
                    }
                    edge3 = node.firstInEdge();
                    edge2 = node.lastInEdge();
                    edgeData2 = layoutDataProvider.getEdgeData(edge3);
                    edgeData = layoutDataProvider.getEdgeData(edge2);
                    if (edge3.source() != edge.source()) break block18;
                    if (edgeData2.getSPC() != edgeData3.getSPC()) {
                        itemFactory.setTemporaryPortConstraint(edge, true, edgeData2.getSPC());
                    }
                    if (edgeData.getSPC() != edgeData3.getTPC()) {
                        itemFactory.setTemporaryPortConstraint(edge, false, edgeData.getSPC());
                    }
                    layoutGraph.setSourcePointRel(edge, layoutGraph.getSourcePointRel(edge3));
                    layoutGraph.setTargetPointRel(edge, layoutGraph.getSourcePointRel(edge2));
                    if (n3 == 0) break block17;
                }
                if (edgeData.getSPC() != edgeData3.getSPC()) {
                    itemFactory.setTemporaryPortConstraint(edge, true, edgeData.getSPC());
                }
                if (edgeData2.getSPC() != edgeData3.getTPC()) {
                    itemFactory.setTemporaryPortConstraint(edge, false, edgeData2.getSPC());
                }
                layoutGraph.setSourcePointRel(edge, layoutGraph.getSourcePointRel(edge2));
                layoutGraph.setTargetPointRel(edge, layoutGraph.getSourcePointRel(edge3));
            }
            layoutGraph.hide(edge);
            nodeCursor.next();
            if (n3 == 0) continue;
        }
        nodeCursor = sameLayerData.getDummyNodes().nodes();
        do {
            n2 = nodeCursor.ok();
            if (n2 == 0) return;
            layoutGraph.removeNode(nodeCursor.node());
            nodeCursor.next();
        } while (n3 == 0);
    }

    private Comparator[] b(SameLayerData sameLayerData, LayoutGraph layoutGraph, Layers layers, LayoutDataProvider layoutDataProvider) {
        Comparator comparator;
        int n2 = HierarchicLayouter.z;
        int[] nArray = new int[layoutGraph.N()];
        q q2 = q.b(layoutGraph, layers, layoutDataProvider, nArray, new int[layoutGraph.N()], new byte[layoutGraph.E()], new int[layoutGraph.E()], new byte[layoutGraph.E()], new int[layoutGraph.E()], (byte)1, (byte)0);
        Object object = sameLayerData.getDummyNodes().nodes();
        while (object.ok()) {
            int n3 = object.node().index();
            nArray[n3] = -1;
            object.next();
            if (n2 == 0) continue;
        }
        if ((object = q2.b(true)) instanceof q._c) {
            q._c _c2 = (q._c)object;
            _c2.b(new _b(layoutGraph.getDataProvider(PortCandidate.TARGET_PCLIST_DPKEY), _c2.c(), this.c, this.b));
        }
        if ((comparator = q2.b(false)) instanceof q._n) {
            q._n _n2 = (q._n)comparator;
            _n2.d(new _b(layoutGraph.getDataProvider(PortCandidate.SOURCE_PCLIST_DPKEY), _n2.e(), this.c, this.b));
        }
        return new Comparator[]{comparator, object};
    }

    static class _b
    implements Comparator,
    Comparators.PartialOrder {
        private final DataProvider ec;
        private final Comparator dc;
        private final byte cc;
        private final int bc;

        _b(DataProvider dataProvider, Comparator comparator, byte by, int n2) {
            this.ec = dataProvider;
            this.dc = comparator;
            this.bc = n2;
            this.cc = by;
        }

        public int compare(Object object, Object object2) {
            double d2;
            double d3;
            block10: {
                Collection collection;
                int n2;
                block9: {
                    n2 = HierarchicLayouter.z;
                    if (this.dc != null && this.dc.compare(object, object2) != 0) {
                        return this.dc.compare(object, object2);
                    }
                    if (this.ec == null) {
                        return 0;
                    }
                    Collection collection2 = (Collection)this.ec.get(object);
                    collection = (Collection)this.ec.get(object2);
                    if (collection2 == null && collection == null) {
                        return 0;
                    }
                    if (collection2 == null) {
                        return -1;
                    }
                    if (collection == null) {
                        return 1;
                    }
                    d3 = 0.0;
                    Iterator iterator = collection2.iterator();
                    while (iterator.hasNext()) {
                        PortCandidate portCandidate = (PortCandidate)iterator.next();
                        d3 += portCandidate.getXOffsetForLayoutOrientation(this.cc, this.bc);
                        if (n2 == 0) {
                            if (n2 == 0) continue;
                        }
                        break block9;
                    }
                    d3 /= (double)collection2.size();
                }
                d2 = 0.0;
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    PortCandidate portCandidate = (PortCandidate)iterator.next();
                    d2 += portCandidate.getXOffsetForLayoutOrientation(this.cc, this.bc);
                    if (n2 == 0) {
                        if (n2 == 0) continue;
                    }
                    break block10;
                }
                d2 /= (double)collection.size();
            }
            return (int)(100.0 * (d3 - d2));
        }
    }

    public static class SameLayerData {
        private final NodeList b = new NodeList();
        private final NodeMap c = Maps.createHashedNodeMap();

        public void addDummyNode(Node node, Edge edge) {
            this.b.add(node);
            this.c.set(node, edge);
        }

        public NodeList getDummyNodes() {
            return this.b;
        }

        public Edge getOriginalEdge(Node node) {
            return (Edge)this.c.get(node);
        }
    }
}

