/*
 * Decompiled with CFR 0.152.
 */
package y.layout.hierarchic;

import y.base.DataProvider;
import y.base.Node;
import y.base.NodeCursor;
import y.base.NodeList;
import y.base.NodeMap;
import y.layout.LayoutGraph;
import y.layout.NodeLayout;
import y.layout.hierarchic.AbstractDrawer;
import y.layout.hierarchic.Drawer;
import y.util.DataProviderAdapter;

public class AlignmentDrawer
implements Drawer {
    public static final Object NODE_ALIGNMENT_POINT_DPKEY = "y.layout.hierarchic.AlignmentDrawer.NODE_ALIGNMENT_POINT_DPKEY";
    private Drawer ce;

    public AlignmentDrawer(Drawer drawer) {
        if (drawer == null) {
            throw new NullPointerException();
        }
        this.ce = drawer;
    }

    protected void alignNodes(LayoutGraph layoutGraph, NodeList[] nodeListArray) {
        boolean bl = AbstractDrawer.z;
        double d2 = 0.0;
        int n2 = 0;
        block0: while (n2 < nodeListArray.length) {
            block4: {
                double d3;
                NodeCursor nodeCursor = nodeListArray[n2].nodes();
                double d4 = 0.0;
                double d5 = 0.0;
                double d6 = Double.MAX_VALUE;
                double d7 = -1.7976931348623157E308;
                nodeCursor.toFirst();
                while (nodeCursor.ok()) {
                    Node node = nodeCursor.node();
                    NodeLayout nodeLayout = layoutGraph.getNodeLayout(node);
                    d6 = Math.min(d6, nodeLayout.getY());
                    d7 = Math.max(d7, nodeLayout.getY() + nodeLayout.getHeight());
                    d3 = AlignmentDrawer.c(node);
                    d4 = Math.max(d4, nodeLayout.getHeight() * 0.5 + d3);
                    d5 = Math.max(d5, nodeLayout.getHeight() * 0.5 - d3);
                    nodeCursor.next();
                    if (bl) continue block0;
                    if (!bl) continue;
                }
                double d8 = d4 + d5;
                d3 = d6 + d2 + d4;
                nodeCursor.toFirst();
                while (nodeCursor.ok()) {
                    Node node = nodeCursor.node();
                    double d9 = AlignmentDrawer.c(node);
                    layoutGraph.setCenter(node, layoutGraph.getCenterX(node), d3 - d9);
                    nodeCursor.next();
                    if (!bl) {
                        if (!bl) continue;
                    }
                    break block4;
                }
                d2 += d8 - (d7 - d6);
                ++n2;
            }
            if (!bl) continue;
        }
    }

    private static final double c(Node node) {
        DataProvider dataProvider = node.getGraph().getDataProvider(NODE_ALIGNMENT_POINT_DPKEY);
        if (dataProvider == null) {
            return 0.0;
        }
        return dataProvider.getDouble(node);
    }

    public void assignCoordinates(LayoutGraph layoutGraph, NodeList[] nodeListArray, DataProvider dataProvider) {
        this.ce.assignCoordinates(layoutGraph, nodeListArray, dataProvider);
        this.alignNodes(layoutGraph, nodeListArray);
    }

    public void setDummyMap(NodeMap nodeMap) {
        this.ce.setDummyMap(nodeMap);
    }

    public void setMinimalEdgeDistance(double d2) {
        this.ce.setMinimalEdgeDistance(d2);
    }

    public void setMinimalLayerDistance(double d2) {
        this.ce.setMinimalLayerDistance(d2);
    }

    public void setMinimalMultiEdgeDistance(double d2) {
        this.ce.setMinimalMultiEdgeDistance(d2);
    }

    public void setMinimalNodeDistance(double d2) {
        this.ce.setMinimalNodeDistance(d2);
    }

    public static final class BottomAlignmentDataProvider
    extends DataProviderAdapter {
        public double getDouble(Object object) {
            Node node = (Node)object;
            LayoutGraph layoutGraph = (LayoutGraph)node.getGraph();
            double d2 = layoutGraph.getHeight(node);
            return 0.5 * d2;
        }
    }

    public static final class RightAlignmentDataProvider
    extends DataProviderAdapter {
        public double getDouble(Object object) {
            Node node = (Node)object;
            LayoutGraph layoutGraph = (LayoutGraph)node.getGraph();
            double d2 = layoutGraph.getWidth(node);
            return -0.5 * d2;
        }
    }

    public static final class LeftAlignmentDataProvider
    extends DataProviderAdapter {
        public double getDouble(Object object) {
            Node node = (Node)object;
            LayoutGraph layoutGraph = (LayoutGraph)node.getGraph();
            double d2 = layoutGraph.getWidth(node);
            return -0.5 * d2;
        }
    }

    public static final class TopAlignmentDataProvider
    extends DataProviderAdapter {
        public double getDouble(Object object) {
            Node node = (Node)object;
            LayoutGraph layoutGraph = (LayoutGraph)node.getGraph();
            double d2 = layoutGraph.getHeight(node);
            return -0.5 * d2;
        }
    }
}

