/*
 * Decompiled with CFR 0.152.
 */
package y.layout.grouping;

import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import y.base.Node;
import y.base.NodeList;
import y.geom.YDimension;
import y.layout.LayoutGraph;
import y.layout.grouping.Grouping;
import y.layout.grouping.GroupingKeys;
import y.layout.grouping.InsetsGroupBoundsCalculator;

public class MinimumSizeGroupBoundsCalculator
extends InsetsGroupBoundsCalculator {
    private Object n;
    private double p;
    private double o;
    private double q = 0.5;
    private double r = 0.5;

    public MinimumSizeGroupBoundsCalculator() {
        this(GroupingKeys.MINIMUM_NODE_SIZE_DPKEY);
    }

    public MinimumSizeGroupBoundsCalculator(Object object) {
        this.n = object;
    }

    public Rectangle2D calculateBounds(LayoutGraph layoutGraph, Node node, NodeList nodeList) {
        double d2;
        double d3;
        YDimension yDimension;
        Object object;
        double d4 = this.p;
        double d5 = this.o;
        if (this.n != null && (object = layoutGraph.getDataProvider(this.n)) != null && (yDimension = (YDimension)object.get(node)) != null) {
            d4 = yDimension.width;
            d5 = yDimension.height;
        }
        object = super.calculateBounds(layoutGraph, node, nodeList);
        double d6 = ((RectangularShape)object).getX();
        double d7 = ((RectangularShape)object).getY();
        double d8 = ((RectangularShape)object).getWidth();
        double d9 = ((RectangularShape)object).getHeight();
        if (d8 < d4) {
            d3 = d4 - d8;
            d2 = this.q * d3;
            d6 -= d2;
            d8 = d4;
        }
        if (d9 < d5) {
            d3 = d5 - d9;
            d2 = this.r * d3;
            d7 -= d2;
            d9 = d5;
        }
        ((Rectangle2D)object).setFrame(d6, d7, d8, d9);
        return object;
    }

    public double getXAlignment() {
        return this.q;
    }

    public void setXAlignment(double d2) {
        block3: {
            block2: {
                if (!(d2 >= 0.0) || !(d2 <= 1.0)) break block2;
                this.q = d2;
                if (!Grouping.z) break block3;
            }
            throw new IllegalArgumentException("xAlignment must be between 0 and 1. Given alignment is: " + d2);
        }
    }

    public double getYAlignment() {
        return this.r;
    }

    public void setYAlignment(double d2) {
        block3: {
            block2: {
                if (!(d2 >= 0.0) || !(d2 <= 1.0)) break block2;
                this.r = d2;
                if (!Grouping.z) break block3;
            }
            throw new IllegalArgumentException("yAlignment must be between 0 and 1. Given alignment is: " + d2);
        }
    }

    public Object getMinimumNodeSizeDPKey() {
        return this.n;
    }

    public void setMinimumNodeSizeDPKey(Object object) {
        this.n = object;
    }

    public void setDefaultMinimumNodeSize(YDimension yDimension) {
        this.p = yDimension.width;
        this.o = yDimension.height;
    }

    public YDimension getDefaultMinimumNodeSize() {
        return new YDimension(this.p, this.o);
    }
}

