/*
 * Decompiled with CFR 0.152.
 */
package y.layout.grouping;

import java.awt.Insets;
import java.awt.geom.Rectangle2D;
import y.base.Node;
import y.base.NodeCursor;
import y.base.NodeList;
import y.geom.YInsets;
import y.layout.LayoutGraph;
import y.layout.LayoutTool;
import y.layout.grouping.GroupBoundsCalculator;
import y.layout.grouping.Grouping;
import y.layout.grouping.GroupingKeys;

public class InsetsGroupBoundsCalculator
implements GroupBoundsCalculator {
    private Object j;
    private int h;
    private int f;
    private int m;
    private int i;
    private boolean l;
    private boolean k;
    private boolean g = true;

    public InsetsGroupBoundsCalculator() {
        this(GroupingKeys.GROUP_NODE_INSETS_DPKEY);
    }

    public InsetsGroupBoundsCalculator(Insets insets) {
        this(GroupingKeys.GROUP_NODE_INSETS_DPKEY, insets);
    }

    public InsetsGroupBoundsCalculator(Object object) {
        this.j = object;
        this.i = 15;
        this.m = 15;
        this.f = 15;
        this.h = 15;
    }

    public InsetsGroupBoundsCalculator(Object object, Insets insets) {
        this.j = object;
        this.h = insets.top;
        this.f = insets.bottom;
        this.m = insets.left;
        this.i = insets.right;
    }

    public boolean isConsiderNodeLabelsEnabled() {
        return this.l;
    }

    public void setConsiderNodeLabelsEnabled(boolean bl) {
        this.l = bl;
    }

    public boolean isConsiderEdgeLabelsEnabled() {
        return this.k;
    }

    public void setConsiderEdgeLabelsEnabled(boolean bl) {
        this.k = bl;
    }

    public boolean isConsiderNodeHalosEnabled() {
        return this.g;
    }

    public void setConsiderNodeHalosEnabled(boolean bl) {
        this.g = bl;
    }

    public Rectangle2D calculateBounds(LayoutGraph layoutGraph, Node node, NodeList nodeList) {
        Rectangle2D rectangle2D = LayoutTool.getBoundingBox(layoutGraph, layoutGraph.nodes(), layoutGraph.edges(), this.isConsiderNodeLabelsEnabled(), this.isConsiderEdgeLabelsEnabled(), this.isConsiderNodeHalosEnabled());
        return this.createEnlargedBounds(layoutGraph, node, nodeList, rectangle2D);
    }

    protected Rectangle2D createEnlargedBounds(LayoutGraph layoutGraph, Node node, NodeList nodeList, Rectangle2D rectangle2D) {
        YInsets yInsets;
        Object object;
        double d2 = this.h;
        double d3 = this.f;
        double d4 = this.i;
        double d5 = this.m;
        if (this.j != null && (object = layoutGraph.getDataProvider(this.j)) != null && (yInsets = YInsets.asYInsets(object.get(node))) != null) {
            d2 = yInsets.top;
            d3 = yInsets.bottom;
            d5 = yInsets.left;
            d4 = yInsets.right;
        }
        object = new Rectangle2D.Double();
        ((Rectangle2D)object).setFrame(rectangle2D.getX() - d5, rectangle2D.getY() - d2, rectangle2D.getWidth() + d5 + d4, rectangle2D.getHeight() + d2 + d3);
        return object;
    }

    protected Rectangle2D getNodeBounds(LayoutGraph layoutGraph, NodeList nodeList) {
        Rectangle2D.Double double_;
        block3: {
            boolean bl = Grouping.z;
            if (nodeList.isEmpty()) {
                return new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
            }
            NodeCursor nodeCursor = nodeList.nodes();
            Node node = nodeList.firstNode();
            Rectangle2D.Double double_2 = new Rectangle2D.Double(layoutGraph.getX(node), layoutGraph.getY(node), layoutGraph.getWidth(node), layoutGraph.getHeight(node));
            Rectangle2D.Double double_3 = new Rectangle2D.Double(double_2.x, double_2.y, double_2.width, double_2.height);
            nodeCursor.next();
            while (nodeCursor.ok()) {
                node = nodeCursor.node();
                double_2.x = layoutGraph.getX(node);
                double_2.y = layoutGraph.getY(node);
                double_2.width = layoutGraph.getWidth(node);
                double_2.height = layoutGraph.getHeight(node);
                double_ = double_3;
                if (!bl) {
                    double_.add(double_2);
                    nodeCursor.next();
                    if (!bl) continue;
                }
                break block3;
            }
            double_ = double_3;
        }
        return double_;
    }

    public void setDefaultInsets(Insets insets) {
        this.h = insets.top;
        this.m = insets.left;
        this.f = insets.bottom;
        this.i = insets.right;
    }

    public Insets getDefaultInsets() {
        return new Insets(this.h, this.m, this.f, this.i);
    }

    public void setGroupNodeInsetsDPKey(Object object) {
        this.j = object;
    }

    public Object getGroupNodeInsetsDPKey() {
        return this.j;
    }
}

