/*
 * Decompiled with CFR 0.152.
 */
package y.layout;

import y.base.YList;
import y.geom.LineSegment;
import y.geom.OrientedRectangle;
import y.geom.YDimension;
import y.geom.YPoint;
import y.geom.YPointCursor;
import y.geom.YPointPath;
import y.geom.YRectangle;
import y.geom.YVector;
import y.layout.EdgeLabelCandidate;
import y.layout.EdgeLabelLayout;
import y.layout.EdgeLabelLayoutImpl;
import y.layout.EdgeLabelModel;
import y.layout.EdgeLayout;
import y.layout.LabelCandidate;
import y.layout.LayoutGraph;
import y.layout.LayoutTool;
import y.layout.NodeLayout;
import y.layout.d;

public class SliderEdgeLabelModel
implements EdgeLabelModel {
    public static final byte CENTER_SLIDER = 0;
    public static final byte SIDE_SLIDER = 1;
    public static final byte CENTER_RATIO = 0;
    public static final byte TAIL_RATIO = 1;
    public static final byte HEAD_RATIO = 2;
    public static final byte LEFT_RATIO = 3;
    public static final byte RIGHT_RATIO = 4;
    private static final double x = 1.0E-6;
    private double y = 1.0;
    private double s = 1.0;
    private double w = 1.0;
    private double u = 9.125;
    private byte t;
    private static final ModelParameter r = new ModelParameter(0, 0.0, new YVector(0.0, 0.0), 2, 0.0);
    private static final ModelParameter v = new ModelParameter(0, 0.0, new YVector(0.0, 0.0), 0, 0.0);

    public SliderEdgeLabelModel(byte by) {
        this.t = by;
    }

    public byte getMode() {
        return this.t;
    }

    public void setDistances(double d2, double d3) {
        this.y = d2;
        this.s = d3;
    }

    public double getMaximumDistance() {
        return this.s;
    }

    public void setMaximumDistance(double d2) {
        this.s = d2;
    }

    public double getMinimumDistance() {
        return this.y;
    }

    public void setMinimumDistance(double d2) {
        this.y = d2;
    }

    public double getDensity() {
        return this.w;
    }

    public void setDensity(double d2) {
        this.w = d2;
    }

    public double getNodeBorderDistance() {
        return this.u;
    }

    public void setNodeBorderDistance(double d2) {
        this.u = d2;
    }

    public Object getDefaultParameter() {
        if (this.t == 1) {
            return r;
        }
        return v;
    }

    public OrientedRectangle getLabelPlacement(YDimension yDimension, EdgeLayout edgeLayout, NodeLayout nodeLayout, NodeLayout nodeLayout2, Object object) {
        YPoint yPoint;
        YPoint yPoint2;
        YRectangle yRectangle;
        OrientedRectangle orientedRectangle;
        YVector yVector;
        double d2;
        byte by;
        block4: {
            double d3;
            double d4;
            block5: {
                ModelParameter modelParameter = object != null ? (ModelParameter)object : (ModelParameter)this.getDefaultParameter();
                int n2 = modelParameter.getSegmentNumber();
                by = modelParameter.getLabelPosition();
                d2 = modelParameter.getRatio();
                yVector = modelParameter.getOffsetVector();
                YPointPath yPointPath = LayoutTool.getEdgeClippedOnBB(edgeLayout, nodeLayout, nodeLayout2, this.u);
                int n3 = n2 < 0 ? yPointPath.length() - 1 + n2 : n2;
                LineSegment lineSegment = yPointPath.getLineSegment(n3);
                orientedRectangle = new OrientedRectangle(new YPoint(0.0, 0.0), yDimension);
                yRectangle = orientedRectangle.getBoundingBox();
                if (lineSegment == null) {
                    orientedRectangle.setCenter(nodeLayout.getX() + yRectangle.width * 0.5, nodeLayout.getY() + yRectangle.height * 0.5);
                    return orientedRectangle;
                }
                yPoint2 = lineSegment.getFirstEndPoint();
                yPoint = lineSegment.getSecondEndPoint();
                if (lineSegment.length() != 0.0) break block4;
                d4 = nodeLayout.getX() + nodeLayout.getWidth() * 0.5 + edgeLayout.getSourcePoint().x - (nodeLayout2.getX() + nodeLayout2.getWidth() * 0.5 + edgeLayout.getTargetPoint().x);
                d3 = nodeLayout.getY() + nodeLayout.getHeight() * 0.5 + edgeLayout.getSourcePoint().y - (nodeLayout2.getY() + nodeLayout2.getHeight() * 0.5 + edgeLayout.getTargetPoint().y);
                if (d4 != 0.0 || d3 != 0.0) break block5;
                yPoint = new YPoint(yPoint2.x + 1.0E-6, yPoint2.y);
                if (!LayoutGraph.z) break block4;
            }
            double d5 = Math.sqrt(d4 * d4 + d3 * d3);
            yPoint = new YPoint(yPoint2.x + 1.0E-6 * d4 / d5, yPoint2.y + 1.0E-6 * d3 / d5);
        }
        YPoint yPoint3 = this.b(d2, yPoint2, yPoint, yRectangle, by);
        YPoint yPoint4 = YVector.add(yPoint3, yVector);
        yPoint4 = YPoint.add(yPoint4, yPoint2);
        orientedRectangle.setCenter(yPoint4.getX() + yRectangle.width * 0.5, yPoint4.getY() + yRectangle.height * 0.5);
        return orientedRectangle;
    }

    public YList getLabelCandidates(EdgeLabelLayout edgeLabelLayout, EdgeLayout edgeLayout, NodeLayout nodeLayout, NodeLayout nodeLayout2) {
        boolean bl = LayoutGraph.z;
        byte[] byArray = SliderEdgeLabelModel.b(this.t);
        OrientedRectangle orientedRectangle = d.b(edgeLabelLayout.getOrientedBox());
        double d2 = orientedRectangle.getWidth();
        double d3 = orientedRectangle.getHeight();
        YDimension yDimension = new YDimension(d2, d3);
        YList yList = new YList();
        YPointPath yPointPath = LayoutTool.getEdgeClippedOnBB(edgeLayout, nodeLayout, nodeLayout2, this.u);
        YPointCursor yPointCursor = yPointPath.points();
        if (!yPointCursor.ok()) {
            orientedRectangle.setCenter(nodeLayout.getX() + d2 * 0.5, nodeLayout.getY() + d3 * 0.5);
            EdgeLabelCandidate edgeLabelCandidate = new EdgeLabelCandidate(orientedRectangle, this.getDefaultParameter(), edgeLabelLayout, this.t == 0);
            yList.add(edgeLabelCandidate);
            return yList;
        }
        double[] dArray = new double[yPointPath.length() - 1];
        double[] dArray2 = new double[yPointPath.length() - 1];
        double d4 = this.b(yPointPath, dArray, dArray2);
        YPoint yPoint = yPointCursor.point();
        yPointCursor.next();
        int n2 = 0;
        block0: while (true) {
            byte by = yPointCursor.ok();
            block1: while (by != 0) {
                YPoint yPoint2 = yPoint;
                yPoint = yPointCursor.point();
                double d5 = yPoint.getX() - yPoint2.getX();
                double d6 = yPoint.getY() - yPoint2.getY();
                double[] dArray3 = this.b(d5, d6, d2, d3);
                int n3 = 0;
                block2: while (true) {
                    int n4 = n3;
                    int n5 = byArray.length;
                    block3: while (n4 < n5) {
                        boolean bl2 = false;
                        by = byArray[n3];
                        if (bl) continue block1;
                        if (by == 0) {
                            bl2 = true;
                        }
                        YVector yVector = this.getOffsetVec(d5, d6, d2, d3, byArray[n3]);
                        YVector yVector2 = YVector.getNormal(yVector);
                        yVector2.scale(this.y);
                        int n6 = 0;
                        block4: while (true) {
                            ++n6;
                            for (int i2 = 0; i2 < dArray3.length; ++i2) {
                                double d7 = dArray3[i2];
                                YPoint yPoint3 = this.b(d7, yPoint2, yPoint, yDimension, byArray[n3]);
                                YPoint yPoint4 = YVector.add(yPoint3, yVector2);
                                yPoint4 = YPoint.add(yPoint4, yPoint2);
                                double d8 = dArray2[n2] / d4 + d7 * dArray[n2];
                                n4 = n2;
                                n5 = (yPointPath.length() - 2) / 2;
                                if (bl) continue block3;
                                int n7 = n4 > n5 ? n2 + 1 - yPointPath.length() : n2;
                                ModelParameter modelParameter = new ModelParameter(n7, d7, yVector2, byArray[n3], d8);
                                OrientedRectangle orientedRectangle2 = new OrientedRectangle(orientedRectangle);
                                orientedRectangle2.setCenter(yPoint4.getX() + d2 * 0.5, yPoint4.getY() + d3 * 0.5);
                                EdgeLabelCandidate edgeLabelCandidate = new EdgeLabelCandidate(orientedRectangle2, (Object)modelParameter, edgeLabelLayout, bl2);
                                yList.add(edgeLabelCandidate);
                                if (!bl) continue;
                            }
                            yVector2.add(yVector);
                            do {
                                if (YVector.add(yVector2, yVector).length() < this.s && this.t != 0 && n6 < 5) continue block4;
                                ++n3;
                            } while (bl);
                            break;
                        }
                        if (!bl) continue block2;
                    }
                    break;
                }
                yPointCursor.next();
                ++n2;
                if (!bl) continue block0;
            }
            break;
        }
        return yList;
    }

    public Object createModelParameter(OrientedRectangle orientedRectangle, EdgeLayout edgeLayout, NodeLayout nodeLayout, NodeLayout nodeLayout2) {
        if (LayoutTool.b(orientedRectangle)) {
            throw new IllegalArgumentException("Invalid label bounds: " + orientedRectangle);
        }
        EdgeLabelLayoutImpl edgeLabelLayoutImpl = new EdgeLabelLayoutImpl();
        edgeLabelLayoutImpl.setOrientedBox(orientedRectangle);
        YList yList = this.getLabelCandidates(edgeLabelLayoutImpl, edgeLayout, nodeLayout, nodeLayout2);
        if (yList.isEmpty()) {
            return this.getDefaultParameter();
        }
        LabelCandidate labelCandidate = d.b(yList, orientedRectangle.getCenter());
        return labelCandidate != null ? labelCandidate.getModelParameter() : this.getDefaultParameter();
    }

    public YVector getOffsetVec(double d2, double d3, double d4, double d5, byte by) {
        if (by == 0) {
            return new YVector(0.0, 0.0);
        }
        double d6 = Math.abs(d2);
        double d7 = Math.abs(d3);
        double d8 = d3 / d2;
        if (Double.isNaN(d8)) {
            d8 = 1.0;
        }
        d4 = Math.max(0.01, d4);
        d5 = Math.max(0.01, d5);
        double d9 = d5 / d4;
        double d10 = d4 * 0.5;
        double d11 = d5 * 0.5;
        if (d7 < d6 * d9) {
            double d12 = d11 + Math.abs(d10 * d8);
            if (SliderEdgeLabelModel.b(by, d2, d3)) {
                return new YVector(0.0, -d12);
            }
            return new YVector(0.0, d12);
        }
        double d13 = d10 + Math.abs(d11 / d8);
        if (SliderEdgeLabelModel.c(by, d2, d3)) {
            return new YVector(-d13, 0.0);
        }
        return new YVector(d13, 0.0);
    }

    private static byte[] b(byte by) {
        if (by == 0) {
            return new byte[]{0};
        }
        if (by == 1) {
            return new byte[]{3, 4};
        }
        throw new IllegalArgumentException("Unknown model mode " + by);
    }

    private double[] b(double d2, double d3, double d4, double d5) {
        double[] dArray;
        block7: {
            int n2;
            boolean bl;
            block9: {
                block8: {
                    bl = LayoutGraph.z;
                    d2 = Math.abs(d2);
                    d3 = Math.abs(d3);
                    d4 = Math.max(0.01, d4);
                    if (!(d3 < d2 * (d5 = Math.max(0.01, d5)) / d4)) break block8;
                    n2 = Math.max(2, (int)Math.floor(d2 / d4));
                    if (!bl) break block9;
                }
                n2 = Math.max(2, (int)Math.floor(d3 / d5));
            }
            n2 = (int)((double)n2 + (this.w - 1.0) * (double)(n2 - 1));
            n2 = Math.min(n2, 20);
            if ((n2 = Math.max(3, n2)) % 2 == 0) {
                ++n2;
            }
            double d6 = 1.0 / (double)(n2 - 1);
            dArray = new double[n2];
            for (int i2 = n2 - 2; i2 > 0; --i2) {
                dArray[i2] = d6 * (double)i2;
                if (!bl) {
                    if (!bl) continue;
                }
                break block7;
            }
            dArray[n2 - 1] = 1.0;
        }
        return dArray;
    }

    private YPoint b(double d2, YPoint yPoint, YPoint yPoint2, YDimension yDimension, byte by) {
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        double d9;
        double d10;
        double d11;
        double d12;
        block14: {
            block18: {
                double d13;
                boolean bl;
                block17: {
                    block16: {
                        block11: {
                            block15: {
                                block13: {
                                    block12: {
                                        bl = LayoutGraph.z;
                                        d12 = yPoint2.getX() - yPoint.getX();
                                        d11 = yPoint2.getY() - yPoint.getY();
                                        double d14 = Math.max(1.0E-7, Math.abs(d12));
                                        double d15 = Math.abs(d11);
                                        d13 = d11 / d12;
                                        if (Double.isNaN(d13)) {
                                            d13 = 1.0;
                                        }
                                        double d16 = Math.max(0.01, yDimension.getWidth());
                                        double d17 = Math.max(0.01, yDimension.getHeight());
                                        double d18 = d17 / d16;
                                        d10 = d16 * 0.5;
                                        d9 = d17 * 0.5;
                                        if (!(d15 < d14 * d18)) break block11;
                                        if (!(d12 > 0.0)) break block12;
                                        d8 = 1.0 + d10;
                                        if (!bl) break block13;
                                    }
                                    d8 = -(1.0 + d10);
                                }
                                d7 = d12 - d8;
                                d6 = d13 * d8;
                                d5 = d11 - d6;
                                if (by == 0) break block14;
                                d4 = d9 + Math.abs(d10 * d13);
                                if (!SliderEdgeLabelModel.b(by, d12, d11)) break block15;
                                d6 -= d4;
                                d5 -= d4;
                                if (!bl) break block14;
                            }
                            d6 += d4;
                            d5 += d4;
                            if (!bl) break block14;
                        }
                        d4 = 1.0 / d13;
                        if (!(d11 > 0.0)) break block16;
                        d6 = 1.0 + d9;
                        if (!bl) break block17;
                    }
                    d6 = -(1.0 + d9);
                }
                d5 = d11 - d6;
                d8 = d6 / d13;
                d7 = d12 - d8;
                if (by == 0) break block14;
                d3 = d10 + Math.abs(d9 * d4);
                if (!SliderEdgeLabelModel.c(by, d12, d11)) break block18;
                d8 -= d3;
                d7 -= d3;
                if (!bl) break block14;
            }
            d8 += d3;
            d7 += d3;
        }
        d4 = d7 - d8;
        d3 = d5 - d6;
        if (d4 * d12 < 0.0 || d3 * d11 < 0.0) {
            return new YPoint((d8 + d7) * 0.5 - d10, (d6 + d5) * 0.5 - d9);
        }
        return new YPoint(d8 + d4 * d2 - d10, d6 + d3 * d2 - d9);
    }

    private static boolean b(byte by, double d2, double d3) {
        if (by == 2) {
            return true;
        }
        if (by == 1) {
            return false;
        }
        if (d2 > 0.0 && by == 3) {
            return true;
        }
        return d2 < 0.0 && by == 4;
    }

    private static boolean c(byte by, double d2, double d3) {
        if (by == 2) {
            return true;
        }
        if (by == 1) {
            return false;
        }
        if (d3 > 0.0 && by == 4) {
            return true;
        }
        return d3 < 0.0 && by == 3;
    }

    private double b(YPointPath yPointPath, double[] dArray, double[] dArray2) {
        double d2;
        block6: {
            double d3;
            double d4;
            YPointCursor yPointCursor;
            YPoint yPoint;
            YPoint yPoint2;
            boolean bl;
            block5: {
                bl = LayoutGraph.z;
                yPoint2 = null;
                yPoint = null;
                yPointCursor = yPointPath.points();
                if (!yPointCursor.ok()) {
                    return 0.0;
                }
                d4 = 0.0;
                yPoint2 = yPointCursor.point();
                yPointCursor.next();
                while (yPointCursor.ok()) {
                    yPoint = yPoint2;
                    yPoint2 = yPointCursor.point();
                    d3 = yPoint.getX() - yPoint2.getX();
                    double d5 = yPoint.getY() - yPoint2.getY();
                    d4 += Math.sqrt(d3 * d3 + d5 * d5);
                    yPointCursor.next();
                    if (!bl) {
                        if (!bl) continue;
                    }
                    break block5;
                }
                yPointCursor = yPointPath.points();
                yPoint2 = yPointCursor.point();
                yPointCursor.next();
                d3 = 0.0;
            }
            int n2 = 0;
            while (yPointCursor.ok()) {
                yPoint = yPoint2;
                yPoint2 = yPointCursor.point();
                double d6 = yPoint.getX() - yPoint2.getX();
                double d7 = yPoint.getY() - yPoint2.getY();
                double d8 = Math.sqrt(d6 * d6 + d7 * d7);
                dArray2[n2] = d3;
                dArray[n2] = d8 / d4;
                d2 = d3 + d8;
                if (!bl) {
                    d3 = d2;
                    ++n2;
                    yPointCursor.next();
                    if (!bl) continue;
                }
                break block6;
            }
            d2 = d4;
        }
        return d2;
    }

    public static class ModelParameter {
        private int e;
        private double c;
        private double d;
        private YVector b;
        private byte f;

        public ModelParameter(int n2, double d2, YVector yVector, byte by, double d3) {
            this.e = n2;
            this.c = d2;
            this.b = new YVector(yVector);
            this.f = by;
            this.d = d3;
        }

        public int getSegmentNumber() {
            return this.e;
        }

        public double getRatio() {
            return this.c;
        }

        public YVector getOffsetVector() {
            return this.b;
        }

        public byte getLabelPosition() {
            return this.f;
        }

        public double getAbsRatio() {
            return this.d;
        }
    }
}

