/*
 * Decompiled with CFR 0.152.
 */
package y.layout;

import java.util.ArrayList;
import y.base.YList;
import y.geom.Geom;
import y.geom.LineSegment;
import y.geom.OrientedRectangle;
import y.geom.YDimension;
import y.geom.YPoint;
import y.geom.YRectangle;
import y.geom.YVector;
import y.layout.EdgeLabelCandidate;
import y.layout.EdgeLabelLayout;
import y.layout.EdgeLabelLayoutImpl;
import y.layout.EdgeLabelModel;
import y.layout.EdgeLayout;
import y.layout.LayoutGraph;
import y.layout.LayoutTool;
import y.layout.NodeLayout;
import y.layout.c;
import y.layout.d;

public class RotatedDiscreteEdgeLabelModel
implements EdgeLabelModel {
    public static final int SHEAD = 1;
    public static final int HEAD = 2;
    public static final int THEAD = 4;
    public static final int STAIL = 8;
    public static final int TAIL = 16;
    public static final int TTAIL = 32;
    public static final int SCENTER = 64;
    public static final int CENTER = 128;
    public static final int TCENTER = 256;
    public static final int TWO_POS = 18;
    public static final int CENTERED = 128;
    public static final int SIX_POS = 63;
    public static final int THREE_CENTER = 448;
    private static final double cc = 5.0;
    private static final byte jc = 0;
    private static final byte gc = 1;
    private static final byte ec = 2;
    private static final byte kc = 3;
    private int bc = 63;
    private double dc = 2.0;
    private double lc;
    private boolean nc = true;
    private boolean fc = false;
    private boolean mc = false;
    private static final double ic = 1.0E-4;
    private static final YVector hc = new YVector(1.0, 0.0);

    public RotatedDiscreteEdgeLabelModel() {
        this(63);
    }

    public RotatedDiscreteEdgeLabelModel(int n2) {
        this.bc = n2;
    }

    public int getCandidateMask() {
        return this.bc;
    }

    public boolean isPositionRelativeToSegment() {
        return this.mc;
    }

    public void setPositionRelativeToSegment(boolean bl) {
        this.mc = bl;
    }

    public boolean isAutoRotationEnabled() {
        return this.nc;
    }

    public void setAutoRotationEnabled(boolean bl) {
        this.nc = bl;
    }

    public boolean isAutoFlippingEnabled() {
        return this.fc;
    }

    public void setAutoFlippingEnabled(boolean bl) {
        this.fc = bl;
    }

    public double getAngle() {
        return this.lc;
    }

    public void setAngle(double d2) {
        this.lc = d2;
    }

    public double getDistance() {
        return this.dc;
    }

    public void setDistance(double d2) {
        this.dc = Math.abs(d2);
    }

    public Object getDefaultParameter() {
        if ((this.bc & 0x80) != 0) {
            return new ModelParameter(128);
        }
        if ((this.bc & 0x40) != 0) {
            return new ModelParameter(64);
        }
        if ((this.bc & 0x10) != 0) {
            return new ModelParameter(16);
        }
        if ((this.bc & 8) != 0) {
            return new ModelParameter(8);
        }
        return new ModelParameter(128);
    }

    private Object[] d() {
        ArrayList<ModelParameter> arrayList = new ArrayList<ModelParameter>();
        arrayList.add(new ModelParameter(1));
        arrayList.add(new ModelParameter(2));
        arrayList.add(new ModelParameter(4));
        arrayList.add(new ModelParameter(8));
        arrayList.add(new ModelParameter(16));
        arrayList.add(new ModelParameter(32));
        arrayList.add(new ModelParameter(64));
        arrayList.add(new ModelParameter(128));
        arrayList.add(new ModelParameter(256));
        return arrayList.toArray();
    }

    public Object createModelParameter(OrientedRectangle orientedRectangle, EdgeLayout edgeLayout, NodeLayout nodeLayout, NodeLayout nodeLayout2) {
        if (LayoutTool.b(orientedRectangle)) {
            throw new IllegalArgumentException("Invalid label bounds: " + orientedRectangle);
        }
        EdgeLabelLayoutImpl edgeLabelLayoutImpl = new EdgeLabelLayoutImpl();
        edgeLabelLayoutImpl.setOrientedBox(orientedRectangle);
        YList yList = this.getLabelCandidates(edgeLabelLayoutImpl, edgeLayout, nodeLayout, nodeLayout2);
        if (yList.isEmpty()) {
            return this.getDefaultParameter();
        }
        return d.b(yList, orientedRectangle.getCenter()).getModelParameter();
    }

    public static Object createPositionParameter(int n2) {
        switch (n2) {
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 16: 
            case 32: 
            case 64: 
            case 128: 
            case 256: {
                return new ModelParameter(n2);
            }
        }
        throw new IllegalArgumentException("Invalid position: " + n2);
    }

    public static int getPosition(Object object) {
        try {
            return ((ModelParameter)object).getPosition();
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("Invalid model parameter type.");
        }
    }

    public boolean isParameterValid(Object object) {
        if (object instanceof ModelParameter) {
            int n2 = ((ModelParameter)object).getPosition();
            return (this.getCandidateMask() & n2) != 0;
        }
        return false;
    }

    public OrientedRectangle getLabelPlacement(YDimension yDimension, EdgeLayout edgeLayout, NodeLayout nodeLayout, NodeLayout nodeLayout2, Object object) {
        ModelParameter modelParameter = (ModelParameter)(object instanceof ModelParameter ? object : this.getDefaultParameter());
        return this.getLabelPlacement(yDimension, edgeLayout, nodeLayout, nodeLayout2, modelParameter.b);
    }

    public YList getLabelCandidates(EdgeLabelLayout edgeLabelLayout, EdgeLayout edgeLayout, NodeLayout nodeLayout, NodeLayout nodeLayout2) {
        boolean bl = LayoutGraph.z;
        YList yList = new YList();
        Object[] objectArray = this.d();
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            boolean bl2;
            int n2;
            block6: {
                block7: {
                    block5: {
                        n2 = ((ModelParameter)objectArray[i2]).b;
                        if ((this.bc & n2) == 0) continue;
                        bl2 = false;
                        if (n2 != 128) break block5;
                        bl2 = true;
                        if (!bl) break block6;
                    }
                    if (n2 != 64) break block7;
                    bl2 = true;
                    if (!bl) break block6;
                }
                if (n2 == 256) {
                    bl2 = true;
                }
            }
            YDimension yDimension = edgeLabelLayout.getOrientedBox().getSize();
            OrientedRectangle orientedRectangle = this.getLabelPlacement(yDimension, edgeLayout, nodeLayout, nodeLayout2, n2);
            yList.add(new EdgeLabelCandidate(orientedRectangle, objectArray[i2], edgeLabelLayout, bl2));
            if (!bl) continue;
        }
        return yList;
    }

    protected OrientedRectangle getLabelPlacement(YDimension yDimension, EdgeLayout edgeLayout, NodeLayout nodeLayout, NodeLayout nodeLayout2, int n2) {
        OrientedRectangle orientedRectangle;
        block31: {
            LineSegment lineSegment;
            YPoint yPoint;
            YPoint yPoint2;
            block32: {
                boolean bl;
                block33: {
                    int n3;
                    int n4;
                    block29: {
                        block30: {
                            double d2;
                            block27: {
                                double d3;
                                block28: {
                                    YPoint[] yPointArray;
                                    block26: {
                                        block25: {
                                            int n5;
                                            block24: {
                                                double d4;
                                                double d5;
                                                block23: {
                                                    bl = LayoutGraph.z;
                                                    orientedRectangle = new OrientedRectangle(new YPoint(0.0, 0.0), yDimension);
                                                    orientedRectangle.setAngle(Math.PI * 2 - this.lc);
                                                    yPointArray = LayoutTool.getEdgeClippedOnBB(edgeLayout, nodeLayout, nodeLayout2, 0.0).toArray();
                                                    if (yPointArray.length < 2) {
                                                        YRectangle yRectangle = orientedRectangle.getBoundingBox();
                                                        orientedRectangle.setCenter(nodeLayout.getX() + yRectangle.width * 0.5, nodeLayout.getY() - yRectangle.height * 0.5);
                                                        if (this.isAutoFlippingEnabled()) {
                                                            LayoutTool.autoFlipBox(orientedRectangle);
                                                        }
                                                        return orientedRectangle;
                                                    }
                                                    if (yPointArray.length == 2 && YPoint.distance(yPointArray[0], yPointArray[1]) < 1.0E-4) {
                                                        orientedRectangle.setCenter(yPointArray[0].x, yPointArray[0].y);
                                                        if (this.isAutoFlippingEnabled()) {
                                                            LayoutTool.autoFlipBox(orientedRectangle);
                                                        }
                                                        return orientedRectangle;
                                                    }
                                                    n4 = 0;
                                                    d5 = 0.0;
                                                    for (int i2 = 0; i2 < yPointArray.length - 1; ++i2) {
                                                        d4 = d5 + YPoint.distance(yPointArray[i2], yPointArray[i2 + 1]);
                                                        if (!bl) {
                                                            d5 = d4;
                                                            if (!bl) continue;
                                                        }
                                                        break block23;
                                                    }
                                                    d4 = d5 / 2.0;
                                                }
                                                double d6 = d4;
                                                d5 = 0.0;
                                                for (n3 = 0; n3 < yPointArray.length - 1; ++n3) {
                                                    double d7 = (d5 += YPoint.distance(yPointArray[n3], yPointArray[n3 + 1])) - d6;
                                                    n5 = d7 == 0.0 ? 0 : (d7 > 0.0 ? 1 : -1);
                                                    if (!bl) {
                                                        if (n5 <= 0) continue;
                                                        n4 = n3;
                                                        if (!bl) break;
                                                        if (!bl) continue;
                                                    }
                                                    break block24;
                                                }
                                                n3 = 0;
                                                n5 = n2;
                                            }
                                            if (n5 != 2 && n2 != 128 && n2 != 16) break block25;
                                            n3 = n4;
                                            if (!bl) break block26;
                                        }
                                        if (n2 == 4 || n2 == 256 || n2 == 32) {
                                            n3 = yPointArray.length - 2;
                                        }
                                    }
                                    if (!(yPoint2 = yPointArray[n3]).equals(yPoint = yPointArray[n3 + 1])) break block27;
                                    d2 = nodeLayout.getX() + nodeLayout.getWidth() * 0.5 + edgeLayout.getSourcePoint().x - (nodeLayout2.getX() + nodeLayout2.getWidth() * 0.5 + edgeLayout.getTargetPoint().x);
                                    d3 = nodeLayout.getY() + nodeLayout.getHeight() * 0.5 + edgeLayout.getSourcePoint().y - (nodeLayout2.getY() + nodeLayout2.getHeight() * 0.5 + edgeLayout.getTargetPoint().y);
                                    if (d2 != 0.0 || d3 != 0.0) break block28;
                                    yPoint = new YPoint(yPoint2.x + 1.0E-4, yPoint2.y);
                                    if (!bl) break block27;
                                }
                                double d8 = Math.sqrt(d2 * d2 + d3 * d3);
                                yPoint = new YPoint(yPoint2.x + 1.0E-4 * d2 / d8, yPoint2.y + 1.0E-4 * d3 / d8);
                            }
                            if (this.nc) {
                                d2 = YVector.angle(new YVector(yPoint, yPoint2), new YVector(1.0, 0.0)) - this.lc;
                                orientedRectangle.setAngle(RotatedDiscreteEdgeLabelModel.e(d2));
                            }
                            lineSegment = new LineSegment(yPoint2, yPoint);
                            if (n2 != 1 && n2 != 64 && n2 != 8) break block29;
                            if (!RotatedDiscreteEdgeLabelModel.c(nodeLayout, yPoint2, 5.0)) break block30;
                            this.c(orientedRectangle, lineSegment, nodeLayout, n2, n3 == n4);
                            if (!bl) break block31;
                        }
                        this.b(orientedRectangle, lineSegment, yPoint2, n2);
                        if (!bl) break block31;
                    }
                    if (n2 != 4 && n2 != 256 && n2 != 32) break block32;
                    if (!RotatedDiscreteEdgeLabelModel.c(nodeLayout2, yPoint, 5.0)) break block33;
                    this.b(orientedRectangle, lineSegment, nodeLayout2, n2, n3 == n4);
                    if (!bl) break block31;
                }
                this.b(orientedRectangle, lineSegment, yPoint, n2);
                if (!bl) break block31;
            }
            YPoint yPoint3 = new YPoint((yPoint2.x + yPoint.x) / 2.0, (yPoint2.y + yPoint.y) / 2.0);
            this.b(orientedRectangle, lineSegment, yPoint3, n2);
        }
        if (this.isAutoFlippingEnabled()) {
            LayoutTool.autoFlipBox(orientedRectangle);
        }
        return orientedRectangle;
    }

    private static boolean c(NodeLayout nodeLayout, YPoint yPoint, double d2) {
        return nodeLayout.getX() - d2 < yPoint.x && nodeLayout.getX() + nodeLayout.getWidth() + d2 > yPoint.x && nodeLayout.getY() - d2 < yPoint.y && nodeLayout.getY() + nodeLayout.getHeight() + d2 > yPoint.y;
    }

    private static double e(double d2) {
        double d3;
        block3: {
            boolean bl = LayoutGraph.z;
            if (d2 < 0.0) {
                d2 += Math.PI * 2;
            }
            while (d2 > Math.PI * 2) {
                d3 = d2 - Math.PI * 2;
                if (!bl) {
                    d2 = d3;
                    if (!bl) continue;
                }
                break block3;
            }
            d3 = d2;
        }
        return d3;
    }

    private static byte d(LineSegment lineSegment) {
        double d2 = YVector.angle(lineSegment.toYVector(), hc);
        if (d2 >= 0.7853981633974483 && d2 < 2.356194490192345) {
            return 0;
        }
        if (d2 >= 2.356194490192345 && d2 < 3.9269908169872414) {
            return 2;
        }
        if (d2 >= 3.9269908169872414 && d2 < 5.497787143782138) {
            return 1;
        }
        return 3;
    }

    private static byte e(LineSegment lineSegment) {
        double d2 = YVector.angle(lineSegment.toYVector(), hc);
        if (d2 >= 0.7853981633974483 && d2 < 2.356194490192345) {
            if (d2 <= 1.5707963267948966) {
                return 3;
            }
            return 2;
        }
        if (d2 >= 2.356194490192345 && d2 < 3.9269908169872414) {
            if (d2 <= Math.PI) {
                return 0;
            }
            return 1;
        }
        if (d2 >= 3.9269908169872414 && d2 < 5.497787143782138) {
            if (d2 <= 4.71238898038469) {
                return 2;
            }
            return 3;
        }
        if (d2 <= Math.PI) {
            return 0;
        }
        return 1;
    }

    private void b(OrientedRectangle orientedRectangle, LineSegment lineSegment, YPoint yPoint, int n2) {
        block7: {
            YVector yVector;
            boolean bl;
            block10: {
                double d2;
                block9: {
                    block8: {
                        bl = LayoutGraph.z;
                        if (n2 != 128 && n2 != 256 && n2 != 64) break block8;
                        orientedRectangle.setCenter(yPoint.x, yPoint.y);
                        if (!bl) break block7;
                    }
                    yVector = YVector.orthoNormal(lineSegment.toYVector());
                    if (!this.mc) break block9;
                    if (n2 != 16 && n2 != 8 && n2 != 32) break block10;
                    yVector = new YVector(-yVector.getX(), -yVector.getY());
                    if (!bl) break block10;
                }
                if ((d2 = YVector.angle(hc, yVector)) >= Math.PI && (n2 == 16 || n2 == 32 || n2 == 8) || d2 < Math.PI && (n2 == 2 || n2 == 1 || n2 == 4)) {
                    yVector = new YVector(-yVector.getX(), -yVector.getY());
                }
            }
            yVector.scale(this.dc + orientedRectangle.getWidth() + orientedRectangle.getHeight());
            YPoint yPoint2 = YVector.add(yPoint, yVector);
            orientedRectangle.setCenter(yPoint2.x, yPoint2.y);
            YPoint[] yPointArray = OrientedRectangle.calcPoints(orientedRectangle);
            double d3 = Double.MAX_VALUE;
            for (int i2 = 0; i2 < yPointArray.length; ++i2) {
                d3 = Math.min(d3, RotatedDiscreteEdgeLabelModel.c(lineSegment, yPointArray[i2]));
                if (!bl) {
                    if (!bl) continue;
                }
                break block7;
            }
            YVector yVector2 = new YVector(-yVector.getX(), -yVector.getY());
            yVector2.norm();
            yVector2.scale(d3 - this.dc);
            yPoint2 = YVector.add(yPoint2, yVector2);
            orientedRectangle.setCenter(yPoint2.x, yPoint2.y);
        }
    }

    private void b(OrientedRectangle orientedRectangle, LineSegment lineSegment, NodeLayout nodeLayout, int n2, boolean bl) {
        this.b(orientedRectangle, lineSegment.getSecondEndPoint(), lineSegment.getFirstEndPoint(), nodeLayout, n2, false, bl);
    }

    private void c(OrientedRectangle orientedRectangle, LineSegment lineSegment, NodeLayout nodeLayout, int n2, boolean bl) {
        this.b(orientedRectangle, lineSegment.getFirstEndPoint(), lineSegment.getSecondEndPoint(), nodeLayout, n2, true, bl);
    }

    private void b(OrientedRectangle orientedRectangle, YPoint yPoint, YPoint yPoint2, NodeLayout nodeLayout, int n2, boolean bl, boolean bl2) {
        boolean bl3;
        YRectangle yRectangle = new YRectangle(nodeLayout.getX(), nodeLayout.getY(), nodeLayout.getWidth(), nodeLayout.getHeight());
        LineSegment lineSegment = new LineSegment(yPoint, yPoint2);
        byte by = RotatedDiscreteEdgeLabelModel.d(lineSegment);
        YPoint yPoint3 = this.b(by, lineSegment, orientedRectangle, nodeLayout, n2, bl, bl2);
        orientedRectangle.setAnchor(yPoint3);
        double d2 = c.b(yRectangle, orientedRectangle);
        YRectangle yRectangle2 = orientedRectangle.getBoundingBox();
        boolean bl4 = bl3 = Math.abs(yPoint.x - yPoint2.x) > 1.0E-4 && Math.abs(yPoint.y - yPoint2.y) > 1.0E-4 && (d2 < 2.5 || d2 > 6.0) && ((by == 0 || by == 1) && (yPoint2.x < yRectangle.getX() - 5.0 - yRectangle2.width * 0.5 || yPoint2.x > yRectangle.getX() + yRectangle.getWidth() + 5.0 + yRectangle2.width * 0.5) || (by == 2 || by == 3) && (yPoint2.y < yRectangle.getY() - 5.0 - yRectangle2.height * 0.5 || yPoint2.y > yRectangle.getY() + yRectangle.getHeight() + 5.0 + yRectangle2.height * 0.5));
        if (bl3) {
            byte by2 = RotatedDiscreteEdgeLabelModel.e(lineSegment);
            YPoint yPoint4 = this.b(by2, lineSegment, orientedRectangle, nodeLayout, n2, bl, bl2);
            orientedRectangle.setAnchor(yPoint4);
            double d3 = c.b(yRectangle, orientedRectangle);
            if (d3 < 2.5 || d3 > d2 && d2 > 2.5) {
                orientedRectangle.setAnchor(yPoint3);
            }
        }
    }

    private YPoint b(byte by, LineSegment lineSegment, OrientedRectangle orientedRectangle, NodeLayout nodeLayout, int n2, boolean bl, boolean bl2) {
        OrientedRectangle orientedRectangle2;
        block33: {
            int n3;
            YPoint yPoint;
            YPoint yPoint2;
            block35: {
                block34: {
                    boolean bl3;
                    block24: {
                        double d2;
                        YPoint yPoint3;
                        YPoint yPoint4;
                        double d3;
                        double d4;
                        YRectangle yRectangle;
                        block32: {
                            block31: {
                                block28: {
                                    block30: {
                                        block29: {
                                            block25: {
                                                block27: {
                                                    double d5;
                                                    block26: {
                                                        block21: {
                                                            block23: {
                                                                block22: {
                                                                    bl3 = LayoutGraph.z;
                                                                    orientedRectangle2 = new OrientedRectangle(orientedRectangle);
                                                                    yPoint2 = lineSegment.getFirstEndPoint();
                                                                    yPoint = lineSegment.getSecondEndPoint();
                                                                    d5 = YVector.angle(lineSegment.toYVector(), hc);
                                                                    yRectangle = orientedRectangle2.getBoundingBox();
                                                                    if (by != 0) break block21;
                                                                    if (!this.mc) break block22;
                                                                    int n4 = n3 = bl && n2 == 1 || !bl && n2 == 4 ? 1 : 0;
                                                                    if (!bl3) break block23;
                                                                }
                                                                int n5 = n3 = (n2 == 1 || n2 == 4) && d5 <= 1.5707963267948966 || (n2 == 8 || n2 == 32) && d5 > 1.5707963267948966 ? 1 : 0;
                                                            }
                                                            if ((d4 = nodeLayout.getY() - 5.0 - yRectangle.getHeight() * 0.5) < yPoint.y) {
                                                                d4 = yPoint.y;
                                                            }
                                                            d3 = n3 != 0 ? Math.min(yPoint2.x, yPoint.x) - yRectangle.width : Math.max(yPoint2.x, yPoint.x) + yRectangle.width;
                                                            orientedRectangle2.setCenter(d3, d4);
                                                            yPoint4 = n2 == 64 || n2 == 256 ? orientedRectangle2.getCenter() : RotatedDiscreteEdgeLabelModel.d(OrientedRectangle.calcPoints(orientedRectangle2), lineSegment);
                                                            yPoint3 = RotatedDiscreteEdgeLabelModel.c(lineSegment, yPoint4, 1.0, 0.0);
                                                            orientedRectangle2.moveBy(yPoint3.x - yPoint4.x, 0.0);
                                                            if (n2 == 64 || n2 == 256) break block24;
                                                            d2 = n3 != 0 ? -this.dc : this.dc;
                                                            orientedRectangle2.moveBy(d2, 0.0);
                                                            if (!bl3) break block24;
                                                        }
                                                        if (by != 1) break block25;
                                                        if (!this.mc) break block26;
                                                        int n6 = n3 = bl && n2 == 8 || !bl && n2 == 32 ? 1 : 0;
                                                        if (!bl3) break block27;
                                                    }
                                                    int n7 = n3 = (n2 == 8 || n2 == 32) && d5 > 4.71238898038469 || (n2 == 1 || n2 == 4) && d5 <= 4.71238898038469 ? 1 : 0;
                                                }
                                                if ((d4 = nodeLayout.getY() + nodeLayout.getHeight() + 5.0 + yRectangle.getHeight() * 0.5) > yPoint.y) {
                                                    d4 = yPoint.y;
                                                }
                                                d3 = n3 != 0 ? Math.min(yPoint2.x, yPoint.x) - yRectangle.width : Math.max(yPoint2.x, yPoint.x) + yRectangle.width;
                                                orientedRectangle2.setCenter(d3, d4);
                                                yPoint4 = n2 == 64 || n2 == 256 ? orientedRectangle2.getCenter() : RotatedDiscreteEdgeLabelModel.d(OrientedRectangle.calcPoints(orientedRectangle2), lineSegment);
                                                yPoint3 = RotatedDiscreteEdgeLabelModel.c(lineSegment, yPoint4, 1.0, 0.0);
                                                orientedRectangle2.moveBy(yPoint3.x - yPoint4.x, 0.0);
                                                if (n2 == 64 || n2 == 256) break block24;
                                                d2 = n3 != 0 ? -this.dc : this.dc;
                                                orientedRectangle2.moveBy(d2, 0.0);
                                                if (!bl3) break block24;
                                            }
                                            if (by != 2) break block28;
                                            if (!this.mc) break block29;
                                            int n8 = n3 = bl && n2 == 1 || !bl && n2 == 4 ? 1 : 0;
                                            if (!bl3) break block30;
                                        }
                                        int n9 = n3 = n2 == 8 || n2 == 32 ? 1 : 0;
                                    }
                                    if ((d4 = nodeLayout.getX() - 5.0 - yRectangle.getWidth() * 0.5) < yPoint.x) {
                                        d4 = yPoint.x;
                                    }
                                    d3 = n3 != 0 ? Math.max(yPoint2.y, yPoint.y) + yRectangle.height : Math.min(yPoint2.y, yPoint.y) - yRectangle.height;
                                    orientedRectangle2.setCenter(d4, d3);
                                    yPoint4 = n2 == 64 || n2 == 256 ? orientedRectangle2.getCenter() : RotatedDiscreteEdgeLabelModel.d(OrientedRectangle.calcPoints(orientedRectangle2), lineSegment);
                                    yPoint3 = RotatedDiscreteEdgeLabelModel.c(lineSegment, yPoint4, 0.0, 1.0);
                                    orientedRectangle2.moveBy(0.0, yPoint3.y - yPoint4.y);
                                    if (n2 == 64 || n2 == 256) break block24;
                                    d2 = n3 != 0 ? this.dc : -this.dc;
                                    orientedRectangle2.moveBy(0.0, d2);
                                    if (!bl3) break block24;
                                }
                                if (by != 3) break block24;
                                if (!this.mc) break block31;
                                int n10 = n3 = bl && n2 == 8 || !bl && n2 == 32 ? 1 : 0;
                                if (!bl3) break block32;
                            }
                            int n11 = n3 = n2 == 8 || n2 == 32 ? 1 : 0;
                        }
                        if ((d4 = nodeLayout.getX() + nodeLayout.getWidth() + 5.0 + yRectangle.getWidth() * 0.5) > yPoint.x) {
                            d4 = yPoint.x;
                        }
                        d3 = n3 != 0 ? Math.max(yPoint2.y, yPoint.y) + yRectangle.height : Math.min(yPoint2.y, yPoint.y) - yRectangle.height;
                        orientedRectangle2.setCenter(d4, d3);
                        yPoint4 = n2 == 64 || n2 == 256 ? orientedRectangle2.getCenter() : RotatedDiscreteEdgeLabelModel.d(OrientedRectangle.calcPoints(orientedRectangle2), lineSegment);
                        yPoint3 = RotatedDiscreteEdgeLabelModel.c(lineSegment, yPoint4, 0.0, 1.0);
                        orientedRectangle2.moveBy(0.0, yPoint3.y - yPoint4.y);
                        if (n2 != 64 && n2 != 256) {
                            d2 = n3 != 0 ? this.dc : -this.dc;
                            orientedRectangle2.moveBy(0.0, d2);
                        }
                    }
                    if (!bl2 || !(YPoint.distance(orientedRectangle2.getCenter(), yPoint2) > YPoint.distance(orientedRectangle2.getCenter(), yPoint))) break block33;
                    n3 = 128;
                    if (n2 > 4) break block34;
                    n3 = 2;
                    if (!bl3) break block35;
                }
                if (n2 <= 32) {
                    n3 = 16;
                }
            }
            YPoint yPoint5 = new YPoint((yPoint2.x + yPoint.x) / 2.0, (yPoint2.y + yPoint.y) / 2.0);
            this.b(orientedRectangle2, lineSegment, yPoint5, n3);
        }
        return orientedRectangle2.getAnchor();
    }

    private static YPoint d(YPoint[] yPointArray, LineSegment lineSegment) {
        boolean bl = LayoutGraph.z;
        double d2 = Double.MAX_VALUE;
        YPoint yPoint = null;
        for (int i2 = 0; i2 < yPointArray.length; ++i2) {
            double d3 = RotatedDiscreteEdgeLabelModel.c(lineSegment, yPointArray[i2]);
            if (!(d3 < d2)) continue;
            yPoint = yPointArray[i2];
            d2 = d3;
            if (!bl) continue;
        }
        return yPoint;
    }

    private static double c(LineSegment lineSegment, YPoint yPoint) {
        YPoint yPoint2 = lineSegment.getFirstEndPoint();
        YPoint yPoint3 = lineSegment.getSecondEndPoint();
        double d2 = yPoint.x - yPoint2.x;
        double d3 = yPoint.y - yPoint2.y;
        double d4 = yPoint3.x - yPoint2.x;
        double d5 = yPoint3.y - yPoint2.y;
        double d6 = d2 * d4 + d3 * d5;
        double d7 = d6 * d6 / (d4 * d4 + d5 * d5);
        double d8 = d2 * d2 + d3 * d3 - d7;
        if (d8 < 0.0) {
            d8 = 0.0;
        }
        return Math.sqrt(d8);
    }

    private static YPoint c(LineSegment lineSegment, YPoint yPoint, double d2, double d3) {
        YPoint yPoint2 = lineSegment.getSecondEndPoint();
        YPoint yPoint3 = lineSegment.getFirstEndPoint();
        double d4 = yPoint.getX();
        double d5 = yPoint.getY();
        return Geom.calcIntersection(yPoint2.getX(), yPoint2.getY(), yPoint3.getX(), yPoint3.getY(), d4, d5, d4 + d2, d5 + d3);
    }

    public static class ModelParameter {
        private final int b;

        public ModelParameter(int n2) {
            this.b = n2;
        }

        public int getPosition() {
            return this.b;
        }
    }
}

