/*
 * Decompiled with CFR 0.152.
 */
package y.layout;

import y.base.Edge;
import y.base.EdgeCursor;
import y.base.ListCell;
import y.base.YList;
import y.geom.Geom;
import y.geom.YPoint;
import y.layout.AbstractLayoutStage;
import y.layout.EdgeLayout;
import y.layout.LayoutGraph;

public class RemoveColinearBendsStage
extends AbstractLayoutStage {
    private double dkc = 2.0;
    private boolean ckc;

    public boolean canLayout(LayoutGraph layoutGraph) {
        return true;
    }

    public double getScale() {
        return this.dkc;
    }

    public void setScale(double d2) {
        this.dkc = d2;
    }

    public boolean isRemoveStraightOnly() {
        return this.ckc;
    }

    public void setRemoveStraightOnly(boolean bl) {
        this.ckc = bl;
    }

    public void doLayout(LayoutGraph layoutGraph) {
        boolean bl = LayoutGraph.z;
        this.doLayoutCore(layoutGraph);
        EdgeCursor edgeCursor = layoutGraph.edges();
        while (edgeCursor.ok()) {
            block11: {
                int n2;
                YList yList;
                Edge edge;
                block10: {
                    int n3;
                    block9: {
                        edge = edgeCursor.edge();
                        EdgeLayout edgeLayout = layoutGraph.getLayout(edge);
                        if (edgeLayout.pointCount() < 1) break block11;
                        yList = new YList();
                        yList.add(layoutGraph.getSourcePointAbs(edge));
                        for (n3 = 0; n3 < edgeLayout.pointCount(); ++n3) {
                            yList.add(edgeLayout.getPoint(n3));
                            if (!bl) {
                                if (!bl) continue;
                            }
                            break block9;
                        }
                        yList.add(layoutGraph.getTargetPointAbs(edge));
                        n3 = yList.size();
                    }
                    ListCell listCell = yList.firstCell();
                    YPoint yPoint = (YPoint)listCell.getInfo();
                    ListCell listCell2 = listCell.succ();
                    YPoint yPoint2 = (YPoint)listCell2.getInfo();
                    ListCell listCell3 = listCell2.succ();
                    while (listCell3 != null) {
                        ListCell listCell4;
                        YPoint yPoint3;
                        block13: {
                            block14: {
                                block12: {
                                    yPoint3 = (YPoint)listCell3.getInfo();
                                    listCell4 = listCell3.succ();
                                    n2 = this.b(yPoint, yPoint2, yPoint3) ? 1 : 0;
                                    if (bl) break block10;
                                    if (n2 == 0) break block12;
                                    yList.removeCell(listCell2);
                                    if (!bl) break block13;
                                }
                                if (!this.b(this.d(yPoint), this.d(yPoint2), this.d(yPoint3))) break block14;
                                yList.removeCell(listCell2);
                                if (!bl) break block13;
                            }
                            listCell = listCell2;
                            yPoint = yPoint2;
                        }
                        listCell2 = listCell3;
                        yPoint2 = yPoint3;
                        listCell3 = listCell4;
                        if (!bl) continue;
                    }
                    n2 = n3;
                }
                if (n2 != yList.size()) {
                    yList.pop();
                    yList.popLast();
                    layoutGraph.setPoints(edge, yList);
                }
            }
            edgeCursor.next();
            if (!bl) continue;
        }
    }

    private boolean b(YPoint yPoint, YPoint yPoint2, YPoint yPoint3) {
        return Geom.collinear(yPoint, yPoint2, yPoint3) && (!this.ckc || this.c(yPoint, yPoint2, yPoint3));
    }

    private boolean c(YPoint yPoint, YPoint yPoint2, YPoint yPoint3) {
        return yPoint.x > yPoint2.x == yPoint2.x > yPoint3.x && yPoint.y > yPoint2.y == yPoint2.y > yPoint3.y;
    }

    private YPoint d(YPoint yPoint) {
        double d2 = Math.pow(10.0, this.dkc);
        double d3 = Math.rint(yPoint.getX() * d2) / d2;
        double d4 = Math.rint(yPoint.getY() * d2) / d2;
        return new YPoint(d3, d4);
    }
}

