/*
 * Decompiled with CFR 0.152.
 */
package y.layout;

import y.base.Edge;
import y.base.EdgeCursor;
import y.base.EdgeMap;
import y.base.Node;
import y.geom.Geom;
import y.geom.LineSegment;
import y.geom.YPoint;
import y.geom.YPointPath;
import y.layout.LayoutGraph;
import y.layout.PortConstraint;

public class PortConstraintConfigurator {
    public PortConstraint createPortConstraintFromSketch(LayoutGraph layoutGraph, Edge edge, boolean bl, boolean bl2) {
        LineSegment lineSegment;
        double d2;
        double d3;
        double d4;
        double d5;
        block8: {
            YPointPath yPointPath;
            block7: {
                Node node = bl ? edge.source() : edge.target();
                d5 = layoutGraph.getX(node) - 2.0;
                d4 = layoutGraph.getY(node) - 2.0;
                d3 = d5 + layoutGraph.getWidth(node) + 4.0;
                d2 = d4 + layoutGraph.getHeight(node) + 4.0;
                yPointPath = layoutGraph.getPath(edge);
                if (!bl) break block7;
                lineSegment = yPointPath.getLineSegment(0);
                if (!LayoutGraph.z) break block8;
            }
            lineSegment = yPointPath.getLineSegment(yPointPath.length() - 2);
        }
        YPoint yPoint = lineSegment.getFirstEndPoint();
        YPoint yPoint2 = lineSegment.getSecondEndPoint();
        if (Geom.linesIntersect(d5, d4, d5, d2, yPoint.x, yPoint.y, yPoint2.x, yPoint2.y)) {
            return PortConstraint.create((byte)8, bl2);
        }
        if (Geom.linesIntersect(d5, d4, d3, d4, yPoint.x, yPoint.y, yPoint2.x, yPoint2.y)) {
            return PortConstraint.create((byte)1, bl2);
        }
        if (Geom.linesIntersect(d3, d2, d5, d2, yPoint.x, yPoint.y, yPoint2.x, yPoint2.y)) {
            return PortConstraint.create((byte)2, bl2);
        }
        if (Geom.linesIntersect(d3, d2, d3, d4, yPoint.x, yPoint.y, yPoint2.x, yPoint2.y)) {
            return PortConstraint.create((byte)4, bl2);
        }
        return PortConstraint.create((byte)0, bl2);
    }

    public void createPortConstraintsFromSketch(LayoutGraph layoutGraph, EdgeMap edgeMap, EdgeMap edgeMap2) {
        this.createPortConstraintsFromSketch(layoutGraph, layoutGraph.edges(), edgeMap, false, edgeMap2, false);
    }

    public void createPortConstraintsFromSketch(LayoutGraph layoutGraph, EdgeCursor edgeCursor, EdgeMap edgeMap, boolean bl, EdgeMap edgeMap2, boolean bl2) {
        boolean bl3 = LayoutGraph.z;
        while (edgeCursor.ok()) {
            Edge edge = edgeCursor.edge();
            edgeMap.set(edge, this.createPortConstraintFromSketch(layoutGraph, edge, true, bl));
            edgeMap2.set(edge, this.createPortConstraintFromSketch(layoutGraph, edge, false, bl2));
            edgeCursor.next();
            if (!bl3) continue;
        }
    }
}

